/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import shape.ShapeContainer;
import shapeUtil.AutoAlign;
import util.Util;

class Align {
    int alignAxis = -1;
    int alignType = -1;
    double value;
    ShapeContainer shapeContainer = null;
    int endPTindex = -1;
    Rectangle2D boundingBox = null;
    Point2D[] alignedPoints = null;
    static final int XALIGN = 10;
    static final int YALIGN = 11;
    static final int LEFT = 0;
    static final int CENTER = 1;
    static final int RIGHT = 2;
    static final int TOP = 3;
    static final int MIDDLE = 4;
    static final int BOTTOM = 5;
    static final int ENDPT = 6;
    static final String[] alignString = new String[]{"LEFT", "CENTER", "RIGHT", "TOP", "MIDDLE", "BOTTOM", "ENDPT", "", "", "", "X-ALIGN", "Y-ALIGN"};

    Align(int alignAxis, int alignType, double value, ShapeContainer shapeContainer) {
        this.alignAxis = alignAxis;
        this.alignType = alignType;
        this.value = value;
        this.shapeContainer = shapeContainer;
        this.endPTindex = -1;
        this.setBoundingBox();
        this.setAlignedPoints();
    }

    Align(int alignAxis, int alignType, double value, ShapeContainer shapeContainer, int endPTindex) {
        this.alignAxis = alignAxis;
        this.alignType = alignType;
        this.value = value;
        this.shapeContainer = shapeContainer;
        this.endPTindex = endPTindex;
        this.setBoundingBox();
        this.setAlignedPoints();
        if (endPTindex >= 0) {
            Point2D[] PTs = this.shapeContainer.getElement().getEndPTs();
            this.boundingBox = new Rectangle2D.Double(PTs[endPTindex].getX(), PTs[endPTindex].getY(), 0.0, 0.0);
            this.alignedPoints = new Point2D[1];
            this.alignedPoints[0] = new Point2D.Double(PTs[endPTindex].getX(), PTs[endPTindex].getY());
        }
    }

    private void setBoundingBox() {
        Rectangle2D box = null;
        int endPTindex = this.getEndPTindex();
        if (this.getAlignType() == 6) {
            if (endPTindex >= 0) {
                Point2D[] PTs = this.getShapeContainer().getElement().getEndPTs();
                box = new Rectangle2D.Double(PTs[endPTindex].getX(), PTs[endPTindex].getY(), 0.0, 0.0);
            }
        } else {
            box = this.getShapeContainer().getBoundingBox();
        }
        this.boundingBox = box;
    }

    private void setAlignedPoints() {
        Rectangle2D box = this.getBoundingBox();
        double x = box.getX();
        double y = box.getY();
        double w = box.getWidth();
        double h = box.getHeight();
        double X = -10000.0;
        double Y = -10000.0;
        Point2D[] points = new Point2D[1];
        int alignAxis = this.getAlignAxis();
        int alignType = this.getAlignType();
        if (alignType == 0) {
            X = x;
            points[0] = new Point2D.Double(x, y + 0.5 * h);
        }
        if (alignType == 1) {
            X = x + 0.5 * w;
            points[0] = new Point2D.Double(x + 0.5 * w, y + 0.5 * h);
        }
        if (alignType == 2) {
            X = x + w;
            points[0] = new Point2D.Double(x + w, y + 0.5 * h);
        }
        if (alignType == 3) {
            Y = y;
            points[0] = new Point2D.Double(x + 0.5 * w, y);
        }
        if (alignType == 4) {
            Y = y + 0.5 * h;
            points[0] = new Point2D.Double(x + 0.5 * w, y + 0.5 * h);
        }
        if (alignType == 5) {
            Y = y + h;
            points[0] = new Point2D.Double(x + 0.5 * w, y + h);
        }
        if (alignType == 6) {
            points[0] = new Point2D.Double(x, y);
        }
        if (alignType != 6) {
            double eps = 1.0;
            Vector<Point2D> vector = new Vector<Point2D>();
            ShapeContainer[] containers = this.getShapeContainer().getGroupedSingleShapeContainers();
            for (int j = 0; j < containers.length; ++j) {
                Point2D[] PTs = containers[j].getElement().getCurve2D().getSamplingPTs(0.5 * AutoAlign.ErrorMargin);
                for (int i = 0; i < PTs.length; ++i) {
                    x = PTs[i].getX();
                    y = PTs[i].getY();
                    if (alignAxis == 10 && Math.abs(X - x) < eps) {
                        vector.add(PTs[i]);
                    }
                    if (alignAxis != 11 || !(Math.abs(Y - y) < eps)) continue;
                    vector.add(PTs[i]);
                }
            }
            int size = vector.size();
            if (size > 0) {
                points = new Point2D[size];
                for (int i = 0; i < size; ++i) {
                    points[i] = (Point2D)vector.get(i);
                }
            }
        }
        this.alignedPoints = points;
    }

    int getAlignAxis() {
        return this.alignAxis;
    }

    int getAlignType() {
        return this.alignType;
    }

    double getValue() {
        return this.value;
    }

    ShapeContainer getShapeContainer() {
        return this.shapeContainer;
    }

    int getEndPTindex() {
        return this.endPTindex;
    }

    Rectangle2D getBoundingBox() {
        return this.boundingBox;
    }

    public Point2D[] getAlignedPoints() {
        return this.alignedPoints;
    }

    public void update() {
        this.setBoundingBox();
        this.setAlignedPoints();
        if (this.endPTindex >= 0) {
            Point2D[] PTs = this.shapeContainer.getElement().getEndPTs();
            this.boundingBox = new Rectangle2D.Double(PTs[this.endPTindex].getX(), PTs[this.endPTindex].getY(), 0.0, 0.0);
            this.alignedPoints = new Point2D[1];
            this.alignedPoints[0] = new Point2D.Double(PTs[this.endPTindex].getX(), PTs[this.endPTindex].getY());
        }
    }

    public String toString() {
        String axisStr = "undef";
        String typeStr = "undef";
        String boxStr = "null";
        if (this.alignAxis >= 0) {
            axisStr = alignString[this.alignAxis];
        }
        if (this.alignType >= 0) {
            typeStr = alignString[this.alignType];
        }
        if (this.boundingBox != null) {
            boxStr = Util.Rect(this.boundingBox);
        }
        String str = "axis=" + axisStr + ", type=" + typeStr + ", value=" + this.value + ",\nboundingBox: " + boxStr + ", ShapeContainer=" + this.shapeContainer.getShapeId();
        return str;
    }

    public String toString(int indent) {
        String space = "";
        for (int i = 0; i < indent; ++i) {
            space = space + " ";
        }
        String axisStr = "undef";
        String typeStr = "undef";
        String boxStr = "null";
        if (this.alignAxis >= 0) {
            axisStr = alignString[this.alignAxis];
        }
        if (this.alignType >= 0) {
            typeStr = alignString[this.alignType];
        }
        if (this.boundingBox != null) {
            boxStr = Util.Rect(this.boundingBox);
        }
        String str = space + "axis=" + axisStr + ", type=" + typeStr + ", value=" + this.value + ",\n" + space + "boundingBox: " + boxStr + ", ShapeContainer=" + this.shapeContainer.getShapeId();
        return str;
    }
}

