/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import DrawTop.ObjectTable;
import geomExtension.Curve2D;
import geomExtension.GeneralCurve2DE;
import geomExtension.Segment2D;
import java.util.Vector;
import javax.swing.JOptionPane;
import shape.BlinkingShape;
import shape.GeneralCurveElement;
import shape.PaintStyle;
import shape.ShapeContainer;
import shape.ShapeElement;
import util.ContainerManager;

public class Combine {
    int debug = 0;

    public void combine() {
        ContainerManager containerManager = ObjectTable.getContainerManager();
        ShapeContainer[] selectedContainers = containerManager.getSelectedContainers();
        if (selectedContainers.length <= 1) {
            return;
        }
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < selectedContainers.length; ++i) {
            ShapeContainer[] containers = selectedContainers[i].getGroupedSingleShapeContainers();
            for (int j = 0; j < containers.length; ++j) {
                Curve2D curve2D = containers[j].getElement().getCurve2D();
                if (curve2D.isClosed()) continue;
                vector.add(containers[j]);
                containers[j].setBlinking(true);
            }
        }
        int size = vector.size();
        if (size > 0) {
            BlinkingShape blinkingShape = ObjectTable.getBlinkingShape();
            blinkingShape.startBlinking();
            String message = "";
            message = size == 1 ? " Error: The specified shape is not closed!" : " Error: The specified shapes are not closed!";
            JOptionPane.showMessageDialog(ObjectTable.getDrawMain(), message, "", 0);
            for (int j = 0; j < size; ++j) {
                ShapeContainer container = (ShapeContainer)vector.get(j);
                container.setBlinking(false);
            }
            blinkingShape.stopBlinking();
            return;
        }
        Segment2D moveSeg = new Segment2D(0, null);
        vector.clear();
        int indexMax = 0;
        PaintStyle newStyle = null;
        for (int i = 0; i < selectedContainers.length; ++i) {
            ShapeContainer[] containers = selectedContainers[i].getGroupedSingleShapeContainers();
            for (int j = 0; j < containers.length; ++j) {
                int containerIndex = containers[j].getContainerIndex();
                if (containerIndex > indexMax) {
                    indexMax = containerIndex;
                    newStyle = containers[j].getPaintStyle();
                }
                Curve2D curve2D = containers[j].getElement().getCurve2D();
                Segment2D[] segments = curve2D.getSegment2Ds();
                for (int k = 0; k < segments.length; ++k) {
                    vector.add(segments[k].clone());
                }
                vector.add(moveSeg.clone());
            }
        }
        Segment2D last = (Segment2D)vector.get(vector.size() - 1);
        if (last.getType() == 0) {
            vector.remove(vector.size() - 1);
        }
        Segment2D[] segments = new Segment2D[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            segments[i] = (Segment2D)vector.get(i);
        }
        GeneralCurve2DE combinedCurve = new GeneralCurve2DE(segments);
        GeneralCurveElement newElement = new GeneralCurveElement();
        newElement.setCurve2D(combinedCurve);
        ShapeContainer newContainer = new ShapeContainer();
        newContainer.setElement(newElement);
        newElement.setShapeContainer(newContainer);
        newContainer.setNewShapeId(containerManager, false);
        if (newStyle != null) {
            newContainer.setPaintStyle(newStyle);
        }
        if (this.debug >= 0) {
            System.out.println("\nCombined newContainer " + newContainer.toString());
        }
        containerManager.undoSetupStart();
        containerManager.addContainer(newContainer);
        newContainer.setSelected(true);
        for (int i = 0; i < selectedContainers.length; ++i) {
            containerManager.deleteContainer(selectedContainers[i]);
        }
        containerManager.undoSetupEnd();
    }

    public void breakCombine() {
        ContainerManager containerManager = ObjectTable.getContainerManager();
        ShapeContainer[] selectedContainers = containerManager.getSelectedContainers();
        for (int i = 0; i < selectedContainers.length; ++i) {
            int j;
            ShapeContainer shapeContainer = selectedContainers[i];
            ShapeElement element = shapeContainer.getElement();
            if (element.getTypeE() != 56) continue;
            GeneralCurveElement gelement = (GeneralCurveElement)element;
            int index = shapeContainer.getContainerIndex();
            PaintStyle paintStyle = shapeContainer.getPaintStyle();
            String str = "** breakCombine i=" + i + " Changing to SimpleElements containerIndex=" + index;
            ShapeElement[] elements = gelement.getSimpleShapeElements();
            if (elements.length <= 0) continue;
            ShapeContainer[] newContainers = new ShapeContainer[elements.length];
            for (j = 0; j < elements.length; ++j) {
                newContainers[j] = new ShapeContainer();
                newContainers[j].setElement(elements[j]);
                newContainers[j].setNewShapeId(containerManager, false);
                newContainers[j].setPaintStyle((PaintStyle)paintStyle.clone());
                str = str + "\n - newContainer[" + j + "]: " + newContainers[j].toShortString();
            }
            if (this.debug >= 0) {
                System.out.println(str);
            }
            containerManager.undoSetupStart();
            containerManager.deleteContainer(shapeContainer);
            for (j = 0; j < elements.length; ++j) {
                newContainers[j].setSelected(true);
                containerManager.addContainer(index, newContainers[j]);
            }
            containerManager.undoSetupEnd();
        }
    }
}

