/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import DrawTop.DrawPanel;
import DrawTop.ObjectTable;
import DrawTop.SelectionLS;
import geomExtension.CrossCurvePT;
import geomExtension.Curve2D;
import geomExtension.Curve2DUtil;
import geomExtension.CurvePT;
import geomExtension.GeneralCurve2DE;
import geomExtension.Matrix2D;
import geomExtension.Segment2D;
import geomExtension.Vector2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Point2D;
import java.util.Vector;
import javax.swing.AbstractAction;
import shape.CubicCurveElement;
import shape.DrawShapeUtil;
import shape.GeneralCurveElement;
import shape.LineElement;
import shape.PaintStyle;
import shape.PolylineElement;
import shape.ShapeContainer;
import shape.ShapeElement;
import shapeUtil.ConnectCurves;
import shapeUtil.Connection;
import shapeUtil.MouseHitShape;
import util.ContainerManager;
import util.Util;

class ConnectCurvesAction
extends AbstractAction
implements WindowListener {
    ConnectCurves dialog = null;
    int debug = 0;

    public ConnectCurvesAction(ConnectCurves dialog) {
        this.dialog = dialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String commandName = e.getActionCommand();
        String componentClassName = "";
        componentClassName = e.getSource().getClass().getSimpleName();
        String componentName = ((Component)e.getSource()).getName();
        if (this.debug > 0) {
            System.out.println("- ConnectCurvesAction.actionPerformed  commandName=" + commandName + ", source component name=" + componentName + ", source class simple name=" + componentClassName);
        }
        if (commandName.equals("Go")) {
            MouseHitShape[] clickedShapes = this.dialog.getClickedShapes();
            if (clickedShapes == null || clickedShapes.length == 0) {
                this.dialog.showMessage(" No curve selected. Click curve !", Color.RED);
                return;
            }
            int returnCode = this.connect();
            if (returnCode >= 0) {
                this.dialog.showMessage(" Succeeded !", Color.BLUE);
            }
            this.endProcess();
        }
        if (commandName.equals("Repeat")) {
            this.dialog.showMessage("", Color.BLUE);
            this.repeatProcess();
        }
        if (commandName.equals("Cancel")) {
            this.closeDialog();
        }
    }

    private int connect() {
        int returnCode = 0;
        Vector connectionVector = new Vector();
        this.getConnectionPTs(connectionVector);
        this.dialog.showMessage(" Show Connection Points. Go or Cancel !", Color.BLUE);
        returnCode = this.checkConnectionPTs(connectionVector);
        if (returnCode < 0) {
            this.dialog.goButton.setEnabled(false);
            return returnCode;
        }
        ObjectTable.getDrawPanel().repaint("connect curves");
        ShapeContainer connectedShape = this.createConnectedCurve(connectionVector);
        if (connectedShape == null) {
            return -2;
        }
        ContainerManager containerManager = ObjectTable.getContainerManager("");
        containerManager.undoSetupStart();
        connectedShape.setNewShapeId(containerManager, true);
        containerManager.addContainer(connectedShape);
        ShapeContainer[] containers = this.dialog.getSelectedCurves();
        for (int i = 0; i < containers.length; ++i) {
            containerManager.deleteContainer(containers[i]);
        }
        containerManager.undoSetupEnd();
        this.dialog.goButton.setEnabled(false);
        connectedShape.setSelected(true);
        return returnCode;
    }

    private void getConnectionPTs(Vector connectionVector) {
        MouseHitShape[] clickedShapes = this.dialog.getClickedShapes();
        if (this.debug > 0) {
            System.out.println("ConnectCurvesAction.connectCurves");
        }
        int size = 0;
        if (clickedShapes != null) {
            size = clickedShapes.length;
        }
        for (int i = 0; i < size; ++i) {
            if (size == 2 && i == size - 1) continue;
            int next = i + 1;
            if (next == size) {
                next = 0;
            }
            ShapeContainer target1 = clickedShapes[i].getShapeContainer();
            ShapeContainer target2 = clickedShapes[next].getShapeContainer();
            double tolerance = 4.0;
            this.calculateConnectionPTs(target1, target2, tolerance, connectionVector);
            target1.setSelected(false);
            target2.setSelected(false);
        }
    }

    private void calculateConnectionPTs(ShapeContainer target1, ShapeContainer target2, double tolerance, Vector connectionVector) {
        Curve2D curve2;
        Curve2D curve1 = target1.getElement().getCurve2D();
        CrossCurvePT[] crossPs = Curve2DUtil.getIntersectionPts(curve1, curve2 = target2.getElement().getCurve2D());
        if (crossPs != null && crossPs.length > 0) {
            for (int i = 0; i < crossPs.length; ++i) {
                Connection connection = new Connection(target2, target1, crossPs[i].getParameterT2(), crossPs[i].getParameterT1());
                connectionVector.add(connection);
            }
            return;
        }
        ShapeContainer container1 = null;
        ShapeContainer container2 = null;
        double distMin = 100000.0;
        Connection connectionSave = null;
        for (int i = 0; i < 2; ++i) {
            if (i == 0) {
                container1 = target1;
                container2 = target2;
            } else {
                container1 = target2;
                container2 = target1;
            }
            curve1 = container1.getElement().getCurve2D();
            curve2 = container2.getElement().getCurve2D();
            int numseg = curve1.getNumOfSegments();
            for (int j = 0; j < 2; ++j) {
                double dist;
                Point2D PT;
                CurvePT curvePT;
                double t = 0.0;
                if (j == 1) {
                    t = numseg;
                }
                if ((curvePT = Curve2DUtil.getShortestLine(PT = curve1.getP(t), curve2)) == null || (dist = Vector2D.dist(PT, curvePT.getP())) > distMin) continue;
                distMin = dist;
                connectionSave = new Connection(container2, container1, curvePT.getParameter(), t);
            }
        }
        if (connectionSave != null && distMin < tolerance) {
            connectionVector.add(connectionSave);
        }
    }

    private int checkConnectionPTs(Vector connectionVector) {
        int i;
        int returnCode = 0;
        MouseHitShape[] clickedShapes = this.dialog.getClickedShapes();
        if (this.debug > 0) {
            System.out.println("ConnectCurvesAction.connectCurves");
        }
        int size = 0;
        if (clickedShapes != null) {
            size = clickedShapes.length;
        }
        for (i = 0; i < size; ++i) {
            int j;
            if (size == 2 && i == size - 1) continue;
            int next = i + 1;
            if (next == size) {
                next = 0;
            }
            ShapeContainer target1 = clickedShapes[i].getShapeContainer();
            ShapeContainer target2 = clickedShapes[next].getShapeContainer();
            Connection[] connections = this.getConnections(target1, target2, connectionVector);
            if (size >= 3 && connections.length >= 2) {
                this.dialog.showMessage(" Error: Curve-" + (i + 1) + ", " + (next + 1) + " has multiple connection points !", Color.RED);
                if (this.debug > 0) {
                    for (j = 0; j < connections.length; ++j) {
                        System.out.println(" ** checkConnectionPTs" + connections[j].toString());
                    }
                }
                returnCode = -1;
                break;
            }
            if (size != 2 || connections.length < 3) continue;
            this.dialog.showMessage(" Error: Curve-" + (i + 1) + ", " + (next + 1) + " has too many connection points !", Color.RED);
            if (this.debug > 0) {
                for (j = 0; j < connections.length; ++j) {
                    System.out.println(" ** checkConnectionPTs" + connections[j].toString());
                }
            }
            returnCode = -1;
            break;
        }
        if (returnCode < 0) {
            for (i = 0; i < connectionVector.size(); ++i) {
                Connection connection = (Connection)connectionVector.get(i);
                double markSize = 3.0;
                DrawShapeUtil.drawTempShape("ConnectCurves", connection.getConnectorPT(), markSize, "", Color.BLUE);
                DrawShapeUtil.drawTempShape("ConnectCurves", connection.getTargetPT(), markSize, "", Color.BLUE);
            }
        }
        ObjectTable.getDrawPanel().repaint("ConnectCurves");
        return returnCode;
    }

    private Connection[] getConnections(ShapeContainer target1, ShapeContainer target2, Vector connectionVector) {
        Vector<Connection> out = new Vector<Connection>();
        int size = connectionVector.size();
        for (int i = 0; i < size; ++i) {
            Connection connection = (Connection)connectionVector.get(i);
            ShapeContainer connector = connection.getConnector();
            ShapeContainer target = connection.getTarget();
            if (connector == target1 && target == target2) {
                out.add(connection);
            }
            if (connector != target2 || target != target1) continue;
            Connection newConnection = new Connection(connection.getConnector(), connection.getTarget(), connection.getConnectorParameter(), connection.getTargetParameter());
            out.add(newConnection);
        }
        Connection[] connections = new Connection[out.size()];
        for (int i = 0; i < out.size(); ++i) {
            connections[i] = (Connection)out.get(i);
        }
        return connections;
    }

    private Connection[] getConnections(ShapeContainer target, Vector connectionVector) {
        Vector<Connection> out = new Vector<Connection>();
        int size = connectionVector.size();
        for (int i = 0; i < size; ++i) {
            Connection connection = (Connection)connectionVector.get(i);
            ShapeContainer Connector = connection.getConnector();
            ShapeContainer Target = connection.getTarget();
            if (Connector == target) {
                out.add(connection);
            }
            if (Target != target) continue;
            Connection newConnection = new Connection(connection.getConnector(), connection.getTarget(), connection.getConnectorParameter(), connection.getTargetParameter());
            out.add(newConnection);
        }
        Connection[] connections = new Connection[out.size()];
        for (int i = 0; i < out.size(); ++i) {
            connections[i] = (Connection)out.get(i);
        }
        return connections;
    }

    private ShapeContainer createConnectedCurve(Vector connectionVector) {
        MouseHitShape[] clickedShapes = this.dialog.getClickedShapes();
        if (this.debug > 0) {
            System.out.println("ConnectCurvesAction.connectCurves");
        }
        int size = 0;
        if (clickedShapes != null) {
            size = clickedShapes.length;
        }
        Curve2D[] trimmedCurves = new Curve2D[size];
        ShapeContainer[] containers = new ShapeContainer[size];
        for (int i = 0; i < size; ++i) {
            ShapeContainer container;
            containers[i] = container = clickedShapes[i].getShapeContainer();
            double clickedT = clickedShapes[i].getCurveParameter();
            double[] interval = this.getCurveInterval(container, clickedT, connectionVector);
            Curve2D curve = container.getElement().getCurve2D();
            trimmedCurves[i] = Curve2DUtil.trimCurve2D(curve, interval[0], interval[1]);
        }
        Curve2D connectedCurve = this.createConnectedCurve2D(trimmedCurves[0], trimmedCurves[1]);
        for (int i = 2; i < size; ++i) {
            connectedCurve = this.createConnectedCurve2D(connectedCurve, trimmedCurves[i]);
        }
        if (this.debug > 0) {
            System.out.println("createConnectedCurve connectedCurve : " + connectedCurve.toString());
        }
        ShapeElement connectedElement = null;
        if (connectedCurve.getType2DE() == 51) {
            connectedElement = new LineElement();
        }
        if (connectedCurve.getType2DE() == 54) {
            connectedElement = new PolylineElement();
        }
        if (connectedCurve.getType2DE() == 55) {
            connectedElement = new CubicCurveElement();
        }
        if (connectedCurve.getType2DE() == 56) {
            connectedElement = new GeneralCurveElement();
        }
        if (connectedElement == null) {
            System.err.println("*** Error in ConnectCurves : Null connected curve !");
            return null;
        }
        connectedElement.setCurve2D(connectedCurve);
        ShapeContainer connectedShape = new ShapeContainer();
        connectedShape.setElement(connectedElement);
        connectedElement.setShapeContainer(connectedShape);
        PaintStyle commonStyle = PaintStyle.getCommonPaintStyle(containers);
        connectedShape.setPaintStyle(commonStyle);
        if (this.debug > 0) {
            System.out.println("createConnectedCurve connectedShape : " + connectedShape.toString());
        }
        return connectedShape;
    }

    private Curve2D createConnectedCurve2D(Curve2D trimmedCurve1, Curve2D trimmedCurve2) {
        int i;
        Point2D[] endP1 = new Point2D[]{trimmedCurve1.getP(0.0), trimmedCurve1.getP(trimmedCurve1.getNumOfSegments())};
        Point2D[] endP2 = new Point2D[]{trimmedCurve2.getP(0.0), trimmedCurve2.getP(trimmedCurve2.getNumOfSegments())};
        double distMin = 100000.0;
        int isave = -1;
        int jsave = -1;
        for (int i2 = 0; i2 < 2; ++i2) {
            for (int j = 0; j < 2; ++j) {
                double dist = Vector2D.dist(endP1[i2], endP2[j]);
                if (!(dist < distMin)) continue;
                distMin = dist;
                isave = i2;
                jsave = j;
            }
        }
        Curve2D newCurve1 = (Curve2D)trimmedCurve1.clone();
        Curve2D newCurve2 = (Curve2D)trimmedCurve2.clone();
        if (isave == 0) {
            newCurve1.reverse();
        }
        if (jsave == 1) {
            newCurve2.reverse();
        }
        int numseg1 = newCurve1.getNumOfSegments();
        int numseg2 = newCurve2.getNumOfSegments();
        this.ajustCurve(newCurve2, newCurve1);
        Segment2D[] newSegments = new Segment2D[numseg1 + numseg2];
        for (i = 0; i < numseg1; ++i) {
            newSegments[i] = newCurve1.getSegment2D(i);
        }
        for (i = 0; i < numseg2; ++i) {
            newSegments[i + numseg1] = newCurve2.getSegment2D(i);
        }
        GeneralCurve2DE connectedCurve = new GeneralCurve2DE(newSegments);
        Curve2D simpleCurve = Curve2DUtil.getSimpleCurve2D(connectedCurve);
        return simpleCurve;
    }

    private double[] getCurveInterval(ShapeContainer container, double clickedT, Vector connectionVector) {
        Curve2D curve = container.getElement().getCurve2D();
        Connection[] connections = this.getConnections(container, connectionVector);
        Vector<Double> work = new Vector<Double>();
        work.add(new Double(0.0));
        work.add(new Double(curve.getNumOfSegments()));
        int size = 0;
        if (connections != null) {
            size = connections.length;
        }
        block0: for (int i = 0; i < size; ++i) {
            double connectionT = connections[i].getConnectorParameter();
            for (int j = 0; j < work.size() - 1; ++j) {
                double t1 = (Double)work.get(j);
                double t2 = (Double)work.get(j + 1);
                if (!(connectionT >= t1) || !(connectionT <= t2) || !(Math.abs(connectionT - t1) > 1.0E-5) || !(Math.abs(t2 - connectionT) > 1.0E-5)) continue;
                work.add(j + 1, new Double(connectionT));
                continue block0;
            }
        }
        String str = "** getCurveInterval";
        for (int i = 0; i < work.size(); ++i) {
            double t = (Double)work.get(i);
            str = str + ", t=" + Util.Num(t);
        }
        double[] interval = null;
        for (int j = 0; j < work.size() - 1; ++j) {
            double t1 = (Double)work.get(j);
            double t2 = (Double)work.get(j + 1);
            if (!(clickedT >= t1) || !(clickedT <= t2)) continue;
            interval = new double[]{t1, t2};
            break;
        }
        if (this.debug > 0) {
            System.out.println("** getCurveInterval interval=" + Util.Num((double)interval[0]) + "," + Util.Num((double)interval[1]));
        }
        return interval;
    }

    private void ajustCurve(Curve2D targetCurve, Curve2D anchorCurve) {
        int numseg1 = anchorCurve.getNumOfSegments();
        int numseg2 = targetCurve.getNumOfSegments();
        Point2D connectionP1 = anchorCurve.getP(numseg1);
        Point2D connectionP2 = targetCurve.getP(0.0);
        Point2D anchorP = targetCurve.getP(numseg2);
        Vector2D r0 = Vector2D.sub(connectionP2, anchorP);
        Vector2D r = Vector2D.sub(connectionP1, anchorP);
        Matrix2D rotationMatrix = Matrix2D.getRotationMatrix(anchorP, r0, r);
        targetCurve.transform(rotationMatrix);
        connectionP2 = targetCurve.getP(numseg2);
        connectionP1 = anchorCurve.getP(0.0);
        double tolerance = 4.0;
        if (Vector2D.dist(connectionP1, connectionP2) < tolerance) {
            anchorP = targetCurve.getP(0.0);
            r0 = Vector2D.sub(connectionP2, anchorP);
            r = Vector2D.sub(connectionP1, anchorP);
            rotationMatrix = Matrix2D.getRotationMatrix(anchorP, r0, r);
            targetCurve.transform(rotationMatrix);
        }
    }

    private void endProcess() {
        DrawShapeUtil.clearTempShape("ConnectCurves");
        ContainerManager manager = ObjectTable.getContainerManager("ConnectCurves");
        ShapeContainer[] containers = manager.getSelectedContainers();
        int size = 0;
        if (containers != null) {
            size = containers.length;
        }
        for (int i = 0; i < size; ++i) {
            containers[i].setSelected(false);
        }
        this.dialog.shapeVector.clear();
        this.dialog.goButton.setEnabled(false);
        this.dialog.repeatButton.setEnabled(true);
        SelectionLS selectionLS = ObjectTable.getSelectionLS("");
        selectionLS.removeSelectionListener(this.dialog);
        DrawPanel drawPanel = ObjectTable.getDrawPanel("");
        drawPanel.repaint();
    }

    private void repeatProcess() {
        DrawShapeUtil.clearTempShape("ConnectCurves");
        ContainerManager manager = ObjectTable.getContainerManager("ConnectCurves");
        ShapeContainer[] containers = manager.getSelectedContainers();
        int size = 0;
        if (containers != null) {
            size = containers.length;
        }
        for (int i = 0; i < size; ++i) {
            containers[i].setSelected(false);
        }
        this.dialog.shapeVector.clear();
        this.dialog.goButton.setEnabled(false);
        this.dialog.repeatButton.setEnabled(false);
        SelectionLS selectionLS = ObjectTable.getSelectionLS("");
        selectionLS.addSelectionListener(this.dialog);
        DrawPanel drawPanel = ObjectTable.getDrawPanel("");
        drawPanel.repaint();
    }

    private void closeDialog() {
        this.dialog.setVisible(false);
        DrawPanel drawPanel = ObjectTable.getDrawPanel("");
        DrawShapeUtil.clearTempShape("ConnectCurves");
        this.dialog.setVisible(false);
        SelectionLS selectionLS = ObjectTable.getSelectionLS("");
        selectionLS.removeSelectionListener(this.dialog);
        drawPanel.repaint("ConnectCurves");
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.closeDialog();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

