/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import geomExtension.Curve2D;
import geomExtension.Vector2D;
import java.awt.geom.Point2D;
import shape.ShapeContainer;
import shape.ShapeElement;
import shapeUtil.MouseHitShape;
import util.Util;

public class Connection {
    public ShapeContainer target = null;
    public ShapeContainer connector = null;
    public double targetParameter;
    public double connectorParameter;
    public static int debug = 0;

    public Connection() {
    }

    public Connection(ShapeContainer target, ShapeContainer connector, double targetParameter, double connectorParameter) {
        this.target = target;
        this.connector = connector;
        this.targetParameter = targetParameter;
        this.connectorParameter = connectorParameter;
    }

    public ShapeContainer getTarget() {
        return this.target;
    }

    public ShapeContainer getConnector() {
        return this.connector;
    }

    public void setTargetParameter(double targetParameter) {
        this.targetParameter = targetParameter;
    }

    public double getTargetParameter() {
        return this.targetParameter;
    }

    public void setConnectorParameter(double connectorParameter) {
        this.connectorParameter = connectorParameter;
    }

    public double getConnectorParameter() {
        return this.connectorParameter;
    }

    public Point2D getTargetPT() {
        Curve2D curve = this.target.getElement().getCurve2D();
        return curve.getP(this.targetParameter);
    }

    public Point2D getConnectorPT() {
        Curve2D curve = this.connector.getElement().getCurve2D();
        return curve.getP(this.connectorParameter);
    }

    public Vector2D getTargetTangent() {
        Curve2D curve = this.target.getElement().getCurve2D();
        return curve.getTangent(this.targetParameter);
    }

    public Vector2D getConnectorTangent() {
        Curve2D curve = this.connector.getElement().getCurve2D();
        return curve.getTangent(this.connectorParameter);
    }

    public boolean equalsInNormalData(Connection connection) {
        double eps = 1.0E-10;
        if (connection.getTarget().getSerialNumber() != this.getTarget().getSerialNumber()) {
            return false;
        }
        if (connection.getConnector().getSerialNumber() != this.getConnector().getSerialNumber()) {
            return false;
        }
        double delta = connection.getTargetParameter() - this.getTargetParameter();
        if (Math.abs(delta) > eps) {
            return false;
        }
        delta = connection.getConnectorParameter() - this.getConnectorParameter();
        return !(Math.abs(delta) > eps);
    }

    public boolean equalsInReversedData(Connection connection) {
        double eps = 1.0E-10;
        if (connection.getTarget().getSerialNumber() != this.getConnector().getSerialNumber()) {
            return false;
        }
        if (connection.getConnector().getSerialNumber() != this.getTarget().getSerialNumber()) {
            return false;
        }
        double delta = connection.getTargetParameter() - this.getConnectorParameter();
        if (Math.abs(delta) > eps) {
            return false;
        }
        delta = connection.getConnectorParameter() - this.getTargetParameter();
        return !(Math.abs(delta) > eps);
    }

    public double getErrorDistance() {
        Point2D p1;
        Point2D p0 = this.connector.getElement().getCurve2D().getP(this.connectorParameter);
        double dist = Vector2D.dist(p0, p1 = this.target.getElement().getCurve2D().getP(this.targetParameter));
        if (dist < 1.0E-10) {
            dist = 0.0;
        }
        return dist;
    }

    protected boolean closeToMouseHitShape(MouseHitShape mouseHitShape) {
        Point2D connectorP;
        ShapeContainer connector;
        Point2D targetP;
        int index;
        int endPTindex = -1;
        if (mouseHitShape != null && (index = mouseHitShape.getEndIndexCloseToMouse()) >= 0) {
            endPTindex = index;
        }
        boolean exceptional = false;
        if (mouseHitShape == null || endPTindex < 0) {
            return false;
        }
        ShapeContainer mouseHitContainer = mouseHitShape.getShapeContainer();
        Point2D mousePT = mouseHitShape.getMousePosition();
        ShapeContainer target = this.getTarget();
        if (target.compare(mouseHitContainer) && Vector2D.dist(mousePT, targetP = this.getTargetPT()) < 5.0) {
            exceptional = true;
        }
        if ((connector = this.getConnector()).compare(mouseHitContainer) && Vector2D.dist(mousePT, connectorP = this.getConnectorPT()) < 5.0) {
            exceptional = true;
        }
        if (debug > 0) {
            System.out.println("isEndPTConnection  exceptional=" + exceptional + ",  mouseHitContainer=" + mouseHitContainer.getShapeId() + ", endPTindex=" + endPTindex + "\n       connection=" + this.toString());
        }
        return exceptional;
    }

    protected void resizeConnector(Point2D oldPoint, Point2D newPoint) {
        double dist = Vector2D.dist(oldPoint, newPoint);
        if (dist < 1.0E-12) {
            return;
        }
        ShapeElement shapeElement = this.connector.getElement();
        int index = 0;
        if (this.getConnectorParameter() > 0.0) {
            index = 1;
        }
        shapeElement.moveEndPoint(0, index, oldPoint, newPoint);
        if (debug > 0) {
            System.out.println("resizeConnector, connection=" + this.toString());
        }
    }

    protected void resizeTarget(Point2D oldPoint, Point2D newPoint) {
        ShapeElement shapeElement = this.target.getElement();
        int index = 0;
        if (this.getTargetParameter() > 0.0) {
            index = 1;
        }
        shapeElement.moveEndPoint(0, index, oldPoint, newPoint);
    }

    public String toShortString() {
        String str = "";
        str = str + " target=" + this.target.getShapeId() + ", connector=" + this.connector.getShapeId() + ", error distance=" + this.getErrorDistance();
        return str;
    }

    public String toString() {
        String str = "";
        str = str + " target=" + this.target.getShapeId() + ", connector=" + this.connector.getShapeId() + ", targetP=" + Util.Num(this.targetParameter) + ", connectorP=" + Util.Num(this.connectorParameter) + ", targetPT=" + Util.Pt(this.getTargetPT()) + ", connectorPT=" + Util.Pt(this.getConnectorPT()) + ", error distance=" + this.getErrorDistance();
        return str;
    }

    public Object clone() {
        ShapeContainer targetC = (ShapeContainer)this.target.clone();
        ShapeContainer connectorC = (ShapeContainer)this.connector.clone();
        double targetPara = this.getTargetParameter();
        double connectorPara = this.getConnectorParameter();
        Connection connection = new Connection(targetC, connectorC, targetPara, connectorPara);
        return connection;
    }

    public static boolean isConnectorType(ShapeContainer connector) {
        if (connector.getElement() == null) {
            return false;
        }
        int connectorType = connector.getElement().getTypeE();
        if (connectorType != 51 && connectorType != 52 && connectorType != 53 && connectorType != 54) {
            return false;
        }
        return !connector.getElement().isClosed();
    }

    public static boolean isTargetType(ShapeContainer target) {
        if (target.getContainerType() == ShapeContainer.GROUP) {
            return false;
        }
        return target.getElement() != null;
    }
}

