/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import DrawTop.DrawPanel;
import DrawTop.DrawParameters;
import DrawTop.ObjectTable;
import geomExtension.Curve2D;
import geomExtension.CurvePT;
import geomExtension.Vector2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import shape.DrawShapeUtil;
import shapeUtil.ConnectionEvent;
import shapeUtil.ConnectionLS;
import shapeUtil.ConnectionLSTestAction;
import shapeUtil.ConnectionListener;

public class ConnectionLSTest
extends JDialog
implements ConnectionListener {
    ConnectionLSTestAction action = null;
    JRadioButton clickPTOnShape = null;
    JRadioButton removeClickedPT = null;
    JRadioButton removeAllClickedPT = null;

    public ConnectionLSTest() {
        super((Frame)ObjectTable.getDrawMain(), "click on a shape");
        this.setName("click on a shape");
        this.action = new ConnectionLSTestAction(this);
        this.createDialog();
    }

    public void createDialog() {
        Window owner = this.getOwner();
        Point centerP = new Point(owner.getX() + 10, owner.getY() + 80);
        this.setLocation(centerP);
        this.addWindowListener(this.action);
        Container contentPane = this.getContentPane();
        Box box = Box.createVerticalBox();
        contentPane.add(box);
        JPanel inputPanel = new JPanel();
        TitledBorder frameBorder = BorderFactory.createTitledBorder("Menu");
        inputPanel.setBorder(frameBorder);
        GridLayout inputPanelLayout = new GridLayout(3, 1);
        inputPanelLayout.setHgap(20);
        inputPanel.setLayout(inputPanelLayout);
        ButtonGroup group = new ButtonGroup();
        this.clickPTOnShape = new JRadioButton("Click on a shape boundary");
        this.removeClickedPT = new JRadioButton("Remove a mark by clicking it");
        this.removeAllClickedPT = new JRadioButton("Remove all marks");
        this.clickPTOnShape.setActionCommand("Click");
        this.removeClickedPT.setActionCommand("Remove");
        this.removeAllClickedPT.setActionCommand("Remove all");
        this.clickPTOnShape.addActionListener(this.action);
        this.removeClickedPT.addActionListener(this.action);
        this.removeAllClickedPT.addActionListener(this.action);
        group.add(this.clickPTOnShape);
        this.clickPTOnShape.setSelected(true);
        group.add(this.removeClickedPT);
        group.add(this.removeAllClickedPT);
        inputPanel.add(this.clickPTOnShape);
        inputPanel.add(this.removeClickedPT);
        inputPanel.add(this.removeAllClickedPT);
        box.add(Box.createVerticalStrut(5));
        box.add(inputPanel);
    }

    public void showDialog() {
        this.pack();
        this.setVisible(true);
        this.addConnectionListener();
    }

    public void addConnectionListener() {
        ConnectionLS connectionLS = ObjectTable.getConnectionLS();
        connectionLS.activateListener(true);
        connectionLS.addConnectionListener(this);
        ObjectTable.getSelectionLS().end();
    }

    public void removeConnectionListener() {
        ConnectionLS connectionLS = ObjectTable.getConnectionLS();
        connectionLS.activateListener(false);
        connectionLS.removeConnectionListener(this);
        ObjectTable.getSelectionLS().start();
    }

    @Override
    public void connected(ConnectionEvent event) {
        CurvePT curvePT = event.getCurvePT();
        DrawPanel drawPanel = ObjectTable.getDrawPanel();
        if (this.clickPTOnShape.isSelected()) {
            double t = curvePT.getParameter();
            Point2D pt = curvePT.getP();
            Curve2D curve = curvePT.getCurve();
            CurvePT[] PTs = curve.getCharacteristicPoints();
            if (t >= 0.0) {
                int type = 0;
                for (int i = 0; i < PTs.length; ++i) {
                    double dist = Vector2D.dist(pt, PTs[i].getP());
                    if (!(dist < 0.5)) continue;
                    type = 1;
                }
                this.drawMark(pt, type);
            }
        }
        if (this.removeClickedPT.isSelected()) {
            DrawShapeUtil.removeTempShape("ClickedPT", curvePT.getP());
            drawPanel.repaint();
        }
        drawPanel.repaint();
    }

    public void receiveConnection(CurvePT curvePT) {
        DrawPanel drawPanel = ObjectTable.getDrawPanel();
        if (this.clickPTOnShape.isSelected()) {
            double t = curvePT.getParameter();
            Point2D pt = curvePT.getP();
            Curve2D curve = curvePT.getCurve();
            CurvePT[] PTs = curve.getCharacteristicPoints();
            if (t >= 0.0) {
                int type = 0;
                for (int i = 0; i < PTs.length; ++i) {
                    double dist = Vector2D.dist(pt, PTs[i].getP());
                    if (!(dist < 0.5)) continue;
                    type = 1;
                }
                this.drawMark(pt, type);
            }
        }
        if (this.removeClickedPT.isSelected()) {
            DrawShapeUtil.removeTempShape("ClickedPT", curvePT.getP());
            drawPanel.repaint();
        }
        drawPanel.repaint();
    }

    private void drawMark(Point2D point, int type) {
        double scale = DrawParameters.getScale();
        double x = point.getX();
        double y = point.getY();
        double width = 16.0 / scale;
        Ellipse2D.Double largeCircle = new Ellipse2D.Double(x - 0.5 * width, y - 0.5 * width, width, width);
        width = 14.0 / scale;
        Rectangle2D.Double largeRect = new Rectangle2D.Double(x - 0.5 * width, y - 0.5 * width, width, width);
        Color color = Color.RED;
        RectangularShape shapeL = largeCircle;
        float lineWidth = 1.0f;
        if (type > 0) {
            color = Color.BLUE;
            shapeL = largeRect;
            lineWidth = 1.0f / (float)scale;
        }
        width = 6.0 / scale;
        Rectangle2D.Double smallRect = new Rectangle2D.Double(x - 0.5 * width, y - 0.5 * width, width, width);
        DrawShapeUtil.drawTempShape("ClickedPT", smallRect, null, color, color, "", null, null);
        BasicStroke defaultStroke = new BasicStroke(lineWidth, 2, 0, 10.0f);
        DrawShapeUtil.drawTempShape("ClickedPT", shapeL, defaultStroke, color, null, "", null, null);
    }
}

