/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import DrawTop.Command;
import DrawTop.DrawParameters;
import DrawTop.ExecCommand;
import DrawTop.ListenerPanel;
import DrawTop.ObjectTable;
import geomExtension.CurvePT;
import geomExtension.Vector2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import menu.MenuUtil;
import shape.CubicCurveElement;
import shape.DrawShapeUtil;
import shape.EllipseElement;
import shape.LineElement;
import shape.PolylineElement;
import shape.RectangleElement;
import shape.RoundRectangleElement;
import shape.ShapeContainer;
import shape.ShapeElement;
import shape.ShapeElementUtil;
import shapeUtil.ComponentLibDialog;
import shapeUtil.ConnectionLS;
import shapeUtil.DiscreteAngledLine;
import util.ContainerManager;

public class CreateShapeLS
implements MouseListener,
MouseMotionListener {
    ShapeContainer shapeContainer = null;
    ShapeElement shapeElement = null;
    int commandId = 0;
    boolean isLineFamily = false;
    boolean isPolylineFamily = false;
    boolean isRectangleFamily = false;
    boolean isComponentFamily = false;
    Point2D startPoint = null;
    Point2D endPoint = null;
    Point2D oldPoint = null;
    Point2D pressedPoint = null;
    Point2D draggedPoint = null;
    boolean clicked = false;
    boolean rightButtonPressed = false;
    int ctrl = 0;
    Point2D[] committedNodePoints = new Point2D[0];
    Point2D[] tentativeNodePoints = new Point2D[0];
    public static int debug = 0;
    int tempShapeNumber = 0;
    int idNumber = 0;

    public void creatingStart(int commandId) {
        this.shapeContainer = new ShapeContainer();
        this.shapeContainer.setMode(1);
        DrawParameters.MODE = 1;
        this.shapeContainer.setSelected(true);
        this.commandId = commandId;
        if (commandId >= 51 && commandId <= 53) {
            this.isLineFamily = true;
        }
        if (commandId >= 54 && commandId <= 55) {
            this.isPolylineFamily = true;
        }
        if (commandId >= 41 && commandId <= 46) {
            this.isRectangleFamily = true;
        }
        if (commandId == 39) {
            this.isComponentFamily = true;
        }
        ListenerPanel listenerPanel = ObjectTable.getListenerPanel();
        listenerPanel.addMouseListener(this);
        listenerPanel.addMouseMotionListener(this);
        ObjectTable.getSelectionLS().end();
        ObjectTable.getConnectionLS().activateListener(false);
        ObjectTable.getDrawMain().setCursor(new Cursor(1));
        if (debug > 0) {
            System.out.println("creatingStart shapeElementType=" + commandId + ", " + Command.getCommandString(commandId));
        }
        switch (commandId) {
            case 41: {
                this.shapeElement = new RectangleElement();
                this.shapeContainer.setElement(this.shapeElement);
                this.shapeElement.setShapeContainer(this.shapeContainer);
                break;
            }
            case 43: {
                this.shapeElement = new RectangleElement();
                this.shapeContainer.setElement(this.shapeElement);
                this.shapeElement.setShapeContainer(this.shapeContainer);
                break;
            }
            case 44: {
                this.shapeElement = new RoundRectangleElement();
                this.shapeContainer.setElement(this.shapeElement);
                this.shapeElement.setShapeContainer(this.shapeContainer);
                break;
            }
            case 45: {
                this.shapeElement = new EllipseElement();
                this.shapeContainer.setElement(this.shapeElement);
                this.shapeElement.setShapeContainer(this.shapeContainer);
                break;
            }
            case 51: {
                this.shapeElement = new LineElement();
                this.shapeContainer.setElement(this.shapeElement);
                this.shapeElement.setShapeContainer(this.shapeContainer);
                break;
            }
            case 52: {
                this.shapeElement = new LineElement();
                this.shapeContainer.setElement(this.shapeElement);
                this.shapeElement.setShapeContainer(this.shapeContainer);
                this.shapeContainer.setArrowStyle("5");
                break;
            }
            case 53: {
                this.shapeElement = new LineElement();
                this.shapeContainer.setElement(this.shapeElement);
                this.shapeElement.setShapeContainer(this.shapeContainer);
                this.shapeContainer.setArrowStyle("7");
                break;
            }
            case 54: {
                this.shapeElement = new PolylineElement();
                this.shapeContainer.setElement(this.shapeElement);
                this.shapeElement.setShapeContainer(this.shapeContainer);
                break;
            }
            case 55: {
                this.shapeElement = new CubicCurveElement();
                this.shapeContainer.setElement(this.shapeElement);
                this.shapeElement.setShapeContainer(this.shapeContainer);
                break;
            }
            case 39: {
                this.shapeContainer.setMode(80);
                MenuUtil menuUtil = ObjectTable.getMenuUtil();
                Component[] components = menuUtil.getMenuComponents(Command.getCommandString(80));
                if (components == null) {
                    System.err.println("*** Error CreateShapeLS.creatingStart:ialogOfComponent not found");
                    return;
                }
                Component targetObject = null;
                for (int i = 0; i < components.length; ++i) {
                    String simpleName = components[i].getClass().getSimpleName();
                    if (!simpleName.startsWith("ComponentLibDialog")) continue;
                    targetObject = components[i];
                    break;
                }
                if (targetObject == null) {
                    System.err.println("*** Error CreateShapeLS.creatingStart: ComponentLibDialog not found by MenuUtil.getDrawMenu");
                    this.abort();
                    return;
                }
                ComponentLibDialog dialog = (ComponentLibDialog)targetObject;
                ShapeContainer selectedComponent = dialog.getSelectedComponent();
                if (debug > 0) {
                    System.out.println("CreateShapeLS.creatingStart selectedComponent=" + selectedComponent.toShortString());
                }
                ShapeContainer clone = (ShapeContainer)selectedComponent.clone();
                this.shapeElement = clone.getElement();
                this.shapeContainer.setElement(this.shapeElement);
                this.shapeElement.setShapeContainer(this.shapeContainer);
                if (clone.getTextBox() != null) {
                    this.shapeContainer.setTextBox(clone.getTextBox());
                }
                this.shapeContainer.setPaintStyle(clone.getPaintStyle());
                this.shapeContainer.setVisible(false);
                break;
            }
        }
        ContainerManager containerManager = ObjectTable.getContainerManager();
        this.shapeContainer.setNewShapeId(containerManager, false);
        String original_type = Command.getCommandString(250);
        this.shapeContainer.setProperty(original_type, this.shapeElement.getShapeIdString(), "CreateShapeLS");
        containerManager.addContainer(this.shapeContainer);
        if (debug > 0) {
            System.out.println("\n*** creatingStart this.shapeContainer=" + this.shapeContainer.toString());
        }
    }

    public void creatingEnd() {
        if (this.commandId >= 41 && this.commandId <= 45) {
            this.shapeContainer.addTextBox();
            this.shapeContainer.makeTextBoxEditable(true);
        }
        DrawShapeUtil.clearAllTempShapes();
        ObjectTable.getDrawMain().setCursor(new Cursor(0));
        ListenerPanel listenerPanel = ObjectTable.getListenerPanel();
        listenerPanel.removeMouseListener(this);
        listenerPanel.removeMouseMotionListener(this);
        ObjectTable.getSelectionLS().start();
        this.shapeContainer.setMode(0);
        DrawParameters.MODE = 0;
        if (debug > 0) {
            System.out.println(" -CS(" + this.idNumber++ + ")ShapeContainer create mode end " + this.toString());
        }
        ContainerManager containerManager = ObjectTable.getContainerManager();
        containerManager.deleteContainer(this.shapeContainer);
        containerManager.undoSetupStart();
        containerManager.addContainer(this.shapeContainer);
        containerManager.undoSetupEnd();
        Command command = new Command(this.commandId, 4, null);
        ExecCommand execCommand = ObjectTable.getExecCommand();
        execCommand.exec(command);
    }

    public int getCommandId() {
        return this.commandId;
    }

    public void abort() {
        DrawShapeUtil.clearAllTempShapes();
        ListenerPanel listenerPanel = ObjectTable.getListenerPanel();
        listenerPanel.removeMouseListener(this);
        listenerPanel.removeMouseMotionListener(this);
        ObjectTable.getSelectionLS().start();
        ContainerManager containerManager = ObjectTable.getContainerManager();
        containerManager.deleteContainer(this.shapeContainer);
        System.out.println("** CreateShapeLS aborted");
        ExecCommand execCommand = ObjectTable.getExecCommand();
        execCommand.activeCreateShapeLS = null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        ConnectionLS connectionLS;
        CurvePT onlinePT;
        if (debug > 0) {
            System.out.println("\nCreatShapeLS.mousePressed");
        }
        this.clicked = false;
        double scale = DrawParameters.getScale();
        double X = (double)e.getX() / scale;
        double Y = (double)e.getY() / scale;
        int key = e.getModifiersEx();
        int ctrl = 0;
        this.rightButtonPressed = false;
        if (e.isPopupTrigger()) {
            this.rightButtonPressed = true;
        }
        if ((key & 0x40) != 0) {
            ctrl = 1;
        }
        if ((key & 0x80) != 0) {
            ctrl = 2;
        }
        if ((key & 0x200) != 0) {
            ctrl = 3;
        }
        if (ctrl != 0) {
            this.ctrl = ctrl;
        }
        this.pressedPoint = new Point2D.Double(X, Y);
        this.startPoint = new Point2D.Double(X, Y);
        boolean enable = DrawParameters.ENABLE_CONNECTOR;
        if (enable && (onlinePT = (connectionLS = ObjectTable.getConnectionLS()).drawMouseHitPT(0, this.startPoint, null, this.shapeContainer)) != null) {
            this.startPoint = onlinePT.getP();
        }
        ObjectTable.getDrawPanel().repaint("CreateShapeLS");
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Vector2D vec;
        ConnectionLS connectionLS;
        CurvePT onlinePT;
        boolean enable;
        if (debug > 0) {
            System.out.println("\nCreatShapeLS.mouseDragged");
        }
        double scale = DrawParameters.getScale();
        double X = (double)e.getX() / scale;
        double Y = (double)e.getY() / scale;
        int key = e.getModifiersEx();
        int ctrl = 0;
        if ((key & 0x40) != 0) {
            ctrl = 1;
        }
        if ((key & 0x80) != 0) {
            ctrl = 2;
        }
        if ((key & 0x200) != 0) {
            ctrl = 3;
        }
        if (ctrl != 0) {
            this.ctrl = ctrl;
        }
        this.draggedPoint = new Point2D.Double(X, Y);
        this.endPoint = new Point2D.Double(X, Y);
        if (ctrl > 0) {
            if (this.isRectangleFamily || this.isComponentFamily) {
                this.endPoint = DiscreteAngledLine.getControlledPT(45.0, 90.0, this.startPoint, this.endPoint);
            } else if (this.isLineFamily) {
                this.endPoint = DiscreteAngledLine.getControlledPT(0.0, 45.0, this.startPoint, this.endPoint);
            }
        }
        if ((enable = DrawParameters.ENABLE_CONNECTOR) && (onlinePT = (connectionLS = ObjectTable.getConnectionLS()).drawMouseHitPT(ctrl, this.endPoint, vec = Vector2D.sub(this.endPoint, this.startPoint), this.shapeContainer)) != null) {
            this.endPoint = (Point2D)onlinePT.getP().clone();
        }
        if (this.isRectangleFamily || this.isComponentFamily) {
            Point2D[] points = new Point2D[]{(Point2D)this.startPoint.clone(), (Point2D)this.endPoint.clone()};
            Rectangle2D boundingBox = ShapeElementUtil.getBoundingBox(points);
            if (this.isRectangleFamily) {
                this.shapeElement.create(boundingBox);
            }
            if (this.isComponentFamily && boundingBox.getWidth() > 5.0 && boundingBox.getHeight() > 5.0) {
                this.shapeContainer.setVisible(true);
                Rectangle2D oldBox = this.shapeElement.getBoundingBox();
                this.shapeElement.moveResize(oldBox, boundingBox, true);
            }
        }
        if (this.isLineFamily) {
            this.shapeElement.create(this.startPoint, this.endPoint);
        }
        this.oldPoint = (Point2D)this.endPoint.clone();
        ObjectTable.getDrawPanel().repaint("CreateShapeLS.mouseDragged");
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (debug > 0) {
            System.out.println("\nCreatShapeLS.mouseReleased");
        }
        double scale = DrawParameters.getScale();
        double X = (double)e.getX() / scale;
        double Y = (double)e.getY() / scale;
        Point2D.Double releasedPoint = new Point2D.Double(X, Y);
        if (this.draggedPoint != null && this.isDifferentPoint(this.draggedPoint, releasedPoint)) {
            System.out.println("CreateShapeLS  the releasedPoint is different from the last dragged point");
        }
        if (!this.rightButtonPressed && e.isPopupTrigger()) {
            this.rightButtonPressed = true;
        }
        int key = e.getModifiersEx();
        int ctrl = 0;
        if ((key & 0x40) != 0) {
            ctrl = 1;
        }
        if ((key & 0x80) != 0) {
            ctrl = 2;
        }
        if ((key & 0x200) != 0) {
            ctrl = 3;
        }
        if (this.isDifferentPoint(this.pressedPoint, releasedPoint)) {
            if (this.isLineFamily || this.isRectangleFamily || this.isComponentFamily) {
                if (debug > 0) {
                    System.out.println("-- The mouseReleased calls .creatingEnd");
                }
                this.creatingEnd();
            }
            if (this.isPolylineFamily) {
                double dist = Vector2D.dist(this.pressedPoint, releasedPoint);
                if (debug > 0) {
                    System.out.println("-- The mouseReleased calls mouseClicked  dist=" + dist);
                }
                this.mouseClicked(e);
                this.clicked = true;
            }
        }
        this.startPoint = null;
        this.endPoint = null;
        this.pressedPoint = null;
        this.draggedPoint = null;
        ObjectTable.getDrawPanel().repaint("CreateShapeLS");
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (debug > 0) {
            System.out.println("\nCreatShapeLS.mouseMoved");
        }
        double scale = DrawParameters.getScale();
        double X = (double)e.getX() / scale;
        double Y = (double)e.getY() / scale;
        int key = e.getModifiersEx();
        int ctrl = 0;
        if ((key & 0x40) != 0) {
            ctrl = 1;
        }
        if ((key & 0x80) != 0) {
            ctrl = 2;
        }
        if ((key & 0x200) != 0) {
            ctrl = 3;
        }
        if (ctrl > 0) {
            this.ctrl = ctrl;
        }
        Point2D.Double mousePT = new Point2D.Double(X, Y);
        double range = 4.0;
        boolean enable = DrawParameters.ENABLE_CONNECTOR;
        if (enable) {
            ConnectionLS connectionLS = ObjectTable.getConnectionLS();
            CurvePT curvePT = connectionLS.drawMouseHitPT(0, mousePT, null, this.shapeContainer);
        }
        if (this.isPolylineFamily) {
            this.createNodePoint(ctrl, mousePT);
        }
        ObjectTable.getDrawPanel().repaint("CreateShapeLS.mouseMoved");
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (debug > 0) {
            System.out.println("\nCreateShapeLS.mouseClicked,  this.clicked=" + this.clicked);
        }
        if (this.clicked) {
            return;
        }
        this.clicked = true;
        double scale = DrawParameters.getScale();
        double X = (double)e.getX() / scale;
        double Y = (double)e.getY() / scale;
        int key = e.getModifiersEx();
        int ctrl = 0;
        if ((key & 0x40) != 0) {
            ctrl = 1;
        }
        if ((key & 0x80) != 0) {
            ctrl = 2;
        }
        if ((key & 0x200) != 0) {
            ctrl = 3;
        }
        boolean doubleClick = false;
        if (e.getClickCount() >= 2) {
            doubleClick = true;
        }
        Dimension sizeOfElement = new Dimension(24, 24);
        double w = sizeOfElement.getWidth();
        double h = sizeOfElement.getHeight();
        Rectangle2D.Double box = new Rectangle2D.Double(X - 0.5 * w, Y - 0.5 * h, w, h);
        if (this.isRectangleFamily) {
            this.shapeElement.create(box);
            this.creatingEnd();
        }
        if (this.isComponentFamily) {
            this.shapeContainer.setVisible(true);
            Rectangle2D oldBox = this.shapeElement.getBoundingBox();
            w = oldBox.getWidth();
            h = oldBox.getHeight();
            Rectangle2D.Double newBox = new Rectangle2D.Double(X - 0.5 * w, Y - 0.5 * h, w, h);
            this.shapeElement.moveResize(oldBox, newBox, true);
            this.creatingEnd();
        }
        if (this.isLineFamily) {
            Point2D.Double startP = new Point2D.Double(((RectangularShape)box).getX(), ((RectangularShape)box).getY());
            Point2D.Double endP = new Point2D.Double(((RectangularShape)box).getX() + ((RectangularShape)box).getWidth(), ((RectangularShape)box).getY() + ((RectangularShape)box).getHeight());
            this.shapeElement.create(startP, endP);
            this.creatingEnd();
        }
        if (this.isPolylineFamily) {
            this.committedNodePoints = this.tentativeNodePoints;
            int size = this.tentativeNodePoints.length;
            if (size >= 2) {
                Point2D segEndP = this.tentativeNodePoints[size - 1];
                DrawShapeUtil.drawTempShape("Node.point", segEndP, 3.0, "", Color.BLUE);
            }
            if (this.rightButtonPressed || doubleClick) {
                DrawShapeUtil.clearTempShape("Node.point");
                if (this.isPolylineFamily) {
                    this.creatingEnd();
                }
                this.ctrl = 0;
                this.rightButtonPressed = false;
            }
        }
        ObjectTable.getDrawPanel().repaint("CreateShapeLS");
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        ObjectTable.getDrawMain().setCursor(DrawParameters.CROSSHAIR_CURSOR);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        ObjectTable.getDrawMain().setCursor(DrawParameters.DEFAULT_CURSOR);
    }

    private boolean isDifferentPoint(Point2D p1, Point2D p2) {
        boolean different = true;
        int x1 = (int)p1.getX();
        int y1 = (int)p1.getY();
        int x2 = (int)p2.getX();
        int y2 = (int)p2.getY();
        if (x1 == x2 && y1 == y2) {
            different = false;
        }
        return different;
    }

    private void createNodePoint(int ctrl, Point2D mousePT) {
        boolean enable = DrawParameters.ENABLE_CONNECTOR;
        ConnectionLS connectionLS = ObjectTable.getConnectionLS();
        Point2D segStartP = null;
        Point2D segEndP = null;
        CurvePT onlinePT = null;
        int size = this.committedNodePoints.length;
        if (size == 0) {
            segStartP = mousePT;
        } else {
            segStartP = this.committedNodePoints[size - 1];
            segEndP = mousePT;
        }
        if (size > 0 && ctrl > 0) {
            segEndP = DiscreteAngledLine.getControlledPT(0.0, 45.0, segStartP, segEndP);
        }
        if (enable) {
            double pointTol = 4.0;
            if (ctrl > 0) {
                pointTol = 0.0 * pointTol;
            }
            if (size == 0) {
                onlinePT = connectionLS.drawMouseHitPT(0, segStartP, null, this.shapeContainer);
                if (onlinePT != null) {
                    segStartP = onlinePT.getP();
                }
            } else {
                Vector2D vec = Vector2D.sub(segEndP, segStartP);
                onlinePT = connectionLS.drawMouseHitPT(ctrl, segEndP, vec, this.shapeContainer);
                if (onlinePT != null) {
                    segEndP = onlinePT.getP();
                }
            }
            this.tentativeNodePoints = new Point2D[size + 1];
            for (int i = 0; i < size; ++i) {
                this.tentativeNodePoints[i] = this.committedNodePoints[i];
            }
            this.tentativeNodePoints[size] = size == 0 ? segStartP : segEndP;
            this.shapeElement.create(this.tentativeNodePoints);
        }
    }
}

