/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import DrawTop.DrawParameters;
import DrawTop.ListenerPanel;
import DrawTop.ObjectTable;
import DrawTop.SelectionLS;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import shape.DrawShapeUtil;
import shape.ShapeContainer;
import shapeUtil.ConnectionUtil;
import shapeUtil.DiscreteAngledLine;
import shapeUtil.ExtendCurve;
import util.Util;

public class ExtendCurveLS
implements MouseListener,
MouseMotionListener {
    ExtendCurve extendCurve = null;
    ShapeContainer shapeContainer = null;
    ConnectionUtil connectionUtil = new ConnectionUtil();
    Point2D startPoint = null;
    Point2D endPoint = null;
    Point2D oldPoint = null;
    DiscreteAngledLine lineAngle = null;
    public static int debug = 0;

    public ExtendCurveLS(ExtendCurve extendCurve) {
        this.extendCurve = extendCurve;
    }

    public void start() {
        System.out.println("- ExtendCurveLS.start. SelectionLS stopped.");
        ListenerPanel listenerPanel = ObjectTable.getListenerPanel("ExtendCurveLS");
        listenerPanel.addMouseListener(this);
        listenerPanel.addMouseMotionListener(this);
        SelectionLS selectionLS = ObjectTable.getSelectionLS();
        selectionLS.end();
        DrawShapeUtil.clearTempShape("ExtendCurve");
    }

    public void end() {
        if (debug >= 0) {
            System.out.println("- ExtendCurveLS.end. SelectionLS restarted.");
        }
        ListenerPanel listenerPanel = ObjectTable.getListenerPanel("ExtendCurveLS");
        listenerPanel.removeMouseListener(this);
        listenerPanel.removeMouseMotionListener(this);
        SelectionLS selectionLS = ObjectTable.getSelectionLS();
        selectionLS.start();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        double scale = DrawParameters.getScale();
        double X = (double)e.getX() / scale;
        double Y = (double)e.getY() / scale;
        int key = e.getModifiersEx();
        int ctrl = 0;
        if ((key & 0x40) != 0) {
            ctrl = 1;
        }
        if ((key & 0x80) != 0) {
            ctrl = 2;
        }
        if ((key & 0x800) != 0) {
            ctrl = 3;
        }
        if ((key & 0x1000) != 0) {
            ctrl = 3;
        }
        Point2D.Double point = new Point2D.Double(X, Y);
        if (debug > 0) {
            System.out.println(" - ExtendCurveLS calls receive method., clickedPoint=" + Util.Pt(point));
        }
        this.extendCurve.receivePoint(point);
        this.end();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        double scale = DrawParameters.getScale();
        double X = (double)e.getX() / scale;
        double Y = (double)e.getY() / scale;
        int key = e.getModifiersEx();
        int ctrl = 0;
        if ((key & 0x40) != 0) {
            ctrl = 1;
        }
        if ((key & 0x80) != 0) {
            ctrl = 2;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.startPoint = null;
        this.endPoint = null;
        this.oldPoint = null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        double scale = DrawParameters.getScale();
        double X = (double)e.getX() / scale;
        double Y = (double)e.getY() / scale;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

