/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import DrawTop.DrawParameters;
import DrawTop.ObjectTable;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import menu.MenuUtil;
import shapeUtil.GeometricTestAction;
import shapeUtil.GeometricTestLS;
import util.Util;

public class GeometricTest
extends JDialog {
    GeometricTestLS geometricTestLS = null;
    JPanel messagePanel = new JPanel();
    Dimension messageLabelDimension = new Dimension(300, 14);
    JLabel messageLabel1 = new JLabel(" ");
    JLabel messageLabel2 = new JLabel(" ");
    JRadioButton NormalLinesButton = null;
    JRadioButton ShortestLineButton = null;
    JRadioButton ProjectionLinesButton = null;
    JRadioButton IntersectionPtsButton = null;
    JRadioButton NormalLinesBetweenShapesButton = null;
    JRadioButton ShortestLinesBetweenShapesButton = null;
    int debug = 0;

    public GeometricTest() {
        super((Frame)ObjectTable.getDrawMain(), "Geometric test");
        this.geometricTestLS = new GeometricTestLS();
        this.setName("Geometric test");
    }

    public void showDialog() {
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        GeometricTest dialog = (GeometricTest)menuUtil.getMenuComponent("Geometric test");
        if (dialog != null) {
            JOptionPane.showMessageDialog(ObjectTable.getDrawMain(), "geometric test dialog is already opened", "", 0);
            return;
        }
        GeometricTestAction action = new GeometricTestAction(this);
        this.addWindowListener(action);
        this.geometricTestLS.start();
        Window owner = this.getOwner();
        Point centerP = new Point(owner.getX() + 50, owner.getY() + 90);
        this.setLocation(centerP);
        Container contentPane = this.getContentPane();
        this.messagePanel.setBorder(BorderFactory.createTitledBorder("message:"));
        Box messageBox = Box.createVerticalBox();
        messageBox.add(Box.createVerticalStrut(0));
        messageBox.add(this.messageLabel1);
        messageBox.add(Box.createVerticalStrut(0));
        messageBox.add(this.messageLabel2);
        messageBox.add(Box.createVerticalStrut(0));
        this.messageLabel1.setPreferredSize(this.messageLabelDimension);
        this.messageLabel2.setPreferredSize(this.messageLabelDimension);
        this.messagePanel.add(messageBox);
        this.showMessage("  Select button from the below");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        this.NormalLinesButton = new JRadioButton("Normal Lines From Mouse");
        this.ShortestLineButton = new JRadioButton("Sortest Line From Mouse");
        this.ProjectionLinesButton = new JRadioButton("Projection Lines From Mouse");
        this.IntersectionPtsButton = new JRadioButton("Intersection Pts");
        this.NormalLinesBetweenShapesButton = new JRadioButton("Normal Lines Between Shapes");
        this.ShortestLinesBetweenShapesButton = new JRadioButton("Shortest Line Between Shapes");
        this.NormalLinesButton.addActionListener(action);
        this.ShortestLineButton.addActionListener(action);
        this.ProjectionLinesButton.addActionListener(action);
        this.IntersectionPtsButton.addActionListener(action);
        this.NormalLinesBetweenShapesButton.addActionListener(action);
        this.ShortestLinesBetweenShapesButton.addActionListener(action);
        this.NormalLinesButton.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.NormalLinesButton);
        group.add(this.ShortestLineButton);
        group.add(this.ProjectionLinesButton);
        group.add(this.IntersectionPtsButton);
        group.add(this.NormalLinesBetweenShapesButton);
        group.add(this.ShortestLinesBetweenShapesButton);
        buttonPanel.add(this.NormalLinesButton);
        buttonPanel.add(this.ShortestLineButton);
        buttonPanel.add(this.ProjectionLinesButton);
        buttonPanel.add(this.IntersectionPtsButton);
        buttonPanel.add(this.NormalLinesBetweenShapesButton);
        buttonPanel.add(this.ShortestLinesBetweenShapesButton);
        buttonPanel.setPreferredSize(new Dimension(300, 150));
        JPanel basePanel = new JPanel();
        contentPane.add(basePanel);
        BoxLayout baseBox = new BoxLayout(basePanel, 2);
        basePanel.add(this.messagePanel);
        basePanel.add(buttonPanel);
        this.setPreferredSize(new Dimension(310, 280));
        this.pack();
        this.setVisible(true);
        menuUtil.setMenuComponent(this);
    }

    protected void showMessage(String message) {
        this.messageLabel1.setForeground(Color.BLUE);
        this.messageLabel2.setForeground(Color.BLUE);
        this.messageLabel1.setFont(DrawParameters.Font12Bold);
        this.messageLabel2.setFont(DrawParameters.Font12Bold);
        int index = message.indexOf("\n");
        String str1 = "";
        String str2 = "";
        if (index > 0) {
            str1 = message.substring(0, index);
            if (index + 1 < message.length()) {
                str2 = message.substring(index + 1, message.length());
            }
        } else {
            str1 = message;
        }
        this.messageLabel1.setText(str1);
        this.messageLabel2.setText(str2);
        if (this.debug > 0) {
            System.out.println("** GeometricTest JDialog size=" + Util.Dim(this.getSize()));
        }
    }

    protected GeometricTestLS getGeometricTestLS() {
        return this.geometricTestLS;
    }
}

