/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import DrawTop.ObjectTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import menu.MenuUtil;
import shape.DrawShapeUtil;
import shapeUtil.GeometricTest;
import shapeUtil.GeometricTestLS;

class GeometricTestAction
extends AbstractAction
implements WindowListener {
    GeometricTest dialog = null;
    int debug = 0;

    public GeometricTestAction(GeometricTest dialog) {
        this.dialog = dialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String commandName = e.getActionCommand();
        String componentClassName = "";
        componentClassName = e.getSource().getClass().getSimpleName();
        String componentName = ((Component)e.getSource()).getName();
        if (this.debug > 0) {
            System.out.println("- GeometricTestAction.actionPerformed  commandName=" + commandName + ", source component name=" + componentName + ", source class simple name=" + componentClassName);
        }
        GeometricTestLS geometricTestLS = this.dialog.getGeometricTestLS();
        if (commandName.equals("Normal Lines From Mouse")) {
            geometricTestLS.setMode(GeometricTestLS.NormalLinesFromMouse_Mode);
            this.dialog.showMessage("  Select shapes and move the mouse!");
        }
        if (commandName.equals("Sortest Line From Mouse")) {
            geometricTestLS.setMode(GeometricTestLS.ShortestLineFromMouse_Mode);
            this.dialog.showMessage("  Select shapes and move the mouse!");
        }
        if (commandName.equals("Projection Lines From Mouse")) {
            geometricTestLS.setMode(GeometricTestLS.ProjectionLinesFromMouse_Mode);
            this.dialog.showMessage("  Select shapes and move the mouse!");
        }
        if (commandName.equals("Intersection Pts")) {
            geometricTestLS.setMode(GeometricTestLS.IntersectionPts_Mode);
            this.dialog.showMessage("  Select shapes and drag them onto other shapes!");
        }
        if (commandName.equals("Normal Lines Between Shapes")) {
            geometricTestLS.setMode(GeometricTestLS.NormalLinesBetweenShapes_Mode);
            this.dialog.showMessage("  Select shapes and drag them!");
        }
        if (commandName.equals("Shortest Line Between Shapes")) {
            geometricTestLS.setMode(GeometricTestLS.ShortestLineBetweenShapes_Mode);
            this.dialog.showMessage("  Select shapes and drag them!");
        }
    }

    private void closeDialog() {
        this.dialog.setVisible(false);
        this.dialog.getGeometricTestLS().end();
        DrawShapeUtil.clearTempShape("geomTest");
        ObjectTable.getDrawPanel().repaint();
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        Component component = menuUtil.getMenuComponent(this.dialog.getName());
        if (component != null) {
            menuUtil.removeMenuComponent(component);
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.closeDialog();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

