/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import DrawTop.DrawParameters;
import DrawTop.ObjectTable;
import geomExtension.CurvePT;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import menu.MenuConstants;
import shape.BlinkingShape;
import shape.ShapeContainer;
import shapeUtil.ConnectionEvent;
import shapeUtil.ConnectionLS;
import shapeUtil.ConnectionListener;
import shapeUtil.RotateAction;
import shapeUtil.RotateSpinnerListener;
import util.ContainerManager;

public class Rotate
extends JDialog
implements ConnectionListener {
    RotateAction action = null;
    JLabel messageLabel = null;
    Dimension panelSize = new Dimension(220, 44);
    JRadioButton pixelButton = null;
    JRadioButton mmButton = null;
    JSpinner[] positionSpinners = new JSpinner[2];
    SpinnerNumberModel[] positionSpinnerModels = new SpinnerNumberModel[2];
    JCheckBox checkBox = null;
    JSpinner angleSpinner = null;
    SpinnerNumberModel angleSpinnerModel = null;
    JRadioButton copyButton = null;
    JButton goButton = null;
    JButton cancelButton = null;
    Vector shapesVector = new Vector();
    Point2D rotationCenterP = null;
    int debug = 0;

    public Rotate() {
        super((Frame)ObjectTable.getDrawMain(), "rotate");
        this.setName("rotate");
        this.action = new RotateAction(this);
        this.createDialog();
    }

    public void createDialog() {
        Window owner = this.getOwner();
        Point centerP = new Point(owner.getX() + 10, owner.getY() + 80);
        this.setLocation(centerP);
        this.addWindowListener(this.action);
        Container contentPane = this.getContentPane();
        Box box = Box.createVerticalBox();
        contentPane.add(box);
        JPanel messagePanel = new JPanel();
        messagePanel.setLayout(new FlowLayout(3));
        this.messageLabel = new JLabel(" ");
        messagePanel.add(this.messageLabel);
        JPanel unitPanel = new JPanel();
        unitPanel.setPreferredSize(this.panelSize);
        TitledBorder frameBorder = BorderFactory.createTitledBorder("Unit of length");
        GridLayout unitPanelLayout = new GridLayout(1, 2);
        unitPanelLayout.setHgap(20);
        unitPanelLayout.setVgap(5);
        unitPanel.setLayout(unitPanelLayout);
        unitPanel.setBorder(frameBorder);
        ButtonGroup group = new ButtonGroup();
        this.pixelButton = new JRadioButton("pixel");
        this.mmButton = new JRadioButton("mm");
        group.add(this.mmButton);
        group.add(this.pixelButton);
        this.pixelButton.setActionCommand("pixel");
        this.mmButton.setActionCommand("mm");
        this.pixelButton.addActionListener(this.action);
        this.mmButton.addActionListener(this.action);
        unitPanel.add(this.mmButton);
        unitPanel.add(this.pixelButton);
        this.mmButton.setSelected(true);
        JPanel centerPositionPanel = new JPanel();
        frameBorder = BorderFactory.createTitledBorder("rotatation center x,y ");
        frameBorder.setTitleColor(Color.BLACK);
        frameBorder.setTitleFont(MenuConstants.MenuFont);
        centerPositionPanel.setBorder(frameBorder);
        GridLayout centerPositionPanelLayout = new GridLayout(2, 1);
        centerPositionPanelLayout.setHgap(20);
        centerPositionPanelLayout.setVgap(0);
        centerPositionPanel.setLayout(centerPositionPanelLayout);
        JPanel xyPanel = new JPanel();
        GridLayout xyPanelLayout = new GridLayout(1, 2);
        xyPanelLayout.setHgap(20);
        xyPanelLayout.setVgap(0);
        xyPanel.setLayout(xyPanelLayout);
        JPanel[] xyPanels = new JPanel[2];
        String[] xyLabel = new String[]{"x: ", "y: "};
        RotateSpinnerListener spinnerListener = new RotateSpinnerListener(this);
        Dimension spinnerSize = new Dimension(80, 22);
        for (int i = 0; i < 2; ++i) {
            xyPanels[i] = new JPanel();
            xyPanels[i].setLayout(new BoxLayout(xyPanels[i], 0));
            JLabel label = new JLabel(xyLabel[i]);
            xyPanels[i].add(label);
            this.positionSpinnerModels[i] = new SpinnerNumberModel(0.0, 0.0, 1000.0, 1.0);
            this.positionSpinners[i] = new JSpinner(this.positionSpinnerModels[i]);
            this.positionSpinners[i].addChangeListener(spinnerListener);
            this.positionSpinners[i].setPreferredSize(spinnerSize);
            xyPanels[i].add(this.positionSpinners[i]);
            xyPanel.add(xyPanels[i]);
        }
        centerPositionPanel.add(xyPanel);
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.setLayout(new BoxLayout(checkBoxPanel, 0));
        JLabel checBoxLabel = new JLabel(": click the rotation center ");
        this.checkBox = new JCheckBox();
        checkBoxPanel.add(this.checkBox);
        checkBoxPanel.add(checBoxLabel);
        this.checkBox.addActionListener(this.action);
        this.checkBox.setActionCommand("click");
        centerPositionPanel.add(checkBoxPanel);
        JPanel anglePanel = new JPanel();
        frameBorder = BorderFactory.createTitledBorder("rotation angle (degree)");
        frameBorder.setTitleColor(Color.BLACK);
        frameBorder.setTitleFont(MenuConstants.MenuFont);
        anglePanel.setBorder(frameBorder);
        JLabel angleLabel = new JLabel("angle: ");
        angleLabel.setPreferredSize(new Dimension(60, 22));
        this.angleSpinnerModel = new SpinnerNumberModel(0.0, -360.0, 360.0, 1.0);
        this.angleSpinner = new JSpinner(this.angleSpinnerModel);
        this.angleSpinner.addChangeListener(spinnerListener);
        anglePanel.setLayout(new GridLayout(1, 2));
        anglePanel.add(angleLabel);
        anglePanel.add(this.angleSpinner);
        this.angleSpinner.setPreferredSize(new Dimension(60, 22));
        JPanel copyPanel = new JPanel();
        copyPanel.setPreferredSize(this.panelSize);
        frameBorder = BorderFactory.createTitledBorder("copy");
        copyPanel.setBorder(frameBorder);
        GridLayout copyPanelLayout = new GridLayout(1, 2);
        copyPanelLayout.setHgap(20);
        copyPanelLayout.setVgap(0);
        copyPanel.setLayout(copyPanelLayout);
        group = new ButtonGroup();
        this.copyButton = new JRadioButton("yes");
        JRadioButton noCopyButton = new JRadioButton("no");
        group.add(this.copyButton);
        group.add(noCopyButton);
        this.copyButton.setSelected(true);
        copyPanel.add(this.copyButton);
        copyPanel.add(noCopyButton);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setPreferredSize(this.panelSize);
        this.goButton = new JButton("GO !");
        this.cancelButton = new JButton("Cancel");
        Dimension buttonSize = new Dimension(80, 22);
        this.goButton.setPreferredSize(buttonSize);
        this.cancelButton.setPreferredSize(buttonSize);
        this.goButton.setEnabled(false);
        this.goButton.setActionCommand("Go");
        this.cancelButton.setActionCommand("Cancel");
        this.goButton.addActionListener(this.action);
        this.cancelButton.addActionListener(this.action);
        buttonPanel.add(this.goButton);
        buttonPanel.add(this.cancelButton);
        box.add(Box.createVerticalStrut(5));
        box.add(messagePanel);
        box.add(Box.createVerticalStrut(5));
        box.add(unitPanel);
        box.add(Box.createVerticalStrut(5));
        box.add(centerPositionPanel);
        box.add(Box.createVerticalStrut(5));
        box.add(anglePanel);
        box.add(Box.createVerticalStrut(5));
        box.add(copyPanel);
        box.add(Box.createVerticalStrut(5));
        box.add(buttonPanel);
    }

    public void showDialog() {
        Window owner = this.getOwner();
        Point centerP = new Point(owner.getX() + owner.getSize().width - 250, owner.getY() + 100);
        this.setLocation(centerP);
        if (this.debug > 0) {
            System.out.println("position spiner size=" + this.positionSpinners[0].getSize());
        }
        ContainerManager containerManager = ObjectTable.getContainerManager("");
        ShapeContainer[] containers = containerManager.getSelectedContainers();
        int size = 0;
        if (containers != null) {
            size = containers.length;
        }
        if (size == 0) {
            this.showMessage("Select shapes before this command !", Color.RED);
            this.shapesVector.clear();
            this.pack();
            this.setVisible(true);
            return;
        }
        this.shapesVector.clear();
        for (int i = 0; i < size; ++i) {
            this.shapesVector.add(containers[i]);
        }
        Vector<ShapeContainer> vector = new Vector<ShapeContainer>();
        for (int i = 0; i < size; ++i) {
            if (!this.isTextBox(containers[i])) continue;
            vector.add(containers[i]);
            containers[i].setBlinking(true);
        }
        int blinkingSize = vector.size();
        if (blinkingSize > 0) {
            BlinkingShape blinkingShape = ObjectTable.getBlinkingShape();
            blinkingShape.startBlinking();
            int result = 0;
            String message1 = "Warning: Selected shape has text";
            String message2 = "Selected shape has comitted text.\n Rotated shape will lose the text\nContinue this process?";
            if (blinkingSize > 1) {
                message1 = "Warning: Selected shapes have text";
                message2 = "Selected shapes have comitted text.\n Rotated shape will lose the text\nContinue this process?";
            }
            this.showMessage(message1, Color.RED);
            int returnCode = JOptionPane.showConfirmDialog(ObjectTable.getDrawMain(), message2, "", 0);
            if (returnCode == 1) {
                result = -1;
            }
            for (int i = 0; i < blinkingSize; ++i) {
                ShapeContainer container = (ShapeContainer)vector.get(i);
                container.setBlinking(false);
            }
            blinkingShape.stopBlinking();
            if (result != 0) {
                return;
            }
        }
        this.goButton.setEnabled(true);
        this.setRotationCenter();
        this.pack();
        this.setVisible(true);
    }

    private boolean isTextBox(ShapeContainer shapeContainer) {
        boolean suitable = false;
        ShapeContainer[] containers = shapeContainer.getGroupedSingleShapeContainers();
        int size = containers.length;
        for (int i = 0; i < size; ++i) {
            if (!containers[i].isCommittedText()) continue;
            suitable = true;
        }
        return suitable;
    }

    public void addConnectionListener() {
        ConnectionLS connectionLS = ObjectTable.getConnectionLS();
        connectionLS.activateListener(true);
        connectionLS.addConnectionListener(this);
        ObjectTable.getSelectionLS().end();
    }

    public void removeConnectionListener() {
        ConnectionLS connectionLS = ObjectTable.getConnectionLS();
        connectionLS.activateListener(false);
        ObjectTable.getSelectionLS().start();
    }

    @Override
    public void connected(ConnectionEvent event) {
        CurvePT curvePT = event.getCurvePT();
        this.rotationCenterP = curvePT.getP();
        this.setValuesToPositionSpinners();
    }

    protected void showMessage(String message, Color color) {
        this.messageLabel.setForeground(color);
        this.messageLabel.setFont(DrawParameters.Font12Bold);
        this.messageLabel.setText(message);
    }

    public ShapeContainer[] getSelectedContainers() {
        int size = this.shapesVector.size();
        ShapeContainer[] containers = new ShapeContainer[size];
        for (int i = 0; i < size; ++i) {
            containers[i] = (ShapeContainer)this.shapesVector.get(i);
        }
        return containers;
    }

    public void setRotationCenter() {
        double xmin;
        int size = this.shapesVector.size();
        double ymin = xmin = 100000.0;
        double xmax = -xmin;
        double ymax = -xmin;
        for (int i = 0; i < size; ++i) {
            ShapeContainer container = (ShapeContainer)this.shapesVector.get(i);
            Rectangle2D boundingBox = container.getBoundingBox();
            double x = boundingBox.getX();
            double y = boundingBox.getY();
            double w = boundingBox.getWidth();
            double h = boundingBox.getHeight();
            if (x < xmin) {
                xmin = x;
            }
            if (y < ymin) {
                ymin = y;
            }
            if (x + w > xmax) {
                xmax = x + w;
            }
            if (!(y + h > ymax)) continue;
            ymax = y + h;
        }
        this.rotationCenterP = new Point2D.Double(0.5 * (xmin + xmax), 0.5 * (ymin + ymax));
        this.setValuesToPositionSpinners();
    }

    public void setValuesToPositionSpinners() {
        double centerX = this.rotationCenterP.getX();
        double centerY = this.rotationCenterP.getY();
        double mm = 0.26458333333333334;
        double unit = 1.0;
        if (this.mmButton.isSelected()) {
            unit = mm;
        }
        this.positionSpinners[0].setValue(centerX *= unit);
        this.positionSpinners[1].setValue(centerY *= unit);
    }

    public JSpinner[] getPositionSpinners() {
        return this.positionSpinners;
    }

    public SpinnerNumberModel[] getPositionSpinnerModels() {
        return this.positionSpinnerModels;
    }

    public JSpinner getAngleSpinner() {
        return this.angleSpinner;
    }

    public SpinnerNumberModel getAngleSpinnerModel() {
        return this.angleSpinnerModel;
    }

    public JRadioButton getCopyButton() {
        return this.copyButton;
    }

    public Vector getShapesVector() {
        return this.shapesVector;
    }
}

