/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public class ConfigFile {
    private Properties properties = new Properties();
    private String fileName;

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        if (this.fileName == null || this.fileName.equals("")) {
            System.out.println("*** Error in ConfigFile fileName=null");
        }
        return this.fileName;
    }

    public void load() throws IOException {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(this.getFileName());
        }
        catch (FileNotFoundException e) {
            throw new IOException("Cannot open file:" + this.getFileName());
        }
        this.properties.load(fileInputStream);
        fileInputStream.close();
    }

    public void save() throws IOException {
        FileOutputStream fileOutputStream;
        try {
            fileOutputStream = new FileOutputStream(this.getFileName());
        }
        catch (FileNotFoundException e) {
            throw new IOException("Cannot create file:" + this.getFileName());
        }
        this.properties.store(fileOutputStream, "");
        fileOutputStream.close();
    }

    public String getValue(String sKey) {
        return this.properties.getProperty(sKey);
    }

    public void putValue(String sKey, String sValue) {
        this.properties.put(sKey, sValue);
    }

    public Enumeration getKeys() {
        return this.properties.propertyNames();
    }
}

