/*
 * Decompiled with CFR 0.152.
 */
package util;

import DrawTop.DrawMain;
import DrawTop.DrawParameters;
import DrawTop.ObjectTable;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.ArrayList;
import javax.print.PrintService;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import util.ContainerManager;
import util.DrawFileIo;
import util.ExtensionFileFilter;
import util.FileInformation;
import util.PageManager;
import util.PrintableDrawPage;
import util.UndoDrawManager;
import util.ViewData;

public class FileIo {
    private JFileChooser fileChooser;
    private String currentFilePath = "";
    private FileInformation fileInformation = new FileInformation();
    public static int debug = 0;

    public FileIo() {
        this.fileChooser = new JFileChooser();
        ExtensionFileFilter filter = new ExtensionFileFilter();
        filter.addExtension("draw");
        filter.setDescription("*.draw");
        this.fileChooser.setFileFilter(filter);
    }

    public String getCurrentFilePath() {
        return this.currentFilePath;
    }

    public FileInformation getFileInformation() {
        return this.fileInformation;
    }

    public void fileNew() {
        PageManager pageManager;
        int ret = this.saveCurrentFile();
        if (ret == 0) {
            String fileName = this.fileInformation.getSimpleFileName(this.currentFilePath);
            String message = "The current file was saved as \"" + fileName + "\".\nThen a file will be opened.";
            JOptionPane.showMessageDialog(ObjectTable.getDrawMain(), message);
        }
        if (ret == 1) {
            String message = "The current file was not saved.\nThen a new file will be opened.";
            JOptionPane.showMessageDialog(ObjectTable.getDrawMain(), message);
        }
        if (ret == 2) {
            return;
        }
        ObjectTable.pageManager = pageManager = new PageManager();
        pageManager.init();
        this.currentFilePath = "";
        DrawMain drawMain = ObjectTable.getDrawMain();
        drawMain.setTitle("DrawTop file name : ");
    }

    public void fileOpen() {
        File file;
        PageManager pageManager;
        int ret = this.saveCurrentFile();
        if (ret == 0) {
            String fileName = this.fileInformation.getSimpleFileName(this.currentFilePath);
            String message = "The current file was saved as \"" + fileName + "\".\nThen the file open dialog will be opened.";
            JOptionPane.showMessageDialog(ObjectTable.getDrawMain(), message);
        }
        if (ret == 1) {
            String message = "The current file was not saved.\nThen the file open dialog will be opened.";
            JOptionPane.showMessageDialog(ObjectTable.getDrawMain(), message);
        }
        if (ret == 2) {
            return;
        }
        if (debug > 0) {
            System.out.println("** FileIO.fileOpen called");
        }
        DrawMain drawMain = ObjectTable.getDrawMain();
        ObjectTable.pageManager = pageManager = new PageManager();
        drawMain.setCursor(Cursor.getPredefinedCursor(3));
        String directoryPath = this.fileInformation.getDirectory();
        if (!directoryPath.equals("")) {
            File directory = new File(directoryPath);
            this.fileChooser.setCurrentDirectory(directory);
            if (debug > 0) {
                System.out.println("** File I/O directory set=" + directoryPath);
            }
        }
        pageManager.init();
        if (this.fileChooser.showOpenDialog(drawMain) != 0) {
            return;
        }
        String filePath = this.fileChooser.getSelectedFile().toString();
        if (!filePath.endsWith(".draw")) {
            filePath = filePath + ".draw";
        }
        if (!(file = new File(filePath)).isFile()) {
            String str = "Draw file :" + this.fileInformation.getSimpleFileName(filePath) + " not found";
            JOptionPane.showMessageDialog(ObjectTable.getDrawMain(), str, "", 0);
            this.currentFilePath = "";
            return;
        }
        if (debug > 0) {
            System.out.println("** FileIO.fileOpen filePath=" + filePath);
        }
        this.currentFilePath = filePath;
        directoryPath = this.fileInformation.convertToDirectoryName(filePath);
        if (directoryPath != null) {
            this.fileInformation.setFileDirectory(directoryPath);
        } else {
            System.err.println("*** Error FileIO.fileOpen: \\ not found in filePath");
        }
        try {
            DrawFileIo drawFileIo = ObjectTable.getDrawFileIo();
            ArrayList newPageList = drawFileIo.readPageList(filePath);
            if (newPageList == null || newPageList.size() == 0) {
                this.currentFilePath = "";
                return;
            }
            pageManager.setPageList(newPageList);
            pageManager.setCurrentPage(1);
            pageManager.showPage(1);
            this.currentFilePath = filePath;
        }
        catch (Exception e) {
            System.err.println("*** Error FileIO.fileOpen e=" + e);
            e.printStackTrace();
            this.currentFilePath = "";
        }
        drawMain.setTitle("DrawTop file name : " + this.fileInformation.getSimpleFileName(this.currentFilePath));
        drawMain.setCursor(Cursor.getPredefinedCursor(0));
    }

    public int fileSave() {
        DrawMain drawMain = ObjectTable.getDrawMain();
        if (this.currentFilePath.equals("")) {
            int ret = this.fileSaveAs();
            return ret;
        }
        if (debug > 0) {
            System.out.println("** FileIO.fileSave currentFilePath=" + this.currentFilePath);
        }
        PageManager pageManager = ObjectTable.getPageManager("FileIO");
        if (debug > 0) {
            System.out.println("** FileIO.fileSave called");
        }
        drawMain.setCursor(Cursor.getPredefinedCursor(3));
        try {
            pageManager.saveCurrentPage();
            DrawFileIo drawFileIo = ObjectTable.getDrawFileIo();
            drawFileIo.writePageList(this.currentFilePath, pageManager.getPageList());
            if (debug > 0) {
                System.out.println("** File I/O successfull outputFile=" + this.currentFilePath);
            }
            String directory = this.fileInformation.convertToDirectoryName(this.currentFilePath);
            this.fileInformation.setFileDirectory(directory);
            drawMain.setTitle("DrawTop file name : " + this.fileInformation.getSimpleFileName(this.currentFilePath));
            if (debug > 0) {
                System.out.println("** File I/O directory set=" + directory);
            }
        }
        catch (Exception e) {
            System.err.println("*** Error FileIO fileSave e=" + e);
            e.printStackTrace();
        }
        this.fileChooser.rescanCurrentDirectory();
        drawMain.setCursor(Cursor.getPredefinedCursor(0));
        UndoDrawManager undoManager = ObjectTable.getUndoDrawManager();
        undoManager.discardAllEdits();
        return 0;
    }

    public int fileSaveAs() {
        DrawMain drawMain = ObjectTable.getDrawMain();
        String directoryPath = this.fileInformation.getDirectory();
        if (!directoryPath.equals("")) {
            File directory = new File(directoryPath);
            this.fileChooser.setCurrentDirectory(directory);
        }
        String filePath = "";
        int ret = this.fileChooser.showSaveDialog(drawMain);
        if (ret == 1) {
            return 1;
        }
        filePath = this.fileChooser.getSelectedFile().toString();
        if (!filePath.endsWith(".draw")) {
            filePath = filePath + ".draw";
        }
        if (!(directoryPath = this.fileInformation.convertToDirectoryName(filePath)).equals("")) {
            if (debug > 0) {
                System.out.println("** FileIO.fileSaveAs filePath=" + filePath + "\n   fileDirectory=" + directoryPath);
            }
            this.fileInformation.setFileDirectory(directoryPath);
        } else {
            System.err.println("  Error \\ not found in filePath");
        }
        PageManager pageManager = ObjectTable.getPageManager("FileIO");
        if (debug > 0) {
            System.out.println("** FileIO.fileSaveAs called");
        }
        drawMain.setCursor(Cursor.getPredefinedCursor(3));
        try {
            pageManager.saveCurrentPage();
            DrawFileIo drawFileIo = ObjectTable.getDrawFileIo();
            drawFileIo.writePageList(filePath, pageManager.getPageList());
            this.currentFilePath = filePath;
            drawMain.setTitle("DrawTop file name : " + this.fileInformation.getSimpleFileName(filePath));
            if (debug > 0) {
                System.out.println("*** File I/O successfull outputFile=" + filePath);
            }
        }
        catch (Exception e) {
            System.err.println("*** Error: FileIO.fileSaveAs, e=" + e);
            e.printStackTrace();
        }
        this.fileChooser.rescanCurrentDirectory();
        drawMain.setCursor(Cursor.getPredefinedCursor(0));
        UndoDrawManager undoManager = ObjectTable.getUndoDrawManager();
        undoManager.discardAllEdits();
        return 0;
    }

    public int saveCurrentFile() {
        int ret = 0;
        ContainerManager containerManager = ObjectTable.getContainerManager();
        UndoDrawManager undoManager = ObjectTable.getUndoDrawManager();
        int size = containerManager.size();
        boolean undo = undoManager.canUndo();
        if (debug > 0) {
            System.out.println("** FileIO.saveCurrentFile size=" + size + ", undo=" + undo);
        }
        if (size == 0 || !undo) {
            return -1;
        }
        String fileName = this.fileInformation.getSimpleFileName(this.currentFilePath);
        String message = fileName.equals("") ? "The current nameless file was changed." : "The \"" + fileName + "\" current file was changed.";
        message = message + " Do you want to save it?";
        ret = JOptionPane.showConfirmDialog(ObjectTable.getDrawMain(), message, "", 1);
        if (ret == -1) {
            ret = 2;
        }
        if (debug > 0) {
            System.out.println("** FileIO.currentfileSaved ret1=" + ret);
        }
        if (ret == 1) {
            return 1;
        }
        if (ret == 2) {
            return 2;
        }
        if (fileName.equals("")) {
            this.fileSaveAs();
        } else {
            this.fileSave();
        }
        return 0;
    }

    public void printOut() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PrintService[] printerServices = printerJob.lookupPrintServices();
        if (printerServices == null || printerServices.length == 0) {
            JOptionPane.showMessageDialog(ObjectTable.getDrawMain(), "Printer not found");
            return;
        }
        Book book = this.createBook();
        printerJob.setPageable(book);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (Exception PrintException) {
                PrintException.printStackTrace();
            }
        }
    }

    public Book createBook() {
        PageManager pageManager = ObjectTable.getPageManager("FileIO");
        Book book = new Book();
        int numOfPages = pageManager.getPageList().size();
        for (int i = 0; i < numOfPages; ++i) {
            ViewData viewData = pageManager.getViewData(i + 1);
            int sheetSize = viewData.getSheetSize();
            Dimension sheetDimension = DrawParameters.SheetSizesMM[sheetSize];
            double pixels = 2.834645669291339;
            sheetDimension = new Dimension((int)(sheetDimension.getWidth() * pixels), (int)(sheetDimension.getHeight() * pixels));
            PageFormat pageFormat = new PageFormat();
            pageFormat.setOrientation(1);
            double paperWidth = sheetDimension.getWidth();
            double paperHeight = sheetDimension.getHeight();
            if (viewData.getSheetOrientation() == 0) {
                pageFormat.setOrientation(0);
            }
            double marginLeft = 0.0;
            double marginRight = 0.0;
            double marginUpper = 0.0;
            double marginBottom = 0.0;
            double originX = marginLeft;
            double originY = marginUpper;
            double imagenableWidth = paperWidth - marginLeft - marginRight;
            double imagenableHeight = paperHeight - marginUpper - marginBottom;
            Paper paper = new Paper();
            paper.setSize(paperWidth, paperHeight);
            paper.setImageableArea(originX, originY, imagenableWidth, imagenableHeight);
            pageFormat.setPaper(paper);
            if (debug > 0) {
                System.out.println("** printOut.pageFormat; pageFormat width,height=" + pageFormat.getWidth() + "," + pageFormat.getHeight() + ", orientation=" + pageFormat.getOrientation() + ", paper width,height=" + paper.getWidth() + "," + paper.getHeight());
            }
            book.append(new PrintableDrawPage(i + 1), pageFormat);
        }
        return book;
    }

    public void exit() {
        System.exit(0);
    }

    public String getCurrentFileName() {
        return this.currentFilePath;
    }

    public String getCurrentSimpleFileName() {
        return this.fileInformation.getSimpleFileName(this.currentFilePath);
    }

    public int getCurrentPage() {
        return ObjectTable.getPageManager().getCurrentPage();
    }
}

