/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Calendar;

public class SysErrOutput {
    private String directoryName = "/ErrorRecords";
    PrintStream printStream = null;
    File currentFile = null;
    String currentFilePath = "";
    public static int debug = 0;

    public void openErrorFile() {
        this.currentFilePath = this.createFileName();
        File file = new File(this.currentFilePath);
        if (file.exists()) {
            if (debug > 0) {
                System.out.println("** SysErrOutput openErrorFile file already exists");
            }
            this.currentFile = file;
        } else {
            try {
                boolean created = file.createNewFile();
                if (debug > 0) {
                    System.out.println("** SysErrOutput openErrorFile created=" + created);
                }
                this.currentFile = file;
            }
            catch (Exception e) {
                System.err.println("*** Error: ErrorFileIO.openErrorFile filePath=" + this.currentFilePath + "\n  e=" + e);
                return;
            }
        }
        this.printStream = this.openFile(this.currentFilePath);
    }

    public boolean getDirectory() {
        File dir = new File("");
        String currentPath = dir.getAbsolutePath();
        String dirPath = currentPath + this.directoryName;
        if (!(dir = new File(dirPath)).isDirectory()) {
            try {
                dir.mkdir();
            }
            catch (Exception e) {
                System.out.println("*** Error: ErrorFileIO getDirectory, mkdir()");
                return false;
            }
        }
        return true;
    }

    public String createFileName() {
        String secsrtr;
        String minsrtr;
        String hoursrtr;
        String ddstr;
        File file = new File("");
        String currentPath = file.getAbsolutePath();
        String filePath = currentPath + this.directoryName;
        Calendar cal = Calendar.getInstance();
        int yy = cal.get(1);
        int mm = cal.get(2) + 1;
        int dd = cal.get(5);
        if (debug > 0) {
            System.out.println("Calender yy=" + yy + ", mm=" + mm + ", dd=" + dd);
        }
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        String mmstr = String.valueOf(mm);
        if (mmstr.length() == 1) {
            mmstr = "0" + mmstr;
        }
        if ((ddstr = String.valueOf(dd)).length() == 1) {
            ddstr = "0" + ddstr;
        }
        if ((hoursrtr = String.valueOf(hour)).length() == 1) {
            hoursrtr = "0" + hoursrtr;
        }
        if ((minsrtr = String.valueOf(min)).length() == 1) {
            minsrtr = "0" + minsrtr;
        }
        if ((secsrtr = String.valueOf(sec)).length() == 1) {
            secsrtr = "0" + secsrtr;
        }
        String date = yy + "" + mmstr + "" + ddstr + "_" + hoursrtr + "" + minsrtr + "" + secsrtr;
        filePath = filePath + "/Errorfile_" + date + ".txt";
        if (debug > 0) {
            System.out.println("createFileName=" + filePath);
        }
        return filePath;
    }

    public PrintStream openFile(String filePath) {
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(this.currentFile);
            System.setErr(printStream);
        }
        catch (Exception e) {
            System.out.println("*** Error: FileIO.fileOpen e=" + e);
            e.printStackTrace();
            return null;
        }
        return printStream;
    }

    public boolean closeFile() {
        if (debug > 0) {
            System.out.println("** SysErrOutput closeFile called");
        }
        try {
            this.printStream.close();
            System.out.println("this.printStream.close");
        }
        catch (Exception e) {
            System.out.println("*** Error: FileIO.closeFile e=" + e);
            e.printStackTrace();
            return false;
        }
        FileReader fileReader = null;
        char[] cbuf = new char[256];
        try {
            fileReader = new FileReader(this.currentFilePath);
            int n = fileReader.read(cbuf);
            String str = new String(cbuf);
            if (str.trim().equals("")) {
                if (debug > 0) {
                    System.out.println("currentFile deleted currentFile=" + this.currentFile.getPath());
                }
                boolean deleted = this.currentFile.delete();
                this.currentFile.deleteOnExit();
                System.out.println("this.currentFile deleted=" + deleted + ", exists=" + this.currentFile.exists());
            }
            fileReader.close();
        }
        catch (IOException e) {
            System.out.println("*** Error: FileReader e=" + e);
        }
        return true;
    }
}

