/*
 * Decompiled with CFR 0.152.
 */
package util;

import DrawTop.ObjectTable;
import java.text.AttributedString;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import shape.PaintStyle;
import shape.SerializableElement;
import shape.SerializableElementUtil;
import shape.SerializablePaintStyle;
import shape.ShapeContainer;
import textBox.SerializableTextBox;
import textBox.TextBox;
import util.ContainerManager;
import util.Util;

public class UndoableDrawEdit
extends AbstractUndoableEdit {

    public static class DeleteText
    extends AbstractUndoableEdit {
        String shapeId = "";
        AttributedString attribStr = null;
        int position = 0;
        int debug = 0;

        public DeleteText(String shapeId, AttributedString attribStr, int position) {
            this.shapeId = shapeId;
            this.attribStr = attribStr;
            this.position = position;
            if (this.debug > 0) {
                System.out.println(" ** UndoableDraeEdit.DeleteText  attribStr=" + Util.Text(attribStr));
            }
        }

        public ShapeContainer getContainer() {
            ContainerManager containerManager = ObjectTable.getContainerManager();
            ShapeContainer container = containerManager.getContainer(this.shapeId);
            return container;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public AttributedString getAttribString() {
            return this.attribStr;
        }

        public void setAttribString(AttributedString attribStr) {
            if (this.debug > 0) {
                System.out.println(" ** UndoableDraeEdit.DeleteText.setAttribString  attribStr=" + Util.Text(attribStr));
            }
            this.attribStr = attribStr;
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public String getUndoPresentationName() {
            return "DeleteText Undo";
        }

        @Override
        public String getRedoPresentationName() {
            return "DeleteText Redo";
        }

        @Override
        public boolean isSignificant() {
            return true;
        }

        @Override
        public void undo() {
            ContainerManager containerManager = ObjectTable.getContainerManager();
            ShapeContainer container = containerManager.getContainer(this.shapeId);
            ShapeContainer shapeContainer = container;
            TextBox textBox = shapeContainer.getTextBox();
            if (textBox == null) {
                System.err.println("*** Error UndoableDrawEdit.DeleteText.undo; textBox not found");
                return;
            }
            shapeContainer.getTextBox().insertText(4, this.position, this.attribStr.getIterator());
            if (this.debug > 0) {
                System.out.println(" ** UndoableDraeEdit.DeleteText.undo  attribStr=" + Util.Text(this.attribStr));
            }
        }

        @Override
        public void redo() {
            ContainerManager containerManager = ObjectTable.getContainerManager();
            ShapeContainer container = containerManager.getContainer(this.shapeId);
            ShapeContainer shapeContainer = container;
            TextBox textBox = shapeContainer.getTextBox();
            if (textBox == null) {
                System.err.println("*** Error UndoableDrawEdit.DeleteText.undo; textBox not found");
                return;
            }
            int length = this.attribStr.getIterator().getEndIndex();
            shapeContainer.getTextBox().deleteText(4, this.position, this.position + length);
        }
    }

    public static class InsertText
    extends AbstractUndoableEdit {
        String shapeId = "";
        AttributedString attribStr = null;
        int position = 0;
        int debug = 0;

        public InsertText(String shapeId, AttributedString attribStr, int position) {
            this.shapeId = shapeId;
            this.attribStr = attribStr;
            this.position = position;
            if (this.debug > 0) {
                System.out.println(" ** UndoableDraeEdit.InsertText  attribStr=" + Util.Text(attribStr));
            }
        }

        public ShapeContainer getContainer() {
            ContainerManager containerManager = ObjectTable.getContainerManager();
            ShapeContainer container = containerManager.getContainer(this.shapeId);
            return container;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public AttributedString getAttribString() {
            return this.attribStr;
        }

        public void setAttribString(AttributedString attribStr) {
            if (this.debug > 0) {
                System.out.println(" ** UndoableDraeEdit.InsertText.setAttribString  attribStr=" + Util.Text(attribStr));
            }
            this.attribStr = attribStr;
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public String getUndoPresentationName() {
            return "InsertText Undo";
        }

        @Override
        public String getRedoPresentationName() {
            return "InsertText Redo";
        }

        @Override
        public boolean isSignificant() {
            return true;
        }

        @Override
        public void undo() {
            ContainerManager containerManager = ObjectTable.getContainerManager();
            ShapeContainer shapeContainer = containerManager.getContainer(this.shapeId);
            TextBox textBox = shapeContainer.getTextBox();
            if (textBox == null) {
                System.err.println("*** Error UndoableDrawEdit.DeleteText.undo; textBox not found");
                return;
            }
            int length = this.attribStr.getIterator().getEndIndex();
            shapeContainer.getTextBox().deleteText(4, this.position, this.position + length);
            if (this.debug > 0) {
                System.out.println(" ** UndoableDraeEdit.InsertText.undo  attribStr=" + Util.Text(this.attribStr));
            }
        }

        @Override
        public void redo() {
            ContainerManager containerManager = ObjectTable.getContainerManager();
            ShapeContainer shapeContainer = containerManager.getContainer(this.shapeId);
            TextBox textBox = shapeContainer.getTextBox();
            if (textBox == null) {
                System.err.println("*** Error UndoableDrawEdit.DeleteText.undo; textBox not found");
                return;
            }
            shapeContainer.getTextBox().insertText(4, this.position, this.attribStr.getIterator());
        }
    }

    public static class ChangeText
    extends AbstractUndoableEdit {
        String shapeId = "";
        AttributedString oldStr = null;
        AttributedString newStr = null;
        int position = 0;
        int debug = 0;

        public ChangeText(String shapeId, AttributedString oldStr, AttributedString newStr) {
            this.shapeId = shapeId;
            this.oldStr = oldStr;
            this.newStr = newStr;
            if (this.debug > 0) {
                System.out.println(" ** UndoableDrawEdit.ChangeText  oldStr=" + Util.Text(oldStr) + "  newStr=" + Util.Text(newStr));
            }
        }

        public ShapeContainer getContainer() {
            ContainerManager containerManager = ObjectTable.getContainerManager();
            ShapeContainer container = containerManager.getContainer(this.shapeId);
            return container;
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public String getUndoPresentationName() {
            return "ChangeText Undo";
        }

        @Override
        public String getRedoPresentationName() {
            return "ChangeText Redo";
        }

        @Override
        public boolean isSignificant() {
            return true;
        }

        @Override
        public void undo() {
            ContainerManager containerManager = ObjectTable.getContainerManager();
            ShapeContainer container = containerManager.getContainer(this.shapeId);
            ShapeContainer shapeContainer = container;
            TextBox textBox = shapeContainer.getTextBox();
            if (textBox == null) {
                System.err.println("*** Error UndoableDrawEdit.ChangeText.undo; textBox not found");
                return;
            }
            shapeContainer.getTextBox().replaceText(4, this.oldStr);
            if (this.debug > 0) {
                System.out.println(" ** UndoableDraeEdit.InsertText.undo  attribStr=" + Util.Text(this.oldStr));
            }
        }

        @Override
        public void redo() {
            ContainerManager containerManager = ObjectTable.getContainerManager();
            ShapeContainer container = containerManager.getContainer(this.shapeId);
            ShapeContainer shapeContainer = container;
            TextBox textBox = shapeContainer.getTextBox();
            if (textBox == null) {
                System.err.println("*** Error UndoableDrawEdit.ChangeText.undo; textBox not found");
                return;
            }
            shapeContainer.getTextBox().replaceText(4, this.newStr);
        }
    }

    public static class ChangePaintStyle
    extends AbstractUndoableEdit {
        String shapeId = "";
        public SerializablePaintStyle oldPaintStyle = null;
        public SerializablePaintStyle newPaintStyle = null;
        int debug = 0;

        public ChangePaintStyle(String shapeId, PaintStyle oldPaintStyle, PaintStyle newPaintStyle) {
            this.shapeId = shapeId;
            this.oldPaintStyle = oldPaintStyle.getSerializablePaintStyle();
            this.newPaintStyle = newPaintStyle.getSerializablePaintStyle();
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public String getUndoPresentationName() {
            return "ChangePaintStyle Undo";
        }

        @Override
        public String getRedoPresentationName() {
            return "ChangePaintStyle Redo";
        }

        @Override
        public boolean isSignificant() {
            return true;
        }

        @Override
        public void undo() {
            ContainerManager containerManager = ObjectTable.getContainerManager();
            ShapeContainer targetContainer = containerManager.getContainer(this.shapeId);
            PaintStyle paintStyle = targetContainer.getPaintStyle();
            paintStyle.setSerializablePaintStyle(this.oldPaintStyle);
            if (this.debug > 0) {
                System.out.println("*** ChangePaintStyle.undo shapeId=" + this.oldPaintStyle.shapeId);
            }
        }

        @Override
        public void redo() {
            ContainerManager containerManager = ObjectTable.getContainerManager();
            ShapeContainer targetContainer = containerManager.getContainer(this.shapeId);
            PaintStyle paintStyle = targetContainer.getPaintStyle();
            paintStyle.setSerializablePaintStyle(this.newPaintStyle);
            if (this.debug > 0) {
                System.out.println("*** ChangePaintStyle.redo shapeId=" + this.newPaintStyle.shapeId);
            }
        }
    }

    public static class ChangeTextBox
    extends AbstractUndoableEdit {
        String shapeId = "";
        public SerializableTextBox oldTextBox = null;
        public SerializableTextBox newTextBox = null;
        int debug = 0;

        public ChangeTextBox(String shapeId, TextBox oldTextBox, TextBox newTextBox) {
            this.shapeId = shapeId;
            this.oldTextBox = oldTextBox.getSerializableTextBox();
            this.newTextBox = newTextBox.getSerializableTextBox();
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public String getUndoPresentationName() {
            return "ChangeTextBox Undo";
        }

        @Override
        public String getRedoPresentationName() {
            return "ChangeTextBox Redo";
        }

        @Override
        public boolean isSignificant() {
            return true;
        }

        @Override
        public void undo() {
            ContainerManager containerManager = ObjectTable.getContainerManager();
            ShapeContainer targetContainer = containerManager.getContainer(this.shapeId);
            if (targetContainer == null || !targetContainer.isTextBox()) {
                System.err.println("*** Error UndoableDrawEdit.ChangeText.undo; targetContainer not found");
                return;
            }
            TextBox textBox = targetContainer.getTextBox();
            textBox.setSerializableTextBox(this.oldTextBox);
            if (this.debug > 0) {
                System.out.println("*** ChangeTextBox.undo shapeId=" + this.oldTextBox.shapeId);
            }
        }

        @Override
        public void redo() {
            ContainerManager containerManager = ObjectTable.getContainerManager();
            ShapeContainer targetContainer = containerManager.getContainer(this.shapeId);
            if (targetContainer == null || !targetContainer.isTextBox()) {
                System.err.println("*** Error UndoableDrawEdit.ChangeText.redo; targetContainer not found");
                return;
            }
            TextBox textBox = targetContainer.getTextBox();
            textBox.setSerializableTextBox(this.newTextBox);
            if (this.debug > 0) {
                System.out.println("*** ChangeTextBox.redo shapeId=" + this.newTextBox.shapeId);
            }
        }
    }

    public static class DeleteContainer
    extends AbstractUndoableEdit {
        SerializableElement data = null;
        boolean significant = true;
        int debug = 0;

        public DeleteContainer(ShapeContainer container) {
            SerializableElement sElement;
            this.data = sElement = SerializableElementUtil.convertShapeContainer(container);
            if (this.debug > 0) {
                System.out.println("UndoDrawEdit.DeleteContainer constructor data=" + this.data.toShortString());
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public String getUndoPresentationName() {
            return "DeleteContainer Undo";
        }

        @Override
        public String getRedoPresentationName() {
            return "DeleteContainer Redo";
        }

        @Override
        public boolean isSignificant() {
            return true;
        }

        @Override
        public void undo() {
            ShapeContainer container = SerializableElementUtil.invertShapeContainer(this.data);
            ContainerManager manager = ObjectTable.getContainerManager("UndoableDrawEdit");
            manager.addContainer(container.getContainerIndex(), container);
            container.setSelected(true);
            if (this.debug > 0) {
                System.out.println(" ** UndoDrawEdit.DeleteContainer, undo addContainer=" + container.getShapeId());
            }
        }

        @Override
        public void redo() {
            ContainerManager manager = ObjectTable.getContainerManager("UndoableDrawEdit");
            boolean removed = false;
            removed = manager.deleteContainer(this.data.shapeId);
            if (!removed) {
                System.err.println("*** Error in  UndoDrawEdit.CreateContainer: redo delete failed  shape=" + this.data.shapeId);
            }
            if (this.debug > 0) {
                System.out.println(" ** UndoDrawEdit.DeleteContainer, redo deleteContainer=" + this.data.shapeId);
            }
        }
    }

    public static class CreateContainer
    extends AbstractUndoableEdit {
        SerializableElement data = null;
        int debug = 0;

        public CreateContainer(ShapeContainer container) {
            SerializableElement sElement;
            this.data = sElement = SerializableElementUtil.convertShapeContainer(container);
            if (this.debug > 0) {
                System.out.println("UndoDrawEdit.CreateContainer constructor container=" + container.toShortString());
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public String getUndoPresentationName() {
            return "CreateContainer Undo";
        }

        @Override
        public String getRedoPresentationName() {
            return "CreateContainer Redo";
        }

        @Override
        public boolean isSignificant() {
            return true;
        }

        @Override
        public void undo() {
            ContainerManager manager = ObjectTable.getContainerManager("UndoableDrawEdit");
            boolean removed = false;
            removed = manager.deleteContainer(this.data.shapeId);
            if (!removed) {
                System.err.println("*** Error UndoDrawEdit.CreateContainer, undo delete failed  shape=" + this.data.shapeId);
            }
            if (this.debug > 0) {
                System.out.println(" ** UndoDrawEdit.CreateContainer, undo, deleteContainer=" + this.data.shapeId);
            }
        }

        @Override
        public void redo() {
            ShapeContainer container = SerializableElementUtil.invertShapeContainer(this.data);
            ContainerManager manager = ObjectTable.getContainerManager("UndoableDrawEdit");
            manager.addContainer(container.getContainerIndex(), container);
            container.setSelected(true);
            if (this.debug > 0) {
                System.out.println(" ** UndoDrawEdit.CreateContainer, redo addContainer=" + container.getShapeId());
            }
            container.setSelected(true);
        }
    }

    public static class ChangeContainer
    extends AbstractUndoableEdit {
        SerializableElement oldData = null;
        SerializableElement newData = null;
        int debug = 0;

        public ChangeContainer(ShapeContainer oldContainer, ShapeContainer newContainer) {
            String newDataStr;
            String oldDataStr;
            SerializableElement sElement;
            this.oldData = sElement = SerializableElementUtil.convertShapeContainer(oldContainer);
            this.newData = sElement = SerializableElementUtil.convertShapeContainer(newContainer);
            if (this.debug > 0) {
                oldDataStr = "null";
                newDataStr = "null";
                if (this.oldData != null) {
                    oldDataStr = this.oldData.toString();
                }
                if (this.newData != null) {
                    newDataStr = this.newData.toString();
                }
                System.out.println(" ** UndoDrawEdit.ChangeContainer\n  -- oldData=" + oldDataStr + "\n  -- newData=" + newDataStr);
            }
            if (this.oldData == null || this.newData == null) {
                System.err.println("*** Error UndoableDrawEdit.ChangeContainer Null data !");
                oldDataStr = "null";
                newDataStr = "null";
                if (this.oldData != null) {
                    oldDataStr = this.oldData.toString();
                }
                if (this.newData != null) {
                    newDataStr = this.newData.toString();
                }
                System.out.println(" ** UndoDrawEdit.ChangeContainer\n  -- oldData=" + oldDataStr + "\n  -- newData=" + newDataStr);
                return;
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public String getUndoPresentationName() {
            return "ChangeContainer Undo";
        }

        @Override
        public String getRedoPresentationName() {
            return "ChangeContainer Redo";
        }

        @Override
        public boolean isSignificant() {
            return true;
        }

        @Override
        public void undo() {
            ContainerManager manager = ObjectTable.getContainerManager("UndoableDrawEdit");
            ShapeContainer container = manager.getContainer(this.oldData.shapeId);
            SerializableElementUtil.setToShapeContainer(this.oldData, container);
            container.setSelected(true);
            if (this.debug > 0) {
                System.out.println(" ** UndoDrawEdit.ChangeContainer, undo=" + container.getShapeId());
            }
        }

        @Override
        public void redo() {
            ContainerManager manager = ObjectTable.getContainerManager("UndoableDrawEdit");
            ShapeContainer container = manager.getContainer(this.newData.shapeId);
            SerializableElementUtil.setToShapeContainer(this.newData, container);
            container.setSelected(true);
            if (this.debug > 0) {
                System.out.println(" ** UndoDrawEdit.ChangeContainer, redo=" + container.getShapeId());
            }
        }
    }

    public static class Delimiter
    extends AbstractUndoableEdit {
        int debug = 0;

        @Override
        public String getUndoPresentationName() {
            return "Delimiter";
        }

        @Override
        public String getRedoPresentationName() {
            return "Delimiter";
        }

        @Override
        public boolean isSignificant() {
            return true;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
        }

        @Override
        public String toString() {
            String str = "Delimiter";
            return str;
        }
    }
}

