/*
 * Decompiled with CFR 0.152.
 */
package util;

import DrawTop.DrawParameters;
import java.awt.Point;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ViewData
implements Serializable {
    public double scale = 1.0;
    public int sheetSize = DrawParameters.SheetSize;
    public int drawPanelWidth = 0;
    public int drawPanelHeight = 0;
    public int sheetOrientation = 0;
    public Point viewPosition = null;
    static int debug = 0;

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public int getSheetSize() {
        return this.sheetSize;
    }

    public void setSheetSize(int sheetSize) {
        this.sheetSize = sheetSize;
    }

    public int getDrawPanelWidth() {
        return this.drawPanelWidth;
    }

    public void setDrawPanelWidth(int drawPanelWidth) {
        this.drawPanelWidth = drawPanelWidth;
    }

    public int getDrawPanelHeight() {
        return this.drawPanelHeight;
    }

    public void setDrawPanelHeight(int drawPanelHeight) {
        this.drawPanelHeight = drawPanelHeight;
    }

    public int getSheetOrientation() {
        return this.sheetOrientation;
    }

    public void setSheetOrientation(int sheetOrientation) {
        this.sheetOrientation = sheetOrientation;
    }

    public Point getViewPosition() {
        return this.viewPosition;
    }

    public void setViewPosition(Point viewPosition) {
        this.viewPosition = viewPosition;
    }

    public String toString() {
        String str = "";
        str = str + "scale=" + this.scale + ", SheetSize=" + DrawParameters.SheetSizeString[this.sheetSize] + ", DrawPanel=" + this.drawPanelWidth + "," + this.drawPanelHeight + ", SheetOrientation=" + DrawParameters.SheetOrientationString[this.sheetOrientation] + ", viewPosition=" + this.viewPosition.getX() + "," + this.viewPosition.getY();
        return str;
    }

    public static int writeViewData(ObjectOutputStream out, ViewData viewData, String version) throws Exception {
        if (debug > 0) {
            System.out.println(" -- writeViewData viewData=" + viewData.toString());
        }
        int ret = 0;
        try {
            out.writeUTF(version);
            out.writeDouble(viewData.scale);
            out.writeInt(viewData.sheetSize);
            out.writeInt(viewData.drawPanelWidth);
            out.writeInt(viewData.drawPanelHeight);
            out.writeInt(viewData.sheetOrientation);
            out.writeObject(viewData.viewPosition);
        }
        catch (Exception e) {
            System.err.println("*** Error ViewData.writeViewData version=" + version);
            e.printStackTrace();
            ret = -1;
        }
        if (debug > 0) {
            System.out.println(" ++ writeViewData ret==" + ret);
        }
        return ret;
    }

    public static ViewData readViewData(ObjectInputStream in) throws Exception {
        ViewData viewData = new ViewData();
        String version = "";
        try {
            version = in.readUTF();
            if (debug > 0) {
                System.out.println(" -- readViewData version=" + version);
            }
            viewData.scale = in.readDouble();
            viewData.sheetSize = in.readInt();
            viewData.drawPanelWidth = in.readInt();
            viewData.drawPanelHeight = in.readInt();
            viewData.sheetOrientation = in.readInt();
            viewData.viewPosition = (Point)in.readObject();
        }
        catch (Exception e) {
            System.err.println("*** Error ViewData.readViewData version=" + version);
            e.printStackTrace();
        }
        return viewData;
    }
}

