/*
 * Decompiled with CFR 0.152.
 */
package util;

import DrawTop.DrawPanel;
import DrawTop.DrawParameters;
import DrawTop.ObjectTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import util.Util;
import util.ViewData;

public class ViewUtil {
    public static int debug = 0;

    public static void zoom(double scale) {
        DrawPanel drawPanel = ObjectTable.getDrawPanel();
        JPanel viewPanel = (JPanel)drawPanel.getParent();
        JScrollPane scrollPane = ObjectTable.getScrollPane();
        double currentScale = DrawParameters.getScale();
        if (debug > 0) {
            System.out.println("\n" + ViewUtil.viewPrint("** ViewUtil.zoom debug before update"));
        }
        JViewport viewport = scrollPane.getViewport();
        Point viewportCenter = new Point(viewport.getWidth() / 2, viewport.getHeight() / 2);
        Point drawPanelCenter = SwingUtilities.convertPoint(viewport, viewportCenter, drawPanel);
        DrawParameters.Scale = scale;
        double ratio = scale / currentScale;
        Point newDrawPanelCenter = new Point((int)(ratio * drawPanelCenter.getX()), (int)(ratio * drawPanelCenter.getY()));
        Point newViewPanelCenter = SwingUtilities.convertPoint(drawPanel, newDrawPanelCenter, viewPanel);
        Point viewLeftTop = new Point((int)(newViewPanelCenter.getX() - viewportCenter.getX()), (int)(newViewPanelCenter.getY() - viewportCenter.getY()));
        ViewUtil.setView(scale, viewLeftTop);
        if (debug > 0) {
            System.out.println("\n" + ViewUtil.viewPrint("** ViewUtil.zoom debug after update"));
        }
    }

    private static String viewPrint(String Title) {
        String str = "";
        double currentScale = DrawParameters.getScale();
        DrawPanel drawPanel = ObjectTable.getDrawPanel();
        JScrollPane scrollPane = ObjectTable.getScrollPane();
        JViewport viewport = scrollPane.getViewport();
        Rectangle drawPanelRec = new Rectangle(0, 0, drawPanel.getWidth(), drawPanel.getHeight());
        JPanel viewPanel = (JPanel)drawPanel.getParent();
        Rectangle viewPanelRec = new Rectangle(0, 0, viewPanel.getWidth(), viewPanel.getHeight());
        Rectangle viewportRec = new Rectangle(0, 0, viewport.getWidth(), viewport.getHeight());
        Rectangle scrollPaneRec = new Rectangle(0, 0, scrollPane.getWidth(), scrollPane.getHeight());
        Point drawPanelOrg = new Point(0, 0);
        Point viewPanelCenter = new Point(viewPanel.getWidth() / 2, viewPanel.getHeight() / 2);
        Point drawPanelCenter = new Point(drawPanel.getWidth() / 2, drawPanel.getHeight() / 2);
        Rectangle drawPanelRecVP = SwingUtilities.convertRectangle(drawPanel, drawPanelRec, viewPanel);
        Rectangle drawPanelRecVPT = SwingUtilities.convertRectangle(drawPanel, drawPanelRec, viewport);
        Rectangle drawPanelRecSC = SwingUtilities.convertRectangle(drawPanel, drawPanelRec, scrollPane);
        Point drawPanelOrgVPT = SwingUtilities.convertPoint(drawPanel, drawPanelOrg, viewport);
        Point drawPanelOrgVP = SwingUtilities.convertPoint(drawPanel, drawPanelOrg, viewPanel);
        Point drawPanelOrgSC = SwingUtilities.convertPoint(drawPanel, drawPanelOrg, scrollPane);
        Point drawPanelCenterVP = SwingUtilities.convertPoint(drawPanel, drawPanelCenter, viewPanel);
        Point drawPanelCenterVPT = SwingUtilities.convertPoint(drawPanel, drawPanelCenter, viewport);
        Point drawPanelCenterSC = SwingUtilities.convertPoint(drawPanel, drawPanelCenter, scrollPane);
        str = str + Title + "\n- scale=" + Util.PercentNum(currentScale, 0) + ", sheet size=" + DrawParameters.SheetSize + "\n- drawPanel Parent=" + drawPanel.getParent().getName() + ", viewPanel Parent=" + viewPanel.getParent().getName() + ", viewport Parent=" + viewport.getParent().getName() + "\n- drawPanel Rec: " + Util.Rect(drawPanelRec) + "\n- viewPanel Rec: " + Util.Rect(viewPanelRec) + "\n- viewport Rec: " + Util.Rect(viewportRec) + "\n- scrollPane Rec: " + Util.Rect(scrollPaneRec) + ", Insets: " + Util.Insets(scrollPane.getInsets()) + "\n- drawPanelOrg on viewPanel=" + Util.Pt(drawPanelOrgVP) + "\n- drawPanelOrg on viewPanel=" + Util.Pt(drawPanelOrgVPT) + "\n- drawPanelOrg on scrooPane=" + Util.Pt(drawPanelOrgSC) + "\n- drawPanel on viewPanel: " + Util.Rect(drawPanelRecVP) + "\n- drawPanel on viewport: " + Util.Rect(drawPanelRecVPT) + "\n- drawPanel on scrollPane: " + Util.Rect(drawPanelRecSC) + "\n- drawPanelCenter on viewPanel=" + Util.Pt(drawPanelCenterVP) + "\n- drawPanelCenter on viewport=" + Util.Pt(drawPanelCenterVPT) + "\n- drawPanelCenter on scrollPane=" + Util.Pt(drawPanelCenterSC);
        return str;
    }

    public static JPanel getViewPanel(JPanel drawPanel) {
        JPanel viewPanel = (JPanel)drawPanel.getParent();
        if (viewPanel == null) {
            viewPanel = new JPanel();
            viewPanel.add((Component)drawPanel, 0);
            viewPanel.setOpaque(true);
            viewPanel.setBackground(Color.LIGHT_GRAY);
        }
        return viewPanel;
    }

    public static void setView(double scale, Point viewLeftTop) {
        DrawPanel drawPanel = ObjectTable.getDrawPanel();
        if (debug > 0) {
            System.out.println("** ViewUtil.zoom called scale=" + scale);
        }
        JScrollPane scrollPane = ObjectTable.getScrollPane("ViewUtil.setView");
        Dimension size = DrawParameters.getSheetSizeByPixel();
        int drawPanelW = (int)size.getWidth();
        int drawPanelH = (int)size.getHeight();
        Dimension newSize = new Dimension((int)(scale * (double)drawPanelW), (int)(scale * (double)drawPanelH));
        drawPanel.setPreferredSize(newSize);
        JPanel viewPanel = ViewUtil.getViewPanel(drawPanel);
        JViewport viewport = scrollPane.getViewport();
        viewport.setView(viewPanel);
        double dpX = drawPanel.getX();
        double dpY = drawPanel.getY();
        double dpW = drawPanel.getWidth();
        double dpH = drawPanel.getHeight();
        if (viewLeftTop != null) {
            double viewLeftTopX = viewLeftTop.getX();
            double viewLeftTopY = viewLeftTop.getY();
            if (viewLeftTopX < dpX) {
                viewLeftTopX = dpX;
            }
            if (viewLeftTopX > dpX + dpW) {
                viewLeftTopX = dpX + dpW;
            }
            if (viewLeftTopY < dpY) {
                viewLeftTopY = dpY;
            }
            if (viewLeftTopY > dpY + dpH) {
                viewLeftTopY = dpY + dpH;
            }
            viewport.setViewPosition(new Point((int)viewLeftTopX, (int)viewLeftTopY));
        }
        drawPanel.revalidate();
        drawPanel.repaint("ViewUtil");
    }

    public static void moveView(Point mousePosition) {
        JScrollPane scrollPane = ObjectTable.getScrollPane("ViewUtil.setView");
        double scale = DrawParameters.getScale();
        double x = mousePosition.getX();
        double y = mousePosition.getY();
        JViewport viewport = scrollPane.getViewport();
        Point leftTopViewP = viewport.getViewPosition();
        double vpX = leftTopViewP.getX();
        double vpY = leftTopViewP.getY();
        double xmin = vpX;
        double ymin = vpY;
        double xmax = viewport.getX() + viewport.getWidth();
        double ymax = viewport.getY() + viewport.getHeight();
        double margin = 10.0;
        double delta = 5.0;
        double moveX = 0.0;
        double moveY = 0.0;
        if (x < xmin + margin) {
            moveX = -5.0;
        }
        if (x > xmax - margin) {
            moveX = 5.0;
        }
        if (y < ymin + margin) {
            moveY = -5.0;
        }
        if (y > ymax - margin) {
            moveY = 5.0;
        }
        if (debug > 0) {
            System.out.println("** ViewUtil.moveViewPort  x,y=" + Util.Num(x) + "," + Util.Num(y) + ", vpX,vpY=" + Util.Num(vpX) + "," + Util.Num(vpY) + ", xmin,xmax=" + Util.Num(xmin) + "," + Util.Num(xmax) + ", ymin,ymax=" + Util.Num(ymin) + "," + Util.Num(ymax));
        }
        if (moveX == 0.0 && moveY == 0.0) {
            return;
        }
        double leftTopX = vpX;
        double leftTopY = vpY;
        leftTopX = vpX + moveX;
        leftTopY = vpY + moveY;
        ViewUtil.setView(scale, new Point((int)leftTopX, (int)leftTopY));
    }

    public static ViewData getViewData() {
        Point leftTopViewP;
        ViewData data = new ViewData();
        data.scale = DrawParameters.Scale;
        data.sheetSize = DrawParameters.SheetSize;
        data.sheetOrientation = DrawParameters.SheetOrientation;
        DrawPanel drawPanel = ObjectTable.getDrawPanel();
        Dimension size = drawPanel.getPreferredSize();
        data.drawPanelWidth = (int)size.getWidth();
        data.drawPanelHeight = (int)size.getHeight();
        JScrollPane scrollPane = ObjectTable.getScrollPane("ViewUtil.zoom");
        data.viewPosition = leftTopViewP = scrollPane.getViewport().getViewPosition();
        return data;
    }

    public static void setViewData(ViewData data) {
        DrawParameters.Scale = data.scale;
        DrawParameters.SheetSize = data.sheetSize;
        DrawParameters.SheetOrientation = data.sheetOrientation;
        Point leftTopViewP = data.viewPosition;
        ViewUtil.setView(data.scale, leftTopViewP);
    }

    public static ViewData getDefaultViewData() {
        ViewData data = new ViewData();
        data.scale = 1.0;
        data.sheetSize = 1;
        data.sheetOrientation = 0;
        data.viewPosition = new Point(0, 0);
        return data;
    }

    public static Point getViewPosition() {
        JScrollPane scrollPane = ObjectTable.getScrollPane("ViewUtil");
        Point point = scrollPane.getViewport().getViewPosition();
        return point;
    }
}

