/*
 * Decompiled with CFR 0.152.
 */
package DrawTop;

import geomExtension.Vector2D;
import java.awt.geom.Point2D;
import java.io.Serializable;
import shape.ShapeContainer;
import textBox.TextBox;

public class MousePositionInfo
implements Serializable {
    ShapeContainer container = null;
    ShapeContainer shapeContainerInGroup = null;
    TextBox textBox = null;
    String mouseStatus = "";
    boolean rightButtonPressed = false;
    int position = 0;
    Point2D point = null;
    String information = "";
    public static final int NO_HIT = 0;
    public static final int INSIDE_DRAWAREA = 1;
    public static final int SELECTION_BOX = 2;
    public static final int NW_RESIZE = 3;
    public static final int NE_RESIZE = 4;
    public static final int SE_RESIZE = 5;
    public static final int SW_RESIZE = 6;
    public static final int N_RESIZE = 7;
    public static final int E_RESIZE = 8;
    public static final int S_RESIZE = 9;
    public static final int W_RESIZE = 10;
    public static final int BOUNDINGBOX_BOUNDARY = 11;
    public static final int INSIDE_BOUNDINGBOX = 12;
    public static final int SHAPE_BOUNDARY = 13;
    public static final int END_POINT = 14;
    public static final int CONTROL_POINT = 15;
    public static final int INSIDE_SHAPE = 16;
    public static final int TEXTBOX_BOUNDARY = 17;
    public static final int INSIDE_TEXTBOX = 18;
    public static final int INSIDE_TEXT = 19;
    public static final String[] positionString = new String[20];

    public MousePositionInfo() {
        this.setPositionString();
    }

    public void setContainer(ShapeContainer container) {
        this.container = container;
    }

    public void setShapeContainerInGroup(ShapeContainer shapeContainerInGroup) {
        this.shapeContainerInGroup = shapeContainerInGroup;
    }

    public void setTextBox(TextBox textBox) {
        this.textBox = textBox;
    }

    public void setMouseStatus(String mouseStatus) {
        this.mouseStatus = mouseStatus;
    }

    public void setRightButtonPressed(boolean pressed) {
        this.rightButtonPressed = pressed;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setPoint(Point2D point) {
        this.point = point;
    }

    public void setInformation(String inf) {
        this.information = inf;
    }

    public ShapeContainer getContainer() {
        return this.container;
    }

    public ShapeContainer getShapeContainerInGroup() {
        return this.shapeContainerInGroup;
    }

    public TextBox getTextBox() {
        return this.textBox;
    }

    public String getMouseStatus() {
        return this.mouseStatus;
    }

    public boolean isRightButtonPressed() {
        return this.rightButtonPressed;
    }

    public int getPosition() {
        return this.position;
    }

    public Point2D getPoint() {
        return this.point;
    }

    public String getInformation() {
        return this.information;
    }

    public int getEndPTindex() {
        int index = -1;
        if (this.onEndPoint()) {
            double d1;
            index = 0;
            Point2D[] PTs = this.container.getElement().getEndPTs();
            double d0 = Vector2D.dist(this.point, PTs[0]);
            if (d0 > (d1 = Vector2D.dist(this.point, PTs[1]))) {
                index = 1;
            }
        }
        return index;
    }

    public Point2D getEndPT() {
        Point2D endPT = null;
        if (this.onEndPoint()) {
            Point2D[] PTs = this.container.getElement().getEndPTs();
            int index = this.getEndPTindex();
            endPT = PTs[index];
        }
        return endPT;
    }

    public boolean onResizeMark() {
        return this.position >= 3 && this.position <= 10;
    }

    public boolean onEndPoint() {
        return this.position == 14;
    }

    public boolean onControlPoint() {
        return this.position == 15;
    }

    public Object clone() {
        if (this == null) {
            return null;
        }
        MousePositionInfo info = new MousePositionInfo();
        info.container = this.container;
        info.shapeContainerInGroup = this.shapeContainerInGroup;
        info.textBox = this.textBox;
        info.mouseStatus = this.mouseStatus;
        info.rightButtonPressed = this.rightButtonPressed;
        info.position = this.position;
        info.point = this.point;
        info.information = this.information;
        return info;
    }

    public String toString() {
        String str = "";
        double X = this.point.getX();
        double Y = this.point.getY();
        str = str + " " + MousePositionInfo.getPositionStringInDetail(this.position);
        if (this.container != null) {
            str = str + ",  shape=" + this.container.getShapeId();
        }
        if (this.shapeContainerInGroup != null) {
            str = str + ",  shape in group=" + this.shapeContainerInGroup.getShapeId();
        }
        str = str + "  x,y=" + (int)X + "," + (int)Y;
        if (this.rightButtonPressed) {
            str = str + ", Right Button Pressed";
        }
        if (this.information.equals("")) {
            str = str + ", inf=" + this.information;
        }
        return str;
    }

    private void setPositionString() {
        for (int i = 0; i < positionString.length; ++i) {
            this.setPositionString(i, "");
        }
        this.setPositionString(0, "NO_HIT");
        this.setPositionString(1, "INSIDE_DRAWAREA");
        this.setPositionString(2, "SELECTION_BOX");
        this.setPositionString(3, "NW_RESIZE");
        this.setPositionString(4, "NE_RESIZE");
        this.setPositionString(5, "SE_RESIZE");
        this.setPositionString(6, "SW_RESIZE");
        this.setPositionString(7, "N_RESIZE");
        this.setPositionString(8, "E_RESIZE");
        this.setPositionString(9, "S_RESIZE");
        this.setPositionString(10, "W_RESIZE");
        this.setPositionString(11, "BOUNDINGBOX_BOUNDARY");
        this.setPositionString(12, "INSIDE_BOUNDINGBOX");
        this.setPositionString(13, "SHAPE_BOUNDARY");
        this.setPositionString(14, "END_POINT");
        this.setPositionString(15, "CONTROL_POINT");
        this.setPositionString(16, "INSIDE_SHAPE");
        this.setPositionString(17, "TEXTBOX_BOUNDARY");
        this.setPositionString(18, "INSIDE_TEXTBOX");
        this.setPositionString(19, "INSIDE_TEXT");
    }

    void setPositionString(int position, String positionString) {
        MousePositionInfo.positionString[position] = positionString;
    }

    public static String getPositionString(int position) {
        String str = "";
        str = positionString[position];
        return str;
    }

    public static String getPositionStringInDetail(int position) {
        String str = "No hit";
        if (position == 0) {
            str = "No hit";
        }
        if (position == 1) {
            str = "Inside draw area";
        }
        if (position == 2) {
            str = "Selection box";
        }
        if (position == 3) {
            str = "NW-resize mark";
        }
        if (position == 4) {
            str = "NE-resize mark";
        }
        if (position == 5) {
            str = "SE-resize mark";
        }
        if (position == 6) {
            str = "SW-resize mark";
        }
        if (position == 7) {
            str = "N-resize mark";
        }
        if (position == 8) {
            str = "E-resize mark";
        }
        if (position == 9) {
            str = "S-resize mark";
        }
        if (position == 10) {
            str = "W-resize mark";
        }
        if (position == 11) {
            str = "Bounding box boundary";
        }
        if (position == 12) {
            str = "Inside bounding box";
        }
        if (position == 13) {
            str = "Shape boundary";
        }
        if (position == 14) {
            str = "End point";
        }
        if (position == 15) {
            str = "Control point";
        }
        if (position == 16) {
            str = "Inside shape";
        }
        if (position == 17) {
            str = "TextBox boundary";
        }
        if (position == 18) {
            str = "Inside TextBox";
        }
        if (position == 19) {
            str = "Inside text";
        }
        return str;
    }
}

