/*
 * Decompiled with CFR 0.152.
 */
package DrawTop;

import DrawTop.Command;
import DrawTop.DrawPanel;
import DrawTop.DrawParameters;
import DrawTop.ExecCommand;
import DrawTop.ExecPopupMenu;
import DrawTop.ListenerPanel;
import DrawTop.MousePositionInfo;
import DrawTop.MousePositionLS;
import DrawTop.ObjectTable;
import DrawTop.SelectionEvent;
import DrawTop.SelectionListener;
import geomExtension.Vector2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JTabbedPane;
import javax.swing.event.EventListenerList;
import shape.DrawShapeUtil;
import shape.PaintStyle;
import shape.ShapeContainer;
import textBox.FontStyle;
import textBox.TextBox;
import util.ContainerManager;
import util.Util;

public class SelectionLS
implements MouseListener,
MouseMotionListener {
    protected EventListenerList listenerList = new EventListenerList();
    public static boolean popupTrigger;
    boolean clicked = false;
    public Point2D clickedPoint = null;
    Rectangle2D draggedRectangle = null;
    Point2D startPoint = null;
    Point2D endPoint = null;
    boolean mouseExited = false;
    private int ctrl = 0;
    int idNumber = 0;
    Vector workVector = new Vector();
    public static int debug;

    public SelectionLS() {
        this.start();
    }

    public void start() {
        if (debug > 0) {
            System.out.println(" -S(" + this.idNumber++ + ")  SelectionLS start");
        }
        this.activateListener(true);
    }

    public void end() {
        if (debug > 0) {
            System.out.println(" -S(" + this.idNumber++ + ") SelectionLS end");
        }
        this.activateListener(false);
        this.draggedRectangle = null;
        this.startPoint = null;
        this.endPoint = null;
        this.clickedPoint = null;
    }

    public boolean isMouseListener(MouseListener listener) {
        ListenerPanel listenerPanel = ObjectTable.getListenerPanel();
        MouseListener[] mouseLS = listenerPanel.getMouseListeners();
        boolean isRegistered = false;
        for (int i = 0; i < mouseLS.length; ++i) {
            if (!listener.equals(mouseLS[i])) continue;
            isRegistered = true;
        }
        return isRegistered;
    }

    public boolean isMouseMotionListener(MouseMotionListener listener) {
        ListenerPanel listenerPanel = ObjectTable.getListenerPanel();
        MouseMotionListener[] mouseMotionLS = listenerPanel.getMouseMotionListeners();
        boolean isRegistered = false;
        for (int i = 0; i < mouseMotionLS.length; ++i) {
            if (!listener.equals(mouseMotionLS[i])) continue;
            isRegistered = true;
        }
        return isRegistered;
    }

    private void activateListener(boolean activate) {
        ListenerPanel listenerPanel;
        if (activate && !this.isMouseListener(this) && !this.isMouseMotionListener(this)) {
            listenerPanel = ObjectTable.getListenerPanel();
            listenerPanel.addMouseListener(this);
            listenerPanel.addMouseMotionListener(this);
        }
        if (!activate && this.isMouseListener(this) && this.isMouseMotionListener(this)) {
            listenerPanel = ObjectTable.getListenerPanel();
            listenerPanel.removeMouseListener(this);
            listenerPanel.removeMouseMotionListener(this);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.listenerList.add(SelectionListener.class, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.listenerList.remove(SelectionListener.class, listener);
    }

    public void removeSelectionListener() {
        this.listenerList = new EventListenerList();
    }

    public void fireEvent(SelectionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != SelectionListener.class) continue;
            ((SelectionListener)listeners[i + 1]).selected(event);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        double Y;
        this.clicked = false;
        popupTrigger = false;
        if (e.isPopupTrigger()) {
            popupTrigger = true;
        }
        int key = e.getModifiersEx();
        this.ctrl = 0;
        if ((key & 0x800) != 0) {
            this.ctrl = 2;
        }
        if ((key & 0x1000) != 0) {
            this.ctrl = 3;
        }
        if (debug > 0) {
            System.out.println("++ SelectionLS.mousePressed;  this.ctrl=" + this.ctrl);
        }
        double scale = DrawParameters.getScale();
        double X = (double)e.getX() / scale;
        if (this.inEditableTextArea(X, Y = (double)e.getY() / scale)) {
            return;
        }
        this.startPoint = new Point2D.Double(X, Y);
        MousePositionLS mousePositionLS = ObjectTable.getMousePositionLS();
        MousePositionInfo info = mousePositionLS.getMousePositionInfoForMoveResize();
        if (info != null) {
            ShapeContainer container = info.getContainer();
            int position = info.getPosition();
            boolean group = info.getContainer().getContainerType() == ShapeContainer.GROUP;
            boolean selected = container.isSelected();
            if (group) {
                boolean posFlag;
                boolean bl = posFlag = position >= 2;
                if (container.isEditableTextBox()) {
                    boolean bl2 = posFlag = position >= 2 && position != 13 && position != 17 && position != 19;
                }
                if (this.ctrl == 0 && selected && posFlag) {
                    this.prepareMoveResizeCommand(info, e);
                }
            } else {
                boolean posFlag;
                boolean bl = posFlag = position >= 2;
                if (container.isEditableTextBox()) {
                    boolean bl3 = posFlag = position >= 2 && position != 13 && position != 17 && position != 19;
                }
                if (this.ctrl == 0 && selected && posFlag) {
                    this.prepareMoveResizeCommand(info, e);
                }
            }
        }
        ObjectTable.getDrawPanel().repaint("SelectionLS.mousePressed");
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (debug > 0) {
            this.printMouseEvent("** mouseDragged", e);
        }
        Rectangle r = new Rectangle(e.getX(), e.getY(), 1, 1);
        ((DrawPanel)e.getSource()).scrollRectToVisible(r);
        double scale = DrawParameters.getScale();
        double X = (double)e.getX() / scale;
        double Y = (double)e.getY() / scale;
        if (this.inEditableTextArea(X, Y)) {
            return;
        }
        this.endPoint = new Point2D.Double(X, Y);
        if (this.startPoint != null) {
            double x1 = this.startPoint.getX();
            double y1 = this.startPoint.getY();
            double x2 = this.endPoint.getX();
            double y2 = this.endPoint.getY();
            double w = Math.abs(x1 - x2);
            double h = Math.abs(y1 - y2);
            double x = x1;
            double y = y1;
            if (x > x2) {
                x = x2;
            }
            if (y > y2) {
                y = y2;
            }
            if (w > 1.0 && h > 1.0) {
                this.draggedRectangle = new Rectangle2D.Double(x, y, w, h);
            }
        }
        ObjectTable.getDrawPanel().repaint("SelectionLS.mouseDragged");
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (debug > 0) {
            this.printMouseEvent("** mouseReleased", e);
        }
        if (e.isPopupTrigger()) {
            popupTrigger = true;
        }
        double scale = DrawParameters.getScale();
        double X = (double)e.getX() / scale;
        double Y = (double)e.getY() / scale;
        this.endPoint = new Point2D.Double(X, Y);
        if (this.inEditableTextArea(X, Y)) {
            return;
        }
        int key = e.getModifiersEx();
        int ctrl = 0;
        if ((key & 0x40) != 0) {
            ctrl = 1;
        }
        if ((key & 0x80) != 0) {
            ctrl = 2;
        }
        if (this.draggedRectangle != null) {
            this.execSelection(ctrl, this.draggedRectangle);
        }
        double dist = 100000.0;
        if (this.startPoint != null && this.endPoint != null) {
            dist = Vector2D.dist(this.startPoint, this.endPoint);
        }
        if (dist != 0.0 && dist < 4.0) {
            MousePositionLS mousePositionLS;
            MousePositionInfo[] infos;
            if (debug > 0) {
                System.out.println("*** Warning: The mouseReleased calls mouseClicked  dist=" + dist);
                System.err.println("*** Warning: The mouseReleased calls mouseClicked  dist=" + dist);
            }
            if ((infos = (mousePositionLS = ObjectTable.getMousePositionLS()).getMousePositionInfoForSelection()) == null || infos.length == 0) {
                ShapeContainer[] selected = ObjectTable.getContainerManager().getSelectedContainers();
                for (int i = 0; i < selected.length; ++i) {
                    selected[i].setSelected(false);
                }
                DrawShapeUtil.clearAllTempShapes();
            }
        }
        this.draggedRectangle = null;
        this.startPoint = null;
        this.endPoint = null;
        ObjectTable.getDrawPanel().repaint("SelectionLS.mouseReleased");
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.clicked = true;
        double scale = DrawParameters.getScale();
        double X = (double)e.getX() / scale;
        double Y = (double)e.getY() / scale;
        int key = e.getModifiersEx();
        int ctrl = 0;
        if ((key & 0x40) != 0) {
            ctrl = 1;
        }
        if ((key & 0x80) != 0) {
            ctrl = 2;
        }
        this.clickedPoint = new Point2D.Double(X, Y);
        this.prepareClickedPointCommand((Point2D)this.clickedPoint.clone());
        if (!this.inEditableTextArea(X, Y)) {
            this.execSelection(ctrl, null);
        }
        if (debug > 0) {
            System.out.println("** SelectionLS this.allMouseEventsCompleted()=" + this.allMouseEventsCompleted() + ", SelectionLS.popupTrigger=" + popupTrigger + ", MousePositionLS.popupTrigger=" + MousePositionLS.popupTrigger);
        }
        if (this.allMouseEventsCompleted() && (popupTrigger || MousePositionLS.popupTrigger)) {
            if (debug > 0) {
                System.out.println("** SelectionLS ExecPopupMenu");
            }
            ExecPopupMenu execPopupMenu = ObjectTable.getExecPopupMenu("");
            execPopupMenu.show(new Point((int)X, (int)Y));
            popupTrigger = false;
            MousePositionLS.popupTrigger = false;
        }
        ObjectTable.getDrawPanel().repaint("SelectionLS.mouseClicked");
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (debug > 0) {
            this.printMouseEvent("** mouseEntered", e);
        }
        this.mouseExited = false;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (debug > 0) {
            this.printMouseEvent("** mouseExited", e);
        }
        this.mouseExited = true;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public void printMouseEvent(String message, MouseEvent e) {
        String str = "";
        str = str + message;
        double scale = DrawParameters.getScale();
        str = str + " (x,y)=(" + e.getX() + ", " + e.getY() + ")";
        str = str + ", scaled(x,y)=(" + (double)e.getX() / scale + ", " + (double)e.getY() / scale + ")";
        int key = e.getModifiersEx();
        str = str + ", key=" + MouseEvent.getMouseModifiersText(key);
        if ((key & 0x40) != 0) {
            str = str + ", SHIFT_DOWN";
        }
        if ((key & 0x80) != 0) {
            str = str + ", CTRL_DOWN";
        }
        str = str + ", e.isPopupTrigger()=" + e.isPopupTrigger();
        DrawPanel drawPanel = ObjectTable.getDrawPanel();
        str = str + ", drawPanel size=(" + drawPanel.getWidth() + ", " + drawPanel.getHeight() + ")";
        System.out.println(str);
    }

    private boolean inEditableTextArea(double X, double Y) {
        boolean in = false;
        ContainerManager manager = ObjectTable.getContainerManager();
        ShapeContainer shapeContainer = manager.getEditableTextBox();
        if (shapeContainer != null) {
            Rectangle2D rect = shapeContainer.getTextBox().getTextArea();
            if (debug > 0) {
                System.out.println("Unselectable Area: " + Util.Rect(rect));
            }
            if (rect.contains(X, Y)) {
                in = true;
            }
        }
        return in;
    }

    public void drawDraggedRectangle(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Color currentColor = g2.getColor();
        g2.setColor(Color.black);
        Rectangle2D draggedArea = this.draggedRectangle;
        float[] dash = new float[]{2.0f, 2.0f};
        BasicStroke basicStroke = new BasicStroke(0.5f, 2, 0, 1.0f, dash, 0.0f);
        Stroke currentStroke = g2.getStroke();
        g2.setStroke(basicStroke);
        if (debug > 1) {
            System.out.println(" -S(" + this.idNumber++ + ") SelectionLS.drawDraggedArea, draggedArea=" + draggedArea);
        }
        if (draggedArea != null) {
            g2.draw(draggedArea);
        }
        g2.setStroke(currentStroke);
        g2.setColor(currentColor);
    }

    public void execSelection(int ctrl, Rectangle2D draggedArea) {
        JTabbedPane tabbedPane = ObjectTable.getTabbedPane("SelectionLS");
        if (tabbedPane != null) {
            tabbedPane.setSelectedIndex(1);
        }
        ContainerManager containerManager = ObjectTable.getContainerManager();
        if (draggedArea != null) {
            this.execSelectionByDrag(ctrl, draggedArea);
        } else {
            this.execSelectionByClick(ctrl);
        }
        ShapeContainer[] containers = containerManager.getAllSigleShapeContainers(true);
        ShapeContainer editableTextContainer = containerManager.getEditableTextBox();
        if (debug > 0) {
            System.out.println("** SelectionLS.execSelection");
            if (editableTextContainer != null) {
                System.out.println("-- editableTextContainer:" + editableTextContainer.getShapeId());
            } else {
                System.out.println("-- editableTextContainer:none");
            }
            int size = 0;
            if (containers != null) {
                size = containers.length;
            }
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    System.out.println("-- selected:" + containers[i].getShapeId());
                }
            } else {
                System.out.println("-- selected:none");
            }
        }
        PaintStyle.setPaintStyleToMenu(containers, "SelectionLS.execSelection");
        if (editableTextContainer == null) {
            FontStyle.setFontStyleToMenu(containers, "SelectionLS.execSelection");
        } else {
            FontStyle.setFontStyleToMenu(editableTextContainer.getTextBox(), "SelectionLS.execSelection");
        }
        this.clickedPoint = null;
        ObjectTable.getExecCommand().setPreviousCommandId(33);
    }

    public void execSelectionByDrag(int ctrl, Rectangle2D draggedArea) {
        ContainerManager containerManager = ObjectTable.getContainerManager();
        MousePositionInfo[] infos = this.selectInDraggedArea(draggedArea);
        if (infos == null || infos.length == 0) {
            ShapeContainer[] selected = containerManager.getSelectedContainers();
            for (int i = 0; i < selected.length; ++i) {
                selected[i].setSelected(false);
            }
            return;
        }
        if (ctrl > 0) {
            for (int i = 0; i < infos.length; ++i) {
                ShapeContainer selectedContainer = infos[i].getContainer();
                if (selectedContainer.isSelected()) {
                    selectedContainer.setSelected(false);
                    continue;
                }
                selectedContainer.setSelected(true);
                this.workVector.add(selectedContainer);
            }
        } else {
            int i;
            ShapeContainer[] selected = containerManager.getSelectedContainers();
            for (i = 0; i < selected.length; ++i) {
                selected[i].setSelected(false);
            }
            for (i = 0; i < infos.length; ++i) {
                ShapeContainer selectedContainer = infos[i].getContainer();
                selectedContainer.setSelected(true);
                this.workVector.add(selectedContainer);
            }
        }
        if (this.workVector.size() > 0) {
            int size = this.workVector.size();
            ShapeContainer[] containers = new ShapeContainer[size];
            for (int i = 0; i < size; ++i) {
                containers[i] = (ShapeContainer)this.workVector.get(i);
            }
            SelectionEvent event = new SelectionEvent(this, "dragged", containers, null);
            this.fireEvent(event);
        }
    }

    private MousePositionInfo[] selectInDraggedArea(Rectangle2D draggedArea) {
        if (draggedArea == null) {
            return null;
        }
        ArrayList<MousePositionInfo> arrayList = new ArrayList<MousePositionInfo>();
        ContainerManager containerManager = ObjectTable.getContainerManager();
        ShapeContainer[] containers = containerManager.getContainers();
        for (int i = 0; i < containers.length; ++i) {
            Rectangle2D boundingBox = containers[i].getBoundingBox();
            if (boundingBox == null) continue;
            double x = boundingBox.getX();
            double y = boundingBox.getY();
            double w = boundingBox.getWidth();
            double h = boundingBox.getHeight();
            if (!draggedArea.contains(x, y) || !draggedArea.contains(x + w, y + h)) continue;
            MousePositionInfo info = new MousePositionInfo();
            info.setContainer(containers[i]);
            info.setMouseStatus("mouseDragged");
            int position = 16;
            info.setPosition(position);
            info.setPoint(new Point2D.Double(x + 0.5 * w, y + 0.5 * h));
            arrayList.add(info);
        }
        int size = arrayList.size();
        MousePositionInfo[] infos = new MousePositionInfo[size];
        for (int i = 0; i < size; ++i) {
            infos[i] = (MousePositionInfo)arrayList.get(i);
        }
        return infos;
    }

    public void execSelectionByClick(int ctrl) {
        ShapeContainer[] containers;
        MousePositionLS mousePositionLS = ObjectTable.getMousePositionLS();
        MousePositionInfo[] infos = mousePositionLS.getMousePositionInfoForSelection();
        if (debug > 0) {
            System.out.println("execSelectionByClick");
            if (infos.length == 0) {
                System.out.println("infos is null");
            } else {
                for (int i = 0; i < infos.length; ++i) {
                    System.out.println("rankedInfos[" + i + "]: " + infos[i].toString());
                }
            }
        }
        ContainerManager containerManager = ObjectTable.getContainerManager();
        if (infos == null || infos.length == 0) {
            ShapeContainer[] selected = containerManager.getSelectedContainers();
            for (int i = 0; i < selected.length; ++i) {
                selected[i].setSelected(false);
            }
            DrawShapeUtil.clearAllTempShapes();
            ObjectTable.getDrawPanel().repaint("SelectionLS");
            return;
        }
        MousePositionInfo info = infos[0];
        info.setMouseStatus("mouseClicked");
        if (this.ctrl >= 2) {
            info.setRightButtonPressed(true);
        }
        ShapeContainer selectedContainer = info.getContainer();
        this.workVector.clear();
        if (ctrl > 0) {
            if (selectedContainer.isSelected()) {
                selectedContainer.setSelected(false);
            } else {
                selectedContainer.setSelected(true);
                this.workVector.add(selectedContainer);
                if (info.getPosition() == 19 || info.getPosition() == 18) {
                    this.selectTextBox(selectedContainer, info, ctrl);
                }
            }
        } else if (selectedContainer.isSelected() && info.isRightButtonPressed()) {
            selectedContainer.setSelected(true);
        } else if (selectedContainer.isSelected() && !info.isRightButtonPressed()) {
            if (info.getPosition() == 19) {
                this.selectTextBox(selectedContainer, info, ctrl);
            } else {
                selectedContainer.setSelected(false);
            }
        } else {
            containers = containerManager.getContainers();
            for (int i = 0; i < containers.length; ++i) {
                containers[i].setSelected(false);
            }
            selectedContainer.setSelected(true);
            this.workVector.add(selectedContainer);
            if (info.getPosition() == 19) {
                this.selectTextBox(selectedContainer, info, ctrl);
            }
        }
        if (this.workVector.size() > 0) {
            containers = new ShapeContainer[]{(ShapeContainer)this.workVector.get(0)};
            SelectionEvent event = new SelectionEvent(this, "clicked", containers, this.clickedPoint);
            this.fireEvent(event);
        }
    }

    private void selectTextBox(ShapeContainer selectedContainer, MousePositionInfo info, int ctrl) {
        ContainerManager containerManager = ObjectTable.getContainerManager();
        if (selectedContainer.getContainerType() == ShapeContainer.SHAPE && selectedContainer.isTextBox()) {
            containerManager.makeAllTextBoxesUneditable();
            selectedContainer.makeTextBoxEditable(info.getPoint(), ctrl);
        }
        if (selectedContainer.getContainerType() == ShapeContainer.GROUP) {
            containerManager.makeAllTextBoxesUneditable();
            TextBox textBox = info.getTextBox();
            ShapeContainer shapeContainer = textBox.getShapeContainer();
            shapeContainer.makeTextBoxEditable(info.getPoint(), ctrl);
        }
    }

    public void selectAll(boolean select) {
        ContainerManager containerManager = ObjectTable.getContainerManager();
        ShapeContainer[] containers = containerManager.getContainers();
        for (int i = 0; i < containers.length; ++i) {
            if (containers[i].isSelected() == select) continue;
            containers[i].setSelected(select);
        }
        ObjectTable.getDrawPanel().repaint("SelectionLS.selectAll");
    }

    public void prepareMoveResizeCommand(MousePositionInfo mouseInfo, MouseEvent e) {
        ExecCommand execCommand = ObjectTable.getExecCommand();
        int position = mouseInfo.getPosition();
        if (debug > 0) {
            System.out.println(" -S(" + this.idNumber++ + ") SelectionLS.prepareCommand  prepareCommand position=" + MousePositionInfo.getPositionString(position));
        }
        Object[] args = new Object[]{mouseInfo, e};
        if (!(position != 2 && position != 13 && position < 16 || mouseInfo.onResizeMark())) {
            Command command = new Command(81, 3, args);
            if (debug > 0) {
                System.out.println(" -S(" + this.idNumber++ + ") SelectionLS.prepareCommand, command=" + command.toString());
            }
            execCommand.exec(command);
            return;
        }
        if (position >= 3 && position <= 10 || position == 14) {
            Command command = new Command(Command.getCommandId("RESIZE"), 3, args);
            if (debug > 0) {
                System.out.println(" -S(" + this.idNumber++ + ") SelectionLS.prepareCommand, command=" + command.toString());
            }
            execCommand.exec(command);
        }
    }

    public void prepareClickedPointCommand(Point2D point) {
        ExecCommand execCommand = ObjectTable.getExecCommand();
        if (execCommand.getCurrentCommandId() < 0) {
            Object[] args = new Object[]{point};
            Command command = new Command(32, 2, args);
            execCommand.exec(command);
        }
    }

    public boolean mouseEventCompleted() {
        return this.clicked;
    }

    public boolean allMouseEventsCompleted() {
        boolean completed = false;
        MousePositionLS mousePositionLS = ObjectTable.getMousePositionLS("SelectionLS");
        if (mousePositionLS.mouseEventCompleted() && this.mouseEventCompleted()) {
            completed = true;
        }
        return completed;
    }

    static {
        debug = 0;
    }
}

