/*
 * Decompiled with CFR 0.152.
 */
package geomExtension;

import geomExtension.Curve2D;
import geomExtension.Vector2D;
import java.awt.geom.Point2D;
import java.text.NumberFormat;

public class CurvePT {
    public double t;
    Point2D p = null;
    Curve2D curve = null;

    public CurvePT(double t, Point2D p) {
        this.t = t;
        this.p = p;
    }

    public CurvePT(double t, Point2D p, Curve2D curve2D) {
        this.t = t;
        this.p = p;
        this.curve = curve2D;
    }

    public double getParameter() {
        return this.t;
    }

    public Point2D getP() {
        if (this.curve != null) {
            this.p = this.curve.getP(this.t);
        }
        return this.p;
    }

    public void setCurve(Curve2D curve2D) {
        this.curve = curve2D;
    }

    public Curve2D getCurve() {
        return this.curve;
    }

    public double getDistanceToCurveEndPT(int index) {
        Point2D p = this.getP();
        Point2D[] PTs = this.curve.getEndPoints();
        double dist = 0.0;
        dist = index == 0 ? Vector2D.dist(p, PTs[0]) : Vector2D.dist(p, PTs[1]);
        return dist;
    }

    public String toString() {
        NumberFormat nf1 = NumberFormat.getNumberInstance();
        nf1.setMaximumIntegerDigits(4);
        nf1.setMinimumFractionDigits(2);
        NumberFormat nf2 = NumberFormat.getNumberInstance();
        nf2.setMaximumIntegerDigits(5);
        nf2.setMinimumFractionDigits(2);
        String str = "";
        str = str + "CurvePoint t=" + nf1.format(this.t) + ", p=" + nf2.format(this.p.getX()) + "," + nf2.format(this.p.getY());
        return str;
    }
}

