/*
 * Decompiled with CFR 0.152.
 */
package geomExtension;

import geomExtension.Curve2D;
import geomExtension.Segment2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import util.Util;

public class Line2DE
extends Curve2D {
    public Line2DE(Segment2D[] segments) {
        super(segments);
    }

    public Line2DE(Point2D p1, Point2D p2) {
        this.generalPath = new GeneralPath(0);
        this.segments = new Segment2D[1];
        Line2D.Double line = new Line2D.Double(p1, p2);
        this.segments[0] = new Segment2D(1, line);
        this.generalPath.append(line, true);
        this.closed = false;
    }

    public Line2DE(double x1, double y1, double x2, double y2) {
        this.generalPath = new GeneralPath(0);
        this.segments = new Segment2D[1];
        Line2D.Double line = new Line2D.Double(new Point2D.Double(x1, y1), new Point2D.Double(x2, y2));
        this.segments[0] = new Segment2D(1, line);
        this.generalPath.append(line, true);
        this.closed = false;
    }

    public void setData(Point2D p1, Point2D p2) {
        this.generalPath = new GeneralPath(0);
        Line2D.Double line = new Line2D.Double(p1, p2);
        this.segments[0] = new Segment2D(1, line);
        this.generalPath.append(line, true);
        this.closed = false;
    }

    public Point2D getP1() {
        return this.segments[0].getP(0.0);
    }

    public Point2D getP2() {
        return this.segments[0].getP(1.0);
    }

    public double getX1() {
        return this.segments[0].getP(0.0).getX();
    }

    public double getY1() {
        return this.segments[0].getP(0.0).getY();
    }

    public double getX2() {
        return this.segments[0].getP(1.0).getX();
    }

    public double getY2() {
        return this.segments[0].getP(1.0).getY();
    }

    @Override
    public int getType2DE() {
        return 51;
    }

    public Line2DE getTrimmedCurve2DE(double t1, double t2) {
        if (t1 == 0.0 && t2 == 0.0) {
            return this;
        }
        Line2DE trimmedLine = this;
        Point2D p1 = this.getP(t1);
        Point2D p2 = this.getP(t2);
        trimmedLine = new Line2DE(p1, p2);
        return trimmedLine;
    }

    public Line2DE getTrimmedLine(double cut1, double cut2) {
        if (cut1 == 0.0 && cut2 == 0.0) {
            return this;
        }
        Line2DE trimmedLine = this;
        double length = this.getCurveLength(0.0, 1.0);
        double t1 = cut1 / length;
        double t2 = 1.0 - cut2 / length;
        trimmedLine = this.getTrimmedCurve2DE(t1, t2);
        return trimmedLine;
    }

    @Override
    public Object clone() {
        return new Line2DE(this.getP1(), this.getP2());
    }

    @Override
    public String toString() {
        String str = "Line x1,y1=" + Util.Pt(this.getP1()) + ", x2,y2=" + Util.Pt(this.getP2());
        return str;
    }
}

