/*
 * Decompiled with CFR 0.152.
 */
package geomExtension;

import geomExtension.Curve2D;
import geomExtension.Segment2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.text.NumberFormat;
import util.Util;

public class RoundRectangle2DE
extends Curve2D {
    public RoundRectangle2DE(Segment2D[] segments) {
        super(segments);
    }

    public RoundRectangle2DE(double x, double y, double width, double height, double arcw, double arch) {
        this.setData(x, y, width, height, arcw, arch);
    }

    public void setData(double x, double y, double width, double height, double arcw, double arch) {
        this.generalPath = new GeneralPath(0);
        this.segments = new Segment2D[8];
        Line2D.Double line0 = new Line2D.Double(x, y + 0.5 * arch, x, y + height - 0.5 * arch);
        Line2D.Double line1 = new Line2D.Double(x + 0.5 * arcw, y + height, x + width - 0.5 * arcw, y + height);
        Line2D.Double line2 = new Line2D.Double(x + width, y + height - 0.5 * arch, x + width, y + 0.5 * arch);
        Line2D.Double line3 = new Line2D.Double(x + width - 0.5 * arcw, y, x + 0.5 * arcw, y);
        Arc2D.Double arc0 = new Arc2D.Double(x, y + height - arch, arcw, arch, 180.0, 90.0, 0);
        Arc2D.Double arc1 = new Arc2D.Double(x + width - arcw, y + height - arch, arcw, arch, 270.0, 90.0, 0);
        Arc2D.Double arc2 = new Arc2D.Double(x + width - arcw, y, arcw, arch, 0.0, 90.0, 0);
        Arc2D.Double arc3 = new Arc2D.Double(x, y, arcw, arch, 90.0, 90.0, 0);
        this.segments[0] = new Segment2D(1, line0);
        this.segments[1] = new Segment2D(2, arc0);
        this.segments[2] = new Segment2D(1, line1);
        this.segments[3] = new Segment2D(2, arc1);
        this.segments[4] = new Segment2D(1, line2);
        this.segments[5] = new Segment2D(2, arc2);
        this.segments[6] = new Segment2D(1, line3);
        this.segments[7] = new Segment2D(2, arc3);
        for (int i = 0; i < this.segments.length; ++i) {
            Shape shape = this.segments[i].getShape();
            this.generalPath.append(shape, true);
        }
        this.generalPath.closePath();
        this.closed = true;
    }

    @Override
    public int getType2DE() {
        return 44;
    }

    public double getX() {
        Arc2D arc = (Arc2D)this.segments[7].getShape();
        return arc.getX();
    }

    public double getY() {
        Arc2D arc = (Arc2D)this.segments[7].getShape();
        return arc.getY();
    }

    public double getWidth() {
        Arc2D arc = (Arc2D)this.segments[7].getShape();
        Line2D lineX = (Line2D)this.segments[2].getShape();
        double width = arc.getWidth() + lineX.getX2() - lineX.getX1();
        return width;
    }

    public double getHeight() {
        Arc2D arc = (Arc2D)this.segments[7].getShape();
        Line2D lineY = (Line2D)this.segments[0].getShape();
        double height = arc.getHeight() + lineY.getY2() - lineY.getY1();
        return height;
    }

    public double getArcWidth() {
        Arc2D arc = (Arc2D)this.segments[7].getShape();
        return arc.getWidth();
    }

    public double getArcHeight() {
        Arc2D arc = (Arc2D)this.segments[7].getShape();
        return arc.getHeight();
    }

    @Override
    public Object clone() {
        double x = this.getX();
        double y = this.getY();
        double w = this.getWidth();
        double h = this.getHeight();
        double arcw = this.getArcWidth();
        double arch = this.getArcHeight();
        return new RoundRectangle2DE(x, y, w, h, arcw, arch);
    }

    @Override
    public String toString() {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumIntegerDigits(4);
        nf.setMinimumFractionDigits(1);
        double x = this.getX();
        double y = this.getY();
        double w = this.getWidth();
        double h = this.getHeight();
        double arcw = this.getArcWidth();
        double arch = this.getArcHeight();
        String str = "";
        str = str + "RoundRectangle x,y=" + Util.Num(x) + "," + Util.Num(y) + ", width,height=" + Util.Num(w) + "," + Util.Num(h) + ", arcw,arch=" + Util.Num(arcw) + "," + Util.Num(arch);
        return str;
    }
}

