/*
 * Decompiled with CFR 0.152.
 */
package geomExtension;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SerializableSegment2D
implements Serializable {
    public int type = 0;
    public Shape shape = null;
    public AffineTransform affineTransform = null;
    public static final String[] versions = new String[]{"ver0.0", "ver0.1"};
    static int debug = 0;

    public SerializableSegment2D() {
    }

    public SerializableSegment2D(int type, Shape shape) {
        this.type = type;
        this.shape = shape;
    }

    public SerializableSegment2D(int type, Shape shape, AffineTransform affineTransform) {
        this.type = type;
        this.shape = shape;
        this.affineTransform = affineTransform;
    }

    public Object clone() {
        SerializableSegment2D seg = new SerializableSegment2D();
        if (this.type == 1) {
            Line2D line = (Line2D)this.shape;
            Line2D newLine = (Line2D)line.clone();
            seg = new SerializableSegment2D(this.type, newLine);
        }
        if (this.type == 2) {
            Arc2D arc = (Arc2D)this.shape;
            Arc2D newArc = (Arc2D)arc.clone();
            seg = this.affineTransform == null ? new SerializableSegment2D(this.type, newArc, null) : new SerializableSegment2D(this.type, newArc, (AffineTransform)this.affineTransform.clone());
        }
        if (this.type == 3) {
            CubicCurve2D curve = (CubicCurve2D)this.shape;
            CubicCurve2D newCurve = (CubicCurve2D)curve.clone();
            seg = new SerializableSegment2D(this.type, newCurve, null);
        }
        return seg;
    }

    public static int writeSerializableSegment2D(ObjectOutputStream out, SerializableSegment2D sSegment2D) throws Exception {
        if (debug > 0) {
            System.out.println(" -- writeSerializableSegment2D sCurve2D=" + sSegment2D.toString());
        }
        int ret = 0;
        try {
            out.writeUTF(versions[1]);
            out.writeInt(sSegment2D.type);
            out.writeObject(sSegment2D.shape);
            out.writeObject(sSegment2D.affineTransform);
        }
        catch (Exception e) {
            System.err.println("*** Error writeSerializableSegment2D version=" + versions[0]);
            e.printStackTrace();
            ret = -1;
        }
        if (debug > 0) {
            System.out.println(" ++ writeSerializableSegment2D ret==" + ret);
        }
        return ret;
    }

    public static SerializableSegment2D readSerializableSegment2D(ObjectInputStream in) throws Exception {
        SerializableSegment2D sSegment2D = new SerializableSegment2D();
        String version = "";
        try {
            version = in.readUTF();
            if (debug > 0) {
                System.out.println(" -- readSerializableShape version=" + version);
            }
            if (version.equals(versions[0])) {
                sSegment2D.type = in.readInt();
                sSegment2D.shape = (Shape)in.readObject();
                sSegment2D.affineTransform = null;
            } else if (version.equals(versions[1])) {
                sSegment2D.type = in.readInt();
                sSegment2D.shape = (Shape)in.readObject();
                sSegment2D.affineTransform = (AffineTransform)in.readObject();
            }
        }
        catch (Exception e) {
            System.err.println("*** Error readSerializableCurve2D version=" + version);
            e.printStackTrace();
        }
        return sSegment2D;
    }
}

