/*
 * Decompiled with CFR 0.152.
 */
package menu;

import DrawTop.Command;
import DrawTop.DrawMain;
import DrawTop.ObjectTable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.border.BevelBorder;
import menu.ButtonOfDebugTestCode;
import menu.DialogOfSystemOut;
import menu.JMenuEx;
import menu.MenuConstants;
import menu.MenuUtil;
import util.ContainerManager;

public class ButtonOfDebug
extends JMenuBar
implements ActionListener {
    JMenu menu;
    String[] menuItemNames = null;
    public static int debug = 0;

    public ButtonOfDebug(String commandName, boolean setText, ImageIcon imageIcon, String tip) {
        this.setLayout(new FlowLayout(3, 0, 0));
        this.setName(commandName);
        this.setOpaque(false);
        this.menu = new JMenuEx();
        this.add(this.menu);
        if (setText) {
            this.menu.setText(commandName);
            this.menu.setHorizontalTextPosition(10);
        }
        if (imageIcon != null) {
            this.menu.setIcon(imageIcon);
        }
        this.menu.setOpaque(false);
        this.menu.setToolTipText(tip);
        this.setStandardButtonStyle();
    }

    public void setStandardButtonStyle() {
        BevelBorder raisedBorder = new BevelBorder(0);
        this.menu.setBorder(raisedBorder);
        this.menu.setFont(MenuConstants.MenuFont);
        this.menu.setIconTextGap(0);
        this.menu.setOpaque(true);
        Color backGround = new Color(14543091);
        this.menu.setBackground(backGround);
        this.menu.setForeground(Color.black);
    }

    @Override
    public boolean isSelected() {
        return this.menu.isSelected();
    }

    public void setSelected(boolean selected) {
        this.menu.setSelected(selected);
    }

    public static ButtonOfDebug createDebugButton(int width) {
        String commandName = Command.getCommandLowerString(190);
        ButtonOfDebug menuButton = new ButtonOfDebug(commandName, true, null, commandName);
        menuButton.setPreferredSize(new Dimension(width, 22));
        JMenu menu = menuButton.menu;
        JMenuItem menuItem = new JMenuItem("System.out dialog");
        menuItem.setName("System.out dialog");
        menuItem.setActionCommand("System.out dialog");
        menuItem.addActionListener(menuButton);
        menu.add(menuItem);
        JMenu printSubMenu = new JMenu("Print");
        printSubMenu.setName("Print");
        JMenuItem printMenuItem1 = new JMenuItem("Print Menu List");
        printMenuItem1.setActionCommand("Print Menu List");
        printMenuItem1.addActionListener(menuButton);
        printSubMenu.add(printMenuItem1);
        JMenuItem printMenuItem2 = new JMenuItem("Print ContainerList");
        printMenuItem2.setActionCommand("Print ContainerList");
        printMenuItem2.addActionListener(menuButton);
        printSubMenu.add(printMenuItem2);
        JMenuItem printMenuItem3 = new JMenuItem("Print ScrollPane");
        printMenuItem3.setActionCommand("Print ScrollPane");
        printMenuItem3.addActionListener(menuButton);
        printSubMenu.add(printMenuItem3);
        menu.add(printSubMenu);
        JMenu shapeSubMenu = new JMenu("Test Shape");
        shapeSubMenu.setName("Test Shape");
        JMenuItem shapeMenuItem1 = new JMenuItem("ShapeContainer.clone");
        shapeMenuItem1.setActionCommand("ShapeContainer.clone");
        shapeMenuItem1.addActionListener(menuButton);
        shapeSubMenu.add(shapeMenuItem1);
        JMenuItem shapeMenuItem2 = new JMenuItem("SerializableElement.clone");
        shapeMenuItem2.setActionCommand("SerializableElement.clone");
        shapeMenuItem2.addActionListener(menuButton);
        shapeSubMenu.add(shapeMenuItem2);
        JMenuItem shapeMenuItem3 = new JMenuItem("DrawFileIo convert, invert");
        shapeMenuItem3.setActionCommand("DrawFileIo convert, invert");
        shapeMenuItem3.addActionListener(menuButton);
        shapeSubMenu.add(shapeMenuItem3);
        menu.add(shapeSubMenu);
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(menuButton);
        if (debug > 0) {
            menuUtil.printMenuComponent(menuButton);
        }
        return menuButton;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DialogOfSystemOut newDialog;
        DialogOfSystemOut dialog;
        MenuUtil menuUtil;
        String menuItem = e.getActionCommand();
        if (debug >= 0) {
            System.out.println("** ButtonOfDebug.actionPerformed menuItem=" + menuItem);
        }
        if (menuItem.compareToIgnoreCase("System.out dialog") == 0) {
            DialogOfSystemOut dialog2 = new DialogOfSystemOut();
            dialog2.showDialog();
            System.out.println("System.out dialog open");
        }
        if (menuItem.compareToIgnoreCase("Print Menu List") == 0) {
            menuUtil = ObjectTable.getMenuUtil();
            dialog = (DialogOfSystemOut)menuUtil.getMenuComponent("DialogOfSystemOut");
            if (dialog == null) {
                newDialog = new DialogOfSystemOut();
                newDialog.showDialog();
            }
            DrawMain frame = ObjectTable.getDrawMain();
            frame.list(System.out, 0);
        }
        if (menuItem.compareToIgnoreCase("Print ContainerList") == 0) {
            menuUtil = ObjectTable.getMenuUtil();
            dialog = (DialogOfSystemOut)menuUtil.getMenuComponent("DialogOfSystemOut");
            if (dialog == null) {
                newDialog = new DialogOfSystemOut();
                newDialog.showDialog();
            }
            ContainerManager manager = ObjectTable.getContainerManager(menuItem);
            manager.printContainers("");
        }
        if (menuItem.compareToIgnoreCase("Print ScrollPane") == 0) {
            menuUtil = ObjectTable.getMenuUtil();
            dialog = (DialogOfSystemOut)menuUtil.getMenuComponent("DialogOfSystemOut");
            if (dialog == null) {
                newDialog = new DialogOfSystemOut();
                newDialog.showDialog();
            }
            ButtonOfDebugTestCode.printScrollPane();
        }
        if (menuItem.compareToIgnoreCase("ShapeContainer.clone") == 0) {
            menuUtil = ObjectTable.getMenuUtil();
            dialog = (DialogOfSystemOut)menuUtil.getMenuComponent("DialogOfSystemOut");
            if (dialog == null) {
                newDialog = new DialogOfSystemOut();
                newDialog.showDialog();
            }
            ButtonOfDebugTestCode.shapeContainerClone();
        }
        if (menuItem.compareToIgnoreCase("SerializableElement.clone") == 0) {
            menuUtil = ObjectTable.getMenuUtil();
            dialog = (DialogOfSystemOut)menuUtil.getMenuComponent("DialogOfSystemOut");
            if (dialog == null) {
                newDialog = new DialogOfSystemOut();
                newDialog.showDialog();
            }
            ButtonOfDebugTestCode.serializableElementClone();
        }
        if (menuItem.compareToIgnoreCase("DrawFileIo convert, invert") == 0) {
            menuUtil = ObjectTable.getMenuUtil();
            dialog = (DialogOfSystemOut)menuUtil.getMenuComponent("DialogOfSystemOut");
            if (dialog == null) {
                newDialog = new DialogOfSystemOut();
                newDialog.showDialog();
            }
            ButtonOfDebugTestCode.DrawFileIoConvertInvert();
        }
        int count = this.menu.getItemCount();
        for (int i = 0; i < count; ++i) {
            this.menu.getItem(i).setSelected(false);
        }
    }
}

