/*
 * Decompiled with CFR 0.152.
 */
package menu;

import DrawTop.Command;
import DrawTop.DrawParameters;
import DrawTop.ObjectTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.border.BevelBorder;
import menu.JMenuEx;
import menu.MenuConstants;
import menu.MenuUtil;
import shapeUtil.GeometricTest;
import util.ContainerManager;

public class ButtonOfTest
extends JMenuBar
implements ActionListener {
    static ButtonOfTest buttonOfTest;
    JMenu menu;
    String[] menuItemNames = null;
    public static int debug;

    public ButtonOfTest(String commandName, boolean setText, ImageIcon imageIcon, String tip) {
        this.setLayout(new FlowLayout(3, 0, 0));
        this.setName(commandName);
        this.setOpaque(false);
        this.menu = new JMenuEx();
        this.add(this.menu);
        if (setText) {
            this.menu.setText(commandName);
            this.menu.setHorizontalTextPosition(10);
        }
        if (imageIcon != null) {
            this.menu.setIcon(imageIcon);
        }
        this.menu.setOpaque(false);
        this.menu.setToolTipText(tip);
        this.setStandardButtonStyle();
    }

    public void setStandardButtonStyle() {
        BevelBorder raisedBorder = new BevelBorder(0);
        this.menu.setBorder(raisedBorder);
        this.menu.setFont(MenuConstants.MenuFont);
        this.menu.setIconTextGap(0);
        this.menu.setOpaque(true);
        Color backGround = new Color(14543091);
        this.menu.setBackground(backGround);
        this.menu.setForeground(Color.black);
    }

    @Override
    public boolean isSelected() {
        return this.menu.isSelected();
    }

    public void setSelected(boolean selected) {
        this.menu.setSelected(selected);
    }

    public static ButtonOfTest createTestButton(int width) {
        String commandName = Command.getCommandLowerString(191);
        buttonOfTest = new ButtonOfTest(commandName, true, null, commandName);
        buttonOfTest.setPreferredSize(new Dimension(width, 22));
        JMenu menu = ButtonOfTest.buttonOfTest.menu;
        JMenuItem menuItem = new JMenuItem("geometric test");
        menuItem.setName("geometric test");
        menuItem.setActionCommand("geometric test");
        menuItem.addActionListener(buttonOfTest);
        menu.add(menuItem);
        menuItem = new JCheckBoxMenuItem("draw bounding box");
        menuItem.setName("draw bounding box");
        menuItem.setActionCommand("draw bounding box");
        menuItem.addActionListener(buttonOfTest);
        menu.add(menuItem);
        menuItem = new JCheckBoxMenuItem("draw characteristic points");
        menuItem.setName("draw characteristic points");
        menuItem.setActionCommand("draw characteristic points");
        menuItem.addActionListener(buttonOfTest);
        menu.add(menuItem);
        menuItem = new JCheckBoxMenuItem("draw textLayout bound");
        menuItem.setName("draw textLayout bound");
        menuItem.setActionCommand("draw textLayout bound");
        menuItem.addActionListener(buttonOfTest);
        menu.add(menuItem);
        menuItem = new JMenuItem("renumber ContainerList");
        menuItem.setName("renumber ContainerList");
        menuItem.setActionCommand("renumber ContainerList");
        menuItem.addActionListener(buttonOfTest);
        menu.add(menuItem);
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(buttonOfTest);
        if (debug > 0) {
            ButtonOfTest.printMenuItems();
        }
        return buttonOfTest;
    }

    static void printMenuItems() {
        JMenu menu = ButtonOfTest.buttonOfTest.menu;
        Component[] components = menu.getMenuComponents();
        String str = "";
        str = "\n** ButtonOfTest size=" + components.length;
        for (int i = 0; i < components.length; ++i) {
            str = str + "\n- component name=" + components[i].getName();
        }
        System.out.println(str);
    }

    static Component getMenuItem(String name) {
        JMenu menu = ButtonOfTest.buttonOfTest.menu;
        Component[] components = menu.getMenuComponents();
        int index = -1;
        for (int i = 0; i < components.length; ++i) {
            if (!components[i].getName().equals(name)) continue;
            index = i;
            break;
        }
        if (index < 0) {
            String str = "*** Error in ButtonOfTest.getMenuItem the name not found, name=" + name;
            System.err.println(str);
            System.out.println(str);
            return null;
        }
        return components[index];
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JCheckBoxMenuItem check;
        String menuItem = e.getActionCommand();
        if (debug > 0) {
            System.out.println("** ButtonOfTest.actionPerformed menuItem=" + menuItem);
        }
        if (menuItem.compareToIgnoreCase("geometric test") == 0) {
            GeometricTest geometricTest = new GeometricTest();
            geometricTest.showDialog();
        }
        if (menuItem.compareToIgnoreCase("draw bounding box") == 0) {
            check = (JCheckBoxMenuItem)ButtonOfTest.getMenuItem("draw bounding box");
            if (debug > 0) {
                System.out.println("** ButtonOfTest.actionPerformed check=" + check.getName() + ", selected=" + check.isSelected());
            }
            DrawParameters.DRAW_BOUNDINGBOX = false;
            if (check.isSelected()) {
                DrawParameters.DRAW_BOUNDINGBOX = true;
            }
        }
        if (menuItem.compareToIgnoreCase("draw characteristic points") == 0) {
            check = (JCheckBoxMenuItem)ButtonOfTest.getMenuItem("draw characteristic points");
            if (debug > 0) {
                System.out.println("** ButtonOfTest.actionPerformed check=" + check.getName() + ", selected=" + check.isSelected());
            }
            DrawParameters.DRAW_CHARACTERISTIC_POINTS = false;
            if (check.isSelected()) {
                DrawParameters.DRAW_CHARACTERISTIC_POINTS = true;
                DrawParameters.DRAW_NODE_POINTS = false;
            }
        }
        if (menuItem.compareToIgnoreCase("draw textLayout bound") == 0) {
            check = (JCheckBoxMenuItem)ButtonOfTest.getMenuItem("draw textLayout bound");
            if (debug > 0) {
                System.out.println("** ButtonOfTest.actionPerformed check=" + check.getName() + ", selected=" + check.isSelected());
            }
            DrawParameters.DRAW_TEXTLAYOUT = false;
            if (check.isSelected()) {
                DrawParameters.DRAW_TEXTLAYOUT = true;
            }
        }
        if (menuItem.compareToIgnoreCase("renumber ContainerList") == 0) {
            ContainerManager manager = ObjectTable.getContainerManager();
            manager.printContainers(" Before Renumbering ContainerList");
            manager.renumberContainerList();
            manager.printContainers(" After Renumbering ContainerList");
        }
        if (menuItem.compareToIgnoreCase("draw unselectable areas") == 0) {
            check = (JCheckBoxMenuItem)ButtonOfTest.getMenuItem("draw unselectable areas");
            if (debug > 0) {
                System.out.println("** ButtonOfTest.actionPerformed check=" + check.getName() + ", selected=" + check.isSelected());
            }
            DrawParameters.DRAW_UNSELECTABLEAREA = false;
            if (check.isSelected()) {
                DrawParameters.DRAW_UNSELECTABLEAREA = true;
            }
        }
        ObjectTable.getDrawPanel().repaint("ExecCommand.test");
    }

    static {
        debug = 0;
    }
}

