/*
 * Decompiled with CFR 0.152.
 */
package menu;

import DrawTop.ObjectTable;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import menu.ComboBoxAction;
import menu.MenuConstants;
import menu.MenuUtil;

public class ComboBox
extends JComboBox {
    ComboBoxAction action = new ComboBoxAction();

    public ComboBox(String commandName, String[] items, String tip) {
        super(items);
        this.setActionCommand(commandName);
        this.addActionListener(this.action);
        this.setName(commandName);
        this.setToolTipText(tip);
    }

    public void activateListener(boolean activate) {
        if (activate && !this.isActionListener(this.action)) {
            this.addActionListener(this.action);
        }
        if (!activate && this.isActionListener(this.action)) {
            this.removeActionListener(this.action);
        }
    }

    private boolean isActionListener(ActionListener listener) {
        ActionListener[] listeners = (ActionListener[])this.getListeners(ActionListener.class);
        boolean isRegistered = false;
        for (int i = 0; i < listeners.length; ++i) {
            if (!listener.equals(listeners[i])) continue;
            isRegistered = true;
        }
        return isRegistered;
    }

    public static JComboBox createFontFamilyComboBox(String name) {
        int debug = 0;
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = env.getAvailableFontFamilyNames();
        fontNames[0] = " ";
        if (debug > 0) {
            String str = "createFontFamilyComboBox  ";
            for (int i = 0; i < fontNames.length; ++i) {
                str = str + fontNames[i] + ", ";
            }
            System.out.println(str);
        }
        ComboBox comboBox = new ComboBox(name, fontNames, "font family");
        comboBox.activateListener(false);
        comboBox.setSelectedItem("Dialog");
        comboBox.setFont(MenuConstants.MenuItemFont);
        comboBox.setPreferredSize(new Dimension(132, 22));
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(comboBox);
        return comboBox;
    }

    public static JComboBox createFontSizeComboBox(String name) {
        String[] fontSizes = new String[]{"", "8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
        ComboBox comboBox = new ComboBox(name, fontSizes, "font size");
        comboBox.activateListener(false);
        comboBox.setSelectedIndex(5);
        comboBox.activateListener(true);
        comboBox.setFont(MenuConstants.MenuItemFont);
        comboBox.setPreferredSize(new Dimension(44, 22));
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        menuUtil.setMenuComponent(comboBox);
        return comboBox;
    }
}

