/*
 * Decompiled with CFR 0.152.
 */
package menu;

import DrawTop.Command;
import DrawTop.DrawPanel;
import DrawTop.DrawParameters;
import DrawTop.ListenerPanel;
import DrawTop.ObjectTable;
import geomExtension.Vector2D;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import menu.ButtonOfPulldownMenu;
import menu.ButtonOfToggle;
import menu.MenuConstants;
import menu.MenuUtil;
import menu.ShapeFormatAction;
import menu.ShapeFormatListener;
import menu.SpinnersChangeListener;
import shape.GroupElement;
import shape.ShapeContainer;
import textBox.AttributedStringUtil;
import textBox.CommittedTextContainer;
import textBox.TextBox;

public class DialogOfShapeFormat
extends JDialog {
    ShapeFormatAction action = null;
    JScrollPane dataScrollPane;
    JScrollPane textScrollPane;
    ShapeContainer shapeContainer;
    JRadioButton pixelButton = null;
    JRadioButton mmButton = null;
    JCheckBox resizeBox = null;
    JCheckBox ratioBox = null;
    JCheckBox directionBox = null;
    JCheckBox connectorBox = null;
    JCheckBox ungroupBox = null;
    public static final String RESIZING = Command.getCommandString(253);
    public static final String ASPECT_RATIO = Command.getCommandString(255);
    public static final String LINE_DIRECTION = Command.getCommandString(256);
    public static final String CONNECTOR_CONNECTIONS = Command.getCommandString(257);
    public static final String UNGROUPING = Command.getCommandString(259);
    Dimension dialogDimension = new Dimension(400, 330);
    Dimension buttonSize = new Dimension(80, 22);
    JSpinner[] positionSpinners = new JSpinner[4];
    SpinnerNumberModel[] positionSpinnerModels = new SpinnerNumberModel[4];
    JSpinner[] centerSpinners = new JSpinner[2];
    SpinnerNumberModel[] centerSpinnerModels = new SpinnerNumberModel[2];
    JSpinner[] sizeSpinners = new JSpinner[2];
    SpinnerNumberModel[] sizeSpinnerModels = new SpinnerNumberModel[2];
    JSpinner[] startSpinners = new JSpinner[2];
    SpinnerNumberModel[] startSpinnerModels = new SpinnerNumberModel[2];
    JSpinner[] endSpinners = new JSpinner[2];
    SpinnerNumberModel[] endSpinnerModels = new SpinnerNumberModel[2];
    JSpinner[] lineSpinners = new JSpinner[2];
    SpinnerNumberModel[] lineSpinnerModels = new SpinnerNumberModel[2];
    JSpinner[] marginSpinners = new JSpinner[4];
    SpinnerNumberModel[] marginSpinnerModels = new SpinnerNumberModel[4];
    JSpinner lineSpaceSpinner = null;
    SpinnerNumberModel lineSpaceSpinnerModel = null;
    SpinnersChangeListener changeListener = new SpinnersChangeListener(this);
    int debug = 0;

    public DialogOfShapeFormat() {
        super(ObjectTable.getDrawMain(), "Shape Format", true);
        this.setName("DialogOfShapeFormat");
        this.action = new ShapeFormatAction(this);
        this.addWindowListener(this.action);
    }

    public void showDialog(ShapeContainer container) {
        this.shapeContainer = container;
        int type = this.shapeContainer.getElement().getTypeE();
        ShapeFormatListener shapeFormatListener = new ShapeFormatListener(this);
        this.addComponentListener(shapeFormatListener);
        double scale = DrawParameters.Scale;
        DrawPanel drawPanel = ObjectTable.getDrawPanel("");
        Window owner = this.getOwner();
        Rectangle2D rect = this.shapeContainer.getBoundingBox();
        int X = (int)Math.max(0.0, (double)owner.getX() + scale * (rect.getX() + rect.getWidth() + 20.0));
        int Y = (int)Math.max(0.0, (double)owner.getY() + scale * rect.getY());
        Point position = SwingUtilities.convertPoint(drawPanel, X, Y, owner);
        this.setLocation(position);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        contentPane.add((Component)tabbedPane, "North");
        JPanel paintStylePanel = this.createPaintStylePanel();
        JPanel positionSizePanel = null;
        boolean lineType = false;
        if (type >= 51 && type <= 53) {
            lineType = true;
        }
        positionSizePanel = lineType ? this.createLinePanel() : this.createRectangularPanel();
        JPanel propertyPanel = this.createPropertyPanel();
        JPanel dataPanel = this.createDataPanel();
        JPanel textBoxPanel = this.createTextBoxPanel();
        JPanel textInfoPanel = this.createTextInfoPanel();
        tabbedPane.add("position, size", positionSizePanel);
        tabbedPane.add("style", paintStylePanel);
        tabbedPane.add("property", propertyPanel);
        tabbedPane.add("data", dataPanel);
        tabbedPane.add("text box", textBoxPanel);
        tabbedPane.add("text", textInfoPanel);
        if (container.getContainerType() == ShapeContainer.GROUP) {
            tabbedPane.setEnabledAt(4, false);
        } else {
            ShapeContainer shapeContainer = container;
            if (shapeContainer.getTextBox() == null) {
                tabbedPane.setEnabledAt(4, false);
                tabbedPane.setEnabledAt(5, false);
            }
        }
        this.setPreferredSize(this.dialogDimension);
        this.pack();
        this.setVisible(true);
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        DialogOfShapeFormat dialog = (DialogOfShapeFormat)menuUtil.getMenuComponent("DialogOfShapeFormat");
        if (dialog != null) {
            dialog.removeDialog();
        }
        menuUtil.setMenuComponent(this);
    }

    protected void removeDialog() {
        this.setVisible(false);
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        Component component = menuUtil.getMenuComponent(this.getName());
        if (component != null) {
            menuUtil.removeMenuComponent(component);
        }
    }

    protected void setScrollViewPosition() {
        this.dataScrollPane.getViewport().setViewPosition(new Point(0, 0));
        if (this.textScrollPane != null) {
            this.textScrollPane.getViewport().setViewPosition(new Point(0, 0));
        }
    }

    private JPanel createRectangularPanel() {
        int i;
        int i2;
        int i3;
        int type = this.shapeContainer.getElement().getTypeE();
        boolean lineType = false;
        if (type >= 51 && type <= 53) {
            lineType = true;
        }
        if (lineType) {
            System.err.println("*** Error DialogOfShapeFormat.createRectangularPanel: The selected shape isn't a rectangular");
            return null;
        }
        JPanel basePanel = new JPanel();
        JPanel unitPanel = new JPanel();
        unitPanel.setPreferredSize(new Dimension(100, 44));
        TitledBorder titleBorder = BorderFactory.createTitledBorder("unit of length");
        GridLayout unitPanelLayout = new GridLayout(1, 2);
        unitPanelLayout.setHgap(20);
        unitPanelLayout.setVgap(5);
        unitPanel.setLayout(unitPanelLayout);
        unitPanel.setBorder(titleBorder);
        ButtonGroup group = new ButtonGroup();
        this.pixelButton = new JRadioButton("pixel");
        this.mmButton = new JRadioButton("mm");
        group.add(this.mmButton);
        group.add(this.pixelButton);
        this.pixelButton.setActionCommand("pixel");
        this.mmButton.setActionCommand("mm");
        this.pixelButton.addActionListener(this.action);
        this.mmButton.addActionListener(this.action);
        unitPanel.add(this.mmButton);
        unitPanel.add(this.pixelButton);
        this.mmButton.setSelected(true);
        Dimension panelSize = new Dimension(120, 20);
        JPanel positionPanel = new JPanel();
        titleBorder = BorderFactory.createTitledBorder("position");
        titleBorder.setTitleColor(Color.BLACK);
        titleBorder.setTitleFont(MenuConstants.MenuFont);
        positionPanel.setBorder(titleBorder);
        GridLayout positionPanelLayout = new GridLayout(2, 2);
        positionPanelLayout.setHgap(20);
        positionPanelLayout.setVgap(5);
        positionPanel.setLayout(positionPanelLayout);
        JPanel[] xyPanels = new JPanel[4];
        String[] positionLabel = new String[]{"x-min: ", "x-max: ", "y-min: ", "y-max: "};
        for (i3 = 0; i3 < 4; ++i3) {
            xyPanels[i3] = new JPanel();
            xyPanels[i3].setLayout(new BoxLayout(xyPanels[i3], 0));
            JLabel label = new JLabel(positionLabel[i3]);
            xyPanels[i3].add(label);
            this.positionSpinnerModels[i3] = new SpinnerNumberModel(0.0, 0.0, 1000.0, 1.0);
            this.positionSpinners[i3] = new JSpinner(this.positionSpinnerModels[i3]);
            this.positionSpinners[i3].setName(positionLabel[i3]);
            xyPanels[i3].add(this.positionSpinners[i3]);
            xyPanels[i3].setPreferredSize(panelSize);
            positionPanel.add(xyPanels[i3]);
        }
        for (i3 = 0; i3 < 4; ++i3) {
            this.positionSpinners[i3].addChangeListener(this.changeListener);
        }
        JPanel centerPanel = new JPanel();
        titleBorder = BorderFactory.createTitledBorder("center point");
        titleBorder.setTitleColor(Color.BLACK);
        titleBorder.setTitleFont(MenuConstants.MenuFont);
        centerPanel.setBorder(titleBorder);
        GridLayout centerPanelLayout = new GridLayout(1, 2);
        centerPanelLayout.setHgap(20);
        centerPanelLayout.setVgap(5);
        centerPanel.setLayout(centerPanelLayout);
        JPanel[] centerPanels = new JPanel[2];
        String[] centerLabel = new String[]{" x: ", " y: "};
        for (i2 = 0; i2 < 2; ++i2) {
            centerPanels[i2] = new JPanel();
            centerPanels[i2].setLayout(new BoxLayout(centerPanels[i2], 0));
            JLabel label = new JLabel(centerLabel[i2]);
            centerPanels[i2].add(label);
            this.centerSpinnerModels[i2] = new SpinnerNumberModel(0.0, 0.0, 1000.0, 1.0);
            this.centerSpinners[i2] = new JSpinner(this.centerSpinnerModels[i2]);
            this.centerSpinners[i2].setName(centerLabel[i2]);
            centerPanels[i2].add(this.centerSpinners[i2]);
            centerPanels[i2].setPreferredSize(panelSize);
            centerPanel.add(centerPanels[i2]);
        }
        for (i2 = 0; i2 < 2; ++i2) {
            this.centerSpinners[i2].addChangeListener(this.changeListener);
        }
        JPanel sizePanel = new JPanel();
        titleBorder = BorderFactory.createTitledBorder("size");
        titleBorder.setTitleColor(Color.BLACK);
        titleBorder.setTitleFont(MenuConstants.MenuFont);
        sizePanel.setBorder(titleBorder);
        GridLayout sizePanelLayout = new GridLayout(1, 2);
        sizePanelLayout.setHgap(20);
        sizePanelLayout.setVgap(5);
        sizePanel.setLayout(sizePanelLayout);
        JPanel[] sizePanels = new JPanel[2];
        String[] sizeLabel = new String[]{"width: ", "height: "};
        for (i = 0; i < 2; ++i) {
            sizePanels[i] = new JPanel();
            sizePanels[i].setLayout(new BoxLayout(sizePanels[i], 0));
            JLabel label = new JLabel(sizeLabel[i]);
            sizePanels[i].add(label);
            this.sizeSpinnerModels[i] = new SpinnerNumberModel(0.0, 0.0, 1000.0, 1.0);
            this.sizeSpinners[i] = new JSpinner(this.sizeSpinnerModels[i]);
            this.sizeSpinners[i].setName(sizeLabel[i]);
            sizePanels[i].add(this.sizeSpinners[i]);
            sizePanels[i].setPreferredSize(panelSize);
            sizePanel.add(sizePanels[i]);
        }
        for (i = 0; i < 2; ++i) {
            this.sizeSpinners[i].addChangeListener(this.changeListener);
        }
        int unitType = 0;
        if (this.mmButton.isSelected()) {
            unitType = 1;
        }
        this.showRectangular(unitType);
        Box box = Box.createVerticalBox();
        basePanel.add(box);
        box.add(Box.createVerticalStrut(5));
        box.add(unitPanel);
        box.add(Box.createVerticalStrut(5));
        box.add(positionPanel);
        box.add(Box.createVerticalStrut(5));
        box.add(centerPanel);
        box.add(Box.createVerticalStrut(5));
        box.add(sizePanel);
        return basePanel;
    }

    protected void showRectangular(int unitType) {
        Rectangle2D boundingBox = this.shapeContainer.getBoundingBox();
        double mm = 0.26458333333333334;
        double unit = 1.0;
        if (unitType != 0) {
            unit = mm;
        }
        double x = boundingBox.getX() * unit;
        double y = boundingBox.getY() * unit;
        double w = boundingBox.getWidth() * unit;
        double h = boundingBox.getHeight() * unit;
        this.changeListener.removeChangeListener();
        this.positionSpinners[0].setValue(x);
        this.positionSpinners[1].setValue(x + w);
        this.positionSpinners[2].setValue(y);
        this.positionSpinners[3].setValue(y + h);
        this.centerSpinners[0].setValue(x + w / 2.0);
        this.centerSpinners[1].setValue(y + h / 2.0);
        this.sizeSpinners[0].setValue(w);
        this.sizeSpinners[1].setValue(h);
        boolean resizing = this.shapeContainer.getBooleanProperty(RESIZING, "DialogOfShapeFormat");
        boolean connector = this.shapeContainer.getBooleanProperty(CONNECTOR_CONNECTIONS, "DialogOfShapeFormat");
        boolean aspect_ratio = this.shapeContainer.getBooleanProperty(ASPECT_RATIO, "DialogOfShapeFormat");
        boolean line_dir = this.shapeContainer.getBooleanProperty(LINE_DIRECTION, "DialogOfShapeFormat");
        if (!resizing) {
            this.sizeSpinners[0].setEnabled(false);
            this.sizeSpinners[1].setEnabled(false);
        }
        this.changeListener.addChangeListener();
    }

    private JPanel createLinePanel() {
        int i;
        int i2;
        int i3;
        int type = this.shapeContainer.getElement().getTypeE();
        boolean lineType = false;
        if (type >= 51 && type <= 53) {
            lineType = true;
        }
        if (!lineType) {
            System.err.println("*** Error DialogOfShapeFormat.createLinePanel: The selected shape isn't a line");
            return null;
        }
        JPanel basePanel = new JPanel();
        JPanel unitPanel = new JPanel();
        unitPanel.setPreferredSize(new Dimension(100, 44));
        TitledBorder titleBorder = BorderFactory.createTitledBorder("unit of length");
        GridLayout unitPanelLayout = new GridLayout(1, 2);
        unitPanelLayout.setHgap(20);
        unitPanelLayout.setVgap(5);
        unitPanel.setLayout(unitPanelLayout);
        unitPanel.setBorder(titleBorder);
        ButtonGroup group = new ButtonGroup();
        this.pixelButton = new JRadioButton("pixel");
        this.mmButton = new JRadioButton("mm");
        group.add(this.mmButton);
        group.add(this.pixelButton);
        this.pixelButton.setActionCommand("pixel");
        this.mmButton.setActionCommand("mm");
        this.pixelButton.addActionListener(this.action);
        this.mmButton.addActionListener(this.action);
        unitPanel.add(this.mmButton);
        unitPanel.add(this.pixelButton);
        this.mmButton.setSelected(true);
        Dimension panelSize = new Dimension(120, 20);
        JPanel startPanel = new JPanel();
        titleBorder = BorderFactory.createTitledBorder("start point");
        titleBorder.setTitleColor(Color.BLACK);
        titleBorder.setTitleFont(MenuConstants.MenuFont);
        startPanel.setBorder(titleBorder);
        GridLayout startPanelLayout = new GridLayout(1, 2);
        startPanelLayout.setHgap(20);
        startPanelLayout.setVgap(5);
        startPanel.setLayout(startPanelLayout);
        JPanel[] startPanels = new JPanel[2];
        String[] xyLabel = new String[]{" x: ", " y: "};
        for (i3 = 0; i3 < 2; ++i3) {
            startPanels[i3] = new JPanel();
            startPanels[i3].setLayout(new BoxLayout(startPanels[i3], 0));
            JLabel label = new JLabel(xyLabel[i3]);
            startPanels[i3].add(label);
            this.startSpinnerModels[i3] = new SpinnerNumberModel(0.0, 0.0, 1000.0, 1.0);
            this.startSpinners[i3] = new JSpinner(this.startSpinnerModels[i3]);
            this.startSpinners[i3].setName("start" + xyLabel[i3]);
            startPanels[i3].add(this.startSpinners[i3]);
            startPanels[i3].setPreferredSize(panelSize);
            startPanel.add(startPanels[i3]);
        }
        for (i3 = 0; i3 < 2; ++i3) {
            this.startSpinners[i3].addChangeListener(this.changeListener);
        }
        JPanel endPanel = new JPanel();
        titleBorder = BorderFactory.createTitledBorder("end point");
        titleBorder.setTitleColor(Color.BLACK);
        titleBorder.setTitleFont(MenuConstants.MenuFont);
        endPanel.setBorder(titleBorder);
        GridLayout endPanelLayout = new GridLayout(1, 2);
        endPanelLayout.setHgap(20);
        endPanelLayout.setVgap(5);
        endPanel.setLayout(endPanelLayout);
        JPanel[] endPanels = new JPanel[2];
        for (i2 = 0; i2 < 2; ++i2) {
            endPanels[i2] = new JPanel();
            endPanels[i2].setLayout(new BoxLayout(endPanels[i2], 0));
            JLabel label = new JLabel(xyLabel[i2]);
            endPanels[i2].add(label);
            this.endSpinnerModels[i2] = new SpinnerNumberModel(0.0, 0.0, 1000.0, 1.0);
            this.endSpinners[i2] = new JSpinner(this.endSpinnerModels[i2]);
            this.endSpinners[i2].setName("end" + xyLabel[i2]);
            endPanels[i2].add(this.endSpinners[i2]);
            endPanels[i2].setPreferredSize(panelSize);
            endPanel.add(endPanels[i2]);
        }
        for (i2 = 0; i2 < 2; ++i2) {
            this.endSpinners[i2].addChangeListener(this.changeListener);
        }
        JPanel linePanel = new JPanel();
        titleBorder = BorderFactory.createTitledBorder("line (angle: angle to x-axis in degrees)");
        titleBorder.setTitleColor(Color.BLACK);
        titleBorder.setTitleFont(MenuConstants.MenuFont);
        linePanel.setBorder(titleBorder);
        GridLayout linePanelLayout = new GridLayout(1, 2);
        linePanelLayout.setHgap(20);
        linePanelLayout.setVgap(5);
        linePanel.setLayout(linePanelLayout);
        JPanel[] linePanels = new JPanel[2];
        String[] lineLabel = new String[]{"angle: ", "length: "};
        this.lineSpinnerModels[0] = new SpinnerNumberModel(0.0, -180.0, 180.0, 1.0);
        this.lineSpinnerModels[1] = new SpinnerNumberModel(1.0, 1.0, 1000.0, 1.0);
        for (i = 0; i < 2; ++i) {
            linePanels[i] = new JPanel();
            linePanels[i].setLayout(new BoxLayout(linePanels[i], 0));
            JLabel label = new JLabel(lineLabel[i]);
            linePanels[i].add(label);
            this.lineSpinners[i] = new JSpinner(this.lineSpinnerModels[i]);
            this.lineSpinners[i].setName(lineLabel[i]);
            linePanels[i].add(this.lineSpinners[i]);
            linePanels[i].setPreferredSize(panelSize);
            linePanel.add(linePanels[i]);
        }
        for (i = 0; i < 2; ++i) {
            this.lineSpinners[i].addChangeListener(this.changeListener);
        }
        int unitType = 0;
        if (this.mmButton.isSelected()) {
            unitType = 1;
        }
        this.showLine(unitType);
        Box box = Box.createVerticalBox();
        basePanel.add(box);
        box.add(Box.createVerticalStrut(5));
        box.add(unitPanel);
        box.add(Box.createVerticalStrut(5));
        box.add(startPanel);
        box.add(Box.createVerticalStrut(5));
        box.add(endPanel);
        box.add(Box.createVerticalStrut(5));
        box.add(linePanel);
        return basePanel;
    }

    protected void showLine(int unitOfLength) {
        Point2D[] Pt = this.shapeContainer.getElement().getEndPTs();
        Vector2D vec = Vector2D.sub(Pt[1], Pt[0]);
        double mm = 0.26458333333333334;
        double unit = 1.0;
        if (unitOfLength != 0) {
            unit = mm;
        }
        this.changeListener.removeChangeListener();
        double startX = Pt[0].getX() * unit;
        double startY = Pt[0].getY() * unit;
        double endX = Pt[1].getX() * unit;
        double endY = Pt[1].getY() * unit;
        this.startSpinners[0].setValue(startX);
        this.startSpinners[1].setValue(startY);
        this.endSpinners[0].setValue(endX);
        this.endSpinners[1].setValue(endY);
        double angle = Math.atan2(-vec.getY(), vec.getX()) * 180.0 / Math.PI;
        double len = Math.sqrt(vec.getX() * vec.getX() + vec.getY() * vec.getY()) * unit;
        this.lineSpinners[0].setValue(angle);
        this.lineSpinners[1].setValue(len);
        boolean resizing = this.shapeContainer.getBooleanProperty(RESIZING, "DialogOfShapeFormat");
        boolean line_dir = this.shapeContainer.getBooleanProperty(LINE_DIRECTION, "DialogOfShapeFormat");
        if (line_dir) {
            this.lineSpinners[0].setEnabled(false);
        }
        if (!resizing) {
            this.lineSpinners[0].setEnabled(false);
            this.lineSpinners[1].setEnabled(false);
        }
        this.changeListener.addChangeListener();
    }

    private JPanel createPaintStylePanel() {
        JPanel basePanel = new JPanel();
        JPanel colorPanel = new JPanel();
        TitledBorder titleBorder = BorderFactory.createTitledBorder("Color");
        titleBorder.setTitleColor(Color.BLACK);
        titleBorder.setTitleFont(MenuConstants.MenuFont);
        colorPanel.setBorder(titleBorder);
        Box box = Box.createHorizontalBox();
        colorPanel.add(box);
        ButtonOfPulldownMenu fillColorButton = ButtonOfPulldownMenu.createFillColorChooserButton(false);
        ButtonOfPulldownMenu lineColorButton = ButtonOfPulldownMenu.createLineColorChooserButton(false);
        fillColorButton.setPreferredSize(new Dimension(64, 22));
        lineColorButton.setPreferredSize(new Dimension(64, 22));
        box.add(Box.createHorizontalStrut(5));
        box.add(fillColorButton);
        box.add(Box.createHorizontalStrut(30));
        box.add(lineColorButton);
        box.add(Box.createHorizontalStrut(5));
        JPanel lineStylePanel = new JPanel();
        titleBorder = BorderFactory.createTitledBorder("Line Format");
        titleBorder.setTitleColor(Color.BLACK);
        titleBorder.setTitleFont(MenuConstants.MenuFont);
        lineStylePanel.setBorder(titleBorder);
        box = Box.createHorizontalBox();
        lineStylePanel.add(box);
        ButtonOfPulldownMenu lineStyleButton = ButtonOfPulldownMenu.createLineWidthButton(false);
        ButtonOfPulldownMenu dashedStyleButton = ButtonOfPulldownMenu.createLineStrokeButton(false);
        ButtonOfPulldownMenu arrowStyleButton = ButtonOfPulldownMenu.createArrowStyleButton(false);
        lineStyleButton.setPreferredSize(new Dimension(64, 22));
        dashedStyleButton.setPreferredSize(new Dimension(76, 22));
        arrowStyleButton.setPreferredSize(new Dimension(76, 22));
        box.add(Box.createHorizontalStrut(5));
        box.add(lineStyleButton);
        box.add(Box.createHorizontalStrut(20));
        box.add(dashedStyleButton);
        box.add(Box.createHorizontalStrut(20));
        box.add(arrowStyleButton);
        box.add(Box.createHorizontalStrut(5));
        box = Box.createVerticalBox();
        basePanel.add(box);
        box.add(Box.createVerticalStrut(5));
        box.add(colorPanel);
        box.add(Box.createVerticalStrut(5));
        box.add(lineStylePanel);
        box.add(Box.createVerticalStrut(5));
        ShapeContainer[] shapeContainers = null;
        if (this.shapeContainer.getContainerType() == ShapeContainer.SHAPE) {
            shapeContainers = new ShapeContainer[]{this.shapeContainer};
        } else {
            ShapeContainer shapeContainer = this.shapeContainer;
            GroupElement groupElement = (GroupElement)shapeContainer.getElement();
            shapeContainers = groupElement.getGroupedSingleShapeContainers();
        }
        return basePanel;
    }

    private JPanel createPropertyPanel() {
        JPanel basePanel = new JPanel();
        Dimension panelSize = new Dimension(360, 52);
        JPanel resizePanel = new JPanel();
        resizePanel.setPreferredSize(panelSize);
        TitledBorder titleBorder = BorderFactory.createTitledBorder("resize");
        titleBorder.setTitleColor(Color.BLACK);
        titleBorder.setTitleFont(MenuConstants.MenuFont);
        resizePanel.setBorder(titleBorder);
        FlowLayout resizePanelLayout = new FlowLayout(3, 0, 0);
        resizePanel.setLayout(resizePanelLayout);
        this.resizeBox = new JCheckBox("enable resizing");
        this.resizeBox.addActionListener(this.action);
        this.resizeBox.addChangeListener(this.action);
        this.resizeBox.setActionCommand(RESIZING);
        this.ratioBox = new JCheckBox("keep aspect ratio");
        this.ratioBox.addActionListener(this.action);
        this.ratioBox.addChangeListener(this.action);
        this.ratioBox.setActionCommand(ASPECT_RATIO);
        resizePanel.add(this.resizeBox);
        resizePanel.add(this.ratioBox);
        JPanel linePanel = new JPanel();
        linePanel.setPreferredSize(panelSize);
        titleBorder = BorderFactory.createTitledBorder("line");
        titleBorder.setTitleColor(Color.BLACK);
        titleBorder.setTitleFont(MenuConstants.MenuFont);
        linePanel.setBorder(titleBorder);
        FlowLayout linePanelLayout = new FlowLayout(3, 0, 0);
        linePanel.setLayout(linePanelLayout);
        this.directionBox = new JCheckBox("keep line direction");
        this.directionBox.addActionListener(this.action);
        this.directionBox.setActionCommand(LINE_DIRECTION);
        linePanel.add(this.directionBox);
        JPanel connectorPanel = new JPanel();
        connectorPanel.setPreferredSize(panelSize);
        titleBorder = BorderFactory.createTitledBorder("connector");
        titleBorder.setTitleColor(Color.BLACK);
        titleBorder.setTitleFont(MenuConstants.MenuFont);
        connectorPanel.setBorder(titleBorder);
        FlowLayout connectorPanelLayout = new FlowLayout(3, 0, 0);
        connectorPanel.setLayout(connectorPanelLayout);
        this.connectorBox = new JCheckBox("keep connector connections");
        this.connectorBox.addActionListener(this.action);
        this.connectorBox.setActionCommand(CONNECTOR_CONNECTIONS);
        connectorPanel.add(this.connectorBox);
        JPanel groupPanel = new JPanel();
        groupPanel.setPreferredSize(panelSize);
        titleBorder = BorderFactory.createTitledBorder("group, ungroup");
        titleBorder.setTitleColor(Color.BLACK);
        titleBorder.setTitleFont(MenuConstants.MenuFont);
        groupPanel.setBorder(titleBorder);
        FlowLayout groupPanelLayout = new FlowLayout(3, 0, 0);
        groupPanel.setLayout(groupPanelLayout);
        this.ungroupBox = new JCheckBox("enable ungrouping");
        this.ungroupBox.addActionListener(this.action);
        this.ungroupBox.setActionCommand(UNGROUPING);
        groupPanel.add(this.ungroupBox);
        JPanel okPanel = new JPanel();
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        okButton.setPreferredSize(this.buttonSize);
        cancelButton.setPreferredSize(this.buttonSize);
        okButton.setActionCommand("OK Property");
        cancelButton.setActionCommand("Cancel Property");
        okButton.addActionListener(this.action);
        cancelButton.addActionListener(this.action);
        okPanel.add(okButton);
        okPanel.add(cancelButton);
        Box vbox = Box.createVerticalBox();
        basePanel.add(vbox);
        vbox.add(resizePanel);
        vbox.add(Box.createVerticalStrut(5));
        vbox.add(linePanel);
        vbox.add(Box.createVerticalStrut(5));
        vbox.add(connectorPanel);
        vbox.add(Box.createVerticalStrut(5));
        vbox.add(groupPanel);
        vbox.add(Box.createVerticalStrut(5));
        vbox.add(okPanel);
        vbox.add(Box.createVerticalStrut(5));
        this.showProperty();
        return basePanel;
    }

    protected void showProperty() {
        boolean selected = this.shapeContainer.getBooleanProperty(RESIZING, "DialogOfShapeFormat");
        this.getResizeBox().setSelected(selected);
        if (!selected) {
            this.getRatioBox().setSelected(false);
            this.getDirectionBox().setSelected(false);
            this.getRatioBox().setEnabled(false);
            this.getDirectionBox().setEnabled(false);
        }
        selected = this.shapeContainer.getBooleanProperty(ASPECT_RATIO, "DialogOfShapeFormat");
        this.getRatioBox().setSelected(selected);
        selected = this.shapeContainer.getBooleanProperty(LINE_DIRECTION, "DialogOfShapeFormat");
        this.getDirectionBox().setSelected(selected);
        selected = this.shapeContainer.getBooleanProperty(CONNECTOR_CONNECTIONS, "DialogOfShapeFormat");
        this.getConnectorBox().setSelected(selected);
        selected = this.shapeContainer.getBooleanProperty(UNGROUPING, "DialogOfShapeFormat");
        this.getUngroupBox().setSelected(selected);
        int type = this.shapeContainer.getElement().getTypeE();
        if (type != 51) {
            this.getDirectionBox().setEnabled(false);
        }
        if (type == 51) {
            this.getRatioBox().setEnabled(false);
        }
        if (this.shapeContainer.getContainerType() == ShapeContainer.SHAPE) {
            this.getUngroupBox().setEnabled(false);
        }
    }

    private JPanel createDataPanel() {
        JPanel basePanel = new JPanel();
        JPanel infoPanel = new JPanel();
        TitledBorder titleBorder = BorderFactory.createTitledBorder("Information");
        titleBorder.setTitleColor(Color.BLACK);
        titleBorder.setTitleFont(MenuConstants.MenuFont);
        infoPanel.setBorder(titleBorder);
        GridLayout inforMationPanelLayout = new GridLayout(1, 2);
        inforMationPanelLayout.setHgap(5);
        inforMationPanelLayout.setVgap(5);
        infoPanel.setLayout(inforMationPanelLayout);
        JTextArea textPane = new JTextArea();
        String str = this.shapeContainer.toString();
        if (this.shapeContainer.getContainerType() == ShapeContainer.SHAPE) {
            str = str + "\n - Path :\n" + this.shapeContainer.toPathString();
        }
        if (this.shapeContainer.getContainerType() == ShapeContainer.GROUP) {
            ShapeContainer[] containers = this.shapeContainer.getGroupedContainers();
            for (int i = 1; i < containers.length; ++i) {
                str = str + "\n - Element[" + (i - 1) + "] : " + containers[i].toShortString();
                str = str + "\n - Path[" + (i - 1) + "] :\n" + containers[i].toPathString();
            }
        }
        textPane.setText(str);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(32);
        scrollPane.setVerticalScrollBarPolicy(22);
        this.dataScrollPane = scrollPane;
        JViewport viewport = new JViewport();
        scrollPane.setViewport(viewport);
        viewport.setView(textPane);
        viewport.setViewPosition(new Point(0, 0));
        infoPanel.add(scrollPane);
        Box box = Box.createVerticalBox();
        basePanel.add(box);
        box.add(Box.createVerticalStrut(5));
        box.add(infoPanel);
        return basePanel;
    }

    private JPanel createTextBoxPanel() {
        JPanel basePanel = new JPanel();
        if (this.shapeContainer.getContainerType() == ShapeContainer.GROUP) {
            return basePanel;
        }
        if (this.shapeContainer.getTextBox() == null) {
            return basePanel;
        }
        JPanel alignPanel = new JPanel();
        TitledBorder titleBorder = BorderFactory.createTitledBorder("Text Align");
        titleBorder.setTitleColor(Color.BLACK);
        titleBorder.setTitleFont(MenuConstants.MenuFont);
        alignPanel.setBorder(titleBorder);
        GridLayout alignPanelLayout = new GridLayout(1, 2);
        alignPanelLayout.setHgap(30);
        alignPanelLayout.setVgap(5);
        alignPanel.setLayout(alignPanelLayout);
        ButtonOfToggle button = ButtonOfToggle.createButton("text_align_left", false, "text_align_left32T.png", "text_align_left");
        alignPanel.add(button);
        button = ButtonOfToggle.createButton("text_align_center", false, "text_align_center32T.png", "text_align_center");
        alignPanel.add(button);
        button = ButtonOfToggle.createButton("text_align_right", false, "text_align_right32T.png", "text_align_right");
        alignPanel.add(button);
        JPanel marginPanel = new JPanel();
        titleBorder = BorderFactory.createTitledBorder("Internal margin (pixels)");
        titleBorder.setTitleColor(Color.BLACK);
        titleBorder.setTitleFont(MenuConstants.MenuFont);
        marginPanel.setBorder(titleBorder);
        GridLayout marginPanelLayout = new GridLayout(2, 2);
        marginPanelLayout.setHgap(20);
        marginPanelLayout.setVgap(5);
        marginPanel.setLayout(marginPanelLayout);
        JPanel[] marginPanels = new JPanel[4];
        String[] positionLabel = new String[]{"left   : ", "top       : ", "right : ", "bottom: "};
        for (int i = 0; i < 4; ++i) {
            marginPanels[i] = new JPanel();
            marginPanels[i].setLayout(new BoxLayout(marginPanels[i], 0));
            JLabel label = new JLabel(positionLabel[i]);
            marginPanels[i].add(label);
            this.marginSpinnerModels[i] = new SpinnerNumberModel(0.0, 0.0, 10.0, 0.1);
            this.marginSpinners[i] = new JSpinner(this.marginSpinnerModels[i]);
            marginPanels[i].add(this.marginSpinners[i]);
            marginPanel.add(marginPanels[i]);
        }
        double top = 0.0;
        double left = 0.0;
        double right = 0.0;
        double bottom = 0.0;
        if (this.shapeContainer.getTextBox() != null) {
            Insets insets = this.shapeContainer.getTextBox().getTextBoxInsets();
            top = insets.top;
            left = insets.left;
            right = insets.right;
            bottom = insets.bottom;
        }
        this.marginSpinnerModels[0].setValue(left);
        this.marginSpinnerModels[1].setValue(top);
        this.marginSpinnerModels[2].setValue(right);
        this.marginSpinnerModels[3].setValue(bottom);
        JPanel lineSpacePanel = new JPanel();
        titleBorder = BorderFactory.createTitledBorder("Text line space (pixels)");
        titleBorder.setTitleColor(Color.BLACK);
        titleBorder.setTitleFont(MenuConstants.MenuFont);
        lineSpacePanel.setBorder(titleBorder);
        this.lineSpaceSpinnerModel = new SpinnerNumberModel(0.0, 0.0, 10.0, 0.1);
        this.lineSpaceSpinner = new JSpinner(this.lineSpaceSpinnerModel);
        lineSpacePanel.add(this.lineSpaceSpinner);
        double lineSpace = 0.0;
        if (this.shapeContainer.getTextBox() != null) {
            lineSpace = this.shapeContainer.getTextBox().getTextLineSpace();
            this.lineSpaceSpinnerModel.setValue(lineSpace);
        }
        JPanel okPanel = new JPanel();
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        okButton.setActionCommand("OK TextBox");
        cancelButton.setActionCommand("Cancel TextBox");
        okButton.addActionListener(this.action);
        cancelButton.addActionListener(this.action);
        okPanel.add(okButton);
        okPanel.add(cancelButton);
        Box box = Box.createVerticalBox();
        basePanel.add(box);
        box.add(Box.createVerticalStrut(5));
        box.add(alignPanel);
        box.add(Box.createVerticalStrut(5));
        box.add(marginPanel);
        box.add(Box.createVerticalStrut(5));
        box.add(lineSpacePanel);
        box.add(Box.createVerticalStrut(5));
        box.add(okPanel);
        box.add(Box.createVerticalStrut(5));
        return basePanel;
    }

    private JPanel createTextInfoPanel() {
        JPanel basePanel = new JPanel();
        JPanel infoPanel = new JPanel();
        TitledBorder titleBorder = BorderFactory.createTitledBorder("Text information");
        titleBorder.setTitleColor(Color.BLACK);
        titleBorder.setTitleFont(MenuConstants.MenuFont);
        infoPanel.setBorder(titleBorder);
        GridLayout inforMationPanelLayout = new GridLayout(1, 2);
        inforMationPanelLayout.setHgap(5);
        inforMationPanelLayout.setVgap(5);
        infoPanel.setLayout(inforMationPanelLayout);
        if (this.shapeContainer.getContainerType() == ShapeContainer.GROUP) {
            return basePanel;
        }
        ShapeContainer shapeContainer = this.shapeContainer;
        TextBox textBox = shapeContainer.getTextBox();
        if (textBox == null) {
            return basePanel;
        }
        CommittedTextContainer textContainer = textBox.getCommittedTextContainer();
        AttributedStringUtil attribUtil = new AttributedStringUtil(textContainer.getCommittedText());
        String str = "";
        str = str + attribUtil.toString();
        int caretPosition = textBox.getTextIndex();
        str = str + "\n\n-- caret position=" + caretPosition;
        if (textBox.hasSelectedText()) {
            int start = textBox.getSelectedTextStart();
            int end = textBox.getSelectedTextEnd();
            str = str + ",  selected text start, end=" + start + "," + end;
        } else {
            str = str + ",  selected text is non";
        }
        ListenerPanel listenerPanel = ObjectTable.getListenerPanel("");
        str = str + "\n\n-- Mouse Listener Info\n  " + listenerPanel.getMouseListenersInfo();
        JTextPane textPane = new JTextPane();
        textPane.setText(str);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(32);
        scrollPane.setVerticalScrollBarPolicy(22);
        JViewport viewport = new JViewport();
        scrollPane.setViewport(viewport);
        this.textScrollPane = scrollPane;
        viewport.setView(textPane);
        viewport.setViewPosition(new Point(0, 0));
        infoPanel.add(scrollPane);
        Box box = Box.createVerticalBox();
        basePanel.add(box);
        box.add(Box.createVerticalStrut(5));
        box.add(infoPanel);
        box.add(Box.createVerticalStrut(5));
        return basePanel;
    }

    public ShapeContainer getShapeContainer() {
        return this.shapeContainer;
    }

    public JScrollPane getDataScrollPane() {
        return this.dataScrollPane;
    }

    public JScrollPane getTextScrollPane() {
        return this.textScrollPane;
    }

    public JSpinner[] getPositionSpinners() {
        return this.positionSpinners;
    }

    public SpinnerNumberModel[] getPositionSpinnerModels() {
        return this.positionSpinnerModels;
    }

    public JSpinner[] getSizeSpinners() {
        return this.sizeSpinners;
    }

    public SpinnerNumberModel[] getSizeSpinnerModels() {
        return this.sizeSpinnerModels;
    }

    public JSpinner[] getCenterSpinners() {
        return this.centerSpinners;
    }

    public SpinnerNumberModel[] getCenterSpinnerModels() {
        return this.centerSpinnerModels;
    }

    public JSpinner[] getStartSpinners() {
        return this.startSpinners;
    }

    public SpinnerNumberModel[] getStartSpinnerModels() {
        return this.startSpinnerModels;
    }

    public JSpinner[] getEndSpinners() {
        return this.endSpinners;
    }

    public SpinnerNumberModel[] getEndSpinnerModels() {
        return this.endSpinnerModels;
    }

    public JSpinner[] getLineSpinners() {
        return this.lineSpinners;
    }

    public SpinnerNumberModel[] getLineSpinnerModels() {
        return this.lineSpinnerModels;
    }

    public JSpinner[] getMarginSpinners() {
        return this.marginSpinners;
    }

    public SpinnerNumberModel[] getMarginSpinnerModels() {
        return this.marginSpinnerModels;
    }

    public JSpinner getLineSpaceSpinner() {
        return this.lineSpaceSpinner;
    }

    public SpinnerNumberModel getLineSpaceSpinnerModels() {
        return this.lineSpaceSpinnerModel;
    }

    public JCheckBox getResizeBox() {
        return this.resizeBox;
    }

    public JCheckBox getRatioBox() {
        return this.ratioBox;
    }

    public JCheckBox getDirectionBox() {
        return this.directionBox;
    }

    public JCheckBox getConnectorBox() {
        return this.connectorBox;
    }

    public JCheckBox getUngroupBox() {
        return this.ungroupBox;
    }
}

