/*
 * Decompiled with CFR 0.152.
 */
package menu;

import DrawTop.Command;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JToggleButton;

public class MenuUtil {
    ArrayList MenuComponentList = new ArrayList();
    public static int debug = 0;

    public void setMenuComponent(Component component) {
        this.MenuComponentList.add(component);
    }

    public void removeMenuComponent(Component component) {
        boolean removed = this.MenuComponentList.remove(component);
        if (debug > 0) {
            System.out.println("** MenuUtil.removeMenuComponent removed=" + removed);
        }
    }

    public Component getMenuComponent(String name) {
        Component[] components = this.getMenuComponents(name);
        if (components == null || components.length == 0) {
            if (debug > 0) {
                System.err.println("*** Error MenuUtil.getMenuComponent,  DrawMenu not found,  name=" + name);
            }
            return null;
        }
        if (components.length >= 2 && debug > 0) {
            System.err.println("*** Warning MenuUtil.getMenuComponent,  Multiple DrawMenus found,  name=" + name);
        }
        return components[0];
    }

    public Component[] getMenuComponents(String name) {
        int i;
        Vector<Component> vector = new Vector<Component>();
        int size = this.MenuComponentList.size();
        Component component = null;
        for (int i2 = 0; i2 < size; ++i2) {
            component = (Component)this.MenuComponentList.get(i2);
            String componentName = component.getName();
            if (!Command.compareStrings(name, componentName)) continue;
            vector.add(component);
        }
        Component[] components = new Component[vector.size()];
        for (i = 0; i < vector.size(); ++i) {
            components[i] = (Component)vector.get(i);
        }
        if (component == null) {
            System.err.println("*** Error MenuUtil.getMenuComponent  name=" + name);
        }
        if (debug > 1) {
            System.out.println("- MenuUtil.getMenuComponents name=" + name + ", count=" + vector.size());
            for (i = 0; i < vector.size(); ++i) {
                System.out.println("   -- components[" + i + "]=" + components[i]);
            }
        }
        return components;
    }

    public Component getChildComponent(Container parent, String name, String simpleClassName) {
        Component[] components = this.getChildComponents(parent, name, simpleClassName);
        int size = components.length;
        if (size == 0) {
            return null;
        }
        if (size >= 2) {
            System.err.println("*** Warning MenuUtil getChildComponent  Multiple children found,  target name=" + name + ", simpleClassName=" + simpleClassName);
        }
        if (debug > 0) {
            System.out.println("*** MenuUtil getChildComponent  target found,  target name=" + name + ", simpleClassName=" + simpleClassName + "\n   component=" + components[0]);
        }
        return components[0];
    }

    private Component[] getChildComponents(Container parent, String name, String simpleClassName) {
        Vector vector = new Vector();
        Vector out = new Vector();
        this.getComponents(parent, vector);
        int size = vector.size();
        for (int i = 0; i < size; ++i) {
            Object child = vector.get(i);
            String childName = ((Component)child).getName();
            String className = child.getClass().getSimpleName();
            if (!name.equals(childName) || !simpleClassName.equals(className)) continue;
            out.add(child);
        }
        size = out.size();
        Component[] components = new Component[size];
        for (int i = 0; i < size; ++i) {
            components[i] = (Component)out.get(i);
        }
        return components;
    }

    private void getComponents(Container container, Vector vector) {
        String simpleName = container.getClass().getSimpleName();
        Component[] children = container.getComponents();
        if (simpleName.equals("JMenu")) {
            JMenu jMenu = (JMenu)container;
            children = jMenu.getMenuComponents();
        }
        if (children == null || children.length == 0) {
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            vector.add(children[i]);
            this.getComponents((Container)children[i], vector);
        }
    }

    public void resetSelectedMenuComponents() {
        int size = this.MenuComponentList.size();
        for (int i = 0; i < size; ++i) {
            JToggleButton button;
            String className;
            Component component = (Component)this.MenuComponentList.get(i);
            String componentName = component.getName();
            if (Command.getCommandId(componentName) >= 131 && Command.getCommandId(componentName) <= 138 || !(className = component.getClass().getSimpleName()).equals("ButtonOfToggle") || !(button = (JToggleButton)component).isSelected()) continue;
            button.setSelected(false);
        }
    }

    public void printMenuComponent(Container parent) {
        String str = "";
        Vector vector = new Vector();
        this.getComponents(parent, vector);
        int size = vector.size();
        str = "printDrawMenu parent name=" + parent.getName() + ", class name=" + parent.getClass().getSimpleName();
        if (size == 0) {
            str = str + "  no children";
        } else {
            for (int i = 0; i < size; ++i) {
                JComponent child = (JComponent)vector.get(i);
                String className = child.getClass().getSimpleName();
                str = str + "\n    children[" + i + "]  Name=" + child.getName() + ", class name=" + className;
            }
        }
        System.out.println(str);
    }

    public void printMenuComponentList() {
        String str = "";
        int size = this.MenuComponentList.size();
        for (int i = 0; i < size; ++i) {
            JComponent menu = (JComponent)this.MenuComponentList.get(i);
            String className = menu.getClass().getSimpleName();
            str = str + "\n    menu[" + i + "]  Name=" + menu.getName() + ", class name=" + className;
        }
        System.out.println(str);
    }
}

