/*
 * Decompiled with CFR 0.152.
 */
package menu;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import menu.ColorSelectionEvent;
import menu.ColorSelectionListener;
import menu.CustomColorChooserDialog;

class PreviewPanel
extends JComponent
implements ChangeListener,
ColorSelectionListener,
MouseListener {
    Color selectedColor = Color.WHITE;
    CustomColorChooserDialog dialog;
    protected Dimension panelSize = new Dimension(200, 60);
    protected Dimension margin = new Dimension(10, 5);
    protected String[][] messages = new String[][]{{"Command : Fill color", "NULL colored or multi-colored"}, {"Command : Line color", "NULL colored or multi-colored"}, {"Command : Font color", "No text, NULL colored or multi-colored"}};
    int debug = 0;

    public PreviewPanel(CustomColorChooserDialog dialog) {
        dialog.getColorChooser().getSelectionModel().addChangeListener(this);
        dialog.getImportedColorsPanel().addColorSelectionListener(this);
        int width = (int)((double)this.panelSize.width + 2.0 * this.margin.getWidth());
        int height = (int)((double)this.panelSize.height + 2.0 * this.margin.getHeight());
        this.setPreferredSize(new Dimension(width, height));
        this.setOpaque(true);
        this.dialog = dialog;
        this.setToolTipText("");
        this.addMouseListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.selectedColor = this.dialog.getColorChooser().getColor();
        if (this.debug > 0) {
            System.out.println("** JColorChooser.SelectionModel->PreviewPanel stateChanged  currentColor=" + this.selectedColor + ", selectedColor=" + this.selectedColor);
        }
        this.repaint();
    }

    @Override
    public void colorSelected(ColorSelectionEvent event) {
        this.selectedColor = event.getColor();
        if (this.debug > 0) {
            System.out.println("** ImportedColorsPanel->PreviewPanel colorSelected current=" + this.selectedColor + ", selectedColor=" + this.selectedColor);
        }
        this.repaint();
    }

    protected Color getSelectedColor() {
        return this.selectedColor;
    }

    protected void setSelectedColor(Color color) {
        this.selectedColor = color;
        this.repaint();
        if (this.debug > 0) {
            System.out.println("PreviewPanel.setSelectedColor  currentColor=" + this.selectedColor + ", selectedColor=" + this.selectedColor);
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Color color = this.selectedColor;
        String str = "";
        str = color == null ? "Null color" : "RGB: " + this.selectedColor.getRed() + ", " + this.selectedColor.getGreen() + ", " + this.selectedColor.getBlue();
        return str;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.white);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.translate(this.margin.getWidth(), this.margin.getHeight());
        int width = this.panelSize.width;
        Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, 30.0f, 30.0f);
        Color paintColor = this.selectedColor;
        if (this.selectedColor == null) {
            paintColor = Color.white;
        }
        Color shadow = Color.GRAY;
        double shadowX = 1.0;
        double shadowY = 1.0;
        g2.translate(shadowX, shadowY);
        g2.setColor(shadow);
        g2.fill(rect);
        g2.translate(-shadowX, -shadowY);
        g2.setColor(paintColor);
        g2.fill(rect);
        g2.translate(width / 3, 0);
        BasicStroke stroke = new BasicStroke(2.0f);
        g2.setStroke(stroke);
        g2.translate(shadowX, shadowY);
        g2.setColor(shadow);
        g2.draw(rect);
        g2.translate(-shadowX, -shadowY);
        g2.setColor(paintColor);
        g2.draw(rect);
        g2.translate(width / 3, 0);
        Font font = new Font("Java", 0, 14);
        g2.setFont(font);
        g2.translate(shadowX, shadowY);
        g2.setColor(shadow);
        g2.drawString("Java", 0, 14);
        g2.translate(-shadowX, -shadowY);
        g2.setColor(paintColor);
        g2.drawString("Java", 0, 14);
        font = new Font("Java", 3, 14);
        g2.setFont(font);
        g2.translate(shadowX, shadowY);
        g2.setColor(shadow);
        g2.drawString("Java", 0, 30);
        g2.translate(-shadowX, -shadowY);
        g2.setColor(paintColor);
        g2.drawString("Java", 0, 30);
        String[] names = new String[]{"fill color", "line color", "font color"};
        String commandName = this.dialog.getCommandName();
        int id = 0;
        for (int i = 0; i < names.length; ++i) {
            if (!commandName.equals(names[i])) continue;
            id = i;
            break;
        }
        String str1 = this.messages[id][0];
        String str2 = this.messages[id][1];
        if (this.selectedColor != null) {
            str2 = "(RGB : " + this.selectedColor.getRed() + ", " + this.selectedColor.getGreen() + ", " + this.selectedColor.getBlue() + ")";
        }
        g2.translate((double)(-width) * 2.0 / 3.0 - this.margin.getWidth() + 3.0, 50.0);
        g2.setColor(Color.DARK_GRAY);
        font = new Font("", 1, 12);
        g2.setFont(font);
        g2.drawString(str1, 0, 0);
        g2.setFont(font);
        g2.drawString(str2, 0, 12);
    }
}

