/*
 * Decompiled with CFR 0.152.
 */
package shape;

import geomExtension.SerializableCurve2D;
import java.awt.Color;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import shape.ShapeContainer;
import textBox.SerializableAttributedString;

public class SerializableElement
implements Serializable {
    public int containerType;
    public int containerIndex = -1;
    public String parent = "";
    public String shapeId = "";
    public Date date = null;
    public String fileNameAndPage = "";
    public boolean connectorTargetPermission = true;
    public boolean connectorPermission = true;
    public HashMap<String, Object> property = new HashMap();
    public String elementType = "";
    public SerializableCurve2D serializableCurve2D = new SerializableCurve2D();
    public Color fillColor = null;
    public Color lineColor = null;
    public float lineWidth = 0.5f;
    public String dashedStyle = "";
    public float[] dash = null;
    public int arrowStyle = 1;
    public int startArrowType = 0;
    public int endArrowType = 0;
    public Rectangle2D textArea = null;
    public SerializableAttributedString attributedString = null;
    public Insets textBoxInsets = new Insets(0, 0, 0, 0);
    public int textAlign = 0;
    public int lineSpace = 0;
    public byte[] imageByteData;
    public ArrayList childrenList = new ArrayList();
    int debug = 0;

    public SerializableElement[] getGroupedElements() {
        Vector<SerializableElement> vector = new Vector<SerializableElement>();
        vector.add(this);
        this.getGroupedElementsE(vector);
        int length = 0;
        if (vector.size() > 0) {
            length = vector.size();
        }
        SerializableElement[] elements = new SerializableElement[length];
        for (int i = 0; i < length; ++i) {
            elements[i] = (SerializableElement)vector.get(i);
        }
        return elements;
    }

    private void getGroupedElementsE(Vector vector) {
        int size = 0;
        if (this.childrenList != null) {
            size = this.childrenList.size();
        }
        for (int i = 0; i < size; ++i) {
            String ObjectName = this.childrenList.get(i).getClass().getSimpleName();
            String shapeId = "";
            if (ObjectName.equals("String")) {
                shapeId = (String)this.childrenList.get(i);
            } else {
                SerializableElement element = (SerializableElement)this.childrenList.get(i);
                shapeId = element.shapeId;
                int type = element.containerType;
                vector.add(element);
                if (this.debug > 0) {
                    System.out.println("** SerializableElement getGroupedElements(Vector vector) add element[" + i + "]=" + shapeId);
                }
                if (type == ShapeContainer.GROUP) {
                    element.getGroupedElementsE(vector);
                }
            }
            if (this.debug <= 0) continue;
            System.out.println(" - child=" + shapeId);
        }
    }

    public int getGroupTreeDepth(String shapeId) {
        Vector<Object> vector = new Vector<Object>();
        Integer treeDepth = new Integer(0);
        Integer findDepth = new Integer(-1);
        vector.add(shapeId);
        vector.add(treeDepth);
        vector.add(findDepth);
        if (this.shapeId.equals(shapeId)) {
            findDepth = new Integer(0);
            return 0;
        }
        if (this.containerType == ShapeContainer.GROUP) {
            this.getGroupTreeDepthE(vector);
        }
        findDepth = (Integer)vector.get(2);
        return findDepth;
    }

    private void getGroupTreeDepthE(Vector vector) {
        Integer treeDepth = (Integer)vector.get(1);
        treeDepth = treeDepth + 1;
        if (this.debug > 0) {
            System.out.println("   ** getGroupTreeDepth treeDepth=" + treeDepth + ", search shapeId=" + (String)vector.get(0) + ", target shapeId=" + this.shapeId);
        }
        vector.set(1, treeDepth);
        ArrayList childrenList = this.childrenList;
        int size = 0;
        if (this.childrenList != null) {
            size = this.childrenList.size();
        }
        for (int i = 0; i < size; ++i) {
            SerializableElement childElement = (SerializableElement)this.childrenList.get(i);
            int type = childElement.containerType;
            String shapeId = (String)vector.get(0);
            if (childElement.shapeId.equals(shapeId)) {
                vector.set(2, new Integer(treeDepth));
                return;
            }
            if (type != ShapeContainer.GROUP) continue;
            childElement.getGroupTreeDepthE(vector);
        }
        treeDepth = (Integer)vector.get(1);
        treeDepth = treeDepth - 1;
        vector.set(1, treeDepth);
    }

    public Object clone() {
        SerializableElement newElement;
        block9: {
            newElement = new SerializableElement();
            newElement.containerType = this.containerType;
            newElement.containerIndex = this.containerIndex;
            newElement.parent = new String(this.parent);
            newElement.shapeId = new String(this.shapeId);
            newElement.date = (Date)this.date.clone();
            newElement.fileNameAndPage = new String(this.fileNameAndPage);
            newElement.connectorTargetPermission = this.connectorTargetPermission;
            newElement.connectorPermission = this.connectorPermission;
            newElement.property = this.cloneHashMap(this.property);
            newElement.elementType = new String(this.elementType);
            newElement.serializableCurve2D = (SerializableCurve2D)this.serializableCurve2D.clone();
            if (this.fillColor != null) {
                newElement.fillColor = new Color(this.fillColor.getRed(), this.fillColor.getGreen(), this.fillColor.getBlue(), this.fillColor.getAlpha());
            }
            if (this.lineColor != null) {
                newElement.lineColor = new Color(this.lineColor.getRed(), this.lineColor.getGreen(), this.lineColor.getBlue(), this.lineColor.getAlpha());
            }
            newElement.lineWidth = this.lineWidth;
            newElement.dashedStyle = "";
            if (this.dashedStyle != null || this.dashedStyle.equals("")) {
                newElement.dashedStyle = new String(this.dashedStyle);
            }
            newElement.dash = this.dash;
            newElement.arrowStyle = this.arrowStyle;
            newElement.startArrowType = this.startArrowType;
            newElement.endArrowType = this.endArrowType;
            newElement.textArea = null;
            if (this.textArea != null) {
                newElement.textArea = new Rectangle2D.Double(this.textArea.getX(), this.textArea.getY(), this.textArea.getWidth(), this.textArea.getHeight());
            }
            newElement.attributedString = null;
            if (this.attributedString != null) {
                newElement.attributedString = (SerializableAttributedString)this.attributedString.clone();
            }
            newElement.textBoxInsets = (Insets)this.textBoxInsets.clone();
            newElement.textAlign = this.textAlign;
            newElement.lineSpace = this.lineSpace;
            newElement.imageByteData = this.imageByteData;
            newElement.childrenList = new ArrayList();
            if (this.childrenList.size() <= 0) break block9;
            String className = this.childrenList.get(0).getClass().getSimpleName();
            if (className.equals("String")) {
                for (int i = 0; i < this.childrenList.size(); ++i) {
                    String newShapeId = new String((String)this.childrenList.get(i));
                    newElement.childrenList.add(newShapeId);
                }
            } else {
                for (int i = 0; i < this.childrenList.size(); ++i) {
                    SerializableElement sElement = (SerializableElement)this.childrenList.get(i);
                    SerializableElement cloneElement = (SerializableElement)sElement.clone();
                    newElement.childrenList.add(cloneElement);
                }
            }
        }
        return newElement;
    }

    private HashMap<String, Object> cloneHashMap(HashMap<String, Object> hashMap) {
        HashMap<String, Object> newHashMap = new HashMap<String, Object>();
        Set<String> set = hashMap.keySet();
        Vector<String> list = new Vector<String>(set);
        for (int i = 0; i < list.size(); ++i) {
            String key = list.get(i);
            if (key.equals("")) continue;
            String object = hashMap.get(key).toString();
            String name = object.getClass().getSimpleName();
            if (this.debug > 0) {
                System.out.println("cloneHashMap key=" + key + ", object=" + object + ", object name=" + name);
            }
            if (!name.equals("String")) continue;
            String str = object;
            String newStr = new String(str);
            newHashMap.put(key, newStr);
        }
        return newHashMap;
    }

    public String toString() {
        String str = "";
        str = str + this.toStringE(0, "");
        if (this.containerType == ShapeContainer.GROUP) {
            SerializableElement[] childElements = this.getGroupedElements();
            for (int i = 1; i < childElements.length; ++i) {
                int treeDepth = this.getGroupTreeDepth(childElements[i].shapeId);
                String space = "";
                for (int j = 0; j < treeDepth; ++j) {
                    space = space + "    ";
                }
                if (this.debug > 0) {
                    System.out.println(" debug childElements[" + i + "].toVeryShortString: " + childElements[i].shapeId + ", treeDepth=" + treeDepth);
                }
                str = str + "\n" + childElements[i].toStringE(treeDepth, "- child: ");
            }
        }
        return str;
    }

    private String toStringE(int indent, String header) {
        String str = "";
        String space = "";
        for (int j = 0; j < indent; ++j) {
            space = space + "    ";
        }
        if (this.containerType == ShapeContainer.SHAPE) {
            String parentSTr = "null";
            if (!this.parent.equals("")) {
                parentSTr = this.parent;
            }
            str = str + space + header + this.shapeId + ", containertype=SHAPE, index=" + this.containerIndex + ", parent=" + parentSTr;
            String attrStr = null;
            if (this.attributedString != null) {
                attrStr = this.attributedString.getString();
            }
            if (attrStr == null || attrStr.equals("")) {
                str = str + ", Text=null";
            } else if (this.textArea != null) {
                str = str + "\n" + space + "    Text=" + this.attributedString.getString();
            }
            String fillColorStr = "null";
            String lineColorStr = "null";
            if (this.fillColor != null) {
                fillColorStr = this.fillColor.toString();
            }
            if (this.lineColor != null) {
                lineColorStr = this.lineColor.toString();
            }
            str = str + "\n" + space + "   fillColor=" + fillColorStr + ", lineColor=" + lineColorStr;
            str = str + "\n" + space + "   lineWidth=" + this.lineWidth + ", dashedStyle=" + this.dashedStyle;
            String dashStr = "null";
            if (this.dash != null && this.dash.length > 0) {
                dashStr = "";
                for (int i = 0; i < this.dash.length; ++i) {
                    dashStr = String.valueOf(this.dash[i]) + ", ";
                }
            }
            str = str + ", dash=" + dashStr;
            str = str + ", startArrowType=" + this.startArrowType + ", endArrowType=" + this.endArrowType;
        }
        if (this.containerType == ShapeContainer.GROUP) {
            int size = this.childrenList.size();
            String parentSTr = "null";
            if (!this.parent.equals("")) {
                parentSTr = this.parent;
            }
            String ObjectName = this.childrenList.get(0).getClass().getSimpleName();
            str = str + space + header + this.shapeId + ", containertype=Group, index=" + this.containerIndex + ", parent=" + parentSTr + ", children type=" + ObjectName;
            for (int i = 0; i < size; ++i) {
                if (!ObjectName.startsWith("String")) continue;
                String childId = (String)this.childrenList.get(i);
                str = str + "\n" + space + "    - children[" + i + "]=" + childId;
            }
        }
        return str;
    }

    public String toShortString() {
        String str = "";
        str = str + this.toShortStringE(0, "");
        if (this.containerType == ShapeContainer.GROUP) {
            SerializableElement[] childElements = this.getGroupedElements();
            for (int i = 1; i < childElements.length; ++i) {
                int treeDepth = this.getGroupTreeDepth(childElements[i].shapeId);
                String space = "";
                for (int j = 0; j < treeDepth; ++j) {
                    space = space + "    ";
                }
                if (this.debug > 0) {
                    System.out.println(" debug childElements[" + i + "].toVeryShortString: " + childElements[i].shapeId + ", treeDepth=" + treeDepth);
                }
                str = str + "\n" + childElements[i].toShortStringE(treeDepth, "- child: ");
            }
        }
        return str;
    }

    private String toShortStringE(int indent, String header) {
        String str = "";
        String space = "";
        for (int j = 0; j < indent; ++j) {
            space = space + "    ";
        }
        if (this.containerType == ShapeContainer.SHAPE) {
            str = str + space + header + this.shapeId + ", containertype=SHAPE, index=" + this.containerIndex;
            if (!this.parent.equals("")) {
                str = str + ", parent=" + this.parent;
            }
            String attrStr = null;
            if (this.attributedString != null) {
                attrStr = this.attributedString.getString();
            }
            if (attrStr == null || attrStr.equals("")) {
                str = str + ", Text=null";
            } else if (this.textArea != null) {
                str = str + "\n" + space + "    Text=" + this.attributedString.getString();
            }
        }
        if (this.containerType == ShapeContainer.GROUP) {
            int size = this.childrenList.size();
            str = str + space + header + this.shapeId + ", containertype=Group, index=" + this.containerIndex;
            if (!this.parent.equals("")) {
                str = str + ", parent=" + this.parent;
            }
            String ObjectName = this.childrenList.get(0).getClass().getSimpleName();
            str = str + ", children type=" + ObjectName;
            for (int i = 0; i < size; ++i) {
                if (!ObjectName.startsWith("String")) continue;
                String childId = (String)this.childrenList.get(i);
                str = str + "\n" + space + "    - children[" + i + "]=" + childId;
            }
        }
        return str;
    }

    public String toVeryShortString() {
        String str = "";
        str = str + this.toVeryShortStringE(0, "");
        if (this.containerType == ShapeContainer.GROUP) {
            SerializableElement[] childElements = this.getGroupedElements();
            for (int i = 1; i < childElements.length; ++i) {
                int treeDepth = this.getGroupTreeDepth(childElements[i].shapeId);
                String space = "";
                for (int j = 0; j < treeDepth; ++j) {
                    space = space + "    ";
                }
                if (this.debug > 0) {
                    System.out.println(" debug childElements[" + i + "].toVeryShortString: " + childElements[i].shapeId + ", treeDepth=" + treeDepth);
                }
                str = str + "\n" + childElements[i].toVeryShortStringE(treeDepth, "- child: ");
            }
        }
        return str;
    }

    private String toVeryShortStringE(int indent, String header) {
        String str = "";
        String space = "";
        for (int j = 0; j < indent; ++j) {
            space = space + "    ";
        }
        if (this.containerType == ShapeContainer.SHAPE) {
            str = str + space + header + this.shapeId;
            String parentSTr = "null";
            if (!this.parent.equals("")) {
                str = str + ", parent=" + this.parent;
            }
        }
        if (this.containerType == ShapeContainer.GROUP) {
            int size = 0;
            if (this.childrenList != null) {
                size = this.childrenList.size();
            }
            str = str + space + header + this.shapeId;
            if (!this.parent.equals("")) {
                str = str + ", parent=" + this.parent;
            }
            String ObjectName = this.childrenList.get(0).getClass().getSimpleName();
            str = str + ", children type=" + ObjectName;
            for (int i = 0; i < size; ++i) {
                if (!ObjectName.startsWith("String")) continue;
                String childId = (String)this.childrenList.get(i);
                str = str + "\n" + space + "    - children[" + i + "]=" + childId;
            }
        }
        return str;
    }
}

