/*
 * Decompiled with CFR 0.152.
 */
package shape;

import DrawTop.Command;
import DrawTop.ObjectTable;
import geomExtension.SerializableCurve2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import shape.CubicCurveElement;
import shape.EllipseElement;
import shape.GeneralCurveElement;
import shape.GroupElement;
import shape.ImageElement;
import shape.LineElement;
import shape.PaintStyle;
import shape.PolylineElement;
import shape.RectangleElement;
import shape.RoundRectangleElement;
import shape.SerializableElement;
import shape.ShapeContainer;
import shape.ShapeElement;
import textBox.CommittedTextContainer;
import textBox.TextBox;
import util.Edit;
import util.FileIo;

public class SerializableElementUtil
implements Serializable {
    public static final String[] versions = new String[]{"ver0.0", "ver1.0"};
    static int debug = 0;

    public static SerializableElement convertShapeContainer(ShapeContainer container) {
        SerializableElement sElement = null;
        sElement = container.getContainerType() == ShapeContainer.SHAPE ? SerializableElementUtil.convertSingleContainer(container) : SerializableElementUtil.convertGroupContainer(container);
        return sElement;
    }

    public static SerializableElement convertSingleContainer(ShapeContainer container) {
        SerializableElement sElement = new SerializableElement();
        sElement.containerType = ShapeContainer.SHAPE;
        sElement.containerIndex = container.getContainerIndex();
        ShapeContainer parent = container.getParent();
        sElement.parent = "";
        if (parent != null) {
            sElement.parent = parent.getShapeId();
        }
        sElement.shapeId = container.getShapeId();
        sElement.date = Calendar.getInstance().getTime();
        sElement.fileNameAndPage = ObjectTable.getFileIo().getCurrentFileName() + ":" + ObjectTable.getFileIo().getCurrentPage();
        sElement.connectorTargetPermission = container.connectorTargetPermission;
        sElement.connectorPermission = container.connectorPermission;
        sElement.property = container.property;
        ShapeElement shapeElement = container.getElement();
        int tye = shapeElement.getTypeE();
        sElement.elementType = Command.getCommandString(tye);
        sElement.serializableCurve2D = shapeElement.getSerializableCurve2D();
        sElement.fillColor = container.getPaintStyle().fillColor;
        sElement.lineColor = container.getPaintStyle().lineColor;
        sElement.lineWidth = container.getPaintStyle().lineWidth;
        sElement.dashedStyle = container.getPaintStyle().dashedStyle;
        sElement.dash = container.getPaintStyle().dash;
        sElement.arrowStyle = container.getPaintStyle().arrowStyle;
        sElement.startArrowType = container.getPaintStyle().startArrowType;
        sElement.endArrowType = container.getPaintStyle().endArrowType;
        if (container.isTextBox()) {
            TextBox textBox = container.getTextBox();
            sElement.textArea = (Rectangle2D)textBox.textArea.clone();
            CommittedTextContainer committedTextContainer = textBox.getCommittedTextContainer();
            sElement.attributedString = committedTextContainer.getSerializableAttributedString();
            sElement.textBoxInsets = (Insets)textBox.textBoxInsets.clone();
            sElement.textAlign = textBox.textAlign;
            sElement.lineSpace = textBox.lineSpace;
        }
        if (sElement.elementType.equalsIgnoreCase("IMAGE")) {
            ImageElement imageElement = (ImageElement)shapeElement;
            sElement.imageByteData = imageElement.getByteImage();
        }
        return sElement;
    }

    private static SerializableElement convertGroupContainer(ShapeContainer container) {
        SerializableElement sElement = new SerializableElement();
        GroupElement groupElement = (GroupElement)container.getElement();
        sElement.containerType = ShapeContainer.GROUP;
        sElement.containerIndex = container.getContainerIndex();
        ShapeContainer parent = container.getParent();
        sElement.parent = "";
        if (parent != null) {
            sElement.parent = parent.getShapeId();
        }
        int tye = groupElement.getTypeE();
        sElement.elementType = Command.getCommandString(tye);
        sElement.shapeId = container.getShapeId();
        sElement.date = Calendar.getInstance().getTime();
        sElement.fileNameAndPage = ObjectTable.getFileIo().getCurrentFileName() + ":" + ObjectTable.getFileIo().getCurrentPage();
        sElement.connectorTargetPermission = container.connectorTargetPermission;
        sElement.connectorPermission = container.connectorPermission;
        sElement.property = container.property;
        ShapeContainer[] children = groupElement.getChildren();
        sElement.childrenList.clear();
        for (int i = 0; i < children.length; ++i) {
            ShapeContainer child = children[i];
            SerializableElement sChild = SerializableElementUtil.convertShapeContainer(child);
            sElement.childrenList.add(sChild);
            if (debug <= 0) continue;
            System.out.println(" convertGroupContainer add to childrenList sChild[" + i + "]=" + sChild.shapeId + ", Parent=" + container.getShapeId());
        }
        return sElement;
    }

    public static ShapeContainer invertShapeContainer(SerializableElement sElement) {
        ShapeContainer container = null;
        if (sElement.containerType == ShapeContainer.SHAPE) {
            container = SerializableElementUtil.invertSingleContainer(sElement);
            if (container != null) {
                container.setSelected(false);
            }
        } else {
            container = SerializableElementUtil.invertGroupContainer(sElement);
            container.setSelected(false);
        }
        if (debug > 0) {
            System.out.println("\n** SerializableElementUtil invertShapeContainer **\n- SerializableElementUtil" + sElement.toShortString() + "\n- ShapeContainer" + container.toShortString());
        }
        return container;
    }

    public static ShapeContainer invertSingleContainer(SerializableElement sElement) {
        ShapeContainer container = new ShapeContainer();
        container.setContainerIndex(sElement.containerIndex);
        ShapeElement shapeElement = null;
        String shapeId = sElement.shapeId;
        int id = container.getElementType(shapeId);
        int type = Command.getCommandId(sElement.elementType);
        if (type < 0) {
            System.err.println("*** Error invertSingleContainerSimply: id=" + type + ", elementType=" + sElement.elementType);
            type = id;
        }
        switch (type) {
            case 43: {
                shapeElement = new RectangleElement();
                break;
            }
            case 44: {
                shapeElement = new RoundRectangleElement();
                break;
            }
            case 45: {
                shapeElement = new EllipseElement();
                break;
            }
            case 51: {
                shapeElement = new LineElement();
                break;
            }
            case 54: {
                shapeElement = new PolylineElement();
                break;
            }
            case 55: {
                shapeElement = new CubicCurveElement();
                break;
            }
            case 56: {
                shapeElement = new GeneralCurveElement();
                break;
            }
            case 46: {
                shapeElement = new ImageElement();
                ImageElement imageElement = (ImageElement)shapeElement;
                imageElement.setByteImage(sElement.imageByteData);
                break;
            }
        }
        container.setShapeId(sElement.shapeId);
        container.setElement(shapeElement);
        shapeElement.setShapeContainer(container);
        container.setConnectorTargetPermission(sElement.connectorTargetPermission);
        container.setConnectorPermission(sElement.connectorPermission);
        container.property = sElement.property;
        container.property.put("type", shapeElement.getShapeIdString());
        shapeElement.setSerializableCurve2D((SerializableCurve2D)sElement.serializableCurve2D.clone());
        PaintStyle paintStyle = container.getPaintStyle();
        paintStyle.fillColor = sElement.fillColor;
        paintStyle.lineColor = sElement.lineColor;
        paintStyle.lineWidth = sElement.lineWidth;
        paintStyle.dashedStyle = sElement.dashedStyle;
        paintStyle.dash = sElement.dash;
        paintStyle.arrowStyle = sElement.arrowStyle;
        paintStyle.startArrowType = sElement.startArrowType;
        paintStyle.endArrowType = sElement.endArrowType;
        container.setPaintStyle(paintStyle);
        if (sElement.textArea != null) {
            Rectangle2D textArea = (Rectangle2D)sElement.textArea.clone();
            container.addTextBox(textArea);
            TextBox textBox = container.getTextBox();
            textBox.setTextArea(textArea);
            CommittedTextContainer committedTextContainer = textBox.getCommittedTextContainer();
            committedTextContainer.setSerializableAttributedString(sElement.attributedString);
            textBox.textBoxInsets = (Insets)sElement.textBoxInsets.clone();
            textBox.textAlign = sElement.textAlign;
            textBox.lineSpace = sElement.lineSpace;
        }
        if (debug > 0) {
            System.out.println(" ++ OutputElementData.createShapeContainer container=" + container.toString());
        }
        return container;
    }

    public static ShapeContainer invertGroupContainer(SerializableElement sElement) {
        if (debug > 0) {
            System.out.println("\n** SerializableElementUtil invertGropShapeContainer **\n- SerializableElementUtil" + sElement.toString());
        }
        ShapeContainer container = new ShapeContainer();
        container.setContainerIndex(sElement.containerIndex);
        container.setShapeId(sElement.shapeId);
        container.setConnectorTargetPermission(sElement.connectorTargetPermission);
        container.setConnectorPermission(sElement.connectorPermission);
        container.property = sElement.property;
        GroupElement groupElement = new GroupElement();
        container.setElement(groupElement);
        groupElement.setShapeContainer(container);
        if (debug > 0) {
            System.out.println(" ++ SerializableElementUtil.invertGropShapeContaine groupContainer=" + container.toString());
        }
        ArrayList childrenList = (ArrayList)sElement.childrenList.clone();
        for (int j = 0; j < childrenList.size(); ++j) {
            SerializableElement childData;
            ShapeContainer childContainer;
            String className = childrenList.get(j).getClass().getSimpleName();
            if (debug > 0) {
                System.out.println(" ++ SerializableElementUtil.convertToGroupContainer loop j=" + j + ", className=" + className);
            }
            if (className.equals("String") || (childContainer = SerializableElementUtil.invertShapeContainer(childData = (SerializableElement)childrenList.get(j))) == null) continue;
            groupElement.addChildren(childContainer);
            childContainer.setParent(container);
        }
        if (debug > 0) {
            System.out.println("\n** SerializableElementUtil invertGropShapeContainer **\n- ShapeContainer" + container.toShortString());
        }
        return container;
    }

    public static void setToShapeContainer(SerializableElement sElement, ShapeContainer container) {
        if (container.getContainerType() == ShapeContainer.GROUP) {
            SerializableElementUtil.setToGroupContainer(sElement, container);
        } else {
            SerializableElementUtil.setToSingleShapeContainer(sElement, container);
        }
        container.setSelected(false);
    }

    private static void setToGroupContainer(SerializableElement sElement, ShapeContainer container) {
        int debug = FileIo.debug;
        container.setContainerIndex(sElement.containerIndex);
        GroupElement groupElement = (GroupElement)container.getElement();
        container.setElement(groupElement);
        groupElement.setShapeContainer(container);
        container.setShapeId(sElement.shapeId);
        ArrayList childrenList = groupElement.getChildrenList();
        ArrayList sChildrenList = (ArrayList)sElement.childrenList.clone();
        for (int j = 0; j < sChildrenList.size(); ++j) {
            SerializableElement sChildData = (SerializableElement)sChildrenList.get(j);
            ShapeContainer child = (ShapeContainer)childrenList.get(j);
            SerializableElementUtil.setToShapeContainer(sChildData, child);
        }
        if (debug > 0) {
            System.out.println(" ++ setToGroupContainer groupContainer=" + container.toString());
        }
    }

    private static void setToSingleShapeContainer(SerializableElement sElement, ShapeContainer container) {
        int debug;
        container.setShapeId(sElement.shapeId);
        container.setContainerIndex(sElement.containerIndex);
        container.setConnectorTargetPermission(sElement.connectorTargetPermission);
        container.setConnectorPermission(sElement.connectorPermission);
        container.property = sElement.property;
        ShapeElement shapeElement = null;
        String shapeId = sElement.shapeId;
        int id = container.getElementType(shapeId);
        int type = Command.getCommandId(sElement.elementType);
        if (type < 0) {
            System.err.println("*** Error SerializableElementUtil.setToSingleContainer: id=" + type + ", elementType=" + sElement.elementType);
            type = id;
        }
        switch (type) {
            case 43: {
                shapeElement = new RectangleElement();
                break;
            }
            case 44: {
                shapeElement = new RoundRectangleElement();
                break;
            }
            case 45: {
                shapeElement = new EllipseElement();
                break;
            }
            case 51: {
                shapeElement = new LineElement();
                break;
            }
            case 54: {
                shapeElement = new PolylineElement();
                break;
            }
            case 55: {
                shapeElement = new CubicCurveElement();
                break;
            }
            case 56: {
                shapeElement = new GeneralCurveElement();
                break;
            }
            case 46: {
                shapeElement = new ImageElement();
                ImageElement imageElement = (ImageElement)shapeElement;
                imageElement.setByteImage(sElement.imageByteData);
                break;
            }
        }
        container.setElement(shapeElement);
        shapeElement.setShapeContainer(container);
        shapeElement.setSerializableCurve2D((SerializableCurve2D)sElement.serializableCurve2D.clone());
        PaintStyle paintStyle = container.getPaintStyle();
        paintStyle.fillColor = sElement.fillColor;
        paintStyle.lineColor = sElement.lineColor;
        paintStyle.lineWidth = sElement.lineWidth;
        paintStyle.dashedStyle = sElement.dashedStyle;
        paintStyle.dash = sElement.dash;
        paintStyle.arrowStyle = sElement.arrowStyle;
        paintStyle.startArrowType = sElement.startArrowType;
        paintStyle.endArrowType = sElement.endArrowType;
        container.setPaintStyle(paintStyle);
        if (sElement.textArea != null) {
            container.addTextBox();
            Rectangle2D textArea = (Rectangle2D)sElement.textArea.clone();
            TextBox textBox = container.getTextBox();
            CommittedTextContainer attributedStringContainer = textBox.getCommittedTextContainer();
            attributedStringContainer.setSerializableAttributedString(sElement.attributedString);
            textBox.setTextArea(textArea);
            textBox.textBoxInsets = (Insets)sElement.textBoxInsets.clone();
            textBox.textAlign = sElement.textAlign;
            textBox.lineSpace = sElement.lineSpace;
        }
        if ((debug = Edit.debug + FileIo.debug) > 0) {
            System.out.println(" ++ OutputElementData.createShapeContainer container=" + container.toString());
        }
    }
}

