/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import DrawTop.ObjectTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import shape.ShapeContainer;
import shapeUtil.ChangeShapeElement;
import shapeUtil.ComponentLibDialog;
import shapeUtil.ComponentLibPanel;
import shapeUtil.ComponentManager;
import util.ContainerManager;

class ComponentAction
extends AbstractAction
implements WindowListener,
MouseListener {
    ComponentLibDialog dialog;
    String actionButtonName = "";
    int debug = 0;

    ComponentAction(ComponentLibDialog dialog) {
        this.dialog = dialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String commandName = e.getActionCommand();
        String componentClassName = "";
        componentClassName = e.getSource().getClass().getSimpleName();
        String componentName = ((Component)e.getSource()).getName();
        if (this.debug > 0) {
            System.out.println("- ComponentAction.actionPerformed  commandName=" + commandName + ", source component name=" + componentName + ", source class simple name=" + componentClassName);
        }
        this.dialog.showMessage(" ", Color.BLACK);
        if (commandName.equals("add")) {
            this.actionButtonName = "add";
            boolean added = this.addComponent();
            if (added) {
                this.dialog.showMessage("Succeeded.", Color.BLUE);
            }
            return;
        }
        if (commandName.equals("delete")) {
            this.actionButtonName = "delete";
            boolean deleted = this.deleteComponent();
            if (deleted) {
                this.dialog.showMessage("Succeeded.", Color.BLUE);
            }
            return;
        }
        if (commandName.equals("change")) {
            this.actionButtonName = "change";
            ChangeShapeElement changeElement = new ChangeShapeElement(this.dialog);
            changeElement.start();
            boolean changed = true;
            if (changed) {
                this.dialog.showMessage("Succeeded.", Color.BLUE);
            }
            return;
        }
    }

    public String getActionButtonName() {
        return this.actionButtonName;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.debug > 0) {
            System.out.println("ComponentAction mouseClicked");
        }
    }

    private boolean addComponent() {
        ContainerManager manager = ObjectTable.getContainerManager("");
        ShapeContainer[] containers = manager.getSelectedContainers();
        int size = 0;
        if (containers != null) {
            size = containers.length;
        }
        if (size == 0) {
            this.dialog.showMessage("Selected a shape on the canvas !", Color.RED);
            return false;
        }
        for (int i = 0; i < size; ++i) {
            Rectangle2D currentBox = containers[i].getBoundingBox();
            ComponentLibPanel componentLibPanel = this.dialog.getComponentLibPanel();
            Dimension componentSize = componentLibPanel.sizeOfComponent;
            double scaleX = componentSize.getWidth() / currentBox.getWidth();
            double scaleY = componentSize.getHeight() / currentBox.getHeight();
            double scale = Math.min(scaleX, scaleY);
            Rectangle2D.Double newBox = new Rectangle2D.Double(0.0, 0.0, scale * currentBox.getWidth(), scale * currentBox.getHeight());
            ShapeContainer container = (ShapeContainer)containers[i].clone();
            container.getElement().moveResize(currentBox, newBox, true);
            ContainerManager containerManager = this.dialog.getComponentManager().getContainerManager();
            container.setNewShapeId(containerManager, true);
            containerManager.addContainer(container);
            if (this.debug > 0) {
                containerManager.printContainers("++ addComponentToLib");
            }
            ComponentManager componentManager = this.dialog.getComponentManager();
            componentManager.writeComponentList();
            componentLibPanel.revalidate();
            componentLibPanel.repaint();
        }
        return true;
    }

    private boolean deleteComponent() {
        ContainerManager containerManager = this.dialog.getComponentManager().getContainerManager();
        ComponentLibPanel componentLibPanel = this.dialog.getComponentLibPanel();
        int selectedComponentIndex = componentLibPanel.getSelectedComponentByIndex();
        int size = containerManager.size();
        if (selectedComponentIndex < 0) {
            this.dialog.showMessage("No component is selected on the dialog!", Color.RED);
            return false;
        }
        if (selectedComponentIndex >= 0 && selectedComponentIndex < size) {
            int returnCode = JOptionPane.showConfirmDialog(ObjectTable.getDrawMain(), "Delete selected component? Are you sure ?", "", 0);
            if (returnCode == 1) {
                return false;
            }
            containerManager.deleteContainer(selectedComponentIndex);
            this.dialog.getComponentLibPanel().setSelectedComponentByIndex(-1);
        }
        ComponentManager componentManager = this.dialog.getComponentManager();
        componentManager.writeComponentList();
        componentLibPanel.revalidate();
        componentLibPanel.repaint();
        return true;
    }

    private void closeDialog() {
        ComponentLibDialog dialog = this.dialog;
        Window owner = dialog.getOwner();
        Point dialogPT = dialog.getLocation();
        dialog.dialogLocation = new Point((int)dialogPT.getX() - owner.getX(), (int)dialogPT.getY() - owner.getY());
        this.dialog.getDialog().setVisible(false);
        ObjectTable.getMenuUtil().removeMenuComponent(this.dialog.getDialog());
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.closeDialog();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

