/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import DrawTop.Command;
import DrawTop.DrawParameters;
import DrawTop.ObjectTable;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import menu.MButton;
import menu.MenuConstants;
import shape.ShapeContainer;
import shapeUtil.ComponentAction;
import shapeUtil.ComponentLibPanel;
import shapeUtil.ComponentManager;
import util.ContainerManager;
import util.Util;

public class ComponentLibDialog
extends JDialog {
    ComponentAction action;
    ComponentManager componentManager;
    ComponentLibPanel componentLibPanel;
    JLabel messageLabel1 = new JLabel(" ");
    JLabel messageLabel2 = new JLabel(" ");
    MButton addButton = null;
    MButton deleteButton = null;
    MButton changeButton = null;
    JScrollPane scrollPane = null;
    Dimension buttonDimension = new Dimension(140, 22);
    Dimension messageDimension = new Dimension(300, 14);
    Point dialogLocation = new Point(500, 90);
    int debug = 0;

    public ComponentLibDialog() {
        super((Frame)ObjectTable.getDrawMain(), "component lib");
        this.setName(Command.getCommandString(80));
        this.action = new ComponentAction(this);
        this.componentManager = new ComponentManager(this);
        this.componentLibPanel = new ComponentLibPanel(this);
        this.createDialog();
    }

    public void createDialog() {
        this.addWindowListener(this.action);
        Container contentPane = this.getContentPane();
        Box box = Box.createVerticalBox();
        box.setBackground(Color.GREEN);
        box.setForeground(Color.MAGENTA);
        contentPane.add(box);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        JViewport viewport = new JViewport();
        this.scrollPane.setViewport(viewport);
        this.componentLibPanel.setAutoscrolls(true);
        viewport.setView(this.componentLibPanel);
        viewport.setViewPosition(new Point(0, 0));
        JPanel buttonPanel1 = new JPanel();
        JPanel buttonPanel2 = new JPanel();
        JPanel buttonPanel3 = new JPanel();
        this.addButton = new MButton("add component");
        this.deleteButton = new MButton("del component");
        this.changeButton = new MButton("change shapes");
        String tipText = "Select a shape on the canvas and press this button,\n then the selected shape will be added to the upper panel.";
        this.addButton.setToolTipText(tipText);
        this.addButton.setToolTipFont(1);
        tipText = "Select a component on the upper panel and press this button,\n then the selected component will be deleted.";
        this.deleteButton.setToolTipText(tipText);
        this.deleteButton.setToolTipFont(1);
        tipText = "Select a component on the upper panel,select a shape on the canvas,\n, and press this bottn, then the selected shape will be changes.";
        this.changeButton.setToolTipText(tipText);
        this.changeButton.setToolTipFont(1);
        this.setButtonAttribute(this.addButton, "add", this.action, this.buttonDimension);
        this.setButtonAttribute(this.deleteButton, "delete", this.action, this.buttonDimension);
        this.setButtonAttribute(this.changeButton, "change", this.action, this.buttonDimension);
        buttonPanel1.add(this.addButton);
        buttonPanel1.add(this.deleteButton);
        buttonPanel2.add(this.changeButton);
        JPanel descriptionPanel = new JPanel();
        descriptionPanel.setBorder(BorderFactory.createTitledBorder("operation"));
        JPanel messagePanel = new JPanel();
        messagePanel.setBorder(BorderFactory.createTitledBorder("message:"));
        Box messageBox = Box.createVerticalBox();
        messagePanel.add(messageBox);
        messageBox.add(Box.createVerticalStrut(0));
        messageBox.add(this.messageLabel1);
        messageBox.add(Box.createVerticalStrut(0));
        messageBox.add(this.messageLabel2);
        messageBox.add(Box.createVerticalStrut(0));
        this.messageLabel1.setPreferredSize(this.messageDimension);
        this.messageLabel2.setPreferredSize(this.messageDimension);
        Box descriptionBox = Box.createVerticalBox();
        descriptionPanel.add(descriptionBox);
        JLabel label1 = new JLabel();
        label1.setBorder(BorderFactory.createTitledBorder(" add component"));
        label1.setHorizontalTextPosition(2);
        String str = "Select shapes on the screen, then click add component button";
        label1.setText(str);
        label1.setBackground(Color.YELLOW);
        descriptionPanel.add(label1);
        box.add(this.scrollPane);
        box.add(Box.createVerticalStrut(0));
        box.add(buttonPanel1);
        box.add(Box.createVerticalStrut(0));
        box.add(buttonPanel2);
        box.add(Box.createVerticalStrut(0));
        box.add(Box.createVerticalStrut(0));
        box.add(messagePanel);
    }

    private void setButtonAttribute(JButton button, String actionCommand, ActionListener action, Dimension dimension) {
        button.setFont(MenuConstants.MenuFont);
        button.setActionCommand(actionCommand);
        button.addActionListener(action);
        button.setPreferredSize(dimension);
    }

    public void showDialog() {
        this.componentManager.readComponentList();
        this.componentLibPanel.repaint();
        if (this.debug > 0) {
            this.printView(this);
        }
        this.scrollPane.setPreferredSize(this.componentLibPanel.getSizeOfScrollPane());
        Window owner = this.getOwner();
        Point pos = new Point(owner.getX() + (int)this.dialogLocation.getX(), owner.getY() + (int)this.dialogLocation.getY());
        this.setLocation(pos);
        this.pack();
        this.setVisible(true);
        ObjectTable.getMenuUtil().setMenuComponent(this.getDialog());
    }

    public void showMessage(String message, Color color) {
        this.messageLabel1.setForeground(color);
        this.messageLabel2.setForeground(color);
        this.messageLabel1.setFont(DrawParameters.Font12Bold);
        this.messageLabel2.setFont(DrawParameters.Font12Bold);
        int index = message.indexOf("\n");
        String str1 = message;
        String str2 = "";
        if (index > 0) {
            str1 = message.substring(0, index);
            if (index + 1 < message.length()) {
                str2 = message.substring(index + 1, message.length());
            }
        }
        this.messageLabel1.setText(str1);
        this.messageLabel2.setText(str2);
    }

    @Override
    public String getName() {
        String name = Command.getCommandString(80);
        return name;
    }

    public void setSelected(boolean selected) {
    }

    public boolean isSelected() {
        return false;
    }

    public ShapeContainer getSelectedComponent() {
        int index = this.componentLibPanel.getSelectedComponentByIndex();
        if (index < 0) {
            return null;
        }
        ContainerManager containerManager = this.componentManager.getContainerManager();
        ShapeContainer selectedContainer = containerManager.getContainer(index);
        return selectedContainer;
    }

    protected ComponentLibPanel getComponentLibPanel() {
        return this.componentLibPanel;
    }

    protected ComponentManager getComponentManager() {
        return this.componentManager;
    }

    protected JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    protected JDialog getDialog() {
        return this;
    }

    private void printView(ComponentLibDialog dialog) {
        System.out.println("++ printView ComponentLibDialog\n   dialog:" + Util.Rect(this) + "\n   scrollPane:" + Util.Rect(this.scrollPane) + "\n   componentLibPanel:" + Util.Rect(this.componentLibPanel));
    }
}

