/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import geomExtension.Vector2D;
import java.awt.geom.Point2D;

public class DiscreteAngledLine {
    double initAngle = 0.0;
    double anglePitch = 0.0;
    Point2D startPT = null;
    int ctrl = 0;
    int direction = -1;
    Vector2D[] vec = null;

    public DiscreteAngledLine(double initAngle, double anglePitch, Point2D startPT) {
        this.initAngle = initAngle;
        this.anglePitch = anglePitch;
        this.startPT = startPT;
        double pai = Math.PI;
        int num = (int)(360.0 / anglePitch);
        this.vec = new Vector2D[num];
        for (int i = 0; i < num; ++i) {
            double teta = (initAngle + anglePitch * (double)i) / 180.0 * pai;
            this.vec[i] = new Vector2D(Math.cos(teta), Math.sin(teta));
        }
    }

    public Point2D getControlledPT(int ctrl, Point2D p) {
        Vector2D vec0;
        Point2D newPT = null;
        if (ctrl == 0) {
            this.direction = -1;
        }
        if (ctrl > 0 && this.direction < 0) {
            vec0 = new Vector2D(p.getX() - this.startPT.getX(), p.getY() - this.startPT.getY());
            if (Vector2D.length(vec0) == 0.0) {
                this.direction = -1;
            } else {
                double sprodMax = -10000.0;
                int maxIndex = 0;
                for (int i = 0; i < this.vec.length; ++i) {
                    double sprod = Vector2D.sproduct(vec0, this.vec[i]);
                    if (!(sprod > sprodMax)) continue;
                    maxIndex = i;
                    sprodMax = sprod;
                }
                this.direction = maxIndex;
            }
        }
        if (this.direction == -1) {
            newPT = (Point2D)p.clone();
        } else {
            vec0 = new Vector2D(p.getX() - this.startPT.getX(), p.getY() - this.startPT.getY());
            double sprod = Vector2D.sproduct(vec0, this.vec[this.direction]);
            Vector2D newVec = Vector2D.multiply(sprod, this.vec[this.direction]);
            newPT = new Point2D.Double(this.startPT.getX() + newVec.getX(), this.startPT.getY() + newVec.getY());
        }
        return newPT;
    }

    public static Point2D getControlledPT(double initAngle, double anglePitch, Point2D p0, Point2D p) {
        Vector2D vec0 = new Vector2D(p.getX() - p0.getX(), p.getY() - p0.getY());
        if (Vector2D.length(vec0) == 0.0) {
            return (Point2D)p0.clone();
        }
        double pai = Math.PI;
        int num = (int)(360.0 / anglePitch);
        Vector2D[] vec = new Vector2D[num];
        for (int i = 0; i < num; ++i) {
            double teta = (initAngle + anglePitch * (double)i) / 180.0 * pai;
            vec[i] = new Vector2D(Math.cos(teta), Math.sin(teta));
        }
        double sprodMax = -10000.0;
        int maxIndex = 0;
        for (int i = 0; i < vec.length; ++i) {
            double sprod = Vector2D.sproduct(vec0, vec[i]);
            if (!(sprod > sprodMax)) continue;
            maxIndex = i;
            sprodMax = sprod;
        }
        Vector2D newVec = Vector2D.multiply(sprodMax, vec[maxIndex]);
        Point2D.Double newPoint = new Point2D.Double(p0.getX() + newVec.getX(), p0.getY() + newVec.getY());
        return newPoint;
    }
}

