/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import DrawTop.DrawPanel;
import DrawTop.DrawParameters;
import DrawTop.ObjectTable;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.geom.Rectangle2D;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import menu.MRadioButton;
import shape.ShapeContainer;
import shapeUtil.ModifyShapeAction;
import shapeUtil.ModifyShapeLS;
import util.ContainerManager;

public class ModifyShape
extends JDialog {
    ModifyShapeAction action = null;
    ModifyShapeLS modifyShapeLS = new ModifyShapeLS();
    ShapeContainer targerContainer = null;
    JLabel messageLabel1 = null;
    JLabel messageLabel2 = null;
    MRadioButton moveButton = null;
    MRadioButton addPointButton = null;
    MRadioButton deletePointButton = null;
    MRadioButton smoothButton = null;
    MRadioButton cuspButton = null;
    MRadioButton disconnectButton = null;
    JButton exitButton = null;
    private Dimension dialogDimension = new Dimension(300, 80);

    public ModifyShape() {
        super((Frame)ObjectTable.getDrawMain(), "ModifyShape");
        this.setName("ModifyShape");
        this.action = new ModifyShapeAction(this);
    }

    public void showDialog() {
        ContainerManager manager = ObjectTable.getContainerManager("ModifyShape");
        ShapeContainer[] containers = manager.getSelectedContainers();
        if (containers == null || containers.length == 0) {
            JOptionPane.showMessageDialog(ObjectTable.getDrawMain(), "Shape not selected!  Select one.", "", 1);
            return;
        }
        if (containers.length > 1) {
            for (int i = 1; i < containers.length; ++i) {
                containers[i].setSelected(false);
            }
        }
        if (containers[0].getContainerType() == ShapeContainer.GROUP) {
            JOptionPane.showMessageDialog(ObjectTable.getDrawMain(), "Group was selected!  Select one shape.", "", 1);
            return;
        }
        this.targerContainer = containers[0];
        this.modifyShapeLS.start(this.targerContainer);
        this.targerContainer.setMode(5);
        ObjectTable.getDrawPanel("").repaint("ModifyShape");
        double scale = DrawParameters.Scale;
        DrawPanel drawPanel = ObjectTable.getDrawPanel("");
        Window owner = this.getOwner();
        Rectangle2D rect = this.targerContainer.getBoundingBox();
        int X = (int)Math.max(0.0, (double)owner.getX() + scale * (rect.getX() + rect.getWidth() + 20.0));
        int Y = (int)Math.max(0.0, (double)owner.getY() + scale * rect.getY());
        Point position = SwingUtilities.convertPoint(drawPanel, X, Y, owner);
        this.setLocation(position);
        this.addWindowListener(this.action);
        Container contentPane = this.getContentPane();
        Box box = Box.createVerticalBox();
        contentPane.add(box);
        JPanel messagePanel = new JPanel();
        messagePanel.setPreferredSize(this.dialogDimension);
        GridLayout basePanelLayout = new GridLayout(3, 1);
        basePanelLayout.setHgap(20);
        basePanelLayout.setVgap(5);
        messagePanel.setLayout(basePanelLayout);
        messagePanel.setPreferredSize(this.dialogDimension);
        JLabel instructionLabel = new JLabel("   Modify shape.  Select button !");
        this.messageLabel1 = new JLabel(" ");
        this.messageLabel2 = new JLabel(" ");
        messagePanel.add(instructionLabel);
        messagePanel.add(this.messageLabel1);
        messagePanel.add(this.messageLabel2);
        JPanel radioButtonPanel = new JPanel();
        radioButtonPanel.setLayout(new GridLayout(2, 3, 5, 5));
        this.moveButton = new MRadioButton("move");
        this.addPointButton = new MRadioButton("add point");
        this.deletePointButton = new MRadioButton("delete point");
        this.smoothButton = new MRadioButton("smooth");
        this.cuspButton = new MRadioButton("cusp");
        this.disconnectButton = new MRadioButton("disconnect");
        this.moveButton.addActionListener(this.action);
        this.addPointButton.addActionListener(this.action);
        this.deletePointButton.addActionListener(this.action);
        this.smoothButton.addActionListener(this.action);
        this.cuspButton.addActionListener(this.action);
        this.disconnectButton.addActionListener(this.action);
        this.moveButton.setSelected(true);
        String tipText = "Move a small rectangle on a curve or a tangent line.\n \u2022 Mark filled in blue: node point. \n \u2022 Mark filled in white: center of line/arc or ends of tangent.";
        this.moveButton.setToolTipText(tipText);
        tipText = "Click on a curve to add a new node point on the curve.";
        this.addPointButton.setToolTipText(tipText);
        tipText = "Click near a node point (blue mark) to delete it.";
        this.deletePointButton.setToolTipText(tipText);
        tipText = "Click on a cusp node point to connect a curve smoothly.\nAt least, one of the curves connecting at the cusp point must be cubic.";
        this.smoothButton.setToolTipText(tipText);
        tipText = "Click on a smooth node point to change it cusp point.";
        this.cuspButton.setToolTipText(tipText);
        tipText = "Click on a node point to disconnect a curve.";
        this.disconnectButton.setToolTipText(tipText);
        if (this.targerContainer.getElement().getTypeE() == 44) {
            this.addPointButton.setEnabled(false);
            this.deletePointButton.setEnabled(false);
            this.smoothButton.setEnabled(false);
            this.cuspButton.setEnabled(false);
            this.disconnectButton.setEnabled(false);
        }
        ButtonGroup group = new ButtonGroup();
        group.add(this.moveButton);
        group.add(this.addPointButton);
        group.add(this.deletePointButton);
        group.add(this.smoothButton);
        group.add(this.cuspButton);
        group.add(this.disconnectButton);
        radioButtonPanel.add(this.moveButton);
        radioButtonPanel.add(this.addPointButton);
        radioButtonPanel.add(this.deletePointButton);
        radioButtonPanel.add(this.smoothButton);
        radioButtonPanel.add(this.cuspButton);
        radioButtonPanel.add(this.disconnectButton);
        JPanel buttonPanel = new JPanel();
        this.exitButton = new JButton("Exit");
        this.exitButton.setActionCommand("Exit");
        this.exitButton.addActionListener(this.action);
        buttonPanel.add(this.exitButton);
        box.add(Box.createVerticalStrut(5));
        box.add(messagePanel);
        box.add(Box.createVerticalStrut(5));
        box.add(radioButtonPanel);
        box.add(Box.createVerticalStrut(5));
        box.add(buttonPanel);
        this.pack();
        this.setVisible(true);
        int type = this.targerContainer.getElement().getTypeE();
        this.showMessage(1, "  move button selected (shift/ctrl key available)");
        if (type == 54) {
            this.showMessage(2, "   => move blue point or edge !");
        } else {
            this.showMessage(2, "   => move blue point or tangent !");
        }
    }

    protected void showMessage(int id, String message) {
        if (id == 1) {
            this.messageLabel1.setForeground(Color.BLUE);
            this.messageLabel1.setFont(DrawParameters.Font12Bold);
            this.messageLabel1.setText(message);
        } else {
            this.messageLabel2.setForeground(Color.BLUE);
            this.messageLabel2.setFont(DrawParameters.Font14Bold);
            this.messageLabel2.setText(message);
        }
    }

    protected ShapeContainer getTargetContainer() {
        return this.targerContainer;
    }

    protected ModifyShapeLS getModifyShapeLS() {
        return this.modifyShapeLS;
    }
}

