/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import DrawTop.DrawParameters;
import DrawTop.ListenerPanel;
import DrawTop.MousePositionInfo;
import DrawTop.ObjectTable;
import geomExtension.Curve2D;
import geomExtension.CurvePT;
import geomExtension.Vector2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import shape.DrawShapeUtil;
import shape.ShapeContainer;
import shape.ShapeElement;
import shape.ShapeElementUtil;
import shapeUtil.AutoAlign;
import shapeUtil.ConnectionLS;
import shapeUtil.ConnectionUtil;
import util.ContainerManager;
import util.Util;

public class MoveResizeShapeLS
implements MouseListener,
MouseMotionListener {
    MousePositionInfo mousePositionInfo = null;
    ShapeContainer[] selectedContainers;
    int auto_tracking_option;
    boolean connected = false;
    boolean guided = false;
    ConnectionUtil connectionUtil = new ConnectionUtil();
    AutoAlign autoAlign = new AutoAlign(this);
    int mode = 0;
    int mousePositionCode = 0;
    int movePtIndex = 0;
    Point2D startPoint = null;
    Point2D newPoint = null;
    Point2D oldPoint = null;
    Rectangle2D startBox = null;
    Rectangle2D newBox = null;
    Rectangle2D oldBox = null;
    static final double Limit = 5.0;
    public static int debug = 0;
    boolean test = true;

    public void start(MousePositionInfo info, MouseEvent e) {
        int result = this.init(info, e);
        if (result != 0) {
            System.err.println("*** Error  MoveResizeShapeLS.init info:" + info.toString());
            return;
        }
        double scale = DrawParameters.getScale();
        double X = (double)e.getX() / scale;
        double Y = (double)e.getY() / scale;
        if (debug > 0) {
            System.out.println(" - MoveResizeShapeLS start");
        }
        ListenerPanel listenerPanel = ObjectTable.getListenerPanel();
        listenerPanel.addMouseListener(this);
        listenerPanel.addMouseMotionListener(this);
        ObjectTable.getSelectionLS().end();
        ShapeContainer[] containers = this.connectionUtil.getTargetsAndConnectors();
        ContainerManager containerManager = ObjectTable.getContainerManager("");
        containerManager.undoSetupStart(containers);
        for (int i = 0; i < containers.length; ++i) {
            containers[i].setConnectorPermission(true);
            containers[i].setConnectorTargetPermission(true);
        }
    }

    public int init(MousePositionInfo mousePositionInfo, MouseEvent e) {
        int i;
        double scale = DrawParameters.getScale();
        double X = (double)e.getX() / scale;
        double Y = (double)e.getY() / scale;
        int key = e.getModifiersEx();
        int ctrl = 0;
        if ((key & 0x40) != 0) {
            ctrl = 1;
        }
        if ((key & 0x80) != 0) {
            ctrl = 2;
        }
        if ((key & 0x200) != 0) {
            ctrl = 3;
        }
        this.mousePositionInfo = mousePositionInfo;
        this.mousePositionCode = mousePositionInfo.getPosition();
        this.movePtIndex = mousePositionInfo.getEndPTindex();
        this.mode = mousePositionInfo.onResizeMark() ? 3 : (mousePositionInfo.onEndPoint() ? 4 : 2);
        DrawParameters.MODE = 2;
        ContainerManager containerManager = ObjectTable.getContainerManager("");
        ShapeContainer[] selectedContainers = containerManager.getSelectedContainers();
        if (selectedContainers == null || selectedContainers.length == 0) {
            return -1;
        }
        if (this.mode == 2 || this.mode == 3) {
            this.selectedContainers = selectedContainers;
        } else if (this.mode == 4) {
            ShapeContainer targetContainer = null;
            this.connected = false;
            targetContainer = this.mousePositionInfo.getContainer();
            if (this.isSuitableForMoveEndPT(targetContainer)) {
                this.selectedContainers = new ShapeContainer[1];
                this.selectedContainers[0] = targetContainer;
            }
        }
        if (DrawParameters.ENABLE_CONNECTOR) {
            this.connectionUtil.setTargets(this.selectedContainers);
        }
        this.startPoint = new Point2D.Double(X, Y);
        this.oldPoint = new Point2D.Double(X, Y);
        this.startBox = ShapeElementUtil.getBoundingBox(this.selectedContainers);
        this.oldBox = (Rectangle2D)this.startBox.clone();
        for (i = 0; i < this.selectedContainers.length; ++i) {
            this.selectedContainers[i].getElement().mouseStart(ctrl, this.startPoint);
            this.selectedContainers[i].setMode(this.mode);
        }
        for (i = 0; i < this.selectedContainers.length; ++i) {
            this.selectedContainers[i].setConnectorPermission(true);
            this.selectedContainers[i].setConnectorTargetPermission(true);
        }
        if (this.test) {
            this.autoAlign.start(this.mode, this.mousePositionInfo, this.selectedContainers);
        } else {
            this.auto_tracking_option = DrawParameters.AUTO_TRACKING_OPTION;
            if (DrawParameters.AUTO_ALIGN) {
                this.autoAlign.start(this.mode, this.mousePositionInfo, this.selectedContainers);
            }
        }
        if (this.test) {
            this.connectionUtil.start(this.mode, this.mousePositionInfo, this.selectedContainers);
        } else if (DrawParameters.ENABLE_CONNECTOR) {
            this.connectionUtil.setTargets(this.selectedContainers);
        }
        return 0;
    }

    public void end() {
        if (debug > 0) {
            System.out.println(" -  MoveResizeShapeLS end");
        }
        ListenerPanel listenerPanel = ObjectTable.getListenerPanel("AutoAlignLS");
        listenerPanel.removeMouseListener(this);
        listenerPanel.removeMouseMotionListener(this);
        ObjectTable.getSelectionLS().start();
        for (int i = 0; i < this.selectedContainers.length; ++i) {
            this.selectedContainers[i].setMode(0);
        }
        DrawParameters.MODE = 0;
        this.connectionUtil.end();
        ContainerManager containerManager = ObjectTable.getContainerManager("");
        containerManager.undoSetupEnd();
        DrawShapeUtil.clearTempShape("Connection.pt");
        DrawShapeUtil.clearTempShape("Guide.pt");
        DrawShapeUtil.clearTempShape("ConnectionMark");
        ObjectTable.getDrawPanel().repaint();
    }

    public boolean isSuitableForMoveEndPT(ShapeContainer container) {
        int containerType = container.getContainerType();
        int type = container.getElement().getTypeE();
        if (containerType == ShapeContainer.GROUP) {
            return false;
        }
        if (type < 51 || type > 56) {
            return false;
        }
        return !container.getElement().isClosed();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int i;
        double scale = DrawParameters.getScale();
        double X = (double)e.getX() / scale;
        double Y = (double)e.getY() / scale;
        int key = e.getModifiersEx();
        int ctrl = 0;
        if ((key & 0x40) != 0) {
            ctrl = 1;
        }
        if ((key & 0x80) != 0) {
            ctrl = 2;
        }
        if ((key & 0x200) != 0) {
            ctrl = 3;
        }
        this.newPoint = new Point2D.Double(X, Y);
        if (this.mode == 2) {
            for (i = 0; i < this.selectedContainers.length; ++i) {
                this.selectedContainers[i].getElement().move(ctrl, this.newPoint, true);
            }
            if (DrawParameters.ENABLE_CONNECTOR && ctrl > 0) {
                this.guided = this.connectionUtil.resizeTargetsByGuideLines();
            }
        }
        if (this.mode == 3) {
            for (i = 0; i < this.selectedContainers.length; ++i) {
                String mousePosition = MousePositionInfo.getPositionString(this.mousePositionCode);
                this.selectedContainers[i].getElement().resize(ctrl, this.newPoint, mousePosition, true);
            }
        }
        if (this.mode == 4) {
            if (this.isSuitableForMoveEndPT(this.selectedContainers[0])) {
                ShapeElement shapeElement = this.selectedContainers[0].getElement();
                shapeElement.moveEndPoint(ctrl, this.movePtIndex, this.newPoint);
                ObjectTable.getDrawPanel().repaint("MoveRsize");
            }
            if (DrawParameters.ENABLE_CONNECTOR && !this.test) {
                ConnectionLS connectionLS = ObjectTable.getConnectionLS();
                boolean lineDir = false;
                Curve2D curve = this.selectedContainers[0].getElement().getCurve2D();
                int endIndex = curve.getCloseEndpointIndex(this.newPoint);
                Point2D endPT = curve.getP(endIndex);
                Vector2D vec = curve.getTangent(endIndex);
                CurvePT connectionPT = null;
                connectionPT = ctrl > 0 || lineDir ? connectionLS.drawMouseHitPT(1, endPT, vec, this.selectedContainers[0]) : connectionLS.drawMouseHitPT(0, endPT, null, this.selectedContainers[0]);
                if (connectionPT != null) {
                    ShapeElement shapeElement = this.selectedContainers[0].getElement();
                    Point2D replacedPT = connectionPT.getP();
                    shapeElement.moveEndPoint(ctrl, this.movePtIndex, replacedPT);
                    this.connected = true;
                    if (debug > 0) {
                        System.out.println("mouseDragged  endPT=" + Util.Pt(endPT) + ", replacedPT=" + Util.Pt(replacedPT));
                    }
                }
            }
        }
        if (this.test) {
            this.autoAlign.mouseDragged(e);
            this.connectionUtil.mouseDragged(e);
        } else {
            if (DrawParameters.AUTO_ALIGN) {
                this.autoAlign.drawHitAligns();
            }
            this.connectionUtil.resizeConnectors(this.auto_tracking_option);
        }
        this.oldPoint = this.newPoint;
        this.oldBox = this.newBox;
        ObjectTable.getDrawPanel().repaint("MoveRsize");
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int ctrl = 0;
        int key = e.getModifiersEx();
        if ((key & 0x40) != 0) {
            ctrl = 1;
        }
        if ((key & 0x80) != 0) {
            ctrl = 2;
        }
        if ((key & 0x200) != 0) {
            ctrl = 3;
        }
        if (this.mode != 4 || DrawParameters.ENABLE_CONNECTOR) {
            // empty if block
        }
        if (this.test) {
            this.autoAlign.mouseReleased(e);
            this.connectionUtil.mouseReleased(e);
        } else if (DrawParameters.AUTO_ALIGN) {
            if (this.mode == 4) {
                if (!this.connected) {
                    this.autoAlign.ajustAlignment(ctrl);
                    this.connectionUtil.resizeConnectors(this.auto_tracking_option);
                }
            } else {
                if (!this.guided) {
                    this.autoAlign.ajustAlignment(ctrl);
                }
                this.connectionUtil.resizeConnectors(this.auto_tracking_option);
            }
        }
        this.startPoint = null;
        this.newPoint = null;
        ObjectTable.getDrawPanel().repaint("MoveRsize");
        this.end();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

