/*
 * Decompiled with CFR 0.152.
 */
package shapeUtil;

import DrawTop.DrawParameters;
import DrawTop.ObjectTable;
import geomExtension.CurvePT;
import geomExtension.Vector2D;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.geom.Point2D;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import menu.MenuConstants;
import shape.DrawShapeUtil;
import shape.ShapeContainer;
import shapeUtil.ConnectionEvent;
import shapeUtil.ConnectionLS;
import shapeUtil.ConnectionListener;
import shapeUtil.TranslateAction;
import shapeUtil.TranslateSpinnerListener;
import util.ContainerManager;
import util.Util;

public class Translate
extends JDialog
implements ConnectionListener {
    TranslateAction action = null;
    JLabel messageLabel = null;
    Dimension panelSize = new Dimension(220, 44);
    JRadioButton pixelButton = null;
    JRadioButton mmButton = null;
    JSpinner[] translateSpinners = new JSpinner[2];
    SpinnerNumberModel[] translateSpinnerModels = new SpinnerNumberModel[2];
    JCheckBox checkBox = null;
    JRadioButton copyButton = null;
    JButton goButton = null;
    JButton cancelButton = null;
    Vector shapesVector = new Vector();
    Vector2D translateVec = new Vector2D(0.0, 0.0);
    Vector twoPointsVector = new Vector();
    int debug = 0;

    public Translate() {
        super((Frame)ObjectTable.getDrawMain(), "translate");
        this.setName("translate");
        this.action = new TranslateAction(this);
        this.createDialog();
    }

    public void createDialog() {
        this.addWindowListener(this.action);
        Container contentPane = this.getContentPane();
        Box box = Box.createVerticalBox();
        contentPane.add(box);
        JPanel messagePanel = new JPanel();
        messagePanel.setLayout(new FlowLayout(3));
        this.messageLabel = new JLabel(" ");
        messagePanel.add(this.messageLabel);
        JPanel unitPanel = new JPanel();
        unitPanel.setPreferredSize(new Dimension(100, 44));
        TitledBorder frameBorder = BorderFactory.createTitledBorder("unit of length");
        GridLayout unitPanelLayout = new GridLayout(1, 2);
        unitPanelLayout.setHgap(20);
        unitPanelLayout.setVgap(5);
        unitPanel.setLayout(unitPanelLayout);
        unitPanel.setBorder(frameBorder);
        ButtonGroup group = new ButtonGroup();
        this.pixelButton = new JRadioButton("pixel");
        this.mmButton = new JRadioButton("mm");
        group.add(this.mmButton);
        group.add(this.pixelButton);
        this.pixelButton.setActionCommand("pixel");
        this.mmButton.setActionCommand("mm");
        this.pixelButton.addActionListener(this.action);
        this.mmButton.addActionListener(this.action);
        unitPanel.add(this.mmButton);
        unitPanel.add(this.pixelButton);
        this.mmButton.setSelected(true);
        JPanel translatePanel = new JPanel();
        frameBorder = BorderFactory.createTitledBorder("translate x,y");
        frameBorder.setTitleColor(Color.BLACK);
        frameBorder.setTitleFont(MenuConstants.MenuFont);
        translatePanel.setBorder(frameBorder);
        GridLayout translatePanelLayout = new GridLayout(2, 1);
        translatePanelLayout.setHgap(20);
        translatePanelLayout.setVgap(5);
        translatePanel.setLayout(translatePanelLayout);
        JPanel xyPanel = new JPanel();
        GridLayout xyPanelLayout = new GridLayout(1, 2);
        xyPanelLayout.setHgap(20);
        xyPanelLayout.setVgap(5);
        xyPanel.setLayout(xyPanelLayout);
        JPanel[] xyPanels = new JPanel[2];
        String[] xyLabel = new String[]{"x: ", "y: "};
        TranslateSpinnerListener spinnerListener = new TranslateSpinnerListener(this);
        for (int i = 0; i < 2; ++i) {
            xyPanels[i] = new JPanel();
            xyPanels[i].setLayout(new BoxLayout(xyPanels[i], 0));
            JLabel label = new JLabel(xyLabel[i]);
            xyPanels[i].add(label);
            this.translateSpinnerModels[i] = new SpinnerNumberModel(0.0, -1000.0, 1000.0, 1.0);
            this.translateSpinners[i] = new JSpinner(this.translateSpinnerModels[i]);
            this.translateSpinners[i].addChangeListener(spinnerListener);
            xyPanels[i].add(this.translateSpinners[i]);
            xyPanel.add(xyPanels[i]);
        }
        translatePanel.add(xyPanel);
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.setLayout(new BoxLayout(checkBoxPanel, 0));
        JLabel checBoxLabel = new JLabel(": click two points ");
        this.checkBox = new JCheckBox();
        checkBoxPanel.add(this.checkBox);
        checkBoxPanel.add(checBoxLabel);
        this.checkBox.addActionListener(this.action);
        this.checkBox.setActionCommand("click");
        translatePanel.add(checkBoxPanel);
        JPanel copyPanel = new JPanel();
        frameBorder = BorderFactory.createTitledBorder("copy");
        copyPanel.setBorder(frameBorder);
        GridLayout copyPanelLayout = new GridLayout(1, 2);
        copyPanel.setLayout(copyPanelLayout);
        ButtonGroup copyGroup = new ButtonGroup();
        this.copyButton = new JRadioButton("yes");
        JRadioButton noCopyButton = new JRadioButton("no");
        copyGroup.add(this.copyButton);
        this.copyButton.setSelected(true);
        copyGroup.add(noCopyButton);
        copyPanel.add(this.copyButton);
        copyPanel.add(noCopyButton);
        JPanel buttonPanel = new JPanel();
        this.goButton = new JButton("GO !");
        this.cancelButton = new JButton("Cancel");
        this.goButton.setEnabled(false);
        this.goButton.setActionCommand("Go");
        this.cancelButton.setActionCommand("Cancel");
        this.goButton.addActionListener(this.action);
        this.cancelButton.addActionListener(this.action);
        buttonPanel.add(this.goButton);
        buttonPanel.add(this.cancelButton);
        box.add(Box.createVerticalStrut(5));
        box.add(messagePanel);
        box.add(Box.createVerticalStrut(5));
        box.add(unitPanel);
        box.add(Box.createVerticalStrut(5));
        box.add(translatePanel);
        box.add(Box.createVerticalStrut(5));
        box.add(copyPanel);
        box.add(Box.createVerticalStrut(5));
        box.add(buttonPanel);
    }

    public void showDialog() {
        Window owner = this.getOwner();
        Point centerP = new Point(owner.getX() + owner.getSize().width - 250, owner.getY() + 100);
        this.setLocation(centerP);
        this.pack();
        this.setVisible(true);
        ContainerManager containerManager = ObjectTable.getContainerManager("");
        ShapeContainer[] containers = containerManager.getSelectedContainers();
        int size = 0;
        if (containers != null) {
            size = containers.length;
        }
        if (size > 0) {
            this.shapesVector.clear();
            for (int i = 0; i < size; ++i) {
                this.shapesVector.add(containers[i]);
            }
        }
        if (this.shapesVector.size() > 0) {
            this.goButton.setEnabled(true);
        } else {
            this.showMessage("Select shapes before this command !", Color.RED);
            this.shapesVector.clear();
        }
    }

    public void addConnectionListener() {
        ConnectionLS connectionLS = ObjectTable.getConnectionLS();
        connectionLS.activateListener(true);
        connectionLS.addConnectionListener(this);
        ObjectTable.getSelectionLS().end();
        this.twoPointsVector.clear();
        this.showMessage("Click at the first point", Color.BLUE);
    }

    public void removeConnectionListener() {
        ConnectionLS connectionLS = ObjectTable.getConnectionLS();
        connectionLS.activateListener(false);
        connectionLS.removeConnectionListener(this);
        this.twoPointsVector.clear();
        ObjectTable.getSelectionLS().start();
    }

    @Override
    public void connected(ConnectionEvent event) {
        Point2D startPoint;
        CurvePT curvePT = event.getCurvePT();
        this.twoPointsVector.add(curvePT.getP());
        int size = this.twoPointsVector.size();
        if (this.debug > 0) {
            System.out.println("** Debug Translate.connected curvePT=" + Util.Pt(curvePT.getP()));
        }
        if (size == 1) {
            DrawShapeUtil.clearTempShape("Translate");
            this.translateVec = new Vector2D(0.0, 0.0);
            this.showMessage("Click at the second point", Color.BLUE);
            startPoint = (Point2D)this.twoPointsVector.get(0);
            this.drawMark(startPoint, "p1");
        }
        if (size == 2) {
            startPoint = (Point2D)this.twoPointsVector.get(0);
            Point2D endPoint = (Point2D)this.twoPointsVector.get(1);
            this.drawMark(endPoint, "p2");
            this.translateVec = Vector2D.sub(endPoint, startPoint);
            this.setValuesToTranslateSpinners();
            this.showMessage("Translation defined", Color.BLUE);
            this.twoPointsVector.clear();
        }
    }

    public void drawMark(Point2D point, String message) {
        ObjectTable.getDrawPanel().repaint();
        DrawShapeUtil.drawTempShape("Translate", point, 3.0, message, Color.RED);
    }

    protected void showMessage(String message, Color color) {
        this.messageLabel.setForeground(color);
        this.messageLabel.setFont(DrawParameters.Font12Bold);
        this.messageLabel.setText(message);
    }

    public void setValuesToTranslateSpinners() {
        double vecX = this.translateVec.getX();
        double vecY = this.translateVec.getY();
        double mm = 0.26458333333333334;
        double unit = 1.0;
        if (this.mmButton.isSelected()) {
            unit = mm;
        }
        this.translateSpinners[0].setValue(vecX *= unit);
        this.translateSpinners[1].setValue(vecY *= unit);
    }

    public ShapeContainer[] getSelectedContainers() {
        int size = this.shapesVector.size();
        ShapeContainer[] containers = new ShapeContainer[size];
        for (int i = 0; i < size; ++i) {
            containers[i] = (ShapeContainer)this.shapesVector.get(i);
        }
        return containers;
    }

    public JSpinner[] getTranslateSpinners() {
        return this.translateSpinners;
    }

    public SpinnerNumberModel[] getTranslateSpinnerModels() {
        return this.translateSpinnerModels;
    }

    public JRadioButton getCopyButton() {
        return this.copyButton;
    }

    public Vector getShapeVector() {
        return this.shapesVector;
    }
}

