/*
 * Decompiled with CFR 0.152.
 */
package textBox;

import DrawTop.Command;
import DrawTop.ObjectTable;
import java.awt.Color;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Vector;
import menu.ButtonOfToggle;
import menu.ComboBox;
import menu.CustomColorChooserDialog;
import menu.MenuUtil;
import shape.ShapeContainer;
import textBox.AttributedInterval;
import textBox.AttributedStringUtil;
import textBox.TextBox;

public class FontStyle {
    private String fontFamily;
    private int bold;
    private int italic;
    private int fontSize;
    private int underLine;
    private int superScript;
    private Color fontColor;
    public static final String DefaultStyle = "DefaultStyle";
    public static final String DefaultFontFamily = "Dialog";
    public static final int DefaultBold = 0;
    public static final int DefaultItalic = 0;
    public static final int DefaultFontSize = 12;
    public static final int DefaultUnderLine = -1;
    public static final int DefaultSuperScript = 0;
    public static final Color DefaultFontColor = Color.BLACK;
    public static final String UNDEF_string = "UNDEF";
    public static final int UNDEF_int = -99;
    public static final String MANY_string = "MANY";
    public static final int MANY_int = -99;
    public static final int OFF = 0;
    public static final int ON = 1;
    static int debug = 0;

    public FontStyle() {
        this.fontFamily = UNDEF_string;
        this.bold = -99;
        this.italic = -99;
        this.fontSize = -99;
        this.underLine = -99;
        this.superScript = -99;
        this.fontColor = null;
    }

    public FontStyle(String str) {
        this.fontFamily = UNDEF_string;
        this.bold = -99;
        this.italic = -99;
        this.fontSize = -99;
        this.underLine = -99;
        this.superScript = -99;
        this.fontColor = null;
        if (!str.equals(DefaultStyle)) {
            System.err.println("*** Error FontStyle.constructor Parameter Error=" + str);
            return;
        }
        this.fontFamily = DefaultFontFamily;
        this.bold = 0;
        this.italic = 0;
        this.fontSize = 12;
        this.underLine = -1;
        this.superScript = 0;
        this.fontColor = DefaultFontColor;
    }

    public FontStyle(String fontFamily, int bold, int italic, int fontSize, int underLine, int superScript, Color fontColor) {
        this.fontFamily = fontFamily;
        this.bold = bold;
        this.italic = italic;
        this.fontSize = fontSize;
        this.underLine = underLine;
        this.superScript = superScript;
        this.fontColor = fontColor;
        if (debug > 0) {
            this.printTextAttribute("FontStyle Constructor");
        }
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setBold(int bold) {
        this.bold = bold;
    }

    public int getBold() {
        return this.bold;
    }

    public void setItalic(int italic) {
        this.italic = italic;
    }

    public int getItalic() {
        return this.italic;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setUnderLine(int underLine) {
        this.underLine = underLine;
    }

    public int getUnderLine() {
        return this.underLine;
    }

    public void setSuperScript(int superScript) {
        this.superScript = superScript;
    }

    public int getSuperScript() {
        return this.superScript;
    }

    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public AttributedCharacterIterator setTo(AttributedCharacterIterator iterator, int selStart, int selEnd) {
        if (debug > 0) {
            System.out.println("- FontStyle.setTo " + this.toString());
        }
        if (selStart > selEnd) {
            int temp = selStart;
            selStart = selEnd;
            selStart = temp;
            System.err.println("*** Warning: AttributedStringUtil.setFontStyle selStart>selEnd, selStart,selEnd=" + selStart + "," + selEnd);
        }
        if (selStart < iterator.getBeginIndex()) {
            System.err.println("*** Warning: AttributedStringUtil.setFontStyle delStart=" + selStart + " out of range");
            selStart = iterator.getBeginIndex();
        }
        if (selEnd > iterator.getEndIndex()) {
            System.err.println("*** Warning: AttributedStringUtil.setFontStyle selEnd=" + selEnd + " out of range");
            selEnd = iterator.getEndIndex();
        }
        AttributedCharacterIterator newText = null;
        AttributedStringUtil util = new AttributedStringUtil(iterator);
        if (debug > 0) {
            System.out.println(" - FontStyle.setTo  this.fontStyle " + this.toString());
            System.out.println(" - FontStyle.setTo  selStart,selEnd=" + selStart + "," + selEnd + "\n  Text Before Operation=" + util.toString());
        }
        if (!this.getFontFamily().equals(UNDEF_string)) {
            util.addAttribute(TextAttribute.FAMILY, this.getFontFamily(), selStart, selEnd);
            newText = util.getAttributedString().getIterator();
        }
        if (this.getBold() != -99) {
            int bold = this.getBold();
            if (bold == 0) {
                util.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR, selStart, selEnd);
            } else {
                util.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD, selStart, selEnd);
            }
            newText = util.getAttributedString().getIterator();
        }
        if (this.getItalic() != -99) {
            int italic = this.getItalic();
            if (italic == 0) {
                util.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR, selStart, selEnd);
            } else {
                util.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, selStart, selEnd);
            }
            newText = util.getAttributedString().getIterator();
        }
        if (this.getFontSize() != -99) {
            util.addAttribute(TextAttribute.SIZE, this.getFontSize(), selStart, selEnd);
            newText = util.getAttributedString().getIterator();
        }
        if (this.getUnderLine() != -99) {
            util.addAttribute(TextAttribute.UNDERLINE, this.getUnderLine(), selStart, selEnd);
            newText = util.getAttributedString().getIterator();
        }
        if (this.getSuperScript() != -99) {
            int superScript = this.getSuperScript();
            int setScript = 0;
            if (superScript < 0) {
                setScript = TextAttribute.SUPERSCRIPT_SUB;
            } else if (superScript > 0) {
                setScript = TextAttribute.SUPERSCRIPT_SUPER;
            }
            util.removeAttribute(TextAttribute.FONT, selStart, selEnd);
            util.addAttribute(TextAttribute.SUPERSCRIPT, setScript, selStart, selEnd);
            newText = util.getAttributedString().getIterator();
        }
        if (this.getFontColor() != null) {
            util.addAttribute(TextAttribute.FOREGROUND, this.getFontColor(), selStart, selEnd);
            newText = util.getAttributedString().getIterator();
        }
        if ((newText = util.getAttributedString().getIterator()) != null) {
            util.setAttributedString(newText);
        }
        if (debug > 0) {
            System.out.println(" - FontStyle.setTo  selStart,selEnd=" + selStart + "," + selEnd + "\n  Text After Operation=" + util.toString());
        }
        return newText;
    }

    public String toString() {
        String fontFamilyStr = UNDEF_string;
        if (!this.fontFamily.equals(UNDEF_string)) {
            fontFamilyStr = this.fontFamily;
        }
        String boldStr = UNDEF_string;
        if (this.bold == 0) {
            boldStr = "PLAIN";
        }
        if (this.bold == 1) {
            boldStr = "BOLD";
        }
        String italicStr = UNDEF_string;
        if (this.italic == 0) {
            italicStr = "REGULAR";
        }
        if (this.italic == 1) {
            italicStr = "ITALIC";
        }
        String sizeStr = UNDEF_string;
        if (this.fontSize != -99) {
            sizeStr = String.valueOf(this.fontSize);
        }
        String underLineStr = "UNDERLINE_OFF";
        if (this.underLine == TextAttribute.UNDERLINE_ON) {
            underLineStr = "UNDERLINE_ON";
        }
        String superScriptStr = UNDEF_string;
        if (this.superScript == 0) {
            superScriptStr = "0";
        }
        if (this.superScript > 0) {
            superScriptStr = "1";
        }
        if (this.superScript < 0) {
            superScriptStr = "-1";
        }
        if (this.superScript == -99) {
            superScriptStr = UNDEF_string;
        }
        Color color = this.fontColor;
        String colorStr = UNDEF_string;
        if (color != null) {
            colorStr = this.fontColor.toString();
        }
        String str = "";
        str = str + "fontFamily=" + fontFamilyStr + ", size=" + sizeStr + ", bold=" + boldStr + ", posture=" + italicStr + ", underLine=" + underLineStr + ", superScript=" + superScriptStr + ", Color=" + colorStr;
        return str;
    }

    public void printTextAttribute(String title) {
        String str = "";
        str = str + "WEIGHT_REGULAR=" + TextAttribute.WEIGHT_REGULAR + ", WEIGHT_BOLD=" + TextAttribute.WEIGHT_BOLD + ", POSTURE_REGULAR=" + TextAttribute.POSTURE_REGULAR + ", POSTURE_OBLIQUE=" + TextAttribute.POSTURE_OBLIQUE + ", UNDERLINE_ON=" + TextAttribute.UNDERLINE_ON + ", SUPERSCRIPT_SUPER=" + TextAttribute.SUPERSCRIPT_SUPER + ", SUPERSCRIPT_SUB=" + TextAttribute.SUPERSCRIPT_SUB;
        System.out.println(title + "  " + str);
    }

    public static FontStyle getDefaultFontStyle() {
        FontStyle defaultFontStyle = new FontStyle();
        defaultFontStyle.setFontFamily(DefaultFontFamily);
        defaultFontStyle.setBold(0);
        defaultFontStyle.setItalic(0);
        defaultFontStyle.setFontSize(12);
        defaultFontStyle.setUnderLine(-1);
        defaultFontStyle.setSuperScript(0);
        defaultFontStyle.setFontColor(DefaultFontColor);
        return defaultFontStyle;
    }

    public static FontStyle getFontStyleFromMenu() {
        FontStyle fontStyle = new FontStyle();
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        ComboBox familyComboBox = (ComboBox)menuUtil.getMenuComponent(Command.getCommandString(131));
        String family = (String)familyComboBox.getSelectedItem();
        if (!family.equals("")) {
            fontStyle.setFontFamily(family);
        }
        ButtonOfToggle boldButton = (ButtonOfToggle)menuUtil.getMenuComponent(Command.getCommandString(133));
        int bold = 0;
        if (boldButton.isSelected()) {
            bold = 1;
        }
        fontStyle.setBold(bold);
        ButtonOfToggle italicButton = (ButtonOfToggle)menuUtil.getMenuComponent(Command.getCommandString(134));
        int italic = 0;
        if (italicButton.isSelected()) {
            italic = 1;
        }
        fontStyle.setItalic(italic);
        ComboBox fontSize = (ComboBox)menuUtil.getMenuComponent(Command.getCommandString(132));
        String sizeString = (String)fontSize.getSelectedItem();
        if (!sizeString.equals("")) {
            fontStyle.setFontSize(Integer.parseInt(sizeString));
        }
        ButtonOfToggle undetLineButton = (ButtonOfToggle)menuUtil.getMenuComponent(Command.getCommandString(135));
        int undeLine = -1;
        if (undetLineButton.isSelected()) {
            undeLine = TextAttribute.UNDERLINE_ON;
        }
        fontStyle.setUnderLine(undeLine);
        ButtonOfToggle subscriptButton = (ButtonOfToggle)menuUtil.getMenuComponent(Command.getCommandString(136));
        int subScript = 0;
        if (subscriptButton.isSelected()) {
            subScript = TextAttribute.SUPERSCRIPT_SUB;
        }
        fontStyle.setSuperScript(subScript);
        ButtonOfToggle superScriptButton = (ButtonOfToggle)menuUtil.getMenuComponent(Command.getCommandString(137));
        int superScript = subScript;
        if (superScriptButton.isSelected()) {
            superScript = TextAttribute.SUPERSCRIPT_SUPER;
        }
        fontStyle.setSuperScript(superScript);
        CustomColorChooserDialog dialog = ObjectTable.getCustomColorChooserDialog();
        Color fontColor = dialog.getPreviewColor("font color");
        if (fontColor != null) {
            fontStyle.setFontColor(fontColor);
        }
        if (debug > 0) {
            System.out.println("- FontStyle.getFontStyleFromMenu  fontStyle: " + fontStyle.toString());
        }
        return fontStyle;
    }

    public static FontStyle setFontStyleToMenu(TextBox textBox, String callFrom) {
        if (debug > 0) {
            System.out.println("- FontStyle.setFontStyleToMenu(extBox) callFrom=" + callFrom);
            System.out.println("  " + textBox.getShapeContainer().getShapeId());
        }
        FontStyle fontStyle = FontStyle.getDefaultFontStyle();
        AttributedString attribString = textBox.getCommittedTextContainer().getAttributedString();
        if (attribString == null) {
            return fontStyle;
        }
        AttributedCharacterIterator iterator = attribString.getIterator();
        int start = iterator.getBeginIndex();
        int end = iterator.getEndIndex();
        if (textBox.hasSelectedText()) {
            start = textBox.getSelectedTextStart();
            end = textBox.getSelectedTextEnd();
        } else if (textBox.getTextIndex() >= 0) {
            end = textBox.getTextIndex();
            if (end > 0) {
                start = end - 1;
            } else {
                end = 1;
            }
        }
        fontStyle = FontStyle.getCommonFontStyle(iterator, start, end);
        if (debug > 0) {
            System.out.println("- FontStyle.setFontStyleToMenu(textBox) callFrom=" + callFrom + ", FontStyle=" + fontStyle.toString());
        }
        FontStyle.updateFontMenu(fontStyle);
        return fontStyle;
    }

    public static FontStyle setFontStyleToMenu(ShapeContainer[] containers, String callFrom) {
        FontStyle fontStyle = null;
        if (containers == null || containers.length == 0) {
            return null;
        }
        if (debug > 0) {
            System.out.println("- FontStyle.setFontStyleToMenu(ShapeContainers) callFrom=" + callFrom);
            for (int i = 0; i < containers.length; ++i) {
                System.out.println("   " + containers[i].getShapeId());
            }
        }
        Vector<TextBox> vector = new Vector<TextBox>();
        for (int i = 0; i < containers.length; ++i) {
            TextBox[] textBoxes = containers[i].getGroupedTextBoxes();
            for (int j = 0; j < textBoxes.length; ++j) {
                vector.add(textBoxes[j]);
            }
        }
        TextBox[] textBoxes = new TextBox[vector.size()];
        for (int i = 0; i < textBoxes.length; ++i) {
            textBoxes[i] = (TextBox)vector.get(i);
        }
        fontStyle = FontStyle.getCommonFontStyle(textBoxes);
        if (debug > 0) {
            System.out.println("- FontStyle.setFontStyleToMenu(ShapeContainers) callFrom=" + callFrom + ", FontStyle=" + fontStyle.toString());
        }
        FontStyle.updateFontMenu(fontStyle);
        return fontStyle;
    }

    private static void updateFontMenu(FontStyle fontStyle) {
        if (debug > 0) {
            System.out.println("- FontStyle.updateFontMenu, fontStyle " + fontStyle.toString());
        }
        MenuUtil menuUtil = ObjectTable.getMenuUtil();
        String fontFamily = fontStyle.getFontFamily();
        ComboBox family = (ComboBox)menuUtil.getMenuComponent(Command.getCommandString(131));
        if (fontFamily.equals(UNDEF_string)) {
            fontFamily = " ";
        }
        family.activateListener(false);
        family.setSelectedItem(fontFamily);
        if (debug > 1) {
            System.out.println("-  FontStyle.updateFontMenu  setSelectedItem(fontFamily) fontFamily=" + fontFamily);
        }
        family.activateListener(true);
        int bold = fontStyle.getBold();
        ButtonOfToggle boldButton = (ButtonOfToggle)menuUtil.getMenuComponent(Command.getCommandString(133));
        boldButton.setSelected(false);
        if (bold != -99 && bold == 1) {
            boldButton.setSelected(true);
        }
        int italic = fontStyle.getItalic();
        ButtonOfToggle italicButton = (ButtonOfToggle)menuUtil.getMenuComponent(Command.getCommandString(134));
        italicButton.setSelected(false);
        if (italic != -99 && italic == 1) {
            italicButton.setSelected(true);
        }
        int size = fontStyle.getFontSize();
        ComboBox fontSize = (ComboBox)menuUtil.getMenuComponent(Command.getCommandString(132));
        fontSize.activateListener(false);
        if (size == -99) {
            fontSize.setSelectedItem("");
        } else {
            fontSize.setSelectedItem(String.valueOf(size));
        }
        fontSize.activateListener(true);
        int underLine = fontStyle.getUnderLine();
        ButtonOfToggle undetLineButton = (ButtonOfToggle)menuUtil.getMenuComponent(Command.getCommandString(135));
        if (underLine == -99 || underLine < 0) {
            undetLineButton.setSelected(false);
        } else {
            undetLineButton.setSelected(true);
        }
        int superScript = fontStyle.getSuperScript();
        ButtonOfToggle subscriptButton = (ButtonOfToggle)menuUtil.getMenuComponent(Command.getCommandString(136));
        ButtonOfToggle superScriptButton = (ButtonOfToggle)menuUtil.getMenuComponent(Command.getCommandString(137));
        if (superScript == -99 || superScript == 0) {
            subscriptButton.setSelected(false);
            superScriptButton.setSelected(false);
        } else if (superScript < 0) {
            subscriptButton.setSelected(true);
            superScriptButton.setSelected(false);
        } else if (superScript > 0) {
            subscriptButton.setSelected(false);
            superScriptButton.setSelected(true);
        }
        Color fontColor = fontStyle.getFontColor();
        CustomColorChooserDialog dialog = ObjectTable.getCustomColorChooserDialog();
        dialog.setPreviewColor(fontColor, "font color");
    }

    private static FontStyle getCommonFontStyle(AttributedCharacterIterator text, int start, int end) {
        int iend;
        int istart;
        int iend2;
        int istart2;
        FontStyle fontStyle = new FontStyle();
        boolean ret = FontStyle.rangeError(text, start, end, "*** Error: FontStyle.getCommonFontStyle");
        if (ret) {
            return fontStyle;
        }
        if (debug > 0) {
            System.out.println("FontStyle.getCommonFontStyle  start=" + start + ", end=" + end);
        }
        AttributedStringUtil util = new AttributedStringUtil(text);
        String string = util.getString();
        if (debug > 0) {
            System.out.println("FontStyle.getCommonFontStyle fontColor, start=" + start + ", end=" + end + "\n" + util.toString());
        }
        AttributedInterval[] intervals = new AttributedInterval[]{};
        String fontFamily = UNDEF_string;
        String currentFontFamily = UNDEF_string;
        intervals = util.getAttributedIntervals(TextAttribute.FAMILY, start, end);
        if (debug > 0) {
            System.out.println("\n** FontStyle.getInvariantFontStyle fontFamily, start=" + start + ", end=" + end + "\n" + AttributedInterval.toString(intervals));
        }
        if (intervals.length > 0) {
            fontFamily = (String)intervals[0].getValue();
            for (int i = 1; i < intervals.length; ++i) {
                int iend3;
                currentFontFamily = (String)intervals[i].getValue();
                int istart3 = intervals[i].getStart();
                if (string.substring(istart3, iend3 = intervals[i].getEnd()).equals("\n") || fontFamily.equals(currentFontFamily)) continue;
                fontFamily = UNDEF_string;
            }
        }
        intervals = util.getAttributedIntervals(TextAttribute.WEIGHT, start, end);
        if (debug > 0) {
            System.out.println("\n** FontStyle.getInvariantFontStyle bold, start=" + start + ", end=" + end + "\n" + AttributedInterval.toString(intervals));
        }
        int bold = -99;
        if (intervals.length > 0) {
            float weight = ((Float)intervals[0].getValue()).floatValue();
            bold = weight == TextAttribute.WEIGHT_BOLD.floatValue() ? 1 : 0;
            for (int i = 1; i < intervals.length; ++i) {
                float currentWeight = ((Float)intervals[0].getValue()).floatValue();
                int currentBold = currentWeight == TextAttribute.WEIGHT_BOLD.floatValue() ? 1 : 0;
                istart2 = intervals[i].getStart();
                if (string.substring(istart2, iend2 = intervals[i].getEnd()).equals("\n") || currentBold == bold) continue;
                bold = -99;
            }
        }
        intervals = util.getAttributedIntervals(TextAttribute.POSTURE, start, end);
        if (debug > 0) {
            System.out.println("\n** FontStyle.getInvariantFontStyle italic, start=" + start + ", end=" + end + "\n" + AttributedInterval.toString(intervals));
        }
        int italic = -99;
        if (intervals.length > 0) {
            float posture = ((Float)intervals[0].getValue()).floatValue();
            italic = posture == TextAttribute.POSTURE_OBLIQUE.floatValue() ? 1 : 0;
            for (int i = 1; i < intervals.length; ++i) {
                float currentPosture = ((Float)intervals[0].getValue()).floatValue();
                int currentItalic = currentPosture == TextAttribute.POSTURE_OBLIQUE.floatValue() ? 1 : 0;
                istart = intervals[i].getStart();
                if (string.substring(istart, iend = intervals[i].getEnd()).equals("\n") || currentItalic == italic) continue;
                italic = -99;
            }
        }
        int size = -99;
        intervals = util.getAttributedIntervals(TextAttribute.SIZE, start, end);
        if (debug > 0) {
            System.out.println("\n** FontStyle.getInvariantFontStyle font size, start=" + start + ", end=" + end + "\n" + AttributedInterval.toString(intervals));
        }
        if (intervals.length > 0) {
            size = (Integer)intervals[0].getValue();
            for (int i = 1; i < intervals.length; ++i) {
                int currentSize = (Integer)intervals[i].getValue();
                istart2 = intervals[i].getStart();
                if (string.substring(istart2, iend2 = intervals[i].getEnd()).equals("\n") || currentSize == size) continue;
                size = -99;
            }
        }
        int underLine = -99;
        intervals = util.getAttributedIntervals(TextAttribute.UNDERLINE, start, end);
        if (debug > 0) {
            System.out.println("\n** FontStyle.getInvariantFontStyle underline, start=" + start + ", end=" + end + "\n" + AttributedInterval.toString(intervals));
        }
        if (intervals.length > 0) {
            underLine = (Integer)intervals[0].getValue();
            for (int i = 1; i < intervals.length; ++i) {
                int currentUnderLine = (Integer)intervals[0].getValue();
                istart = intervals[i].getStart();
                if (string.substring(istart, iend = intervals[i].getEnd()).equals("\n") || currentUnderLine == underLine) continue;
                underLine = -99;
            }
        }
        int superScript = -99;
        intervals = util.getAttributedIntervals(TextAttribute.SUPERSCRIPT, start, end);
        if (debug > 0) {
            System.out.println("\n** FontStyle.getInvariantFontStyle superscript, start=" + start + ", end=" + end + "\n" + AttributedInterval.toString(intervals));
        }
        if (intervals.length > 0) {
            superScript = (Integer)intervals[0].getValue();
            for (int i = 1; i < intervals.length; ++i) {
                int iend4;
                int currentSuperScript = (Integer)intervals[i].getValue();
                int istart4 = intervals[i].getStart();
                if (string.substring(istart4, iend4 = intervals[i].getEnd()).equals("\n") || currentSuperScript == superScript) continue;
                superScript = -99;
            }
        }
        Color color = null;
        Color currentColor = null;
        intervals = util.getAttributedIntervals(TextAttribute.FOREGROUND, start, end);
        if (debug > 0) {
            System.out.println("\n** FontStyle.getInvariantFontStyle fontColor, start=" + start + ", end=" + end + "\n" + AttributedInterval.toString(intervals));
        }
        if (intervals.length > 0) {
            color = (Color)intervals[0].getValue();
            for (int i = 1; i < intervals.length; ++i) {
                int iend5;
                currentColor = (Color)intervals[i].getValue();
                int istart5 = intervals[i].getStart();
                if (string.substring(istart5, iend5 = intervals[i].getEnd()).equals("\n") || currentColor == color) continue;
                color = null;
            }
        }
        fontStyle = new FontStyle(fontFamily, bold, italic, size, underLine, superScript, color);
        if (debug > 0) {
            System.out.println(" - FontStyle.getInvariantFontStyle(AttributedCharacters), fontStyle " + fontStyle.toString());
        }
        return fontStyle;
    }

    private static FontStyle getCommonFontStyle(TextBox[] textBoxes) {
        int i;
        FontStyle commonFontStyle = new FontStyle();
        FontStyle[] fontStyles = new FontStyle[textBoxes.length];
        if (textBoxes == null || textBoxes.length == 0) {
            return commonFontStyle;
        }
        for (i = 0; i < textBoxes.length; ++i) {
            AttributedString attribSTring = textBoxes[i].getCommittedTextContainer().getAttributedString();
            if (attribSTring == null) continue;
            AttributedCharacterIterator iterator = attribSTring.getIterator();
            int start = iterator.getBeginIndex();
            int end = iterator.getEndIndex();
            if (debug > 0) {
                System.out.println("FontStyle.getCommonFontStyle(TextBox[])  shapeId=" + textBoxes[i].getShapeContainer().getShapeId() + ", start=" + start + ", end=" + end);
            }
            fontStyles[i] = FontStyle.getCommonFontStyle(iterator, start, end);
        }
        if (debug > 0) {
            for (i = 0; i < fontStyles.length; ++i) {
                System.out.println("FontStyle.getCommonFontStyle(TextBox[]) FontStyles fontStyle[" + i + "]:" + fontStyles[i].toString());
            }
        }
        int index = -1;
        for (int i2 = 0; i2 < textBoxes.length; ++i2) {
            if (fontStyles[i2] == null) continue;
            index = i2;
        }
        if (index < 0) {
            return commonFontStyle;
        }
        String fontFamily = fontStyles[index].getFontFamily();
        int bold = fontStyles[index].getBold();
        int italic = fontStyles[index].getItalic();
        int size = fontStyles[index].getFontSize();
        int underLine = fontStyles[index].getUnderLine();
        int superScript = fontStyles[index].getSuperScript();
        Color color = fontStyles[index].getFontColor();
        for (int i3 = index + 1; i3 < fontStyles.length; ++i3) {
            if (fontStyles[i3] == null) continue;
            if (!fontStyles[i3].getFontFamily().equals(fontFamily)) {
                fontFamily = UNDEF_string;
            }
            if (fontStyles[i3].getBold() != bold) {
                bold = -99;
            }
            if (fontStyles[i3].getItalic() != italic) {
                italic = -99;
            }
            if (fontStyles[i3].getFontSize() != size) {
                size = -99;
            }
            if (fontStyles[i3].getUnderLine() != underLine) {
                underLine = -99;
            }
            if (fontStyles[i3].getSuperScript() != superScript) {
                superScript = -99;
            }
            if (fontStyles[i3].getFontColor() == color) continue;
            color = null;
        }
        commonFontStyle = new FontStyle(fontFamily, bold, italic, size, underLine, superScript, color);
        if (debug > 0) {
            System.out.println(" - FontStyle.getCommonFontStyle(textBoxes), fontStyle " + commonFontStyle.toString());
        }
        return commonFontStyle;
    }

    public static FontStyle getFontStyleAt(AttributedCharacterIterator text, int position) {
        FontStyle fontStyle = FontStyle.getDefaultFontStyle();
        boolean ret = FontStyle.rangeError(text, position, "*** Error: FontStyle.getFontStyleAt");
        if (ret) {
            return fontStyle;
        }
        if (text == null) {
            return fontStyle;
        }
        int start = text.getBeginIndex();
        int end = text.getEndIndex();
        int pos = position;
        AttributedStringUtil util = new AttributedStringUtil(text);
        if (position == 0) {
            for (int i = 0; i <= end; ++i) {
                if (util.getString(i, i + 1).equals("\n")) continue;
                fontStyle = FontStyle.getCommonFontStyle(text, i, i + 1);
                break;
            }
        } else {
            for (int i = position - 1; i >= 0; --i) {
                if (util.getString(i, i + 1).equals("\n")) continue;
                fontStyle = FontStyle.getCommonFontStyle(text, i, i + 1);
                break;
            }
        }
        return fontStyle;
    }

    public static boolean isFontStyle(AttributedCharacterIterator text, int start, int end) {
        boolean ret = FontStyle.rangeError(text, start, end, "*** Error: FontStyle.isFontStyle");
        if (ret) {
            return false;
        }
        AttributedStringUtil util = new AttributedStringUtil(text);
        String fontAttrib = "";
        AttributedInterval[] intervals = util.getAttributedIntervals(TextAttribute.FAMILY, start, end);
        if (intervals.length > 0) {
            fontAttrib = fontAttrib + "font.family";
        }
        if ((intervals = util.getAttributedIntervals(TextAttribute.WEIGHT, start, end)).length > 0) {
            fontAttrib = fontAttrib + "+plain/bold";
        }
        if ((intervals = util.getAttributedIntervals(TextAttribute.POSTURE, start, end)).length > 0) {
            fontAttrib = fontAttrib + "+italic";
        }
        if ((intervals = util.getAttributedIntervals(TextAttribute.SIZE, start, end)).length > 0) {
            fontAttrib = fontAttrib + "+font.size";
        }
        if ((intervals = util.getAttributedIntervals(TextAttribute.UNDERLINE, start, end)).length > 0) {
            fontAttrib = fontAttrib + "+underline";
        }
        if ((intervals = util.getAttributedIntervals(TextAttribute.SUPERSCRIPT, start, end)).length > 0) {
            fontAttrib = fontAttrib + "+superscript";
        }
        if ((intervals = util.getAttributedIntervals(TextAttribute.FOREGROUND, start, end)).length > 0) {
            fontAttrib = fontAttrib + "+font.color";
        }
        if (fontAttrib.equals("")) {
            return false;
        }
        if (debug > 0) {
            System.out.println("** FontStyle.isFontStyle fontAttrib=" + fontAttrib);
        }
        return true;
    }

    public static boolean isDefaultFontStyle(FontStyle fontStyle) {
        Color color;
        int underLine;
        int superScript;
        int size;
        int italic;
        int bold;
        FontStyle defaultStyle = FontStyle.getDefaultFontStyle();
        boolean isDefault = true;
        String family = fontStyle.getFontFamily();
        if (!family.equals(UNDEF_string) && !family.equals(defaultStyle.getFontFamily())) {
            isDefault = false;
        }
        if ((bold = fontStyle.getBold()) != -99 && bold != defaultStyle.getBold()) {
            isDefault = false;
        }
        if ((italic = fontStyle.getItalic()) != -99 && italic != defaultStyle.getItalic()) {
            isDefault = false;
        }
        if ((size = fontStyle.getFontSize()) != -99 && size != defaultStyle.getFontSize()) {
            isDefault = false;
        }
        if ((superScript = fontStyle.getSuperScript()) != -99 && superScript != defaultStyle.getSuperScript()) {
            isDefault = false;
        }
        if ((underLine = fontStyle.getUnderLine()) != -99 && underLine != defaultStyle.getUnderLine()) {
            isDefault = false;
        }
        if ((color = fontStyle.getFontColor()) != null && !color.equals(Color.BLACK)) {
            isDefault = false;
        }
        if (debug > 0) {
            System.out.println("FontStyle.isDefaultFontStyle  isDefault=" + isDefault + ", fontStyle=" + fontStyle);
        }
        return isDefault;
    }

    private static void rangeCheck(int index, int indexMax) throws RangeException {
        if (index < 0 || index > indexMax) {
            throw new RangeException();
        }
    }

    private static boolean rangeError(AttributedCharacterIterator text, int pos, String errMessage) {
        int beginIndex = -1;
        int endIndex = -1;
        if (text != null) {
            beginIndex = text.getBeginIndex();
            endIndex = text.getEndIndex();
        }
        boolean ret = false;
        try {
            FontStyle.rangeCheck(pos, endIndex);
        }
        catch (RangeException e) {
            System.err.println(errMessage + " pos=" + pos + ", range=" + beginIndex + "," + endIndex);
            e.printStackTrace();
            ret = true;
        }
        return ret;
    }

    private static boolean rangeError(AttributedCharacterIterator text, int start, int end, String errMessage) {
        int beginIndex = -1;
        int endIndex = -1;
        if (text != null) {
            beginIndex = text.getBeginIndex();
            endIndex = text.getEndIndex();
        }
        boolean ret = false;
        try {
            FontStyle.rangeCheck(start, end);
            FontStyle.rangeCheck(end, endIndex);
        }
        catch (RangeException e) {
            System.err.println(errMessage + " start=" + start + ", end=" + end + ", range=" + beginIndex + "," + endIndex);
            e.printStackTrace();
            ret = true;
        }
        return ret;
    }

    static class RangeException
    extends Exception {
        RangeException() {
        }

        @Override
        public String toString() {
            return "range Exception";
        }
    }
}

