/*
 * Decompiled with CFR 0.152.
 */
package util;

import DrawTop.ObjectTable;
import geomExtension.SerializableCurve2D;
import java.awt.Color;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import shape.GroupElement;
import shape.SerializableElement;
import shape.SerializableElementUtil;
import shape.ShapeContainer;
import textBox.SerializableAttributedString;
import util.PageData;
import util.UndoDrawManager;
import util.ViewData;

public class DrawFileIo {
    public final String[] versions = new String[]{"ver0.0", "ver1.0", "ver1_0"};
    private int depth = 0;
    public int debug = 0;

    public void writePageList(String filePath, ArrayList outputPageList) throws Exception {
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(filePath));
        int size = outputPageList.size();
        if (this.debug > 0) {
            System.out.println(" -- write file ver0.0, total page=" + size);
        }
        try {
            out.writeUTF(this.versions[2]);
            out.writeInt(size);
            for (int i = 0; i < size; ++i) {
                PageData outputPageData = (PageData)outputPageList.get(i);
                ViewData.writeViewData(out, outputPageData.viewData, this.versions[2]);
                this.writeContainerList(i, out, this.versions[2], outputPageData.ContainerList);
            }
        }
        catch (Exception e) {
            System.err.println("*** Error writeOutputPageList e=" + e);
            e.printStackTrace();
        }
        out.close();
    }

    public void writeContainerList(int page, ObjectOutputStream out, String version, ArrayList containerList) {
        ArrayList serializableElementList = new ArrayList();
        this.convertContainerList(containerList, serializableElementList);
        int size = serializableElementList.size();
        try {
            out.writeUTF(version);
            out.writeInt(size);
            for (int i = 0; i < size; ++i) {
                SerializableElement sShape = (SerializableElement)serializableElementList.get(i);
                this.writeSerializableElement(out, sShape);
            }
        }
        catch (Exception e) {
            System.err.println("*** Error writeContainerList e~" + e);
            e.printStackTrace();
        }
    }

    public void convertContainerList(ArrayList containerList, ArrayList serializableElementList) {
        int size = containerList.size();
        for (int i = 0; i < size; ++i) {
            ShapeContainer container = (ShapeContainer)containerList.get(i);
            SerializableElement[] sElements = this.convertShapeContainer(container);
            for (int j = 0; j < sElements.length; ++j) {
                serializableElementList.add(sElements[j]);
            }
        }
        if (this.debug > 0) {
            System.out.println("\n*** DrawFileIo convertContainerList before convert ***");
            this.printContainerList("out", "Print ContainerList", containerList);
            System.out.println("\n*** DrawFileIo convertContainerList after convert ***");
            this.printSerializableElementList("out", "Print SerializableElementList", serializableElementList);
        }
    }

    public SerializableElement[] convertShapeContainer(ShapeContainer container) {
        SerializableElement[] sElements = null;
        sElements = container.getContainerType() == ShapeContainer.SHAPE ? new SerializableElement[]{SerializableElementUtil.convertSingleContainer(container)} : this.convertGroupContainer(container);
        return sElements;
    }

    public SerializableElement[] convertGroupContainer(ShapeContainer container) {
        SerializableElement[] sElements = null;
        ShapeContainer[] containers = container.getGroupedContainers();
        sElements = new SerializableElement[containers.length];
        for (int i = 0; i < containers.length; ++i) {
            sElements[i] = SerializableElementUtil.convertShapeContainer(containers[i]);
            if (sElements[i].containerType != ShapeContainer.GROUP) continue;
            ArrayList childrenList = sElements[i].childrenList;
            for (int j = 0; j < childrenList.size(); ++j) {
                String shapeId = ((SerializableElement)childrenList.get((int)j)).shapeId;
                sElements[i].childrenList.set(j, shapeId);
            }
        }
        return sElements;
    }

    public void writeSerializableElement(ObjectOutputStream out, SerializableElement sElement) throws Exception {
        try {
            out.writeUTF(this.versions[1]);
            out.writeInt(sElement.containerType);
            out.writeInt(sElement.containerIndex);
            out.writeUTF(sElement.parent);
            out.writeUTF(sElement.elementType);
            out.writeUTF(sElement.shapeId);
            out.writeObject(sElement.date);
            out.writeUTF(sElement.fileNameAndPage);
            out.writeBoolean(sElement.connectorTargetPermission);
            out.writeBoolean(sElement.connectorPermission);
            out.writeObject(sElement.property);
            int ret = SerializableCurve2D.writeSerializableCurve2D(out, sElement.serializableCurve2D);
            out.writeObject(sElement.fillColor);
            out.writeObject(sElement.lineColor);
            out.writeFloat(sElement.lineWidth);
            out.writeUTF(sElement.dashedStyle);
            out.writeObject(sElement.dash);
            out.writeInt(sElement.arrowStyle);
            out.writeInt(sElement.startArrowType);
            out.writeInt(sElement.endArrowType);
            out.writeObject(sElement.textArea);
            SerializableAttributedString.writeSerializableAttributedString(out, sElement.attributedString);
            out.writeObject(sElement.textBoxInsets);
            out.writeInt(sElement.textAlign);
            out.writeInt(sElement.lineSpace);
            out.writeObject(sElement.imageByteData);
            out.writeObject(sElement.childrenList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList readPageList(String filePath) throws Exception {
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(filePath));
        ArrayList<PageData> newPageList = new ArrayList<PageData>();
        try {
            String version = in.readUTF();
            if (!version.equals(this.versions[1]) && !version.equals(this.versions[2])) {
                String str = "Cannot read the old draw file (version 0_0)";
                JOptionPane.showMessageDialog(ObjectTable.getDrawMain(), str, "", 0);
                in.close();
                return newPageList;
            }
        }
        catch (Exception e) {
            System.err.println("*** Error readOutputPageList e=" + e);
            e.printStackTrace();
            in.close();
            return newPageList;
        }
        try {
            int numpage = in.readInt();
            if (this.debug > 0) {
                System.out.println(" -- Read file total page=" + numpage);
            }
            for (int i = 0; i < numpage; ++i) {
                ViewData viewData = ViewData.readViewData(in);
                ArrayList containerList = this.readContainerList(i + 1, in);
                PageData pageData = new PageData(containerList, viewData, new UndoDrawManager());
                newPageList.add(pageData);
            }
        }
        catch (Exception e) {
            System.err.println("*** Error readOutputPageList e=" + e);
            e.printStackTrace();
            in.close();
            return newPageList;
        }
        in.close();
        return newPageList;
    }

    public ArrayList readContainerList(int page, ObjectInputStream in) throws Exception {
        ArrayList<SerializableElement> serializableElementList = new ArrayList<SerializableElement>();
        ArrayList containerList = new ArrayList();
        try {
            String version = in.readUTF();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                SerializableElement sElement = this.readSerializableElement(in);
                serializableElementList.add(sElement);
            }
        }
        catch (Exception e) {
            System.out.println("*** Error readSerializableElementList e=" + e);
            e.printStackTrace();
        }
        DupicatedTable dupTabel = new DupicatedTable(serializableElementList);
        if (dupTabel.isDuplicated()) {
            String fileName = ObjectTable.getFileIo().getCurrentSimpleFileName();
            String message = "\n*** Warning: page-" + page + "  The shapeId numbers are Duplicated ! ***\n file Name=" + fileName + "  => Recovered";
            System.err.println(message);
            System.out.println(message);
            String str = "";
            str = str + "\n*** Error in DrawFileIo shapeId numbers duplicated page=" + page + "\n";
            str = str + dupTabel.toString();
            System.err.println(str);
            RenameTable table = new RenameTable(serializableElementList);
            table.exec();
            str = "";
            str = "\n** DrawFileIo.renumbering " + table.toString();
            System.err.println(str);
            this.printSerializableElementList("err", "\n** readContainerList Print SerializableElementList after renumbering=" + page, serializableElementList);
        }
        this.invertContainerList(containerList, serializableElementList);
        if (dupTabel.isDuplicated()) {
            this.printContainerList("err", "\n** readContainerList Print ContainerList after readContainerList page=" + page, containerList);
        }
        if (this.debug > 0) {
            this.printContainerList("out", "\n** readContainerList Print ContainerList after readContainerList page=" + page, containerList);
        }
        return containerList;
    }

    private SerializableElement getSerializableElement(String shapeId, ArrayList sElementList) {
        SerializableElement target = null;
        int size = sElementList.size();
        for (int i = 0; i < size; ++i) {
            SerializableElement element = (SerializableElement)sElementList.get(i);
            if (!element.shapeId.equals(shapeId)) continue;
            target = element;
            break;
        }
        return target;
    }

    private int removeSerializableElement(String shapeId, ArrayList sElementList) {
        Object target = null;
        int size = sElementList.size();
        int pos = -1;
        for (int i = 0; i < size; ++i) {
            SerializableElement element = (SerializableElement)sElementList.get(i);
            if (!element.shapeId.equals(shapeId)) continue;
            pos = i;
            sElementList.remove(element);
            break;
        }
        if (this.debug > 0) {
            System.out.println("removeSerializableElement shapeId=" + shapeId + ", pos=" + pos);
        }
        return pos;
    }

    public SerializableElement readSerializableElement(ObjectInputStream in) throws Exception {
        SerializableElement sElement = new SerializableElement();
        try {
            String version = in.readUTF();
            sElement.containerType = in.readInt();
            sElement.containerIndex = in.readInt();
            sElement.parent = in.readUTF();
            sElement.elementType = in.readUTF();
            sElement.shapeId = in.readUTF();
            sElement.date = (Date)in.readObject();
            sElement.fileNameAndPage = in.readUTF();
            sElement.connectorTargetPermission = in.readBoolean();
            sElement.connectorPermission = in.readBoolean();
            if (version.equals(this.versions[1])) {
                sElement.property = (HashMap)in.readObject();
            }
            sElement.serializableCurve2D = SerializableCurve2D.readSerializableCurve2D(in);
            sElement.fillColor = (Color)in.readObject();
            sElement.lineColor = (Color)in.readObject();
            sElement.lineWidth = in.readFloat();
            sElement.dashedStyle = in.readUTF();
            sElement.dash = (float[])in.readObject();
            sElement.arrowStyle = in.readInt();
            sElement.startArrowType = in.readInt();
            sElement.endArrowType = in.readInt();
            sElement.textArea = (Rectangle2D)in.readObject();
            sElement.attributedString = SerializableAttributedString.readSerializableAttributedString(in);
            sElement.textBoxInsets = (Insets)in.readObject();
            sElement.textAlign = in.readInt();
            sElement.lineSpace = in.readInt();
            sElement.imageByteData = (byte[])in.readObject();
            sElement.childrenList = (ArrayList)in.readObject();
        }
        catch (Exception e) {
            System.err.println("*** Error readSerializableElement e=" + e);
            e.printStackTrace();
        }
        return sElement;
    }

    private void invertContainerList(ArrayList containerList, ArrayList serializableElementList) throws Exception {
        int size = serializableElementList.size();
        for (int i = 0; i < size; ++i) {
            SerializableElement sElement = (SerializableElement)serializableElementList.get(i);
            String parent = sElement.parent;
            if (parent != null && !parent.equals("")) continue;
            ShapeContainer container = this.invertShapeContainer(sElement, serializableElementList);
            containerList.add(container);
        }
        if (this.debug > 0) {
            System.out.println("\n** DrawFileIo invertContainerList before invert **");
            this.printSerializableElementList("out", "Print SerializableElementList", serializableElementList);
            System.out.println("\n** DrawFileIo invertContainerList after invert **");
            this.printContainerList("out", "Print ContainerList ", containerList);
        }
    }

    public ShapeContainer invertShapeContainer(SerializableElement sElement, ArrayList serializableElementList) {
        if (this.debug > 0) {
            System.out.println("\n** DrawFileIo invertShapeContainer before invert, sElement=" + sElement.shapeId + " **");
            System.out.println("Print SerializableElement\n" + sElement.toShortString());
        }
        ShapeContainer container = new ShapeContainer();
        if (sElement.containerType == ShapeContainer.SHAPE) {
            container = SerializableElementUtil.invertSingleContainer(sElement);
        } else {
            if (this.debug > 0) {
                System.out.println("- DrawFileIo invertShapeContainer group");
            }
            container = SerializableElementUtil.invertGroupContainer(sElement);
            GroupElement groupElement = (GroupElement)container.getElement();
            ArrayList childrenList = (ArrayList)sElement.childrenList.clone();
            for (int j = 0; j < childrenList.size(); ++j) {
                ShapeContainer childContainer;
                String childShapeId = (String)childrenList.get(j);
                SerializableElement childData = this.getSerializableElement(childShapeId, serializableElementList);
                if (this.debug > 0) {
                    System.out.println("--  DrawFileIo invertShapeContainer --");
                    System.out.println(" - childData[=" + j + "]" + childData.toShortString());
                }
                if ((childContainer = this.invertShapeContainer(childData, serializableElementList)) == null) continue;
                groupElement.addChildren(childContainer);
                childContainer.setParent(container);
            }
        }
        container.setSelected(false);
        if (this.debug > 0) {
            System.out.println("\n** DrawFileIo invertShapeContainer after invert, sElement=" + sElement.shapeId + " **");
            System.out.println("Print ShapeContainer\n" + container.toVeryShortString());
        }
        return container;
    }

    public SerializableElement getPerfectSerializableElement(SerializableElement sElement, ArrayList serializableElementList) {
        ++this.depth;
        if (this.debug > 0) {
            System.out.println("** getPerfectSerializableElement start depth=" + this.depth + "\n - sElement=" + sElement.toVeryShortString() + "\n--> getPerfectSerializableElement start end");
        }
        if (sElement.containerType == ShapeContainer.SHAPE) {
            return sElement;
        }
        if (this.debug > 0) {
            System.out.println("   -- sElement.childrenList.size()=" + sElement.childrenList.size());
        }
        String ObjectName = sElement.childrenList.get(0).getClass().getSimpleName();
        for (int i = 0; i < sElement.childrenList.size(); ++i) {
            if (ObjectName.equals("String")) {
                String shapeId = (String)sElement.childrenList.get(i);
                SerializableElement childElement = this.getSerializableElement(shapeId, serializableElementList);
                if (this.debug > 0) {
                    System.out.println("  - ObjectName=" + ObjectName + ": childElement[" + i + "]=" + childElement.shapeId + ", containerType=" + childElement.containerType + ", parent=" + childElement.parent + ", children=" + childElement.childrenList.size());
                }
                if (childElement.containerType == ShapeContainer.SHAPE) {
                    sElement.childrenList.set(i, childElement);
                    int n = this.removeSerializableElement(shapeId, serializableElementList);
                    continue;
                }
                SerializableElement perfectChildElement = this.getPerfectSerializableElement(childElement, serializableElementList);
                sElement.childrenList.set(i, perfectChildElement);
                int n = this.removeSerializableElement(shapeId, serializableElementList);
                continue;
            }
            SerializableElement childElement = (SerializableElement)sElement.childrenList.get(i);
            if (this.debug <= 0) continue;
            System.out.println("  - ObjectName=" + ObjectName + ": childElement[" + i + "]=" + childElement.shapeId + ", parent=" + childElement.parent + ", children=" + childElement.childrenList.size());
        }
        if (this.debug > 0) {
            System.out.println("** getPerfectSerializableElement return depth=" + this.depth + "\n - sElement=" + sElement.toVeryShortString() + "\n--> getPerfectSerializableElement return end");
        }
        --this.depth;
        return sElement;
    }

    private void printContainerList(String out, String title, ArrayList containerList) {
        String str = "";
        str = str + title + "\n";
        for (int i = 0; i < containerList.size(); ++i) {
            ShapeContainer container = (ShapeContainer)containerList.get(i);
            str = str + " - Container[" + i + "]=" + container.toVeryShortString() + "\n";
        }
        if (out.equals("out")) {
            System.out.println(str);
        } else if (out.equals("err")) {
            System.err.println(str);
        }
    }

    private void printSerializableElementList(String out, String title, ArrayList sElementList) {
        String str = "";
        str = str + title + "\n";
        for (int i = 0; i < sElementList.size(); ++i) {
            SerializableElement sElement = (SerializableElement)sElementList.get(i);
            str = str + " - SerializableElement[" + i + "]=" + sElement.toVeryShortString() + "\n";
        }
        if (out.equals("out")) {
            System.out.println(str);
        } else if (out.equals("err")) {
            System.err.println(str);
        }
    }

    private void printPerfectSerializableElementList(String out, String title, ArrayList sElementList) {
        String str = "";
        str = str + title + "\n";
        for (int i = 0; i < sElementList.size(); ++i) {
            SerializableElement sElement = (SerializableElement)sElementList.get(i);
            sElement = this.getPerfectSerializableElement(sElement, sElementList);
            str = str + " - SerializableElement[" + i + "]=" + sElement.toVeryShortString() + "\n";
        }
        if (out.equals("out")) {
            System.out.println(str);
        } else if (out.equals("err")) {
            System.err.println(str);
        }
    }

    class Element {
        String shapeId = "";
        String newShapeId = "";
        boolean group = false;
        boolean used = false;
        String parent = "";
        String newParent = "";
        String[] childrenShapeIdList = new String[0];
        String[] childrenNewShapeIdList = new String[0];
        int[] childrenId = new int[0];

        Element() {
        }

        public String changeShapeIdNumber(String shapeId, int number) {
            String newShapeId = "";
            int id = shapeId.indexOf("(");
            newShapeId = shapeId.substring(0, id);
            newShapeId = newShapeId + "(No-" + number + ")";
            return newShapeId;
        }

        public String toString() {
            int size;
            String str = "";
            str = str + "shapeId=" + this.shapeId + ", newShapeId=" + this.newShapeId;
            if (this.group) {
                str = str + ", group";
            }
            if (this.parent != null && !this.parent.equals("")) {
                str = str + ", parent=" + this.parent;
            }
            if (this.newParent != null && !this.newParent.equals("")) {
                str = str + ", newParent=" + this.newParent;
            }
            if ((size = this.childrenShapeIdList.length) == 0) {
                return str;
            }
            str = str + "\n";
            for (int i = 0; i < size; ++i) {
                String childName = this.childrenShapeIdList[i];
                str = str + "    child[" + i + "]: shapeId=" + childName + ", id=" + this.childrenId[i] + ", newShapeId=" + this.childrenNewShapeIdList[i];
                if (i >= size - 1) continue;
                str = str + "\n";
            }
            return str;
        }
    }

    class RenameTable {
        ArrayList ElementTable = new ArrayList();
        ArrayList serializableElementList;

        RenameTable(ArrayList serializableElementList) {
            this.serializableElementList = serializableElementList;
        }

        void exec() {
            this.setElements();
            this.setChildrenIndex();
            this.initUsedFlag();
            this.setNewShapeId();
            this.setNewChildrenShapeId();
            this.setNewParentShapeId();
            this.setToSerializableElementList();
        }

        void setElements() {
            int size = this.serializableElementList.size();
            for (int i = 0; i < size; ++i) {
                SerializableElement sElement = (SerializableElement)this.serializableElementList.get(i);
                Element element = new Element();
                element.shapeId = sElement.shapeId;
                element.parent = sElement.parent;
                if (sElement.containerType == ShapeContainer.GROUP) {
                    element.group = true;
                    ArrayList childrenList = sElement.childrenList;
                    int listSize = childrenList.size();
                    element.childrenShapeIdList = new String[listSize];
                    element.childrenNewShapeIdList = new String[listSize];
                    element.childrenId = new int[listSize];
                    for (int j = 0; j < listSize; ++j) {
                        element.childrenShapeIdList[j] = (String)sElement.childrenList.get(j);
                        element.childrenNewShapeIdList[j] = "";
                        element.childrenId[j] = -1;
                    }
                }
                this.ElementTable.add(element);
            }
        }

        void setChildrenIndex() {
            int size = this.ElementTable.size();
            Object elm = null;
            for (int i = 0; i < size; ++i) {
                int num;
                Element element = (Element)this.ElementTable.get(i);
                if (element.used || !element.group || (num = element.childrenShapeIdList.length) == 0) continue;
                element.childrenId = new int[num];
                for (int j = 0; j < num; ++j) {
                    String childName = element.childrenShapeIdList[j];
                    int[] indices = this.getElementIndex(childName, false);
                    if (indices.length == 0) continue;
                    element.childrenId[j] = indices[0];
                    Element childElm = (Element)this.ElementTable.get(indices[0]);
                    childElm.used = true;
                }
            }
        }

        int[] getElementIndex(String shapeId, boolean newId) {
            int size = this.ElementTable.size();
            Vector<Integer> vector = new Vector<Integer>();
            Object elm = null;
            for (int i = 0; i < size; ++i) {
                Element element = (Element)this.ElementTable.get(i);
                if (element.used) continue;
                if (newId) {
                    if (!element.newShapeId.equals(shapeId)) continue;
                    vector.add(i);
                    continue;
                }
                if (!element.shapeId.equals(shapeId)) continue;
                vector.add(i);
            }
            size = vector.size();
            int[] indices = new int[size];
            for (int i = 0; i < size; ++i) {
                Integer num = (Integer)vector.get(i);
                indices[i] = num;
            }
            return indices;
        }

        void initUsedFlag() {
            int size = this.ElementTable.size();
            Object elm = null;
            for (int i = 0; i < size; ++i) {
                Element element = (Element)this.ElementTable.get(i);
                element.used = false;
            }
        }

        void setNewShapeId() {
            int size = this.ElementTable.size();
            Object elm = null;
            for (int i = 0; i < size; ++i) {
                String newShapeId;
                Element element = (Element)this.ElementTable.get(i);
                String shapeId = element.shapeId;
                element.newShapeId = newShapeId = element.changeShapeIdNumber(shapeId, i);
            }
        }

        private void setNewChildrenShapeId() {
            int size = this.ElementTable.size();
            Object elm = null;
            for (int i = 0; i < size; ++i) {
                int num;
                Element element = (Element)this.ElementTable.get(i);
                if (!element.group || (num = element.childrenShapeIdList.length) == 0) continue;
                for (int j = 0; j < num; ++j) {
                    Element childElm = (Element)this.ElementTable.get(element.childrenId[j]);
                    element.childrenNewShapeIdList[j] = childElm.newShapeId;
                }
            }
        }

        private void setNewParentShapeId() {
            int size = this.ElementTable.size();
            Object elm = null;
            for (int i = 0; i < size; ++i) {
                Element[] parentElms;
                Element element = (Element)this.ElementTable.get(i);
                if (element.parent.equals("") || (parentElms = this.getElements(element.parent)).length == 0) continue;
                element.newParent = parentElms[0].newShapeId;
            }
        }

        Element[] getElements(String shapeId) {
            int size = this.ElementTable.size();
            Vector<Element> vector = new Vector<Element>();
            Object elm = null;
            for (int i = 0; i < size; ++i) {
                Element element = (Element)this.ElementTable.get(i);
                if (!element.shapeId.equals(shapeId)) continue;
                vector.add(element);
            }
            size = vector.size();
            Element[] elms = new Element[size];
            for (int i = 0; i < size; ++i) {
                elms[i] = (Element)vector.get(i);
            }
            return elms;
        }

        void setToSerializableElementList() {
            int size = this.serializableElementList.size();
            for (int i = 0; i < size; ++i) {
                SerializableElement sElement = (SerializableElement)this.serializableElementList.get(i);
                Element element = (Element)this.ElementTable.get(i);
                sElement.shapeId = element.newShapeId;
                sElement.parent = element.newParent;
                if (sElement.containerType != ShapeContainer.GROUP) continue;
                ArrayList childrenList = sElement.childrenList;
                int listSize = childrenList.size();
                for (int j = 0; j < listSize; ++j) {
                    sElement.childrenList.set(j, element.childrenNewShapeIdList[j]);
                }
            }
        }

        public String toString() {
            int size = this.ElementTable.size();
            String str = "";
            if (size == 0) {
                str = "RenameTable is empty";
                return str;
            }
            str = "RenameTable size=" + size + "\n";
            for (int i = 0; i < size; ++i) {
                Element element = (Element)this.ElementTable.get(i);
                str = str + " - element[" + i + "]  " + element.toString() + "\n";
            }
            return str;
        }
    }

    class DuplicatedInfo {
        int dupNumber = -1;
        String shapeId1 = "";
        String shapeId2 = "";

        public DuplicatedInfo(int dupNumber, String shapeId1, String shapeId2) {
            this.dupNumber = dupNumber;
            this.shapeId1 = shapeId1;
            this.shapeId2 = shapeId2;
        }

        public String toString() {
            String str = "";
            str = str + "DuplicatedInfo number=" + this.dupNumber + ", shapeId1=" + this.shapeId1 + ", shapeId2=" + this.shapeId2;
            return str;
        }
    }

    class DupicatedTable {
        Vector InfoTable = new Vector();
        ArrayList serializableElementList;

        DupicatedTable(ArrayList serializableElementList) {
            int i;
            this.serializableElementList = serializableElementList;
            int size = serializableElementList.size();
            int[] numbers = new int[size];
            String[] shapeIds = new String[size];
            for (i = 0; i < size; ++i) {
                String shapeId;
                SerializableElement sElement = (SerializableElement)serializableElementList.get(i);
                shapeIds[i] = shapeId = sElement.shapeId;
                int id0 = shapeId.indexOf("-");
                int id1 = shapeId.indexOf(")");
                String num = shapeId.substring(id0 + 1, id1);
                numbers[i] = new Integer(num);
            }
            for (i = 1; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    if (numbers[j] != numbers[i]) continue;
                    DuplicatedInfo info = new DuplicatedInfo(numbers[i], shapeIds[i], shapeIds[j]);
                    this.InfoTable.add(info);
                }
            }
        }

        boolean isDuplicated() {
            boolean dup = false;
            if (this.InfoTable.size() > 0) {
                dup = true;
            }
            return dup;
        }

        public String toString() {
            String str = "";
            int size = this.InfoTable.size();
            str = str + "DupicatedTable InfoTable size=" + size;
            for (int i = 0; i < size; ++i) {
                DuplicatedInfo info = (DuplicatedInfo)this.InfoTable.get(i);
                str = str + "\n- info number=" + info.dupNumber + ", shapeIds1=" + info.shapeId1 + ", shapeIds2=" + info.shapeId2;
            }
            return str;
        }
    }
}

