/*
 * Decompiled with CFR 0.152.
 */
package util;

import DrawTop.DrawParameters;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import shape.ShapeContainer;
import shape.ShapeElementUtil;

public class ScreenImage
implements Serializable,
Cloneable {
    ShapeContainer[] containers;
    Rectangle2D imageArea;
    BufferedImage bufferedImage;
    int debug = 1;

    public ScreenImage(ShapeContainer[] containers) {
        double scale = DrawParameters.getScale();
        this.containers = containers;
        this.imageArea = this.getImageSize(scale, 10, 10);
        int width = (int)this.imageArea.getWidth();
        int height = (int)this.imageArea.getHeight();
        this.bufferedImage = new BufferedImage(width, height, 2);
        Graphics2D g2 = this.bufferedImage.createGraphics();
        this.drawImage(g2, scale);
    }

    private Rectangle2D getImageSize(double scale, int marginX, int marginY) {
        Rectangle2D box = ShapeElementUtil.getBoundingBox(this.containers);
        double x0 = scale * box.getX();
        double y0 = scale * box.getY();
        double width = scale * box.getWidth();
        double height = scale * box.getHeight();
        Rectangle2D.Double area = new Rectangle2D.Double(x0 - (double)marginX, y0 - (double)marginY, width + (double)(2 * marginX), height + (double)(2 * marginY));
        return area;
    }

    private void drawImage(Graphics g, double scale) {
        DrawParameters.DrawMode = 2;
        Graphics2D g2 = (Graphics2D)g;
        Color currentColor = g2.getColor();
        if (this.debug > 0) {
            System.out.println("** drawImage currentColor=" + currentColor);
        }
        g2.translate(-this.imageArea.getX(), -this.imageArea.getY());
        g2.setColor(Color.WHITE);
        g2.fill(this.imageArea);
        g2.setColor(currentColor);
        g2.setColor(Color.BLACK);
        g2.scale(scale, scale);
        for (int i = 0; i < this.containers.length; ++i) {
            this.containers[i].drawShape(g2);
        }
        g2.scale(1.0 / scale, 1.0 / scale);
        g2.translate(this.imageArea.getX(), this.imageArea.getY());
        g2.setColor(currentColor);
        g2.scale(1.0, 1.0);
        DrawParameters.DrawMode = 0;
    }

    public Image getImage() {
        return this.bufferedImage;
    }

    public String toString() {
        String str = "";
        str = str + "image area on DrawPanel x,y=" + (int)this.imageArea.getX() + "," + (int)this.imageArea.getY();
        str = str + "  w, h=" + (int)this.imageArea.getWidth() + "," + (int)this.imageArea.getHeight();
        for (int i = 0; i < this.containers.length; ++i) {
            str = str + "\n  -- " + this.containers[i].toString();
        }
        return str;
    }
}

