/*
 * Decompiled with CFR 0.152.
 */
package util;

import DrawTop.ObjectTable;
import java.awt.Component;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class UndoDrawManager
extends UndoManager {
    int debug = 0;

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        boolean returnCode = super.addEdit(anEdit);
        this.changeButtonState();
        return returnCode;
    }

    @Override
    public void discardAllEdits() {
        super.discardAllEdits();
        this.changeButtonState();
    }

    @Override
    public void undo() {
        boolean realDone = false;
        while (super.canUndo()) {
            String name = super.getUndoPresentationName();
            if (this.debug > 0) {
                System.out.println("   ++ undoManager.undo PresentationName=" + name + ", realDone=" + realDone);
            }
            if (name.startsWith("Delimiter") && realDone) break;
            super.undo();
            realDone = true;
        }
        this.changeButtonState();
    }

    @Override
    public void redo() {
        boolean realDone = false;
        while (super.canRedo()) {
            String name = super.getRedoPresentationName();
            if (this.debug > 0) {
                System.out.println("   ++ undoManager.redo PresentationName=" + super.getRedoPresentationName() + ", realDone=" + realDone);
            }
            if (name.startsWith("Delimiter") && realDone) break;
            super.redo();
            realDone = true;
        }
        this.changeButtonState();
    }

    protected void changeButtonState() {
        Component undoButton = ObjectTable.getMenuUtil().getMenuComponent("undo");
        Component redoButton = ObjectTable.getMenuUtil().getMenuComponent("redo");
        if (undoButton != null) {
            undoButton.setEnabled(super.canUndo());
        }
        if (redoButton != null) {
            redoButton.setEnabled(super.canRedo());
        }
        if (this.debug > 0) {
            System.out.println("** UndoDrawManager.changeButtonState this.UndoDrawManager=" + this.toString());
        }
    }

    @Override
    public String toString() {
        String str = "";
        str = str + " UndoDrawManager canUndo=" + super.canUndo() + ", canRedo=" + super.canRedo();
        return str;
    }
}

