/*
 * Decompiled with CFR 0.152.
 */
package util;

import geomExtension.Vector2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.NumberFormat;
import javax.swing.JComponent;
import textBox.AttributedStringUtil;

public class Util {
    static NumberFormat nf = NumberFormat.getNumberInstance();
    static int debug = 0;

    public static void simpleSort(int[] data) {
        String message = "initial array: ";
        Util.printSort(message, data);
        for (int i = 0; i < data.length - 1; ++i) {
            for (int j = i; j < data.length; ++j) {
                if (data[j] >= data[i]) continue;
                Util.swap(data, i, j);
            }
            message = i + "th array:    ";
            if (debug <= 0) continue;
            Util.printSort(message, data);
        }
    }

    public static void simpleSort(double[] data) {
        String message = "simpleSort initial array: ";
        Util.printSort(message, data);
        for (int i = 0; i < data.length - 1; ++i) {
            for (int j = i; j < data.length; ++j) {
                if (!(data[j] < data[i])) continue;
                Util.swap(data, i, j);
            }
            message = "simpleSort  " + i + "th array:    ";
            if (debug <= 0) continue;
            Util.printSort(message, data);
        }
    }

    public static int[] indexedSimpleSort(int[] data) {
        int size = data.length;
        int[] indices = new int[size];
        for (int i = 0; i < size; ++i) {
            indices[i] = i;
        }
        String message = "simpleSort initial array: ";
        if (debug > 0) {
            Util.printSort(message, data, indices);
        }
        for (int i = 0; i < size - 1; ++i) {
            for (int j = i; j < data.length; ++j) {
                if (data[indices[j]] >= data[indices[i]]) continue;
                Util.indexedSwap(indices, i, j);
            }
        }
        message = "simpleSort final array: ";
        if (debug > 0) {
            Util.printSort(message, data, indices);
        }
        return indices;
    }

    public static int[] indexedSimpleSort(double[] data) {
        int size = data.length;
        int[] indices = new int[size];
        for (int i = 0; i < size; ++i) {
            indices[i] = i;
        }
        String message = "simpleSort initial array: ";
        if (debug > 0) {
            Util.printSort(message, data, indices);
        }
        for (int i = 0; i < size - 1; ++i) {
            for (int j = i; j < data.length; ++j) {
                if (!(data[indices[j]] < data[indices[i]])) continue;
                Util.indexedSwap(indices, i, j);
            }
        }
        message = "simpleSort final array: ";
        if (debug > 0) {
            Util.printSort(message, data, indices);
        }
        return indices;
    }

    private static void indexedSwap(int[] indices, int i, int j) {
        int tmp = indices[j];
        indices[j] = indices[i];
        indices[i] = tmp;
    }

    private static void swap(int[] data, int i, int j) {
        int tmp = data[j];
        data[j] = data[i];
        data[i] = tmp;
    }

    private static void swap(double[] data, int i, int j) {
        double tmp = data[j];
        data[j] = data[i];
        data[i] = tmp;
    }

    private static void printSort(String message, int[] data) {
        int i;
        System.out.print(message);
        for (i = 0; i < data.length - 1; ++i) {
            System.out.print(data[i] + ",");
        }
        System.out.println(data[i]);
    }

    private static void printSort(String message, double[] data) {
        int i;
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumIntegerDigits(4);
        nf.setMinimumFractionDigits(2);
        System.out.print(message);
        for (i = 0; i < data.length - 1; ++i) {
            System.out.print(nf.format(data[i]) + " ,");
        }
        System.out.println(nf.format(data[i]));
    }

    private static void printSort(String message, int[] data, int[] indices) {
        int i;
        System.out.print(message);
        for (i = 0; i < data.length - 1; ++i) {
            System.out.print("[" + indices[i] + "] " + data[indices[i]] + ", ");
        }
        System.out.println("[" + indices[i] + "] " + data[indices[i]]);
    }

    private static void printSort(String message, double[] data, int[] indices) {
        int i;
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumIntegerDigits(4);
        nf.setMinimumFractionDigits(10);
        System.out.print(message);
        for (i = 0; i < data.length - 1; ++i) {
            System.out.print("[" + indices[i] + "] " + nf.format(data[indices[i]]) + ", ");
        }
        System.out.println("[" + indices[i] + "] " + nf.format(data[indices[i]]));
    }

    public static String getASCIIControlString(String str) {
        int ascCode = 64;
        char[] c = str.toCharArray();
        char code = c[0];
        String outputStr = "";
        for (char i = '\u0000'; i < '\u001a'; i = (char)(i + '\u0001')) {
            if (code != i) continue;
            char hitChar = (char)(i + ascCode);
            outputStr = "ctrl " + String.valueOf(hitChar);
            break;
        }
        if (code == '\u007f') {
            outputStr = "DELETE";
        }
        return outputStr;
    }

    public static String toHexString(String str) {
        String hexString = "";
        byte[] btArray = str.getBytes();
        hexString = Util.toHexString(btArray);
        return hexString;
    }

    public static String toHexString(byte[] byteBuff) {
        String[] hex = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
        String result = "";
        for (int i = 0; i < byteBuff.length; ++i) {
            result = result + "0x";
            int num = byteBuff[i] & 0xFF;
            int firstNum = num / 16;
            int secondNum = num - 16 * firstNum;
            result = result + hex[firstNum];
            result = result + hex[secondNum];
            result = result + " ";
        }
        return result;
    }

    public static String Text(String string) {
        String str = "NULL";
        if (str != null && !str.equals("")) {
            str = string.replace("\n", "\\n");
        }
        return str;
    }

    public static String Text(AttributedString attribStr) {
        AttributedStringUtil attribUtil;
        String str = "NULL";
        if (attribStr != null && (str = (attribUtil = new AttributedStringUtil(attribStr.getIterator())).getString()) != null && !str.equals("")) {
            str = str.replace("\n", "\\n");
        }
        return str;
    }

    public static String Text(AttributedCharacterIterator iterator) {
        AttributedStringUtil attribUtil;
        String str = "NULL";
        if (iterator != null && (str = (attribUtil = new AttributedStringUtil(iterator)).getString()) != null && !str.equals("")) {
            str = str.replace("\n", "\\n");
        }
        return str;
    }

    public static String Num(double d) {
        nf.setMaximumIntegerDigits(4);
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        String str = "";
        str = nf.format(d);
        return str;
    }

    public static String Num1(double d) {
        nf.setMaximumIntegerDigits(4);
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        String str = "";
        str = nf.format(d);
        return str;
    }

    public static String Num2(double d) {
        nf.setMaximumIntegerDigits(4);
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        String str = "";
        str = nf.format(d);
        return str;
    }

    public static String Num3(double d) {
        nf.setMaximumIntegerDigits(4);
        nf.setMaximumFractionDigits(3);
        nf.setMinimumFractionDigits(3);
        String str = "";
        str = nf.format(d);
        return str;
    }

    public static String Num4(double d) {
        nf.setMaximumIntegerDigits(4);
        nf.setMaximumFractionDigits(4);
        nf.setMinimumFractionDigits(4);
        String str = "";
        str = nf.format(d);
        return str;
    }

    public static String NumF3(double d) {
        String str = "";
        str = String.format("%3.3E", d);
        return str;
    }

    public static String PercentNum(double d, int fraction) {
        NumberFormat nf = NumberFormat.getPercentInstance();
        nf.setMaximumIntegerDigits(3 + fraction);
        nf.setMaximumFractionDigits(fraction);
        String str = "";
        str = nf.format(d);
        return str;
    }

    public static String Pt(Point point) {
        nf.setMaximumIntegerDigits(4);
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        String str = "";
        str = point == null ? "null" : "(" + nf.format(point.getX()) + ", " + nf.format(point.getY()) + ")";
        return str;
    }

    public static String Pt(Point2D point) {
        nf.setMaximumIntegerDigits(4);
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        String str = "";
        str = point == null ? "null" : "(" + nf.format(point.getX()) + ", " + nf.format(point.getY()) + ")";
        return str;
    }

    public static String Pt(Vector2D vec) {
        nf.setMaximumIntegerDigits(4);
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        String str = "";
        str = vec == null ? "null" : "(" + nf.format(vec.getX()) + ", " + nf.format(vec.getY()) + ")";
        return str;
    }

    public static String Pt(Rectangle2D rect) {
        nf.setMaximumIntegerDigits(4);
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        String str = "";
        str = rect == null ? "null" : "(" + nf.format(rect.getX()) + ", " + nf.format(rect.getY()) + ")";
        return str;
    }

    public static String Pt(Arc2D arc) {
        nf.setMaximumIntegerDigits(4);
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        String str = "";
        str = arc == null ? "null" : "(" + nf.format(arc.getX()) + ", " + nf.format(arc.getY()) + "()";
        return str;
    }

    public static String Angle(Arc2D arc) {
        nf.setMaximumIntegerDigits(4);
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        String str = "";
        str = arc == null ? "null" : nf.format(arc.getAngleStart()) + ", " + nf.format(arc.getAngleExtent());
        return str;
    }

    public static String Rect(Rectangle rect) {
        nf.setMaximumIntegerDigits(4);
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        String str = "";
        str = rect == null ? "null" : "(x,y)=(" + nf.format(rect.getX()) + ", " + nf.format(rect.getY()) + "), (w,h)=(" + nf.format(rect.getWidth()) + ", " + nf.format(rect.getHeight()) + ")";
        return str;
    }

    public static String RectC(Rectangle rect) {
        nf.setMaximumIntegerDigits(4);
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        String str = "";
        str = rect == null ? "null" : "(x,y)=(" + nf.format(rect.getX()) + ", " + nf.format(rect.getY()) + "), (x1,y1)=(" + nf.format(rect.getX() + rect.getWidth()) + ", " + nf.format(rect.getY() + rect.getHeight()) + ")";
        return str;
    }

    public static String Rect(Component component) {
        nf.setMaximumIntegerDigits(4);
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        String str = "";
        if (component == null) {
            str = "null";
        } else {
            Dimension size = component.getPreferredSize();
            str = "(x,y)=(" + nf.format(component.getX()) + ", " + nf.format(component.getY()) + "), (w,h)=(" + nf.format(component.getWidth()) + ", " + nf.format(component.getHeight()) + "), preferredSize=(" + nf.format(size.getWidth()) + ", " + nf.format(size.getHeight()) + ")";
        }
        return str;
    }

    public static String RectC(Component component) {
        nf.setMaximumIntegerDigits(4);
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        String str = "";
        if (component == null) {
            str = "null";
        } else {
            Dimension size = component.getPreferredSize();
            str = "(x,y)=(" + nf.format(component.getX()) + ", " + nf.format(component.getY()) + "), (x1,y1)=(" + nf.format(component.getX() + component.getWidth()) + ", " + nf.format(component.getY() + component.getHeight()) + "), preferredSize=(" + nf.format(size.getWidth()) + ", " + nf.format(size.getHeight()) + ")";
        }
        return str;
    }

    public static String Rect(Rectangle2D rect) {
        nf.setMaximumIntegerDigits(4);
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        String str = "";
        str = rect == null ? "null" : "(x,y)=(" + nf.format(rect.getX()) + ", " + nf.format(rect.getY()) + "), (w,h)=(" + nf.format(rect.getWidth()) + ", " + nf.format(rect.getHeight()) + ")";
        return str;
    }

    public static String RectC(Rectangle2D rect) {
        nf.setMaximumIntegerDigits(4);
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        String str = "";
        str = rect == null ? "null" : "(x,y)=(" + nf.format(rect.getX()) + ", " + nf.format(rect.getY()) + "), (w,h)=(" + nf.format(rect.getX() + rect.getWidth()) + ", " + nf.format(rect.getY() + rect.getHeight()) + ")";
        return str;
    }

    public static String Line(Line2D line) {
        nf.setMaximumIntegerDigits(4);
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        String str = "";
        str = line == null ? "null" : "p1=(" + nf.format(line.getX1()) + ", " + nf.format(line.getY1()) + "), p2=(" + nf.format(line.getX2()) + ", " + nf.format(line.getY2()) + ")";
        return str;
    }

    public static String Comp(JComponent component) {
        nf.setMaximumIntegerDigits(4);
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        String str = "";
        str = component == null ? "null" : "(x,y)=(" + nf.format(component.getX()) + ", " + nf.format(component.getY()) + "), (w,h)=" + nf.format(component.getWidth()) + ", " + nf.format(component.getHeight()) + ")";
        return str;
    }

    public static String Dim(Dimension dim) {
        nf.setMaximumIntegerDigits(4);
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        String str = "";
        str = dim == null ? "null" : "(w,h)=(" + nf.format(dim.getWidth()) + ", " + nf.format(dim.getHeight()) + ")";
        return str;
    }

    public static String Insets(Insets insets) {
        nf.setMaximumIntegerDigits(4);
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        String str = "";
        str = insets == null ? "null" : "(left, right)=(" + nf.format(insets.left) + ", " + nf.format(insets.right) + "), (top, bottom)=(" + nf.format(insets.top) + ", " + nf.format(insets.bottom) + ")";
        return str;
    }

    public static String Color(Color color) {
        String str = "";
        str = color == null ? "null" : "r=" + color.getRed() + ", g=" + color.getGreen() + ", b=" + color.getBlue();
        return str;
    }
}

