package DrawTop;

import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;
import java.util.*;
//import java.lang.reflect.*;
import javax.swing.*;
import javax.swing.event.*;
//import javax.swing.border.Border.*;
import geomExtension.*;
import menu.*;
import shape.*;
import util.*;
import textBox.*;

public class SelectionLS implements MouseListener, MouseMotionListener {

    protected EventListenerList listenerList = new EventListenerList();  
    public static boolean popupTrigger;
    boolean clicked = false;
    public Point2D clickedPoint = null;
    Rectangle2D draggedRectangle = null;
    Point2D startPoint = null;
    Point2D endPoint = null;
    boolean mouseExited = false;
    private int ctrl = 0;
    int idNumber = 0;
    Vector workVector=new Vector();
    public static int debug = 0;

    public SelectionLS() {
        this.start();
    }

    public void start() {
        if (debug > 0) {
            System.out.println(" -S(" + (idNumber++) + ")  SelectionLS start");
        }
        this.activateListener(true);
    }

    public void end() {
        if (debug > 0) {
            System.out.println(" -S(" + (idNumber++) + ") SelectionLS end");
        }
        this.activateListener(false);
        this.draggedRectangle = null;
        this.startPoint = null;
        this.endPoint = null;
        this.clickedPoint = null;
    }
/*
    public void resetSelectionLS() {
        ObjectTable.getContainerManager().deSelectAll();
    }
*/
    public boolean isMouseListener(MouseListener listener) {
        ListenerPanel listenerPanel = ObjectTable.getListenerPanel();
        MouseListener[] mouseLS = listenerPanel.getMouseListeners();
        boolean isRegistered = false;
        for (int i = 0; i < mouseLS.length; i++) {
            if (listener.equals(mouseLS[i])) {
                isRegistered = true;
            }
        }
        return isRegistered;
    }

    public boolean isMouseMotionListener(MouseMotionListener listener) {
        ListenerPanel listenerPanel = ObjectTable.getListenerPanel();
        MouseMotionListener[] mouseMotionLS = listenerPanel.getMouseMotionListeners();
        boolean isRegistered = false;
        for (int i = 0; i < mouseMotionLS.length; i++) {
            if (listener.equals(mouseMotionLS[i])) {
                isRegistered = true;
            }
        }
        return isRegistered;
    }

    private void activateListener(boolean activate) {
        if (activate && !this.isMouseListener(this) && !this.isMouseMotionListener(this)) {
            JComponent listenerPanel = ObjectTable.getListenerPanel();
            listenerPanel.addMouseListener(this);
            listenerPanel.addMouseMotionListener(this);
        }
        if (!activate && this.isMouseListener(this) && this.isMouseMotionListener(this)) {
            JComponent listenerPanel = ObjectTable.getListenerPanel();
            listenerPanel.removeMouseListener(this);
            listenerPanel.removeMouseMotionListener(this);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.listenerList.add(SelectionListener.class, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.listenerList.remove(SelectionListener.class, listener);
    }
    
    public void removeSelectionListener() {
        this.listenerList=new EventListenerList();
    }
    
    public void fireEvent(SelectionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i = i + 2) {
            if (listeners[i] == SelectionListener.class) {
                ((SelectionListener) listeners[i + 1]).selected(event);
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        //System.out.println("** SelectionLS.mousePressed");
        this.clicked = false;
        popupTrigger = false;
        if (e.isPopupTrigger()) {
            popupTrigger = true;
        }
        int key = e.getModifiersEx();
        this.ctrl = 0;
        if ((key & InputEvent.BUTTON2_DOWN_MASK) != 0) {
            this.ctrl = 2;
        }
        if ((key & InputEvent.BUTTON3_DOWN_MASK) != 0) {
            this.ctrl = 3;
        }
        if (debug > 0) {
            System.out.println("++ SelectionLS.mousePressed; "
                    + " this.ctrl=" + this.ctrl);
        }
        double scale = DrawParameters.getScale();
        double X = (double) e.getX() / scale;
        double Y = (double) e.getY() / scale;
        if (this.inEditableTextArea(X, Y)) return;
        
        this.startPoint = new Point2D.Double(X, Y);
        MousePositionLS mousePositionLS = ObjectTable.getMousePositionLS();
        MousePositionInfo info = mousePositionLS.getMousePositionInfoForMoveResize();
        if (info != null) {
            ShapeContainer container = info.getContainer();
            int position = info.getPosition();
            boolean group = info.getContainer().getContainerType()==ShapeContainer.GROUP;
            boolean selected = container.isSelected();
            if(group){
                boolean posFlag=position >= MousePositionInfo.SELECTION_BOX;
                if(container.isEditableTextBox()){
                    posFlag = position >= MousePositionInfo.SELECTION_BOX
                            && position != MousePositionInfo.SHAPE_BOUNDARY
                            && position != MousePositionInfo.TEXTBOX_BOUNDARY
                            && position != MousePositionInfo.INSIDE_TEXT;
                }
                if (this.ctrl == 0 && selected && posFlag){
                    prepareMoveResizeCommand(info, e);
                }
            } else{
                boolean posFlag=position >= MousePositionInfo.SELECTION_BOX;
                if (container.isEditableTextBox()) {
                    posFlag = position >= MousePositionInfo.SELECTION_BOX
                            && position != MousePositionInfo.SHAPE_BOUNDARY
                            && position != MousePositionInfo.TEXTBOX_BOUNDARY
                            && position != MousePositionInfo.INSIDE_TEXT;
                }
                if (this.ctrl == 0 && selected && posFlag){
                    prepareMoveResizeCommand(info, e);
                }
            }
        }
        ObjectTable.getDrawPanel().repaint("SelectionLS.mousePressed");
    }

    	public void mouseDragged(MouseEvent e) {
		if(debug>0) printMouseEvent("** mouseDragged", e);
		Rectangle r = new Rectangle(e.getX(), e.getY(), 1, 1);
		((DrawPanel)e.getSource()).scrollRectToVisible(r);

		double scale = DrawParameters.getScale();
		double X = (double) e.getX() / scale;
		double Y = (double) e.getY() / scale;
		if (this.inEditableTextArea(X, Y)) {
			return;
		}

		this.endPoint = new Point2D.Double(X, Y);
		if (this.startPoint != null) {
			double x1 = this.startPoint.getX();
			double y1 = this.startPoint.getY();
			double x2 = this.endPoint.getX();
			double y2 = this.endPoint.getY();
			double w = Math.abs(x1 - x2);
			double h = Math.abs(y1 - y2);
			double x = x1, y = y1;
			if (x > x2) {
				x = x2;
			}
			if (y > y2) {
				y = y2;
			}
			if (w > 1 && h > 1) {
				this.draggedRectangle = new Rectangle2D.Double(x, y, w, h);
			}
		}
/*	
		Dimension dim=this.nearBorder(e);
		if (dim!=null) {
			Point mousePosition = new Point(e.getX()+(int)dim.getWidth(), e.getY()+(int)dim.getHeight());
			ViewUtil.moveView(mousePosition);
		}

		if (this.mouseExited) {
			Point mousePosition = new Point(e.getX(), e.getY());
			ViewUtil.moveView(mousePosition);
		}
*/
		ObjectTable.getDrawPanel().repaint("SelectionLS.mouseDragged");
	} //mouseDragged

    public void mouseReleased(MouseEvent e) {
        if(debug>0) printMouseEvent("** mouseReleased", e);
        if (e.isPopupTrigger()) {
            popupTrigger = true;
        }
        double scale = DrawParameters.getScale();
        double X = (double) e.getX() / scale;
        double Y = (double) e.getY() / scale;
        this.endPoint = new Point2D.Double(X, Y);
        if (this.inEditableTextArea(X, Y)) {
            return;
        }
// Selection
        int key = e.getModifiersEx();
        int ctrl = 0;
        if ((key & InputEvent.SHIFT_DOWN_MASK) != 0) {
            ctrl = 1;
        }
        if ((key & InputEvent.CTRL_DOWN_MASK) != 0) {
            ctrl = 2;
        }

        //-----------------------------------------------------//
        if (this.draggedRectangle != null) {
            this.execSelection(ctrl, this.draggedRectangle);
        }
        //-----------------------------------------------------//
        //deselection
        double dist = 1.0e+5;
        if (this.startPoint != null && this.endPoint != null) {
            dist = Vector2D.dist(this.startPoint, this.endPoint);
        }
        if (dist != 0.0d && dist < 4.0d) {
            if (debug > 0) {
                System.out.println("*** Warning: The mouseReleased calls mouseClicked"
                        + "  dist=" + dist);
                System.err.println("*** Warning: The mouseReleased calls mouseClicked"
                        + "  dist=" + dist);
            }
            MousePositionLS mousePositionLS = ObjectTable.getMousePositionLS();
            MousePositionInfo[] infos = mousePositionLS.getMousePositionInfoForSelection();
            if (infos == null || infos.length == 0) {
                ShapeContainer[] selected =
                        ObjectTable.getContainerManager().getSelectedContainers();
                for (int i = 0; i < selected.length; i++) {
                    selected[i].setSelected(false);
                }
              //-----------------------------------//
                DrawShapeUtil.clearAllTempShapes();
              //-----------------------------------//
            }
        }
        // end of deselection
        this.draggedRectangle = null;
        this.startPoint = null;
        this.endPoint = null;
        ObjectTable.getDrawPanel().repaint("SelectionLS.mouseReleased");
    }//MOUSERELEASED

    public void mouseClicked(MouseEvent e) {
        //System.out.println("** SelectionLS.mouseClicked");
        this.clicked = true;
        double scale = DrawParameters.getScale();
        double X = e.getX() / scale;
        double Y = e.getY() / scale;
        int key = e.getModifiersEx();
        int ctrl = 0;
        if ((key & InputEvent.SHIFT_DOWN_MASK) != 0) {
            ctrl = 1;
        }
        if ((key & InputEvent.CTRL_DOWN_MASK) != 0) {
            ctrl = 2;
        }
        this.clickedPoint = new Point2D.Double(X, Y);
        //----------------------------------------------------------------//
        this.prepareClickedPointCommand((Point2D)this.clickedPoint.clone());
        //---------------------------------------------------------------//
        if (!this.inEditableTextArea(X, Y)) {
            //------------------------------//
            this.execSelection(ctrl, null);
            //-----------------------------//
        }
        //---------------------------------------------------------------//
        if (debug >0) System.out.println("** SelectionLS this.allMouseEventsCompleted()="+
                this.allMouseEventsCompleted()+", SelectionLS.popupTrigger="
                +SelectionLS.popupTrigger+
                ", MousePositionLS.popupTrigger="+MousePositionLS.popupTrigger);
        //if (SelectionLS.popupTrigger || MousePositionLS.popupTrigger) {
        if (this.allMouseEventsCompleted()
            && (SelectionLS.popupTrigger || MousePositionLS.popupTrigger)) {
            if (debug >0) System.out.println("** SelectionLS ExecPopupMenu");
            ExecPopupMenu execPopupMenu = ObjectTable.getExecPopupMenu("");
            execPopupMenu.show(new Point((int) X, (int) Y));
            SelectionLS.popupTrigger = false;
            MousePositionLS.popupTrigger = false;
        }
        //---------------------------------------------------------------//
        ObjectTable.getDrawPanel().repaint("SelectionLS.mouseClicked");
    }

    public void mouseEntered(MouseEvent e) {
        if(debug>0) printMouseEvent("** mouseEntered", e);
        this.mouseExited = false;
    }

    public void mouseExited(MouseEvent e) {
        if(debug>0) printMouseEvent("** mouseExited", e);
        this.mouseExited = true;
    }

    public void mouseMoved(MouseEvent e) {}
	
	public void printMouseEvent(String message, MouseEvent e) {
		String str="";
		str+=message;
		double scale = DrawParameters.getScale();
		str+=" (x,y)=("+e.getX()+", "+e.getY()+")";
		str+=", scaled(x,y)=("+e.getX()/scale+", "+e.getY()/scale+")";
		int key=e.getModifiersEx();
		str+=", key="+e.getMouseModifiersText(key);
		if ((key & InputEvent.SHIFT_DOWN_MASK) != 0) {
			str+=", SHIFT_DOWN";
		}
		if ((key & InputEvent.CTRL_DOWN_MASK) != 0) {
			str+=", CTRL_DOWN";
		}
		str+=", e.isPopupTrigger()="+e.isPopupTrigger();
		JPanel drawPanel=ObjectTable.getDrawPanel();
		str+=", drawPanel size=("+drawPanel.getWidth()+", "+drawPanel.getHeight()+")";
		
		System.out.println(str);
	}

    private boolean inEditableTextArea(double X, double Y) {
        boolean in = false;
        ContainerManager manager = ObjectTable.getContainerManager();
        ShapeContainer shapeContainer = manager.getEditableTextBox();
        if (shapeContainer != null) {
            Rectangle2D rect = shapeContainer.getTextBox().getTextArea();
            if(debug>0) System.out.println("Unselectable Area: "+Util.Rect(rect));
            if (rect.contains(X, Y)) {
                in = true;
            }
        }
        return in;
    }

    public void drawDraggedRectangle(Graphics g) {
        Graphics2D g2 = (Graphics2D) g;
        Color currentColor = g2.getColor();
        g2.setColor(Color.black);
        Rectangle2D draggedArea = this.draggedRectangle;
        float[] dash = {2.0f, 2.0f};
        BasicStroke basicStroke = new BasicStroke(0.5f, BasicStroke.CAP_SQUARE,
                BasicStroke.JOIN_MITER, 1.0f, dash, 0.0f);
        Stroke currentStroke = g2.getStroke();
        g2.setStroke(basicStroke);
        if (debug > 1) {
            System.out.println(" -S(" + (idNumber++) + ") SelectionLS.drawDraggedArea"
                    + ", draggedArea=" + draggedArea);
        }
        if (draggedArea != null) {
            g2.draw(draggedArea);
        }
        g2.setStroke(currentStroke);
        g2.setColor(currentColor);
    }

    public void execSelection(int ctrl, Rectangle2D draggedArea) {
        JTabbedPane tabbedPane = ObjectTable.getTabbedPane("SelectionLS");
        if(tabbedPane!=null) tabbedPane.setSelectedIndex(1);
        ContainerManager containerManager = ObjectTable.getContainerManager();

        if (draggedArea != null) {
            //selection by mouse drag
            this.execSelectionByDrag(ctrl, draggedArea);
        } else {
            //selection by mouse click
            this.execSelectionByClick(ctrl);
        }
        ShapeContainer[] containers = containerManager.getAllSigleShapeContainers(true);
        ShapeContainer editableTextContainer = containerManager.getEditableTextBox();
        if (debug >0) {
            System.out.println("** SelectionLS.execSelection");
            if (editableTextContainer != null) {
                System.out.println("-- editableTextContainer:" + editableTextContainer.getShapeId());
            } else System.out.println("-- editableTextContainer:none");
            int size = 0;
            if (containers != null) size = containers.length;
            if (size > 0) {
                for (int i = 0; i < size; i++)  System.out.println("-- selected:" + containers[i].getShapeId());
            } else  System.out.println("-- selected:none");
        }
      //-----------------------------------------------------------------//
       //Set PaintStyle to the menus in tool bar
        PaintStyle.setPaintStyleToMenu(containers, "SelectionLS.execSelection");
        if (editableTextContainer == null) {
            FontStyle.setFontStyleToMenu(containers, "SelectionLS.execSelection");
        } else {
            FontStyle.setFontStyleToMenu(editableTextContainer.getTextBox(), "SelectionLS.execSelection");
        }
        //----------------------------------------------------------------//
        this.clickedPoint = null;
        ObjectTable.getExecCommand().setPreviousCommandId(Command.SELECTION);
    } //end of execSelection

    public void execSelectionByDrag(int ctrl, Rectangle2D draggedArea) {
        ContainerManager containerManager = ObjectTable.getContainerManager();
        MousePositionInfo[] infos = this.selectInDraggedArea(draggedArea);
        if (infos == null || infos.length == 0) {
            ShapeContainer[] selected = containerManager.getSelectedContainers();
            for (int i = 0; i < selected.length; i++) {
                selected[i].setSelected(false);
            }
            return;
        }
        //Continue selection
        if (ctrl > 0) {
            for (int i = 0; i < infos.length; i++) {
                ShapeContainer selectedContainer = infos[i].getContainer();
                if (selectedContainer.isSelected()) {
                    selectedContainer.setSelected(false);
                } else {
                    selectedContainer.setSelected(true);
                    this.workVector.add(selectedContainer);
                }
            }
        } else {
            //Deselect the already selected shapes and select a newly clicked shape
            ShapeContainer[] selected = containerManager.getSelectedContainers();
            for (int i = 0; i < selected.length; i++) {
                selected[i].setSelected(false);
            }
            for (int i = 0; i < infos.length; i++) {
                ShapeContainer selectedContainer = infos[i].getContainer();
                selectedContainer.setSelected(true);
                this.workVector.add(selectedContainer);
            }
        }
       //--------------------------------------------------------//
        if(this.workVector.size()>0){
            int size=this.workVector.size();
            ShapeContainer[] containers = new ShapeContainer[size];
            for (int i = 0; i < size; i++) {
                containers[i] = (ShapeContainer)this.workVector.get(i);
            }
            SelectionEvent event = new SelectionEvent(this, "dragged", containers, null);
            this.fireEvent(event);
        }
       //--------------------------------------------------------//
    }

    private MousePositionInfo[] selectInDraggedArea(Rectangle2D draggedArea) {
        if (draggedArea == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        ContainerManager containerManager = ObjectTable.getContainerManager();
        ShapeContainer[] containers = containerManager.getContainers();
        for (int i = 0; i < containers.length; i++) {
            Rectangle2D boundingBox = containers[i].getBoundingBox();
            if (boundingBox == null) {
                continue;
            }
            double x = boundingBox.getX();
            double y = boundingBox.getY();
            double w = boundingBox.getWidth();
            double h = boundingBox.getHeight();
            if (draggedArea.contains(x, y) && draggedArea.contains(x + w, y + h)) {
                MousePositionInfo info = new MousePositionInfo();
                info.setContainer(containers[i]);
                info.setMouseStatus("mouseDragged");
                int position = MousePositionInfo.INSIDE_SHAPE;
                info.setPosition(position);
                info.setPoint(new Point2D.Double(x + 0.5 * w, y + 0.5 * h));
                arrayList.add(info);
            }
        }
        int size = arrayList.size();
        MousePositionInfo[] infos = new MousePositionInfo[size];
        for (int i = 0; i < size; i++) {
            infos[i] = (MousePositionInfo) arrayList.get(i);
        }
        return infos;
    }

    public void execSelectionByClick(int ctrl) {
        MousePositionLS mousePositionLS = ObjectTable.getMousePositionLS();
        MousePositionInfo[] infos = mousePositionLS.getMousePositionInfoForSelection();
        if(debug >0){
            System.out.println("execSelectionByClick");
            if(infos.length==0){
                System.out.println("infos is null");
            } else {
                for (int i = 0; i < infos.length; i++) {
                    System.out.println("rankedInfos["+i+"]: "+infos[i].toString());
                }
            }
        }
        ContainerManager containerManager = ObjectTable.getContainerManager();
        if (infos == null || infos.length == 0) {
            ShapeContainer[] selected = containerManager.getSelectedContainers();
            for (int i = 0; i < selected.length; i++) selected[i].setSelected(false);
            //-----------------------------------------------//
            DrawShapeUtil.clearAllTempShapes();
            ObjectTable.getDrawPanel().repaint("SelectionLS");
            //-----------------------------------------------//
            return;
        }

        MousePositionInfo info = infos[0];
        info.setMouseStatus("mouseClicked");
        if (this.ctrl >= 2) {
            info.setRightButtonPressed(true);
        }
        ShapeContainer selectedContainer = info.getContainer();
        this.workVector.clear();
        if (ctrl > 0) {
            if (selectedContainer.isSelected()) {
                selectedContainer.setSelected(false);
            } else {
                selectedContainer.setSelected(true);
                this.workVector.add(selectedContainer);
                if (info.getPosition() == MousePositionInfo.INSIDE_TEXT||
                    info.getPosition() == MousePositionInfo.INSIDE_TEXTBOX) {
                    this.selectTextBox(selectedContainer, info, ctrl);
                }
            }
        } else {
            if (selectedContainer.isSelected() && info.isRightButtonPressed()) {
                selectedContainer.setSelected(true);

            } else if (selectedContainer.isSelected() && !info.isRightButtonPressed()) {
				if (info.getPosition() == MousePositionInfo.INSIDE_TEXT) {
                //if (info.getPosition() == MousePositionInfo.INSIDE_TEXT||
                //    info.getPosition() == MousePositionInfo.INSIDE_TEXTBOX) {
                    this.selectTextBox(selectedContainer, info, ctrl);
                } else {
                    selectedContainer.setSelected(false);
                }
            } else {
                ShapeContainer[] containers = containerManager.getContainers();
                for (int i = 0; i < containers.length; i++) {
                    containers[i].setSelected(false);
                }
                selectedContainer.setSelected(true);
                this.workVector.add(selectedContainer);
				if (info.getPosition() == MousePositionInfo.INSIDE_TEXT) {
                //if (info.getPosition() == MousePositionInfo.INSIDE_TEXT||
                //    info.getPosition() == MousePositionInfo.INSIDE_TEXTBOX) {
                    this.selectTextBox(selectedContainer, info, ctrl);
                }
            }
        }
       //--------------------------------------------------------//
        if(this.workVector.size()>0){
            ShapeContainer[] containers=new ShapeContainer[1];
            containers[0]=(ShapeContainer)this.workVector.get(0);
            SelectionEvent event=new SelectionEvent(this, "clicked", containers, this.clickedPoint);
            this.fireEvent(event);
        }
    }

    private void selectTextBox(ShapeContainer selectedContainer, MousePositionInfo info,
            int ctrl) {
        ContainerManager containerManager = ObjectTable.getContainerManager();
        if (selectedContainer.getContainerType() == ShapeContainer.SHAPE
                && selectedContainer.isTextBox()) {
            containerManager.makeAllTextBoxesUneditable();
            selectedContainer.makeTextBoxEditable(info.getPoint(), ctrl);
        }
        if (selectedContainer.getContainerType() == ShapeContainer.GROUP) {
            containerManager.makeAllTextBoxesUneditable();
            TextBox textBox = info.getTextBox();
            ShapeContainer shapeContainer = textBox.getShapeContainer();
            shapeContainer.makeTextBoxEditable(info.getPoint(), ctrl);
        }
    }
    
    public void selectAll(boolean select) {
        ContainerManager containerManager = ObjectTable.getContainerManager();
        ShapeContainer[] containers = containerManager.getContainers();
        for (int i = 0; i < containers.length; i++) {
            if (containers[i].isSelected() != select) {
                containers[i].setSelected(select);
            }
        }
        ObjectTable.getDrawPanel().repaint("SelectionLS.selectAll");
    }

    public void prepareMoveResizeCommand(MousePositionInfo mouseInfo, MouseEvent e) {
        ExecCommand execCommand = ObjectTable.getExecCommand();
        int position = mouseInfo.getPosition();
        if (debug > 0) {
            System.out.println(" -S(" + (idNumber++) + ") SelectionLS.prepareCommand  "
                    + "prepareCommand position=" + MousePositionInfo.getPositionString(position));
        }
        Object[] args = new Object[2];
        args[0] = mouseInfo;
        args[1] = e;
        //Move
        if ((position == MousePositionInfo.SELECTION_BOX
                || position == MousePositionInfo.SHAPE_BOUNDARY
                || position >= MousePositionInfo.INSIDE_SHAPE)
                && !mouseInfo.onResizeMark()) {
            Command command = new Command(Command.MOVE, Command.callFromSelectionLS, args);
            if (debug > 0) {
                System.out.println(" -S(" + (idNumber++) + ") SelectionLS.prepareCommand"
                        + ", command=" + command.toString());
            }
            execCommand.exec(command);
            return;
        }
        //Resize
        if (position >= MousePositionInfo.NW_RESIZE
                && position <= MousePositionInfo.W_RESIZE
                || position == MousePositionInfo.END_POINT) {
            Command command = new Command(Command.getCommandId("RESIZE"),
                    Command.callFromSelectionLS, args);
            if (debug > 0) {
                System.out.println(" -S(" + (idNumber++) + ") SelectionLS.prepareCommand"
                        + ", command=" + command.toString());
            }
            execCommand.exec(command);
        }
    }

    public void prepareClickedPointCommand(Point2D point) {
        ExecCommand execCommand = ObjectTable.getExecCommand();
        if (execCommand.getCurrentCommandId() < 0) {
            Object[] args = new Object[1];
            args[0] = point;
            Command command = new Command(Command.CLICKEDPOINT,
                    Command.callFromMousePositionLS, args);
            execCommand.exec(command);
        }
    }

    public boolean mouseEventCompleted() {
        return this.clicked;
    }

    public boolean allMouseEventsCompleted() {
        boolean completed = false;
        MousePositionLS mousePositionLS = ObjectTable.getMousePositionLS("SelectionLS");
        if (mousePositionLS.mouseEventCompleted() && this.mouseEventCompleted()) {
            completed = true;
        }
        return completed;
    }


} //End of class SelectionLS
