/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package geomExtension;

import java.awt.*;
import java.awt.geom.*;
import java.text.*;
import DrawTop.*;

public class Rectangle2DE extends Curve2D{

    //double x; double y; double width; double height;
    
    public Rectangle2DE(Segment2D[] segments){
        super(segments);
    }

    public Rectangle2DE(double x, double y, double width, double height){
        this.generalPath=new GeneralPath(Curve2D.Path2D_WIND);
        this.segments=new Segment2D[4];
        this.segments[0]=new Segment2D(Segment2D.LINE, new Line2D.Double(x, y, x, y+height));
        this.segments[1]=new Segment2D(Segment2D.LINE, new Line2D.Double(x, y+height, x+width, y+height));
        this.segments[2]=new Segment2D(Segment2D.LINE, new Line2D.Double(x+width, y+height, x+width, y));
        this.segments[3]=new Segment2D(Segment2D.LINE, new Line2D.Double(x+width, y, x, y));
        for(int i=0;i<4;i++){
            Shape shape=segments[i].getShape();
            generalPath.append(shape,true);
        }
        generalPath.closePath();
        this.closed=true;
    }

    public int getType2DE(){
        return Command.RECTANGLE;
    }
    
    public double getX(){
        return segments[0].getP(0).getX();
    }

    public double getY(){
        return segments[0].getP(0).getY();
    }

    public double getWidth(){
        double width=Vector2D.dist(segments[1].getP(0), segments[1].getP(1));
        return width;
    }

    public double getHeight(){
        double height=Vector2D.dist(segments[0].getP(0), segments[0].getP(1));
        return height;
    }
    
    public Object clone(){
        double x=this.getX();
        double y=this.getY();
        double w=this.getWidth();
        double h=this.getHeight();
        return (new Rectangle2DE(x, y, w, h));
    }

    public String toString(){
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumIntegerDigits(4);
        nf.setMinimumFractionDigits(1);
        String str="";
        double x=this.getX();
        double y=this.getY();
        double w=this.getWidth();
        double h=this.getHeight();
        str+="Rectangle x,y="+nf.format(x)+","+nf.format(y)+
                ", width,height="+nf.format(w)+","+nf.format(h);
        return str;
    }
}