
package geomExtension;

import util.Util;
import java.awt.*;
import java.awt.geom.*;
import java.text.*;
import DrawTop.*;



public class RoundRectangle2DE extends Curve2D{

    public RoundRectangle2DE(Segment2D[] segments){
        super(segments);
    }
    
    public RoundRectangle2DE(double x, double y, double width, double height, double arcw, double arch){
        this.setData(x, y, width, height, arcw, arch);
    }

//Curve2D method
    public void setData(double x, double y, double width, double height, double arcw, double arch){
        this.generalPath=new GeneralPath(Curve2D.Path2D_WIND);
        this.segments=new Segment2D[8];
        Line2D line0=new Line2D.Double(x, y+0.5*arch, x, y+height-0.5*arch);
        Line2D line1=new Line2D.Double(x+0.5*arcw,  y+height, x+width-0.5*arcw, y+height);
        Line2D line2=new Line2D.Double(x+width, y+height-0.5*arch, x+width, y+0.5*arch);
        Line2D line3=new Line2D.Double(x+width-0.5*arcw, y, x+0.5*arcw, y);
        
        Arc2D arc0=new Arc2D.Double(x, y+height-arch, arcw, arch, 180, 90, Arc2D.OPEN);
        Arc2D arc1=new Arc2D.Double(x+width-arcw, y+height-arch, arcw, arch, 270, 90, Arc2D.OPEN);
        Arc2D arc2=new Arc2D.Double(x+width-arcw, y, arcw, arch, 0, 90, Arc2D.OPEN);
        Arc2D arc3=new Arc2D.Double(x, y, arcw, arch, 90, 90, Arc2D.OPEN);
        
        this.segments[0]=new Segment2D(Segment2D.LINE, line0);
        this.segments[1]=new Segment2D(Segment2D.ARC, arc0);
        this.segments[2]=new Segment2D(Segment2D.LINE, line1);
        this.segments[3]=new Segment2D(Segment2D.ARC, arc1);
        this.segments[4]=new Segment2D(Segment2D.LINE, line2);
        this.segments[5]=new Segment2D(Segment2D.ARC, arc2);
        this.segments[6]=new Segment2D(Segment2D.LINE, line3);
        this.segments[7]=new Segment2D(Segment2D.ARC, arc3);

        for(int i=0;i<this.segments.length;i++){
            Shape shape=this.segments[i].getShape();
            generalPath.append(shape,true);
        }
        this.generalPath.closePath();
        this.closed=true;
    }
//Curve2D method
    public int getType2DE(){
        return Command.ROUND_RECTANGLE;
    }
    
//RoundRectangle2DE proper
    public double getX(){
        Arc2D arc=(Arc2D)segments[7].getShape();
        return arc.getX();
    }
//RoundRectangle2DE proper
    public double getY(){
        Arc2D arc=(Arc2D)segments[7].getShape();
        return arc.getY();
    }
//RoundRectangle2DE proper
    public double getWidth(){
        Arc2D arc=(Arc2D)segments[7].getShape();
        Line2D lineX=(Line2D)segments[2].getShape();
        double width=arc.getWidth()+lineX.getX2()-lineX.getX1();
        return width;
    }
//RoundRectangle2DE proper
    public double getHeight(){
        Arc2D arc=(Arc2D)segments[7].getShape();
        Line2D lineY=(Line2D)segments[0].getShape();
        double height=arc.getHeight()+lineY.getY2()-lineY.getY1();
        return height;
    }
//RoundRectangle2DE proper
    public double getArcWidth(){
        Arc2D arc=(Arc2D)segments[7].getShape();
        return arc.getWidth();
    }
//RoundRectangle2DE proper
    public double getArcHeight(){
        Arc2D arc=(Arc2D)segments[7].getShape();
        return arc.getHeight();
    }

//Curve2D method
    public Object clone(){
        double x=this.getX();
        double y=this.getY();
        double w=this.getWidth();
        double h=this.getHeight();
        double arcw=this.getArcWidth();
        double arch=this.getArcHeight();
        return (new RoundRectangle2DE(x, y, w, h, arcw, arch));
    }
//Curve2D method
    public String toString(){
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumIntegerDigits(4);
        nf.setMinimumFractionDigits(1);
        double x=this.getX();
        double y=this.getY();
        double w=this.getWidth();
        double h=this.getHeight();
        double arcw=this.getArcWidth();
        double arch=this.getArcHeight();
        String str="";
        str+="RoundRectangle x,y="+Util.Num(x)+","+Util.Num(y)+
                ", width,height="+Util.Num(w)+","+Util.Num(h)+
                ", arcw,arch="+Util.Num(arcw)+","+Util.Num(arch);
        return str;
    }
}