package shape;

import java.awt.geom.*;
import geomExtension.*;

public class ArrowShape{
    final static double ArrowAngle=40d/180d*Math.PI;
    final static double MinimumArrowHeight=8d;
    int arrowType=1;
    double lineWidth;
    Vector2D headPosition;
    Vector2D direction;
    int debug=0;
    public ArrowShape(int arrowType, double lineWidth, Vector2D headPosition, Vector2D direction){
        this.arrowType=arrowType;
        this.lineWidth=lineWidth;
        this.headPosition=headPosition;
        this.direction=direction;
    }

    Polyline2DE getArrowShape(){
        double arrowWidth=3.0d*lineWidth;
        double arrowHeight=0.5d*arrowWidth/Math.tan(0.5d*ArrowShape.ArrowAngle);
        if(arrowHeight<ArrowShape.MinimumArrowHeight){
            arrowHeight=ArrowShape.MinimumArrowHeight;
            arrowWidth=2d*arrowHeight*Math.tan(0.5d*ArrowShape.ArrowAngle);
        }
        Vector2D unitVec=Vector2D.unitVector(direction);
        Vector2D orthogonalVec=new Vector2D(-unitVec.getY(), unitVec.getX());
        Vector2D arrowBottom=Vector2D.sub(headPosition, Vector2D.multiply(arrowHeight, unitVec));
        Vector2D wideVec=Vector2D.multiply(0.5d*arrowWidth, orthogonalVec);
        Vector2D rightEdgeP=Vector2D.add(arrowBottom, wideVec);
        Vector2D leftEdgeP=Vector2D.sub(arrowBottom, wideVec);
        Point2D headPoint=new Point2D.Double(headPosition.getX(), headPosition.getY());
        Point2D rightEdgePoint=new Point2D.Double(rightEdgeP.getX(), rightEdgeP.getY());
        Point2D leftEdgePoint =new Point2D.Double(leftEdgeP.getX(), leftEdgeP.getY());
        
        Polyline2DE shape=null;
        if(this.arrowType==1){
            Point2D[] points=new Point2D[3];
            points[0]=leftEdgePoint;
            points[1]=headPoint;
            points[2]=rightEdgePoint;
            shape=new Polyline2DE(points,false);
        }
        if(this.arrowType==2){
            Point2D[] points=new Point2D[4];
            points[0]=leftEdgePoint;
            points[1]=headPoint;
            points[2]=rightEdgePoint;
            points[3]=points[0];
            shape=new Polyline2DE(points,true);
        }
        if(debug>0) System.out.println(" -- Arrow,  arrowType="+arrowType+",lineWidth="+lineWidth+
                 ", arrowHeight="+arrowHeight+", direction="+direction.toString()+
                 ", shape="+shape.toString());
        return shape;
    }
}
