package shape;

import java.awt.*;
import java.awt.geom.*;
import java.util.*;
import DrawTop.*;
import geomExtension.*;
import util.*;

public class RectangleElement extends ShapeElement{

    public RectangleElement() {
        super();
    }

    public int getTypeE(){
        return Command.RECTANGLE;
    }

    public String getShapeIdString(){
         return "Rectangle";
    }

    public Rectangle2D createTextArea(){
        Rectangle2D boundingBox=this.getBoundingBox();
        double delta=2d;
        Rectangle2D textArea=ShapeElementUtil.getShrinkedRectangle(boundingBox, delta, delta);
        if(textArea.getWidth()<ShapeElement.MinTextArea.getWidth()||
                textArea.getHeight()<ShapeElement.MinTextArea.getHeight()) return null;
        return textArea;
    }

//ShapeElement
    public SegmentModifier[] getSegmentModifiers(){
        SegmentModifier[] modifiers=new SegmentModifier[0];
        return modifiers;
    }
//ShapeElement
    public Point2D[] getModifierPTs(){
        Point2D[] PTs=new Point2D[0];
        return PTs;
    }

//ShapeElement
    //public void creationStart(int ctrl, Point2D point){}
    public void create(Point2D startPoint, Point2D currentPoint){}
    public void create(Rectangle2D boundingBox){
        double X=boundingBox.getX(); 
        double Y=boundingBox.getY();
        double Width=boundingBox.getWidth(); 
        double Height=boundingBox.getHeight();
        this.curve2D=new Rectangle2DE(X, Y, Width, Height);
    }
    public void create(Point2D[] points){}

    public void moveEndPoint(int ctrl, int movePtIndex, Point2D currentPoint){};
    public void moveEndPoint(int ctrl, int movePtIndex, Point2D oldPoint, Point2D newPoint){};
    public void modify(int ctrl, Point2D oldPoint, Point2D newPoint){}
    public void modifyPoint(Point2D point, String command){}
    //public int deletePoint(Point2D point){return 0;}


    public Object clone(){
        RectangleElement shapeElement=new RectangleElement();
        Rectangle2DE curve=(Rectangle2DE)curve2D.clone();
        shapeElement.setCurve2D(curve);
        return shapeElement;
    }

    public String toString(){
        String str="";
        if (this.curve2D == null) {
            str += "Rectangle: not defined";
            return str;
        }
        Rectangle2DE rectangle=(Rectangle2DE)this.curve2D;
        double x=rectangle.getX();
        double y=rectangle.getY();
        double width=rectangle.getWidth(); 
        double height=rectangle.getHeight();
        str="Rectangle x,y=("+String.valueOf((int)x)+","+String.valueOf((int)y)+")"
                +" width,height="+String.valueOf((int)width)+","+String.valueOf((int)height);
        return str;
    }

}