package shape;

import java.awt.*;
import java.awt.geom.*;
import java.io.*;
import java.util.*;
import DrawTop.*;
import geomExtension.*;
import textBox.*;
import util.*;
import util.UndoConstants;

public class RoundRectangleElement extends ShapeElement{
    SegmentModifier[] segmentModifiers=null;
    SegmentModifier hitSegmentModifier=null;
    int debug=0;

    public RoundRectangleElement() {
        super();
    }

    // methode defined in ShapeElement
    public int getTypeE(){
        return Command.ROUND_RECTANGLE;
    }
    //ShapeElement
     public String getShapeIdString(){
         return "Round_Rectangle";
     }

    public Rectangle2D createTextArea(){
        RoundRectangle2DE roundRect=(RoundRectangle2DE)this.curve2D;
        double arcw=roundRect.getArcWidth();
        double arch=roundRect.getArcHeight();
        double margin=3d;
        double width=Math.min(arcw, arch)*(1d-1d/Math.sqrt(2))+margin;
        double x=roundRect.getX();
        double y=roundRect.getY();
        double w=roundRect.getWidth();
        double h=roundRect.getHeight();
        Rectangle2D textArea=new Rectangle2D.Double(x+0.5*width, y+0.5*width, w-width, h-width);
        if(textArea.getWidth()<ShapeElement.MinTextArea.getWidth()||
                textArea.getHeight()<ShapeElement.MinTextArea.getHeight()) return null;
        return textArea;
    }
    public SegmentModifier[] getSegmentModifiers(){
      //-----------------------------------------------------------------------------------//
      // SegmentModifier constructor                                                       //
      // public SegmentModifier(int type, int subPathIndex, int segmentPid,                // 
      //       int segmentId1, int segmentId2, String segmentType1, String segmentType2,   //
      //       Point2D p, int jointType, Segment2D tangentIn, Segment2D tangentOut         //
      //-----------------------------------------------------------------------------------// 
        Curve2D curve2D=this.getCurve2D();
        SegmentModifier[] modifiers=new SegmentModifier[2];
        String lineSegStr=Segment2D.codeStr[Segment2D.LINE];
        String arcSegStr=Segment2D.codeStr[Segment2D.ARC];
        modifiers[0]=new SegmentModifier(SegmentModifier.SegmentP, 0, 
                1, 0, 1, lineSegStr, arcSegStr, curve2D.getP(1.0), 0, null, null);
        modifiers[1]=new SegmentModifier(SegmentModifier.SegmentP, 0, 
                2, 1, 2, arcSegStr, lineSegStr, curve2D.getP(2.0), 0, null, null);
        return modifiers;
    }

    public Point2D[] getModifierPTs(){
        SegmentModifier[] modifiers=this.getSegmentModifiers();
        Point2D[] PTs=new Point2D[modifiers.length];
        Point2D PT=null;
        for(int i=0;i<modifiers.length;i++){
            PTs[i]=modifiers[i].getP();
        }
        return PTs;
    }

//ShapeElement
    public void mouseStart(int ctrl, Point2D startPoint){
        super.mouseStart(ctrl, startPoint);
        this.segmentModifiers = this.getSegmentModifiers();
        this.hitSegmentModifier=SegmentModifier.getHitSegmentModifier(this.segmentModifiers, startPoint);
        if(this.hitSegmentModifier==null) System.out.println("modify hit=null");
    }

//ShapeElement
    public void create(Point2D startPoint, Point2D currentPoint){}
    public void create(Rectangle2D boundingBox){
        double X=boundingBox.getX(); double Y=boundingBox.getY();
        double Width=boundingBox.getWidth(); double Height=boundingBox.getHeight();
        double edgeLength=Math.min(Width, Height);
        double Arcw=0.2d*edgeLength;
        double Arch=0.2d*edgeLength;
        this.curve2D=
                new RoundRectangle2DE(X, Y, Width, Height, Arcw, Arch);
    }
    public void create(Point2D[] points){}

//ShapeElement
    public void moveEndPoint(int ctrl, int movePtIndex, Point2D currentPoint){};
    public void moveEndPoint(int ctrl, int movePtIndex, Point2D oldPoint, Point2D newPoint){};

    public void modify(int ctrl, Point2D oldPoint, Point2D currentPoint){
        if(this.hitSegmentModifier==null) return;
        int type2DE=this.curve2D.getType2DE();
        if(type2DE!=Command.ROUND_RECTANGLE) return;
        RoundRectangle2DE roundRectangle=(RoundRectangle2DE)this.curve2D;
        double x=roundRectangle.getX(); 
        double y=roundRectangle.getY();
        double width=roundRectangle.getWidth(); 
        double height=roundRectangle.getHeight();
        Curve2D curve2D=this.getCurve2D();
        Vector2D tangent=curve2D.getTangent(this.hitSegmentModifier.getSegmentPid());
        Vector2D normalTangent=Vector2D.unitVector(tangent);
        Point2D cornerP=new Point2D.Double(x,y+height);
        Vector2D arcVec=Vector2D.sub(currentPoint, cornerP);
        double arcWidth=2*Math.abs(Vector2D.sproduct(arcVec, normalTangent));
        double margin=2d;
        double arcWidthMax=Math.min(width, height)-margin;
        if(arcWidth>=arcWidthMax) arcWidth=arcWidthMax;
        roundRectangle.setData(x, y, width, height, arcWidth, arcWidth);
        if(this.shapeContainer.isTextBox()){
            Rectangle2D textArea=this.createTextArea();
            this.shapeContainer.getTextBox().setTextArea(textArea);
        }
    }

    public void modifyPoint(Point2D point, String command){}
    //public int deletePoint(Point2D point){return 0;}
//ShapeElement
    public Object clone(){
        RoundRectangleElement shapeElement=new RoundRectangleElement();
        RoundRectangle2DE curve=(RoundRectangle2DE)curve2D.clone();
        shapeElement.setCurve2D(curve);
        return shapeElement;
    }


// ShapeElement
    public String toString(){
        String str="";
        if (this.curve2D == null) {
            str += "RoundRectangle: not defined";
            return str;
        }
        RoundRectangle2DE roundRectangle=(RoundRectangle2DE)this.curve2D;
       
        double x=roundRectangle.getX(); 
        double y=roundRectangle.getY();
        double width=roundRectangle.getWidth(); 
        double height=roundRectangle.getHeight();
        double arcw=roundRectangle.getArcWidth(); 
        double arch=roundRectangle.getArcHeight();
        str="RoundRectangle x,y=("+String.valueOf((int)x)+","+String.valueOf((int)y)+")"
                +" width,height="+String.valueOf((int)width)+","+String.valueOf((int)height)
                +" arcw,arch="+String.valueOf((int)arcw)+","+String.valueOf((int)arch);
        return str;
    }

}