package shapeUtil;

import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.border.Border.*;
import DrawTop.*;
import shape.*;
import geomExtension.*;
import util.*;

public class ConnectionLSTest extends JDialog implements ConnectionListener{
    ConnectionLSTestAction action=null;
    JRadioButton clickPTOnShape=null;
    JRadioButton removeClickedPT=null;
    JRadioButton removeAllClickedPT=null;
    
    public ConnectionLSTest(){
        super(ObjectTable.getDrawMain(), "click on a shape");
        this.setName("click on a shape");  
        this.action=new ConnectionLSTestAction(this);
        this.createDialog();
    }
    
    public void createDialog(){
        Component owner=this.getOwner();
        Point centerP=new Point(owner.getX()+10, owner.getY()+80);
        this.setLocation(centerP);
        
        this.addWindowListener(this.action);
        Container contentPane=this.getContentPane();
        Box box=Box.createVerticalBox();
        contentPane.add(box);
        
     //Button group
        JPanel inputPanel=new JPanel();
        TitledBorder frameBorder=BorderFactory.createTitledBorder("Menu");
        inputPanel.setBorder(frameBorder);
        GridLayout inputPanelLayout=new GridLayout(3,1);
        inputPanelLayout.setHgap(20);
        inputPanel.setLayout(inputPanelLayout);
        ButtonGroup group = new ButtonGroup();
        this.clickPTOnShape = new JRadioButton("Click on a shape boundary");
        this.removeClickedPT = new JRadioButton("Remove a mark by clicking it");
        this.removeAllClickedPT = new JRadioButton("Remove all marks");
        this.clickPTOnShape.setActionCommand("Click");
        this.removeClickedPT.setActionCommand("Remove");
        this.removeAllClickedPT.setActionCommand("Remove all");
        this.clickPTOnShape.addActionListener(action);
        this.removeClickedPT.addActionListener(action);
        this.removeAllClickedPT.addActionListener(action);
        group.add(this.clickPTOnShape);
        this.clickPTOnShape.setSelected(true);
        group.add(this.removeClickedPT);
        group.add(this.removeAllClickedPT);
        inputPanel.add(this.clickPTOnShape);
        inputPanel.add(this.removeClickedPT);
        inputPanel.add(this.removeAllClickedPT);
        
// layout the dialog
        box.add(Box.createVerticalStrut(5));
        box.add(inputPanel);
    }
    
    public void showDialog(){
        this.pack();
        this.setVisible(true);
 //set Receiver
      //----------------------------//  
        this.addConnectionListener();
      //----------------------------//
    }
    public void addConnectionListener(){
        ConnectionLS connectionLS=ObjectTable.getConnectionLS();
        connectionLS.activateListener(true);
        connectionLS.addConnectionListener(this);
        ObjectTable.getSelectionLS().end();
    }
   
    public void removeConnectionListener(){
        ConnectionLS connectionLS=ObjectTable.getConnectionLS();
        connectionLS.activateListener(false);
        connectionLS.removeConnectionListener(this);
        ObjectTable.getSelectionLS().start();
    }
    
    public void connected(ConnectionEvent event){
        CurvePT curvePT=event.getCurvePT();
        DrawPanel drawPanel=ObjectTable.getDrawPanel();
        if(this.clickPTOnShape.isSelected()){
            double t=curvePT.getParameter();
            Point2D pt=curvePT.getP();
            Curve2D curve=curvePT.getCurve();
            CurvePT[] PTs=curve.getCharacteristicPoints();
            if(t>=0.0d) {
                int type=0;
                for(int i=0;i<PTs.length;i++){
                    double dist=Vector2D.dist(pt, PTs[i].getP());
                    if(dist<0.5d) type=1;
                }
                this.drawMark(pt, type);
            }
        }
        if(this.removeClickedPT.isSelected()){
            DrawShapeUtil.removeTempShape("ClickedPT", curvePT.getP());
            drawPanel.repaint();
        }
        drawPanel.repaint();
    }
/* 
    public void setConnectionReceiver(){
        ConnectionLS connectionLS=ObjectTable.getConnectionLS();
        connectionLS.activateListener(true);
        connectionLS.setReceiver(this, "receiveConnection");
        ObjectTable.getSelectionLS().end();
    }
*/
    public void receiveConnection(CurvePT curvePT){
        DrawPanel drawPanel=ObjectTable.getDrawPanel();
        if(this.clickPTOnShape.isSelected()){
            double t=curvePT.getParameter();
            Point2D pt=curvePT.getP();
            Curve2D curve=curvePT.getCurve();
            CurvePT[] PTs=curve.getCharacteristicPoints();
            if(t>=0.0d) {
                int type=0;
                for(int i=0;i<PTs.length;i++){
                    double dist=Vector2D.dist(pt, PTs[i].getP());
                    if(dist<0.5d) type=1;
                }
                this.drawMark(pt, type);
            }
        }
        if(this.removeClickedPT.isSelected()){
            DrawShapeUtil.removeTempShape("ClickedPT", curvePT.getP());
            drawPanel.repaint();
        }
        drawPanel.repaint();
    }
/*
    public void resetConnectionReceiver(){
        ConnectionLS connectionLS=ObjectTable.getConnectionLS();
        connectionLS.activateListener(false);
        connectionLS.resetReceiver();
        ObjectTable.getSelectionLS().start();
    }
*/
    private void drawMark(Point2D point, int type){
        double scale=DrawParameters.getScale();
        double x=point.getX();
        double y=point.getY();
        double width=16/scale;
        Ellipse2D largeCircle=new Ellipse2D.Double(x-0.5*width, y-0.5*width, width, width);
        width=14/scale;
        Rectangle2D largeRect=new Rectangle2D.Double(x-0.5*width, y-0.5*width, width, width);
        Color color=Color.RED;
        Shape shapeL=largeCircle;
        float lineWidth=1.0f;
        if(type>0) {
            color=Color.BLUE;
            shapeL=largeRect;
            lineWidth=1.0f/(float)scale;
        }
        width=6/scale;
        Rectangle2D smallRect=new Rectangle2D.Double(x-0.5*width, y-0.5*width, width, width);
        DrawShapeUtil.drawTempShape("ClickedPT", smallRect, null,
                    color, color, "", null, null);
        BasicStroke defaultStroke=new BasicStroke(lineWidth, BasicStroke.CAP_SQUARE, 
                    BasicStroke.JOIN_MITER, 10.0f);
        DrawShapeUtil.drawTempShape("ClickedPT", shapeL, defaultStroke,
                    color, null, "", null, null);
    }
/*
    public void drawMark(Point2D point, String message){
        ObjectTable.getDrawPanel().repaint();
        DrawShapeUtil.drawTempShape("Translate", point,
                DrawParameters.Mark_SmallSize, message, Color.RED);
    }
*/
} //end of DialogOfConnectCurves

class ConnectionLSTestAction extends AbstractAction implements WindowListener {
    ConnectionLSTest dialog=null;
    int debug=0;
    
    public ConnectionLSTestAction(ConnectionLSTest dialog){
        this.dialog=dialog;
    }
    
    public void actionPerformed(ActionEvent e) {
        String commandName=e.getActionCommand();
        String componentClassName=""; 
        componentClassName=e.getSource().getClass().getSimpleName();
        String componentName=((Component)e.getSource()).getName();
        if(debug>0) System.out.println("- ConnectionLSTestAction.actionPerformed  " +
                "commandName="+commandName+
                ", source component name="+componentName+
                ", source class simple name="+componentClassName);
        
        if(commandName.equals("Click")){
            //DrawShapeUtil.clearTempShape("ClickedPT");
            //ObjectTable.getDrawPanel().repaint();
            //this.dialog.setConnectionReceiver();
            //this.dialog.clickPTOnShape.setSelected(true);
        }
        
        if(commandName.equals("Remove")){
        }
        
        if(commandName.equals("Remove all")){
            DrawShapeUtil.clearTempShape("ClickedPT");
            ObjectTable.getDrawPanel().repaint();
        }

    }//End of actionPerformed
    
    private void closeDialog(){
        this.dialog.setVisible(false);
        DrawPanel drawPanel=ObjectTable.getDrawPanel("");
      //-------------------------------// 
        DrawShapeUtil.clearTempShape("ClickedPT");
        drawPanel.repaint();
      //-------------------------------// 
        this.dialog.removeConnectionListener();
        ObjectTable.getSelectionLS().start();
        return;
    }
    
    public void windowActivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowClosing(WindowEvent e) {
        this.closeDialog();
    }
    public void windowDeactivated(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}
} // end of class

