package shapeUtil;

import java.awt.*;
import java.awt.geom.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.border.Border.*;
import shape.*;
import geomExtension.*;
import menu.*;
import util.*;
import DrawTop.*;

public class Flip extends JDialog{
    FlipAction action=null;
    JLabel messageLabel=null;
    Dimension panelSize=new Dimension(220, 44);
    JRadioButton hButton=null;
    JRadioButton vButton=null;
    JRadioButton copyButton=null;
    JButton goButton=null;
    JButton cancelButton=null;
    Vector shapesVector=new Vector();
    
    public Flip(){
        super(ObjectTable.getDrawMain(), "flip");
        this.setName("flip");  
        this.action=new FlipAction(this);
        this.createDialog();
    }
    
    public void createDialog(){
        Component owner=this.getOwner();
        Point centerP=new Point(owner.getX()+owner.getSize().width-250, owner.getY()+100);
        this.setLocation(centerP);
        
        //FlipAction action=new FlipAction();
        this.addWindowListener(action);
        Container contentPane=this.getContentPane();
        Box box=Box.createVerticalBox();
        contentPane.add(box);

    //IMessagePanel
        JPanel messagePanel=new JPanel();
        messagePanel.setLayout(new FlowLayout(FlowLayout.LEADING));
        this.messageLabel=new JLabel(" ");
        messagePanel.add(this.messageLabel);
        
    //InputPanel
        JPanel inputPanel=new JPanel();
        GridLayout inputPanelLayout=new GridLayout(2,1);
        inputPanelLayout.setHgap(20);
        inputPanelLayout.setVgap(10);
        inputPanel.setLayout(inputPanelLayout);
        
    //Center position Panel    
        JPanel flipPanel=new JPanel();
        flipPanel.setPreferredSize(this.panelSize);
        TitledBorder frameBorder=BorderFactory.createTitledBorder("flip");
        frameBorder.setTitleColor(Color.BLACK);
        frameBorder.setTitleFont(MenuConstants.MenuFont);
        flipPanel.setBorder(frameBorder);
        GridLayout flipPanelLayout=new GridLayout(1,2);
        flipPanelLayout.setHgap(20);
        flipPanelLayout.setVgap(5);
        flipPanel.setLayout(flipPanelLayout);
        ButtonGroup flipGroup = new ButtonGroup();
        this.hButton = new JRadioButton("holizontally");
        this.hButton.setSelected(true);
        flipGroup.add(this.hButton);
        flipPanel.add(this.hButton);
        this.vButton = new JRadioButton("vertically");
        flipGroup.add(this.vButton);
        flipPanel.add(this.vButton);
        inputPanel.add(flipPanel);
        
     //Button group
        JPanel copyPanel=new JPanel();
        copyPanel.setPreferredSize(this.panelSize);
        frameBorder=BorderFactory.createTitledBorder("copy");
        copyPanel.setBorder(frameBorder);
        GridLayout copyPanelLayout=new GridLayout(1,2);
        copyPanel.setLayout(copyPanelLayout);
        ButtonGroup copyGroup = new ButtonGroup();
        this.copyButton = new JRadioButton("yes");
        JRadioButton noCopyButton = new JRadioButton("no");
        copyGroup.add(copyButton);
        copyButton.setSelected(true);
        copyGroup.add(noCopyButton);
        copyPanel.add(copyButton);
        copyPanel.add(noCopyButton);
        inputPanel.add(copyPanel);
        
    //Go, OK, Cancel Button    
        JPanel buttonPanel=new JPanel();
        buttonPanel.setPreferredSize(this.panelSize);
        this.goButton=new JButton("GO !");
        this.cancelButton=new JButton("Cancel");
        this.goButton.setEnabled(false);
        this.goButton.setActionCommand("Go");
        this.cancelButton.setActionCommand("Cancel");
        this.goButton.addActionListener(action);
        this.cancelButton.addActionListener(action);
        buttonPanel.add(this.goButton);
        buttonPanel.add(this.cancelButton);
        
// layout the dialog
        box.add(Box.createVerticalStrut(5));
        box.add(messagePanel);
        box.add(Box.createVerticalStrut(5));
        box.add(inputPanel);
        box.add(Box.createVerticalStrut(5));
        box.add(buttonPanel);
    }
    
    public void showDialog(){
        this.pack();
        this.setVisible(true);
 //set Receiver
        SelectionLS selectionLS=ObjectTable.getSelectionLS("flip");
      //---------------------------------------------------------//  
      // selectionLS.addSelectionListener(this);
        //selectionLS.setReceiver(this, "recieve");
      //-----------------------------------------------------------//
        
        ContainerManager containerManager=ObjectTable.getContainerManager("");
        ShapeContainer[] containers=containerManager.getSelectedContainers();
        int size=0;
        if(containers!=null) size=containers.length;
        if(size>0){
            this.shapesVector.clear();
            for(int i=0;i<size;i++) this.shapesVector.add(containers[i]);
        }
        if(this.shapesVector.size()>0) {
            this.goButton.setEnabled(true);
            //showMessage("  Selected shape is accepted !", Color.BLUE);
        }
        else {
            showMessage("Select shapes before this command !", Color.RED);
            this.shapesVector.clear();
        }
    }
/*
    public void selected(SelectionEvent event){
        Point2D point=event.getClickedPoint();
        ShapeContainer[] containers=event.getSelectedContainers();
      //check shape type
        this.shapesVector.add(containers[0]);   
        if(this.shapesVector.size()>0) {
            showMessage("  Selected shape is accepted !", Color.BLUE);
            this.goButton.setEnabled(true);
            for(int i=0;i<this.shapesVector.size();i++) 
                ((ShapeContainer)this.shapesVector.get(i)).setSelected(true);
        }
    }
*/
    protected void showMessage(String message, Color color){
        this.messageLabel.setForeground(color);
        this.messageLabel.setFont(DrawParameters.Font12Bold);
        this.messageLabel.setText(message);

    }

    public ShapeContainer[] getSelectedContainers(){
        int size=this.shapesVector.size();
        ShapeContainer[] containers=new ShapeContainer[size];
        for(int i=0;i<size;i++){
            containers[i]=(ShapeContainer)this.shapesVector.get(i);
        }
        return containers;
    }
    
    public JRadioButton getHorizontalButton(){
        return this.hButton;
    } 
    
    public JRadioButton getCopyButton(){
        return this.copyButton;
    } 
    
    public Vector getShapeVector(){
        return this.shapesVector;
    } 
    
} //end of DialogOfConnectCurves

class FlipAction extends AbstractAction  implements WindowListener {
    Flip dialog=null;
    int debug=0;
    
    public FlipAction(Flip dialog){
        this.dialog=dialog;
    }
    
    public void actionPerformed(ActionEvent e) {

        String commandName=e.getActionCommand();
        String componentClassName=""; 
        componentClassName=e.getSource().getClass().getSimpleName();
        String componentName=((Component)e.getSource()).getName();
        if(debug>0) System.out.println("- FlipAction.actionPerformed  " +
                "commandName="+commandName+
                ", source component name="+componentName+
                ", source class simple name="+componentClassName);
        
        if(commandName.equals("Go")){
            //System.out.println(" -- actionPerformed Go");
            JRadioButton hButton=this.dialog.getHorizontalButton();
            String dir="Horizontally";
            if(!hButton.isSelected()) dir="Vertically";
            JRadioButton copyButton=this.dialog.getCopyButton();
            boolean copy=copyButton.isSelected();
            Vector shapesVector=this.dialog.getShapeVector();
            int size=shapesVector.size();
            if(size==0) return;
            ShapeContainer[] containers=new ShapeContainer[size];
            ShapeContainer[] newContainers=new ShapeContainer[size];
            ContainerManager containerManager=ObjectTable.getContainerManager("");
            for(int i=0;i<size;i++) containers[i]=(ShapeContainer)shapesVector.get(i);
            Rectangle2D box=ShapeElementUtil.getBoundingBox(containers);

            int direction=0;
            double center=box.getX()+box.getWidth()/2;
            if(dir.startsWith("V")) {
                direction=1;
                center=box.getY()+box.getHeight()/2;
            }
            if(copy) center+=10;
          //-----------------------------------------------------------//
            Matrix2D matrix=Matrix2D.getFlipMatrix(direction, center);
          //-----------------------------------------------------------//  
          //------------------------------------------//
            containerManager.undoSetupStart(containers);
          //----------------------------------------//
            for(int i=0;i<size;i++) {
                newContainers[i]=this.flipContainer(matrix, containers[i], copy);
                containers[i].setSelected(false);
                if(copy) {
                    newContainers[i].setSelected(true);
                    //newContainers[i].clearShapeIdWithChildren();
                    newContainers[i].setNewShapeId(containerManager, true);
                    containerManager.addContainer(newContainers[i]);
                } else {
                    newContainers[i].setChangeCode(UndoConstants.CONTAINER);
                }
                if(debug>0) System.out.println("++ flipContainer container="+containers[i]+
                        "\n   newContainer="+newContainers[i]);
            }
          //--------------------------------//  
            containerManager.undoSetupEnd();
          //--------------------------------//
            shapesVector.clear();
            closeDialog();
            ObjectTable.getDrawPanel().repaint("flip");
            //ObjectTable.getDrawPanel().repaint();
        }
        if(commandName.equals("Cancel")){
            closeDialog();
        }
    }//End of actionPerformed
    
    private ShapeContainer flipContainer(Matrix2D flipMatrix, 
            ShapeContainer container, boolean copy){
        ShapeContainer newContainer=container;
        if(copy) newContainer=(ShapeContainer)container.clone();
        if(newContainer.getContainerType()==ShapeContainer.SHAPE){
            ShapeElement element=newContainer.getElement();
            element.transform(flipMatrix);
        } else{
            GroupElement groupElement=(GroupElement)newContainer.getElement();
            ShapeContainer[] children=groupElement.getGroupedSingleShapeContainers();
            for(int j=0;j<children.length;j++){
                ShapeElement element=children[j].getElement();
                element.transform(flipMatrix);
            }
        }
        
        return newContainer;
    }

    private void closeDialog(){
        this.dialog.setVisible(false);
        DrawPanel drawPanel=ObjectTable.getDrawPanel("");
      //-------------------------------// 
        DrawShapeUtil.clearTempShape("Flip");
        drawPanel.repaint();
      //-------------------------------// 
        SelectionLS selectionLS=ObjectTable.getSelectionLS("");
      //-----------------------------//  
      //  selectionLS.removeSelectionListener(this.dialog);
      //------------------------------//
        return;
    }
    
    public void windowActivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowClosing(WindowEvent e) {
        this.closeDialog();
    }
    public void windowDeactivated(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}

} // end of class