package util;

import java.io.*;
import java.util.*;

public class ConfigFile{
   private Properties properties;
   private String fileName;

   public ConfigFile(){
      properties = new Properties();
   }

   public void setFileName(String fileName){
      this.fileName=fileName;
   }

   public String getFileName(){
      if(this.fileName==null||this.fileName.equals("")){
         System.out.println("*** Error in ConfigFile fileName=null");
      }
      return this.fileName;
   }
   public void load() throws IOException{
      FileInputStream fileInputStream;
      try{
         fileInputStream = new FileInputStream(getFileName());
      } catch(FileNotFoundException e){
         throw new IOException("Cannot open file:" + getFileName());
      }
      this.properties.load(fileInputStream);
      fileInputStream.close();      
   }

   public void save() throws IOException{
      FileOutputStream fileOutputStream;
      try{
         fileOutputStream = new FileOutputStream(getFileName());
      } catch(FileNotFoundException e){
         throw new IOException("Cannot create file:" + getFileName());
      }
      this.properties.store(fileOutputStream, "");
      fileOutputStream.close();      
   }

   public String getValue(String sKey){
      return this.properties.getProperty(sKey);
   }

   public void putValue(String sKey, String sValue){
      this.properties.put(sKey, sValue);
   }

   public Enumeration getKeys(){
      return this.properties.propertyNames();
   }
}
